/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.BitSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.BlockHeaderV4;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.Utilities;

public class EventWriterUnsync {
    static final int BLOCK_LENGTH_OFFSET = 0;
    static final int BLOCK_NUMBER_OFFSET = 4;
    static final int HEADER_LENGTH_OFFSET = 8;
    static final int EVENT_COUNT_OFFSET = 12;
    static final int RESERVED1_COUNT_OFFSET = 16;
    static final int BIT_INFO_OFFSET = 20;
    static final int MAGIC_OFFSET = 28;
    static final int VERSION_MASK = 255;
    static final int DEFAULT_BLOCK_SIZE = 0x400000;
    static final int DEFAULT_BLOCK_COUNT = 10000;
    static final int MAX_BLOCK_SIZE = 0x2000000;
    static final int MAX_BLOCK_COUNT = 100000;
    static final int MIN_BLOCK_SIZE = 16;
    static final int MIN_BLOCK_COUNT = 1;
    static final int headerBytes = 32;
    static final int headerWords = 8;
    private int blockSizeMax;
    private int blockCountMax;
    private int blockNumber;
    private String xmlDictionary;
    private boolean wroteDictionary;
    private byte[] dictionaryByteArray;
    private int dictionaryBytes;
    private boolean haveFirstEvent;
    private byte[] firstEventByteArray;
    private int firstEventBytes;
    private int commonBlockByteSize;
    private int commonBlockCount;
    private BitSet bitInfo;
    private boolean closed;
    private boolean toFile;
    private boolean append;
    private boolean hasAppendDictionary;
    private int targetBlockSize;
    private int reserved1;
    private int reserved2;
    private long bytesWrittenToBuffer;
    private int eventsWrittenToBuffer;
    private int eventsWrittenTotal;
    private int currentHeaderPosition;
    private int currentBlockSize;
    private int currentBlockEventCount;
    private int bufferSize;
    private ByteBuffer buffer;
    private ByteOrder byteOrder;
    private File currentFile;
    private RandomAccessFile raf;
    private FileChannel fileChannel;
    private int splitCount;
    public String baseFileName;
    public int specifierCount;
    public int runNumber;
    private long split;
    private int streamCount;
    private boolean overWriteOK;
    private long bytesWrittenToFile;
    private int eventsWrittenToFile;
    private boolean lastEmptyBlockHeaderExists;
    private FileCloser fileCloser;

    public EventWriterUnsync(File file) throws EvioException {
        this(file, false);
    }

    public EventWriterUnsync(File file, boolean append) throws EvioException {
        this(file, 0x400000, 10000, ByteOrder.nativeOrder(), null, null, true, append);
    }

    public EventWriterUnsync(File file, String dictionary, boolean append) throws EvioException {
        this(file, 0x400000, 10000, ByteOrder.nativeOrder(), dictionary, null, true, append);
    }

    public EventWriterUnsync(String filename) throws EvioException {
        this(filename, false);
    }

    public EventWriterUnsync(String filename, boolean append) throws EvioException {
        this(new File(filename), 0x400000, 10000, ByteOrder.nativeOrder(), null, null, true, append);
    }

    public EventWriterUnsync(String filename, boolean append, ByteOrder byteOrder) throws EvioException {
        this(new File(filename), 0x400000, 10000, byteOrder, null, null, true, append);
    }

    public EventWriterUnsync(File file, int blockSizeMax, int blockCountMax, ByteOrder byteOrder, String xmlDictionary, BitSet bitInfo) throws EvioException {
        this(file, blockSizeMax, blockCountMax, byteOrder, xmlDictionary, bitInfo, true, false);
    }

    public EventWriterUnsync(File file, int blockSizeMax, int blockCountMax, ByteOrder byteOrder, String xmlDictionary, BitSet bitInfo, boolean overWriteOK) throws EvioException {
        this(file, blockSizeMax, blockCountMax, byteOrder, xmlDictionary, bitInfo, overWriteOK, false);
    }

    public EventWriterUnsync(File file, int blockSizeMax, int blockCountMax, ByteOrder byteOrder, String xmlDictionary, BitSet bitInfo, boolean overWriteOK, boolean append) throws EvioException {
        this(file.getPath(), null, null, 0, 0L, blockSizeMax, blockCountMax, 0, byteOrder, xmlDictionary, bitInfo, overWriteOK, append);
    }

    public EventWriterUnsync(String baseName, String directory, String runType, int runNumber, long split, ByteOrder byteOrder, String xmlDictionary) throws EvioException {
        this(baseName, directory, runType, runNumber, split, 0x400000, 10000, 0, byteOrder, xmlDictionary, null, false, false);
    }

    public EventWriterUnsync(String baseName, String directory, String runType, int runNumber, long split, ByteOrder byteOrder, String xmlDictionary, int streamId) throws EvioException {
        this(baseName, directory, runType, runNumber, split, 0x400000, 10000, 0, byteOrder, xmlDictionary, null, false, false, null, streamId);
    }

    public EventWriterUnsync(String baseName, String directory, String runType, int runNumber, long split, ByteOrder byteOrder, String xmlDictionary, boolean overWriteOK) throws EvioException {
        this(baseName, directory, runType, runNumber, split, 0x400000, 10000, 0, byteOrder, xmlDictionary, null, overWriteOK, false);
    }

    public EventWriterUnsync(String baseName, String directory, String runType, int runNumber, long split, int blockSizeMax, int blockCountMax, int bufferSize, ByteOrder byteOrder, String xmlDictionary, BitSet bitInfo, boolean overWriteOK, boolean append) throws EvioException {
        this(baseName, directory, runType, runNumber, split, blockSizeMax, blockCountMax, bufferSize, byteOrder, xmlDictionary, bitInfo, overWriteOK, append, null);
    }

    public EventWriterUnsync(String baseName, String directory, String runType, int runNumber, long split, int blockSizeMax, int blockCountMax, int bufferSize, ByteOrder byteOrder, String xmlDictionary, BitSet bitInfo, boolean overWriteOK, boolean append, EvioBank firstEvent) throws EvioException {
        this(baseName, directory, runType, runNumber, split, blockSizeMax, blockCountMax, bufferSize, byteOrder, xmlDictionary, bitInfo, overWriteOK, append, firstEvent, 0);
    }

    public EventWriterUnsync(String baseName, String directory, String runType, int runNumber, long split, int blockSizeMax, int blockCountMax, int bufferSize, ByteOrder byteOrder, String xmlDictionary, BitSet bitInfo, boolean overWriteOK, boolean append, EvioBank firstEvent, int streamId) throws EvioException {
        this(baseName, directory, runType, runNumber, split, blockSizeMax, blockCountMax, bufferSize, byteOrder, xmlDictionary, bitInfo, overWriteOK, append, firstEvent, streamId, 1);
    }

    public EventWriterUnsync(String baseName, String directory, String runType, int runNumber, long split, int blockSizeMax, int blockCountMax, int bufferSize, ByteOrder byteOrder, String xmlDictionary, BitSet bitInfo, boolean overWriteOK, boolean append, EvioBank firstEvent, int streamId, int streamCount) throws EvioException {
        if (baseName == null) {
            throw new EvioException("baseName arg is null");
        }
        if (blockSizeMax < 16) {
            throw new EvioException("blockSizeMax arg must be bigger");
        }
        if (blockSizeMax > 0x2000000) {
            throw new EvioException("blockSizeMax arg must be smaller");
        }
        if (blockCountMax < 1) {
            throw new EvioException("blockCountMax arg must be bigger");
        }
        if (blockCountMax > 100000) {
            throw new EvioException("blockCountMax arg must be smaller");
        }
        if (bufferSize < 4 * blockSizeMax + 32) {
            bufferSize = 4 * blockSizeMax + 32;
        }
        if (byteOrder == null) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        if (append) {
            if (split > 0L) {
                throw new EvioException("Cannot specify split when appending");
            }
            if (xmlDictionary != null || firstEvent != null) {
                throw new EvioException("Cannot specify dictionary or first event when appending");
            }
        }
        if (xmlDictionary != null) {
            if (xmlDictionary.length() < 56) {
                throw new EvioException("Dictionary improper format");
            }
            this.dictionaryByteArray = BaseStructure.stringsToRawBytes(new String[]{xmlDictionary});
            this.commonBlockByteSize = this.dictionaryBytes = this.dictionaryByteArray.length + 8;
            this.commonBlockCount = 1;
        }
        this.split = split;
        this.append = append;
        this.runNumber = runNumber;
        this.byteOrder = byteOrder;
        this.bufferSize = bufferSize;
        this.overWriteOK = overWriteOK;
        this.blockSizeMax = blockSizeMax;
        this.blockCountMax = blockCountMax;
        this.xmlDictionary = xmlDictionary;
        this.streamCount = streamCount;
        this.toFile = true;
        this.blockNumber = 1;
        if (bitInfo != null) {
            this.bitInfo = (BitSet)bitInfo.clone();
        }
        this.splitCount = 0;
        if (streamCount > 1) {
            this.splitCount = streamId * streamCount;
        } else {
            streamCount = 1;
        }
        if (directory != null) {
            baseName = directory + "/" + baseName;
        }
        StringBuilder builder = new StringBuilder(100);
        this.specifierCount = Utilities.generateBaseFileName(baseName, runType, builder);
        this.baseFileName = builder.toString();
        String fileName = Utilities.generateFileName(this.baseFileName, this.specifierCount, runNumber, split, this.splitCount, 0);
        this.splitCount += streamCount;
        this.currentFile = new File(fileName);
        if (!overWriteOK && !append && this.currentFile.exists() && this.currentFile.isFile()) {
            throw new EvioException("File exists but user requested no over-writing or appending, " + this.currentFile.getPath());
        }
        this.buffer = ByteBuffer.allocateDirect(bufferSize);
        this.buffer.order(byteOrder);
        this.targetBlockSize = 4 * blockSizeMax;
        if (split > 0L) {
            this.fileCloser = new FileCloser();
        }
        try {
            if (append) {
                this.raf = new RandomAccessFile(this.currentFile, "rw");
                this.fileChannel = this.raf.getChannel();
                if (this.fileChannel.size() > 0L) {
                    this.examineFirstBlockHeader();
                    if (this.byteOrder != byteOrder) {
                        this.buffer.order(this.byteOrder);
                    }
                    this.toAppendPosition();
                    this.buffer.clear();
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new EvioException("File could not be opened for writing, " + this.currentFile.getPath(), e);
        }
        catch (IOException e) {
            throw new EvioException("File could not be positioned for appending, " + this.currentFile.getPath(), e);
        }
        if (firstEvent != null) {
            this.firstEventBytes = firstEvent.getTotalBytes();
            ByteBuffer firstEventBuf = ByteBuffer.allocate(this.firstEventBytes);
            firstEventBuf.order(this.buffer.order());
            firstEvent.write(firstEventBuf);
            this.firstEventByteArray = firstEventBuf.array();
            this.commonBlockByteSize += this.firstEventBytes;
            ++this.commonBlockCount;
            this.haveFirstEvent = true;
        }
        if (xmlDictionary == null) {
            this.writeNewHeader(0, this.blockNumber++, bitInfo, false, false);
        } else {
            this.writeNewHeader(0, this.blockNumber++, bitInfo, true, false);
        }
        this.writeCommonBlock();
    }

    public EventWriterUnsync(ByteBuffer buf) throws EvioException {
        this(buf, 0x400000, 10000, null, null, 0, false);
    }

    public EventWriterUnsync(ByteBuffer buf, boolean append) throws EvioException {
        this(buf, 0x400000, 10000, null, null, 0, append);
    }

    public EventWriterUnsync(ByteBuffer buf, String xmlDictionary, boolean append) throws EvioException {
        this(buf, 0x400000, 10000, xmlDictionary, null, 0, append);
    }

    public EventWriterUnsync(ByteBuffer buf, int blockSizeMax, int blockCountMax, String xmlDictionary, BitSet bitInfo) throws EvioException {
        this(buf, blockSizeMax, blockCountMax, xmlDictionary, bitInfo, 0, false);
    }

    public EventWriterUnsync(ByteBuffer buf, int blockSizeMax, int blockCountMax, String xmlDictionary, BitSet bitInfo, boolean append) throws EvioException {
        this(buf, blockSizeMax, blockCountMax, xmlDictionary, bitInfo, 0, append);
    }

    public EventWriterUnsync(ByteBuffer buf, int blockSizeMax, int blockCountMax, String xmlDictionary, BitSet bitInfo, int reserved1, int blockNumber) throws EvioException {
        this.initializeBuffer(buf, blockSizeMax, blockCountMax, xmlDictionary, bitInfo, reserved1, blockNumber, false, null);
    }

    public EventWriterUnsync(ByteBuffer buf, int blockSizeMax, int blockCountMax, String xmlDictionary, BitSet bitInfo, int reserved1, boolean append) throws EvioException {
        this.initializeBuffer(buf, blockSizeMax, blockCountMax, xmlDictionary, bitInfo, reserved1, 1, append, null);
    }

    public EventWriterUnsync(ByteBuffer buf, int blockSizeMax, int blockCountMax, String xmlDictionary, BitSet bitInfo, int reserved1, int blockNumber, boolean append, EvioBank firstEvent) throws EvioException {
        this.initializeBuffer(buf, blockSizeMax, blockCountMax, xmlDictionary, bitInfo, reserved1, blockNumber, append, firstEvent);
    }

    private void initializeBuffer(ByteBuffer buf, int blockSizeMax, int blockCountMax, String xmlDictionary, BitSet bitInfo, int reserved1, int blockNumber, boolean append, EvioBank firstEvent) throws EvioException {
        if (blockSizeMax < 16) {
            throw new EvioException("Max block size arg (" + blockSizeMax + ") must be >= " + 16);
        }
        if (blockSizeMax > 0x2000000) {
            throw new EvioException("Max block size arg (" + blockSizeMax + ") must be <= " + 0x2000000);
        }
        if (blockCountMax < 1) {
            throw new EvioException("Max block count arg (" + blockCountMax + ") must be >= " + 1);
        }
        if (blockCountMax > 100000) {
            throw new EvioException("Max block count arg (" + blockCountMax + ") must be <= " + 100000);
        }
        if (buf == null) {
            throw new EvioException("Buffer arg cannot be null");
        }
        if (append && (xmlDictionary != null || firstEvent != null)) {
            throw new EvioException("Cannot specify dictionary or first event when appending");
        }
        if (xmlDictionary != null) {
            if (xmlDictionary.length() < 56) {
                throw new EvioException("Dictionary improper format");
            }
            this.dictionaryByteArray = BaseStructure.stringsToRawBytes(new String[]{xmlDictionary});
            this.commonBlockByteSize = this.dictionaryBytes = this.dictionaryByteArray.length + 8;
            this.commonBlockCount = 1;
        }
        this.append = append;
        this.buffer = buf;
        this.byteOrder = buf.order();
        this.reserved1 = reserved1;
        this.blockNumber = blockNumber;
        this.blockSizeMax = blockSizeMax;
        this.blockCountMax = blockCountMax;
        this.xmlDictionary = xmlDictionary;
        this.split = 0L;
        this.toFile = false;
        this.closed = false;
        this.eventsWrittenTotal = 0;
        this.eventsWrittenToBuffer = 0;
        this.bytesWrittenToBuffer = 0L;
        this.buffer.position(0);
        this.bufferSize = buf.capacity();
        this.targetBlockSize = 4 * blockSizeMax;
        if (bitInfo != null) {
            this.bitInfo = (BitSet)bitInfo.clone();
        }
        try {
            if (append) {
                this.examineFirstBlockHeader();
                this.toAppendPosition();
            }
        }
        catch (IOException e) {
            throw new EvioException("Buffer could not be positioned for appending", e);
        }
        if (firstEvent != null) {
            this.firstEventBytes = firstEvent.getTotalBytes();
            ByteBuffer firstEventBuf = ByteBuffer.allocate(this.firstEventBytes);
            firstEventBuf.order(this.buffer.order());
            firstEvent.write(firstEventBuf);
            this.firstEventByteArray = firstEventBuf.array();
            this.commonBlockByteSize += this.firstEventBytes;
            ++this.commonBlockCount;
            this.haveFirstEvent = true;
        }
        if (xmlDictionary == null) {
            this.writeNewHeader(0, this.blockNumber++, bitInfo, false, false);
        } else {
            this.writeNewHeader(0, this.blockNumber++, bitInfo, true, false);
        }
        this.writeCommonBlock();
    }

    private void reInitializeBuffer(ByteBuffer buf, BitSet bitInfo, int blockNumber) throws EvioException {
        this.buffer = buf;
        this.byteOrder = buf.order();
        this.blockNumber = blockNumber;
        this.split = 0L;
        this.toFile = false;
        this.closed = false;
        this.eventsWrittenTotal = 0;
        this.eventsWrittenToBuffer = 0;
        this.bytesWrittenToBuffer = 0L;
        this.buffer.position(0);
        this.bufferSize = buf.capacity();
        if (bitInfo != null) {
            this.bitInfo = (BitSet)bitInfo.clone();
        }
        if (this.xmlDictionary == null) {
            this.writeNewHeader(0, this.blockNumber++, bitInfo, false, false);
        } else {
            this.writeNewHeader(0, this.blockNumber++, bitInfo, true, false);
        }
        this.writeCommonBlock();
    }

    public long getBytesWrittenToBuffer() {
        return this.bytesWrittenToBuffer;
    }

    public void setBuffer(ByteBuffer buf, BitSet bitInfo, int blockNumber) throws EvioException {
        if (this.toFile) {
            return;
        }
        if (buf == null) {
            throw new EvioException("Buffer arg null");
        }
        if (this.append) {
            throw new EvioException("Method not for use if appending");
        }
        if (!this.closed) {
            throw new EvioException("Close EventWriter before changing buffers");
        }
        this.bitInfo = bitInfo;
        this.reInitializeBuffer(buf, bitInfo, blockNumber);
    }

    public void setBuffer(ByteBuffer buf) throws EvioException {
        this.setBuffer(buf, this.bitInfo, 1);
    }

    private ByteBuffer getBuffer() {
        return this.buffer;
    }

    public ByteBuffer getByteBuffer() {
        if (this.toFile()) {
            return null;
        }
        ByteBuffer buf = this.buffer.duplicate().order(this.buffer.order());
        buf.flip();
        return buf;
    }

    public boolean toFile() {
        return this.toFile;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getCurrentFilename() {
        if (this.currentFile != null) {
            return this.currentFile.getName();
        }
        return null;
    }

    public String getCurrentFilePath() {
        if (this.currentFile != null) {
            return this.currentFile.getPath();
        }
        return null;
    }

    public int getSplitCount() {
        return this.splitCount;
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public int getEventsWritten() {
        return this.eventsWrittenTotal;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setStartingBlockNumber(int startingBlockNumber) {
        if (this.eventsWrittenTotal > 0) {
            return;
        }
        this.blockNumber = startingBlockNumber;
    }

    public void setFirstEvent(EvioNode node) throws EvioException, IOException {
        if (node == null) {
            if (this.xmlDictionary != null) {
                this.commonBlockCount = 1;
                this.commonBlockByteSize = this.dictionaryBytes;
            } else {
                this.commonBlockCount = 0;
                this.commonBlockByteSize = 0;
            }
            this.firstEventBytes = 0;
            this.firstEventByteArray = null;
            this.haveFirstEvent = false;
            return;
        }
        if (this.xmlDictionary != null) {
            this.commonBlockCount = 1;
            this.commonBlockByteSize = this.dictionaryBytes;
        } else {
            this.commonBlockCount = 0;
            this.commonBlockByteSize = 0;
        }
        ByteBuffer firstEventBuf = node.getStructureBuffer(true);
        this.firstEventBytes = node.getTotalBytes();
        this.firstEventByteArray = firstEventBuf.array();
        this.commonBlockByteSize += this.firstEventBytes;
        ++this.commonBlockCount;
        this.haveFirstEvent = true;
        this.writeEvent(null, firstEventBuf, false);
    }

    public void setFirstEvent(EvioBank bank) throws EvioException, IOException {
        if (bank == null) {
            if (this.xmlDictionary != null) {
                this.commonBlockCount = 1;
                this.commonBlockByteSize = this.dictionaryBytes;
            } else {
                this.commonBlockCount = 0;
                this.commonBlockByteSize = 0;
            }
            this.firstEventBytes = 0;
            this.firstEventByteArray = null;
            this.haveFirstEvent = false;
            return;
        }
        if (this.xmlDictionary != null) {
            this.commonBlockCount = 1;
            this.commonBlockByteSize = this.dictionaryBytes;
        } else {
            this.commonBlockCount = 0;
            this.commonBlockByteSize = 0;
        }
        this.firstEventBytes = bank.getTotalBytes();
        ByteBuffer firstEventBuf = ByteBuffer.allocate(this.firstEventBytes);
        firstEventBuf.order(this.buffer.order());
        bank.write(firstEventBuf);
        firstEventBuf.flip();
        this.firstEventByteArray = firstEventBuf.array();
        this.commonBlockByteSize += this.firstEventBytes;
        ++this.commonBlockCount;
        this.haveFirstEvent = true;
        this.writeEvent(null, firstEventBuf, false);
    }

    public void flush() {
        if (this.closed || !this.toFile || this.lastEmptyBlockHeaderExists) {
            return;
        }
        try {
            if (this.flushToFile(true)) {
                this.resetBuffer(false);
            }
        }
        catch (EvioException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        try {
            if (this.toFile) {
                if (this.eventsWrittenToBuffer > 0 || this.bytesWrittenToBuffer < 1L) {
                    this.writeNewHeader(0, this.blockNumber, null, false, true);
                }
                this.flushToFile(true);
            } else {
                this.writeNewHeader(0, this.blockNumber, null, false, true);
            }
        }
        catch (EvioException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.toFile) {
                if (this.raf != null) {
                    this.raf.close();
                }
                if (this.fileCloser != null) {
                    this.fileCloser.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closed = true;
    }

    protected IOStatus examineFirstBlockHeader() throws IOException, EvioException {
        int currentPosition;
        if (!this.append) {
            throw new EvioException("need to be in append mode");
        }
        if (this.toFile) {
            this.buffer.clear();
            this.buffer.limit(32);
            int nBytes = this.fileChannel.read(this.buffer);
            if (nBytes != 32) {
                throw new EvioException("bad file format");
            }
            currentPosition = 0;
            this.fileChannel.position(0L);
        } else {
            if (this.buffer.remaining() < 32) {
                return IOStatus.END_OF_FILE;
            }
            currentPosition = this.buffer.position();
        }
        try {
            int bitInfo;
            int evioVersion;
            this.byteOrder = this.buffer.order();
            int magicNumber = this.buffer.getInt(currentPosition + 28);
            if (magicNumber != -1059454720) {
                this.byteOrder = this.byteOrder == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                this.buffer.order(this.byteOrder);
                magicNumber = this.buffer.getInt(currentPosition + 28);
                if (magicNumber != -1059454720) {
                    System.out.println("ERROR: reread magic # (" + magicNumber + ") & still not right");
                    return IOStatus.EVIO_EXCEPTION;
                }
            }
            if ((evioVersion = (bitInfo = this.buffer.getInt(currentPosition + 20)) & 0xFF) < 4) {
                System.out.println("ERROR: evio version# = " + evioVersion);
                return IOStatus.EVIO_EXCEPTION;
            }
            this.hasAppendDictionary = BlockHeaderV4.hasDictionary(bitInfo);
        }
        catch (BufferUnderflowException a) {
            System.err.println("ERROR endOfBuffer " + a);
            return IOStatus.UNKNOWN_ERROR;
        }
        return IOStatus.SUCCESS;
    }

    private void toAppendPosition() throws EvioException, IOException {
        int headerLength;
        int blockLength;
        int bitInfo;
        if (!this.append) {
            throw new EvioException("need to be in append mode");
        }
        boolean readEOF = false;
        long bytesLeftInFile = 0L;
        if (this.toFile) {
            bytesLeftInFile = this.fileChannel.size();
        }
        this.blockNumber = 1;
        while (true) {
            int currentPosition;
            int nBytes = 0;
            if (this.toFile) {
                this.buffer.clear();
                this.buffer.limit(32);
                while (nBytes < 32) {
                    int partial = this.fileChannel.read(this.buffer);
                    if (partial < 0) {
                        if (nBytes != 0) {
                            throw new EvioException("bad buffer format");
                        }
                        readEOF = true;
                        break;
                    }
                    nBytes += partial;
                    bytesLeftInFile -= (long)partial;
                }
                if (nBytes != 0 && nBytes != 32) {
                    throw new EvioException("internal file reading error");
                }
                currentPosition = 0;
            } else {
                if (this.buffer.remaining() < 32) {
                    throw new EvioException("bad buffer format");
                }
                currentPosition = this.buffer.position();
            }
            bitInfo = this.buffer.getInt(currentPosition + 20);
            blockLength = this.buffer.getInt(currentPosition + 0);
            headerLength = this.buffer.getInt(currentPosition + 8);
            int blockEventCount = this.buffer.getInt(currentPosition + 12);
            boolean lastBlock = BlockHeaderV4.isLastBlock(bitInfo);
            this.eventsWrittenTotal += blockEventCount;
            ++this.blockNumber;
            if (lastBlock || readEOF) break;
            if (this.toFile) {
                int bytesToNextBlockHeader = 4 * blockLength - 32;
                if (bytesLeftInFile < (long)bytesToNextBlockHeader) {
                    throw new EvioException("bad file format");
                }
                this.fileChannel.position(this.fileChannel.position() + (long)bytesToNextBlockHeader);
                bytesLeftInFile -= (long)bytesToNextBlockHeader;
                continue;
            }
            if (this.buffer.remaining() < 4 * blockLength) {
                throw new EvioException("bad buffer format");
            }
            this.buffer.position(this.buffer.position() + 4 * blockLength);
        }
        this.eventsWrittenToFile = this.hasAppendDictionary ? (this.eventsWrittenToBuffer = this.eventsWrittenTotal + 1) : (this.eventsWrittenToBuffer = this.eventsWrittenTotal);
        if (readEOF) {
            --this.blockNumber;
        } else if (blockLength > headerLength) {
            bitInfo = BlockHeaderV4.clearLastBlockBit(bitInfo);
            if (this.toFile) {
                this.fileChannel.position(this.fileChannel.position() - 12L);
                this.buffer.clear();
                this.buffer.putInt(bitInfo);
                this.buffer.flip();
                while (this.buffer.hasRemaining()) {
                    this.fileChannel.write(this.buffer);
                }
                this.fileChannel.position(this.fileChannel.position() + (long)(4 * blockLength) - 21L);
            } else {
                this.buffer.putInt(this.buffer.position() + 20, bitInfo);
                this.buffer.position(this.buffer.position() + 4 * blockLength);
            }
        } else {
            --this.blockNumber;
            if (this.toFile) {
                this.fileChannel.position(this.fileChannel.position() - 32L);
            }
        }
        if (this.toFile) {
            this.bytesWrittenToFile = this.fileChannel.position();
        } else {
            this.bytesWrittenToBuffer = this.buffer.position() + 32;
        }
    }

    private void writeNewHeader(int eventCount, int blockNumber, BitSet bitInfo, boolean hasDictionary, boolean isLast) throws EvioException {
        if (this.buffer.remaining() < 32) {
            throw new EvioException("Buffer size exceeded, need 32 but have " + this.buffer.remaining() + " bytes");
        }
        this.currentHeaderPosition = this.buffer.position();
        int sixthWord = BlockHeaderV4.generateSixthWord(bitInfo, 4, hasDictionary, isLast, 0);
        this.buffer.putInt(8);
        this.buffer.putInt(blockNumber);
        this.buffer.putInt(8);
        this.buffer.putInt(eventCount);
        this.buffer.putInt(this.reserved1);
        this.buffer.putInt(sixthWord);
        this.buffer.putInt(this.reserved2);
        this.buffer.putInt(-1059454720);
        if (isLast) {
            this.lastEmptyBlockHeaderExists = true;
        }
        this.currentBlockSize = 8;
        this.currentBlockEventCount = 0;
        this.bytesWrittenToBuffer += 32L;
    }

    private void writeCommonBlock() throws EvioException {
        if (this.xmlDictionary == null && !this.haveFirstEvent) {
            return;
        }
        if (this.commonBlockByteSize > this.buffer.remaining()) {
            if (!this.toFile) {
                throw new EvioException("Not enough buffer mem for dictionary & first event");
            }
            this.expandBuffer(this.commonBlockByteSize + 64);
            this.resetBuffer(true);
        }
        if (this.xmlDictionary != null) {
            this.buffer.putInt(this.dictionaryByteArray.length / 4 + 1);
            if (this.buffer.order() == ByteOrder.BIG_ENDIAN) {
                this.buffer.putShort((short)0);
                this.buffer.put((byte)DataType.CHARSTAR8.getValue());
                this.buffer.put((byte)0);
            } else {
                this.buffer.put((byte)0);
                this.buffer.put((byte)DataType.CHARSTAR8.getValue());
                this.buffer.putShort((short)0);
            }
            this.buffer.put(this.dictionaryByteArray);
            this.wroteDictionary = true;
            ++this.eventsWrittenToBuffer;
            ++this.currentBlockEventCount;
        }
        if (this.haveFirstEvent) {
            this.buffer.put(this.firstEventByteArray);
            ++this.eventsWrittenTotal;
            ++this.eventsWrittenToBuffer;
            ++this.currentBlockEventCount;
            this.buffer.putInt(this.currentHeaderPosition + 12, 1);
        }
        this.currentBlockSize += this.commonBlockByteSize / 4;
        this.bytesWrittenToBuffer += (long)this.commonBlockByteSize;
        this.buffer.putInt(this.currentHeaderPosition, this.currentBlockSize);
        this.lastEmptyBlockHeaderExists = false;
    }

    private void resetBuffer(boolean beforeDictionary) {
        this.buffer.clear();
        this.bytesWrittenToBuffer = 0L;
        this.eventsWrittenToBuffer = 0;
        try {
            if (beforeDictionary) {
                this.blockNumber = 1;
                this.writeNewHeader(0, this.blockNumber++, null, this.xmlDictionary != null, false);
            } else {
                this.writeNewHeader(0, this.blockNumber++, null, false, false);
            }
        }
        catch (EvioException evioException) {
            // empty catch block
        }
    }

    private void expandBuffer(int newSize) {
        if (newSize <= this.bufferSize) {
            return;
        }
        this.buffer = ByteBuffer.allocateDirect(newSize);
        this.buffer.order(this.byteOrder);
        this.bufferSize = newSize;
    }

    private void writeEventToBuffer(EvioBank bank, ByteBuffer bankBuffer, int currentEventBytes) {
        int headerInfoWord;
        if (bankBuffer != null) {
            this.buffer.put(bankBuffer);
        } else if (bank != null) {
            bank.write(this.buffer);
        } else {
            return;
        }
        this.currentBlockSize += currentEventBytes / 4;
        this.bytesWrittenToBuffer += (long)currentEventBytes;
        ++this.eventsWrittenTotal;
        ++this.eventsWrittenToBuffer;
        ++this.currentBlockEventCount;
        this.buffer.putInt(this.currentHeaderPosition, this.currentBlockSize);
        this.buffer.putInt(this.currentHeaderPosition + 12, this.currentBlockEventCount);
        if (this.wroteDictionary && this.blockNumber == 2 && this.currentBlockEventCount > 1) {
            this.buffer.putInt(this.currentHeaderPosition + 12, this.currentBlockEventCount - 1);
        }
        if (BlockHeaderV4.isLastBlock(headerInfoWord = this.buffer.getInt(this.currentHeaderPosition + 20))) {
            this.buffer.putInt(this.currentHeaderPosition + 20, BlockHeaderV4.clearLastBlockBit(headerInfoWord));
        }
        this.lastEmptyBlockHeaderExists = false;
    }

    public boolean hasRoom(int bytes) {
        return this.toFile() || (long)this.bufferSize - this.bytesWrittenToBuffer >= (long)(bytes + 32);
    }

    public void writeEvent(EvioNode node, boolean force) throws EvioException, IOException {
        this.writeEvent(node, force, true);
    }

    public void writeEvent(EvioNode node, boolean force, boolean duplicate) throws EvioException, IOException {
        if (node == null) {
            throw new EvioException("null node arg");
        }
        ByteBuffer bb = node.getBufferNode().getBuffer();
        ByteBuffer eventBuffer = duplicate ? bb.duplicate().order(bb.order()) : bb;
        int pos = node.getPosition();
        eventBuffer.limit(pos + node.getTotalBytes()).position(pos);
        this.writeEvent(null, eventBuffer, force);
    }

    public void writeEvent(ByteBuffer eventBuffer) throws EvioException, IOException {
        this.writeEvent(null, eventBuffer, false);
    }

    public void writeEvent(EvioBank bank) throws EvioException, IOException {
        this.writeEvent(bank, null, false);
    }

    public void writeEvent(ByteBuffer bankBuffer, boolean force) throws EvioException, IOException {
        this.writeEvent(null, bankBuffer, force);
    }

    public void writeEvent(EvioBank bank, boolean force) throws EvioException, IOException {
        this.writeEvent(bank, null, force);
    }

    private void writeEvent(EvioBank bank, ByteBuffer bankBuffer, boolean force) throws EvioException, IOException {
        int currentEventBytes;
        if (this.closed) {
            throw new EvioException("close() has already been called");
        }
        boolean doFlush = false;
        boolean roomInBuffer = true;
        boolean splittingFile = false;
        boolean needBiggerBuffer = false;
        boolean writeNewBlockHeader = true;
        int newBufSize = 0;
        if (bankBuffer != null) {
            if (bankBuffer.order() != this.byteOrder) {
                throw new EvioException("event buf is " + bankBuffer.order() + ", and writer is " + this.byteOrder);
            }
            currentEventBytes = bankBuffer.remaining();
            if ((currentEventBytes & 3) != 0) {
                throw new EvioException("bad bankBuffer format");
            }
            if (currentEventBytes != 4 * (bankBuffer.getInt(bankBuffer.position()) + 1)) {
                throw new EvioException("inconsistent event lengths");
            }
        } else if (bank != null) {
            currentEventBytes = bank.getTotalBytes();
        } else {
            return;
        }
        if (currentEventBytes + 4 * this.currentBlockSize <= this.targetBlockSize && this.currentBlockEventCount < this.blockCountMax) {
            writeNewBlockHeader = false;
        }
        if (this.split > 0L && (this.blockNumber != 2 || this.eventsWrittenToBuffer > this.commonBlockCount)) {
            long totalSize = (long)currentEventBytes + this.bytesWrittenToFile + this.bytesWrittenToBuffer + 32L;
            if (writeNewBlockHeader) {
                totalSize += 32L;
            }
            if (totalSize > this.split) {
                splittingFile = true;
                if (this.eventsWrittenToBuffer > 0) {
                    doFlush = true;
                }
            }
        }
        if (this.bufferSize < currentEventBytes + 64) {
            if (!this.toFile) {
                System.out.println("evWrite: error, bufSize = " + this.bufferSize + " <? current event bytes = " + currentEventBytes + " + 2 headers (64), total = " + (currentEventBytes + 64) + ", room = " + ((long)this.bufferSize - this.bytesWrittenToBuffer - 32L));
                throw new EvioException("Buffer too small to write event");
            }
            roomInBuffer = false;
            needBiggerBuffer = true;
        } else if (!writeNewBlockHeader && (long)this.bufferSize - this.bytesWrittenToBuffer < (long)(currentEventBytes + 32) || writeNewBlockHeader && (long)this.bufferSize - this.bytesWrittenToBuffer < (long)(currentEventBytes + 64)) {
            if (!this.toFile) {
                throw new EvioException("Buffer too small to write event");
            }
            roomInBuffer = false;
        }
        if (!roomInBuffer) {
            if (needBiggerBuffer) {
                newBufSize = currentEventBytes + 64;
            }
            doFlush = true;
        }
        if (doFlush) {
            this.flushToFile(false);
        }
        if (splittingFile) {
            this.splitFile();
        }
        if (needBiggerBuffer) {
            this.expandBuffer(newBufSize);
        }
        if (doFlush || splittingFile) {
            this.resetBuffer(false);
            writeNewBlockHeader = false;
        }
        if (splittingFile && (this.xmlDictionary != null || this.haveFirstEvent)) {
            int neededBytes = this.commonBlockByteSize + 96 + currentEventBytes;
            writeNewBlockHeader = true;
            this.expandBuffer(neededBytes);
            this.resetBuffer(true);
            this.writeCommonBlock();
        }
        if (writeNewBlockHeader) {
            this.writeNewHeader(1, this.blockNumber++, null, false, false);
        }
        this.writeEventToBuffer(bank, bankBuffer, currentEventBytes);
        if (force && this.toFile) {
            this.flushToFile(true);
            this.resetBuffer(false);
        }
    }

    private boolean flushToFile(boolean force) throws EvioException, IOException {
        if (this.closed) {
            throw new EvioException("close() has already been called");
        }
        if (!this.toFile) {
            return false;
        }
        if (this.buffer.position() < 1) {
            return false;
        }
        this.buffer.flip();
        if (this.bytesWrittenToFile < 1L) {
            try {
                this.raf = new RandomAccessFile(this.currentFile, "rw");
                this.fileChannel = this.raf.getChannel();
            }
            catch (FileNotFoundException e) {
                throw new EvioException("File could not be opened for writing, " + this.currentFile.getPath(), e);
            }
        }
        int bytesWritten = this.buffer.remaining();
        while (this.buffer.hasRemaining()) {
            this.fileChannel.write(this.buffer);
        }
        if (force) {
            this.fileChannel.force(false);
        }
        this.buffer.clear();
        this.bytesWrittenToFile += (long)bytesWritten;
        this.eventsWrittenToFile += this.eventsWrittenToBuffer;
        this.bytesWrittenToBuffer = 0L;
        this.eventsWrittenToBuffer = 0;
        return true;
    }

    private void splitFile() throws EvioException {
        if (this.raf != null) {
            try {
                if (this.eventsWrittenToBuffer > 0 || this.bytesWrittenToBuffer < 1L) {
                    this.writeNewHeader(0, this.blockNumber, null, false, true);
                }
            }
            catch (EvioException e) {
                e.printStackTrace();
            }
            this.fileCloser.closeFile(this.raf);
        }
        this.raf = null;
        String fileName = Utilities.generateFileName(this.baseFileName, this.specifierCount, this.runNumber, this.split, this.splitCount);
        this.splitCount += this.streamCount;
        this.currentFile = new File(fileName);
        if (!this.overWriteOK && this.currentFile.exists() && this.currentFile.isFile()) {
            throw new EvioException("File exists but user requested no over-writing, " + this.currentFile.getPath());
        }
        this.blockNumber = 1;
        this.bytesWrittenToFile = 0L;
        this.eventsWrittenToFile = 0;
        this.wroteDictionary = false;
    }

    private final class FileCloser {
        private final ExecutorService threadPool = Executors.newSingleThreadExecutor();

        FileCloser() {
        }

        void closeFile(RandomAccessFile raf) {
            this.threadPool.submit(new CloseThd(raf));
        }

        void close() {
            this.threadPool.shutdown();
        }

        private final class CloseThd
        implements Runnable {
            private final RandomAccessFile raf;

            CloseThd(RandomAccessFile raf) {
                this.raf = raf;
            }

            @Override
            public final void run() {
                try {
                    this.raf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static enum IOStatus {
        SUCCESS,
        END_OF_FILE,
        EVIO_EXCEPTION,
        CANNOT_OPEN_FILE,
        UNKNOWN_ERROR;

    }
}

