/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.BufferNode;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.CompositeData;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;

public final class CompactEventBuilder {
    private ByteBuffer buffer;
    private byte[] array;
    private int position;
    private ByteOrder order;
    private boolean useByteBuffer;
    private boolean createdBuffer;
    private boolean generateNodes;
    private ArrayList<EvioNode> nodes;
    private static final int MAX_LEVELS = 50;
    private static final int[] padCount = new int[]{0, 3, 2, 1};
    private StructureContent[] stackArray;
    private int[] totalLengths;
    private StructureContent currentStructure;
    private int currentLevel;

    public CompactEventBuilder(int bufferSize, ByteOrder order) throws EvioException {
        this(bufferSize, order, false);
    }

    public CompactEventBuilder(int bufferSize, ByteOrder order, boolean generateNodes) throws EvioException {
        if (order == null) {
            throw new EvioException("null arg(s)");
        }
        if (bufferSize < 8) {
            throw new EvioException("bufferSize arg too small");
        }
        this.array = new byte[bufferSize];
        this.buffer = ByteBuffer.wrap(this.array);
        this.buffer.order(order);
        this.order = order;
        this.generateNodes = generateNodes;
        this.position = 0;
        this.nodes = null;
        this.currentLevel = -1;
        this.createdBuffer = true;
        this.currentStructure = null;
        this.totalLengths = new int[50];
        this.stackArray = new StructureContent[50];
        for (int i = 0; i < 50; ++i) {
            this.stackArray[i] = new StructureContent();
        }
    }

    public CompactEventBuilder(ByteBuffer buffer) throws EvioException {
        this(buffer, false);
    }

    public CompactEventBuilder(ByteBuffer buffer, boolean generateNodes) throws EvioException {
        if (buffer == null) {
            throw new EvioException("null arg(s)");
        }
        this.initBuffer(buffer, generateNodes);
        this.totalLengths = new int[50];
        this.stackArray = new StructureContent[50];
        for (int i = 0; i < 50; ++i) {
            this.stackArray[i] = new StructureContent();
        }
    }

    public void setBuffer(ByteBuffer buffer) throws EvioException {
        this.setBuffer(buffer, false);
    }

    public void setBuffer(ByteBuffer buffer, boolean generateNodes) throws EvioException {
        if (buffer == null) {
            throw new EvioException("null arg(s)");
        }
        this.initBuffer(buffer, generateNodes);
    }

    private void initBuffer(ByteBuffer buffer, boolean generateNodes) throws EvioException {
        this.generateNodes = generateNodes;
        this.buffer = buffer;
        buffer.clear();
        this.order = buffer.order();
        this.position = 0;
        if (buffer.limit() < 8) {
            throw new EvioException("compact buffer too small");
        }
        if (buffer.hasArray() && buffer.array().length == buffer.capacity()) {
            this.array = buffer.array();
        } else {
            this.useByteBuffer = true;
        }
        if (this.nodes != null) {
            this.nodes.clear();
        }
        this.currentLevel = -1;
        this.createdBuffer = false;
        this.currentStructure = null;
    }

    public ByteBuffer getBuffer() {
        this.buffer.limit(this.position);
        this.buffer.position(0);
        return this.buffer;
    }

    public int getTotalBytes() {
        return this.position;
    }

    public EvioNode openSegment(int tag, DataType dataType) throws EvioException {
        if (this.currentStructure == null) {
            throw new EvioException("add a bank (event) first");
        }
        if (this.currentStructure.dataType != DataType.SEGMENT && this.currentStructure.dataType != DataType.ALSOSEGMENT) {
            throw new EvioException("may NOT add segment type, expecting " + (Object)((Object)this.currentStructure.dataType));
        }
        this.buffer.clear();
        if (this.buffer.limit() - this.position < 4) {
            throw new EvioException("no room in buffer");
        }
        if (this.useByteBuffer) {
            if (this.order == ByteOrder.BIG_ENDIAN) {
                this.buffer.put(this.position, (byte)tag);
                this.buffer.put(this.position + 1, (byte)(dataType.getValue() & 0x3F));
            } else {
                this.buffer.put(this.position + 2, (byte)(dataType.getValue() & 0x3F));
                this.buffer.put(this.position + 3, (byte)tag);
            }
        } else if (this.order == ByteOrder.BIG_ENDIAN) {
            this.array[this.position] = (byte)tag;
            this.array[this.position + 1] = (byte)(dataType.getValue() & 0x3F);
        } else {
            this.array[this.position + 2] = (byte)(dataType.getValue() & 0x3F);
            this.array[this.position + 3] = (byte)tag;
        }
        if (++this.currentLevel >= 50) {
            throw new EvioException("too many nested evio structures, increase MAX_LEVELS from 50");
        }
        this.currentStructure = this.stackArray[this.currentLevel];
        this.currentStructure.setData(this.position, DataType.SEGMENT, dataType);
        this.addToAllLengths(1);
        EvioNode node = null;
        if (this.generateNodes) {
            if (this.nodes == null) {
                this.nodes = new ArrayList(100);
            }
            node = new EvioNode(tag, 0, this.position, this.position + 4, DataType.SEGMENT, dataType, new BufferNode(this.buffer));
            this.nodes.add(node);
        }
        this.position += 4;
        return node;
    }

    public EvioNode openTagSegment(int tag, DataType dataType) throws EvioException {
        if (this.currentStructure == null) {
            throw new EvioException("add a bank (event) first");
        }
        if (this.currentStructure.dataType != DataType.TAGSEGMENT) {
            throw new EvioException("may NOT add tagsegment type, expecting " + (Object)((Object)this.currentStructure.dataType));
        }
        this.buffer.clear();
        if (this.buffer.limit() - this.position < 4) {
            throw new EvioException("no room in buffer");
        }
        short compositeWord = (short)(tag << 4 | dataType.getValue() & 0xF);
        if (this.useByteBuffer) {
            if (this.buffer.order() == ByteOrder.BIG_ENDIAN) {
                this.buffer.putShort(this.position, compositeWord);
            } else {
                this.buffer.putShort(this.position + 2, compositeWord);
            }
        } else if (this.order == ByteOrder.BIG_ENDIAN) {
            this.array[this.position] = (byte)(compositeWord >> 8);
            this.array[this.position + 1] = (byte)compositeWord;
        } else {
            this.array[this.position + 2] = (byte)compositeWord;
            this.array[this.position + 3] = (byte)(compositeWord >> 8);
        }
        if (++this.currentLevel >= 50) {
            throw new EvioException("too many nested evio structures, increase MAX_LEVELS from 50");
        }
        this.currentStructure = this.stackArray[this.currentLevel];
        this.currentStructure.setData(this.position, DataType.TAGSEGMENT, dataType);
        this.addToAllLengths(1);
        EvioNode node = null;
        if (this.generateNodes) {
            if (this.nodes == null) {
                this.nodes = new ArrayList(100);
            }
            node = new EvioNode(tag, 0, this.position, this.position + 4, DataType.TAGSEGMENT, dataType, new BufferNode(this.buffer));
            this.nodes.add(node);
        }
        this.position += 4;
        return node;
    }

    public EvioNode openBank(int tag, int num, DataType dataType) throws EvioException {
        if (this.currentStructure != null && this.currentStructure.dataType != DataType.BANK && this.currentStructure.dataType != DataType.ALSOBANK) {
            throw new EvioException("may NOT add bank type, expecting " + (Object)((Object)this.currentStructure.dataType));
        }
        this.buffer.clear();
        if (this.buffer.limit() - this.position < 8) {
            throw new EvioException("no room in buffer");
        }
        if (this.useByteBuffer) {
            this.buffer.putInt(this.position, 1);
            if (this.buffer.order() == ByteOrder.BIG_ENDIAN) {
                this.buffer.putShort(this.position + 4, (short)tag);
                this.buffer.put(this.position + 6, (byte)(dataType.getValue() & 0x3F));
                this.buffer.put(this.position + 7, (byte)num);
            } else {
                this.buffer.put(this.position + 4, (byte)num);
                this.buffer.put(this.position + 5, (byte)(dataType.getValue() & 0x3F));
                this.buffer.putShort(this.position + 6, (short)tag);
            }
        } else if (this.order == ByteOrder.BIG_ENDIAN) {
            this.array[this.position] = 0;
            this.array[this.position + 1] = 0;
            this.array[this.position + 2] = 0;
            this.array[this.position + 3] = 1;
            this.array[this.position + 4] = (byte)(tag >> 8);
            this.array[this.position + 5] = (byte)tag;
            this.array[this.position + 6] = (byte)(dataType.getValue() & 0x3F);
            this.array[this.position + 7] = (byte)num;
        } else {
            this.array[this.position] = 1;
            this.array[this.position + 1] = 0;
            this.array[this.position + 2] = 0;
            this.array[this.position + 3] = 0;
            this.array[this.position + 4] = (byte)num;
            this.array[this.position + 5] = (byte)(dataType.getValue() & 0x3F);
            this.array[this.position + 6] = (byte)tag;
            this.array[this.position + 7] = (byte)(tag >> 8);
        }
        if (++this.currentLevel >= 50) {
            throw new EvioException("too many nested evio structures, increase MAX_LEVELS from 50");
        }
        this.currentStructure = this.stackArray[this.currentLevel];
        this.currentStructure.setData(this.position, DataType.BANK, dataType);
        this.addToAllLengths(2);
        EvioNode node = null;
        if (this.generateNodes) {
            if (this.nodes == null) {
                this.nodes = new ArrayList(100);
            }
            node = new EvioNode(tag, 0, this.position, this.position + 8, DataType.BANK, dataType, new BufferNode(this.buffer));
            this.nodes.add(node);
        }
        this.position += 8;
        return node;
    }

    public boolean closeStructure() {
        if (this.currentLevel < 0) {
            return true;
        }
        this.setCurrentHeaderLength(this.totalLengths[this.currentLevel] - 1);
        if (this.currentStructure.padding > 0) {
            this.setCurrentHeaderPadding(this.currentStructure.padding);
        }
        this.totalLengths[this.currentLevel] = 0;
        if (--this.currentLevel > -1) {
            this.currentStructure = this.stackArray[this.currentLevel];
        }
        return this.currentLevel < 0;
    }

    public void closeAll() {
        while (!this.closeStructure()) {
        }
    }

    public void setTopLevelTag(short tag) {
        if (this.useByteBuffer) {
            if (this.buffer.order() == ByteOrder.BIG_ENDIAN) {
                this.buffer.putShort(4, tag);
            } else {
                this.buffer.putShort(6, tag);
            }
        } else if (this.order == ByteOrder.BIG_ENDIAN) {
            this.array[4] = (byte)(tag >> 8);
            this.array[5] = (byte)tag;
        } else {
            this.array[6] = (byte)tag;
            this.array[7] = (byte)(tag >> 8);
        }
    }

    private void addToAllLengths(int len) {
        int i = this.currentLevel;
        while (i >= 0) {
            int n = i--;
            this.totalLengths[n] = this.totalLengths[n] + len;
        }
    }

    private void setCurrentHeaderLength(int len) {
        switch (this.currentStructure.type) {
            case BANK: 
            case ALSOBANK: {
                if (this.useByteBuffer) {
                    this.buffer.putInt(this.currentStructure.pos, len);
                } else {
                    try {
                        ByteDataTransformer.toBytes(len, this.order, this.array, this.currentStructure.pos);
                    }
                    catch (EvioException e) {
                        // empty catch block
                    }
                }
                return;
            }
            case SEGMENT: 
            case ALSOSEGMENT: 
            case TAGSEGMENT: {
                if (this.useByteBuffer) {
                    if (this.buffer.order() == ByteOrder.BIG_ENDIAN) {
                        this.buffer.putShort(this.currentStructure.pos + 2, (short)len);
                    } else {
                        this.buffer.putShort(this.currentStructure.pos, (short)len);
                    }
                } else {
                    try {
                        if (this.buffer.order() == ByteOrder.BIG_ENDIAN) {
                            ByteDataTransformer.toBytes((short)len, this.order, this.array, this.currentStructure.pos + 2);
                        } else {
                            ByteDataTransformer.toBytes((short)len, this.order, this.array, this.currentStructure.pos);
                        }
                    }
                    catch (EvioException evioException) {
                        // empty catch block
                    }
                }
                return;
            }
        }
    }

    private void setCurrentHeaderPadding(int padding) {
        byte b = (byte)(this.currentStructure.dataType.getValue() & 0x3F | padding << 6);
        switch (this.currentStructure.type) {
            case BANK: 
            case ALSOBANK: {
                if (this.useByteBuffer) {
                    if (this.buffer.order() == ByteOrder.BIG_ENDIAN) {
                        this.buffer.put(this.currentStructure.pos + 6, b);
                    } else {
                        this.buffer.put(this.currentStructure.pos + 5, b);
                    }
                } else if (this.buffer.order() == ByteOrder.BIG_ENDIAN) {
                    this.array[this.currentStructure.pos + 6] = b;
                } else {
                    this.array[this.currentStructure.pos + 5] = b;
                }
                return;
            }
            case SEGMENT: 
            case ALSOSEGMENT: {
                if (this.useByteBuffer) {
                    if (this.buffer.order() == ByteOrder.BIG_ENDIAN) {
                        this.buffer.put(this.currentStructure.pos + 1, b);
                    } else {
                        this.buffer.put(this.currentStructure.pos + 2, b);
                    }
                } else if (this.buffer.order() == ByteOrder.BIG_ENDIAN) {
                    this.array[this.currentStructure.pos + 1] = b;
                } else {
                    this.array[this.currentStructure.pos + 2] = b;
                }
                return;
            }
        }
    }

    private void writeHeader(EvioNode node) {
        switch (this.currentStructure.type) {
            case BANK: 
            case ALSOBANK: {
                if (this.useByteBuffer) {
                    this.buffer.putInt(this.position, node.len);
                    if (this.order == ByteOrder.BIG_ENDIAN) {
                        this.buffer.putShort(this.position + 4, (short)node.tag);
                        this.buffer.put(this.position + 6, (byte)(node.dataType & 0x3F | node.pad << 6));
                        this.buffer.put(this.position + 7, (byte)node.num);
                    } else {
                        this.buffer.put(this.position + 4, (byte)node.num);
                        this.buffer.put(this.position + 5, (byte)(node.dataType & 0x3F | node.pad << 6));
                        this.buffer.putShort(this.position + 6, (short)node.tag);
                    }
                } else if (this.order == ByteOrder.BIG_ENDIAN) {
                    this.array[this.position] = (byte)(node.len >> 24);
                    this.array[this.position + 1] = (byte)(node.len >> 16);
                    this.array[this.position + 2] = (byte)(node.len >> 8);
                    this.array[this.position + 3] = (byte)node.len;
                    this.array[this.position + 4] = (byte)(node.tag >>> 8);
                    this.array[this.position + 5] = (byte)node.tag;
                    this.array[this.position + 6] = (byte)(node.dataType & 0x3F | node.pad << 6);
                    this.array[this.position + 7] = (byte)node.num;
                } else {
                    this.array[this.position] = (byte)node.len;
                    this.array[this.position + 1] = (byte)(node.len >> 8);
                    this.array[this.position + 2] = (byte)(node.len >> 16);
                    this.array[this.position + 3] = (byte)(node.len >> 24);
                    this.array[this.position + 4] = (byte)node.num;
                    this.array[this.position + 5] = (byte)(node.dataType & 0x3F | node.pad << 6);
                    this.array[this.position + 6] = (byte)node.tag;
                    this.array[this.position + 7] = (byte)(node.tag >>> 8);
                }
                this.position += 8;
                break;
            }
            case SEGMENT: 
            case ALSOSEGMENT: {
                if (this.useByteBuffer) {
                    if (this.order == ByteOrder.BIG_ENDIAN) {
                        this.buffer.put(this.position, (byte)node.tag);
                        this.buffer.put(this.position + 1, (byte)(node.dataType & 0x3F | node.pad << 6));
                        this.buffer.putShort(this.position + 2, (short)node.len);
                    } else {
                        this.buffer.putShort(this.position, (short)node.len);
                        this.buffer.put(this.position + 1, (byte)(node.dataType & 0x3F | node.pad << 6));
                        this.buffer.put(this.position + 2, (byte)node.tag);
                    }
                } else if (this.order == ByteOrder.BIG_ENDIAN) {
                    this.array[this.position] = (byte)node.tag;
                    this.array[this.position + 1] = (byte)(node.dataType & 0x3F | node.pad << 6);
                    this.array[this.position + 2] = (byte)(node.len >> 8);
                    this.array[this.position + 3] = (byte)node.len;
                } else {
                    this.array[this.position] = (byte)node.len;
                    this.array[this.position + 1] = (byte)(node.len >> 8);
                    this.array[this.position + 2] = (byte)(node.dataType & 0x3F | node.pad << 6);
                    this.array[this.position + 3] = (byte)node.tag;
                }
                this.position += 4;
                break;
            }
            case TAGSEGMENT: {
                short compositeWord = (short)(node.tag << 4 | node.dataType & 0xF);
                if (this.useByteBuffer) {
                    if (this.order == ByteOrder.BIG_ENDIAN) {
                        this.buffer.putShort(this.position, compositeWord);
                        this.buffer.putShort(this.position + 2, (short)node.len);
                    } else {
                        this.buffer.putShort(this.position, (short)node.len);
                        this.buffer.putShort(this.position + 2, compositeWord);
                    }
                } else if (this.order == ByteOrder.BIG_ENDIAN) {
                    this.array[this.position] = (byte)(compositeWord >> 8);
                    this.array[this.position + 1] = (byte)compositeWord;
                    this.array[this.position + 2] = (byte)(node.len >> 8);
                    this.array[this.position + 3] = (byte)node.len;
                } else {
                    this.array[this.position] = (byte)node.len;
                    this.array[this.position + 1] = (byte)(node.len >> 8);
                    this.array[this.position + 2] = (byte)compositeWord;
                    this.array[this.position + 3] = (byte)(compositeWord >> 8);
                }
                this.position += 4;
                break;
            }
        }
    }

    private void writeNode(EvioNode node, boolean swapData) {
        this.writeHeader(node);
        if (node.getDataTypeObj().isStructure()) {
            ArrayList<EvioNode> kids = node.getChildNodes();
            if (kids == null) {
                return;
            }
            for (EvioNode child : kids) {
                this.writeNode(child, swapData);
            }
        } else {
            ByteBuffer nodeBuf = node.bufferNode.buffer;
            if (swapData) {
                try {
                    ByteDataTransformer.swapData(node.getDataTypeObj(), nodeBuf, this.buffer, node.dataPos, this.position, node.dataLen, false);
                }
                catch (EvioException e) {
                    e.printStackTrace();
                }
            } else if (!this.useByteBuffer && nodeBuf.hasArray() && this.buffer.hasArray() && nodeBuf.array().length == nodeBuf.capacity()) {
                System.arraycopy(nodeBuf.array(), node.dataPos, this.array, this.position, 4 * node.dataLen);
            } else {
                ByteBuffer duplicateBuf = nodeBuf.duplicate();
                duplicateBuf.limit(node.dataPos + 4 * node.dataLen).position(node.dataPos);
                this.buffer.position(this.position);
                this.buffer.put(duplicateBuf);
                this.buffer.position(0);
            }
            this.position += 4 * node.dataLen;
        }
    }

    public void addEvioNode(EvioNode node) throws EvioException {
        if (node == null) {
            throw new EvioException("no data to add");
        }
        if (this.currentStructure == null) {
            throw new EvioException("add a bank, segment, or tagsegment first");
        }
        if (this.currentStructure.dataType != node.getTypeObj()) {
            throw new EvioException("may only add " + (Object)((Object)this.currentStructure.dataType) + " data");
        }
        this.buffer.clear();
        int len = node.getTotalBytes();
        if (this.buffer.limit() - this.position < len) {
            throw new EvioException("no room in buffer");
        }
        this.addToAllLengths(len / 4);
        ByteBuffer nodeBuf = node.bufferNode.buffer;
        if (nodeBuf.order() == this.buffer.order()) {
            if (!this.useByteBuffer && nodeBuf.hasArray() && this.buffer.hasArray() && nodeBuf.array().length == nodeBuf.capacity()) {
                System.arraycopy(nodeBuf.array(), node.pos, this.array, this.position, node.getTotalBytes());
            } else {
                ByteBuffer duplicateBuf = nodeBuf.duplicate();
                duplicateBuf.limit(node.pos + node.getTotalBytes()).position(node.pos);
                this.buffer.position(this.position);
                this.buffer.put(duplicateBuf);
                this.buffer.position(0);
            }
            this.position += len;
        } else {
            this.writeNode(node, false);
        }
    }

    public void addByteData(byte[] data) throws EvioException {
        if (data == null || data.length < 1) {
            throw new EvioException("no data to add");
        }
        if (this.currentStructure == null) {
            throw new EvioException("add a bank, segment, or tagsegment first");
        }
        if (this.currentStructure.dataType != DataType.CHAR8 && this.currentStructure.dataType != DataType.UCHAR8) {
            throw new EvioException("may only add " + (Object)((Object)this.currentStructure.dataType) + " data");
        }
        this.buffer.clear();
        int len = data.length;
        if (this.buffer.limit() - this.position < len) {
            throw new EvioException("no room in buffer");
        }
        int lastWordLen = (this.currentStructure.dataLen + 3) / 4;
        if (this.currentStructure.dataLen > 0) {
            this.position -= this.currentStructure.padding;
        }
        this.currentStructure.dataLen += len;
        int totalWordLen = (this.currentStructure.dataLen + 3) / 4;
        this.addToAllLengths(totalWordLen - lastWordLen);
        if (this.useByteBuffer) {
            this.buffer.position(this.position);
            this.buffer.put(data);
            this.buffer.position(0);
        } else {
            System.arraycopy(data, 0, this.array, this.position, len);
        }
        this.currentStructure.padding = padCount[this.currentStructure.dataLen % 4];
        this.position += len + this.currentStructure.padding;
    }

    public void addIntData(int[] data) throws EvioException {
        this.addIntData(data, 0);
    }

    public void addIntData(int[] data, int offset) throws EvioException {
        if (data == null || offset < 0 || data.length - offset < 1) {
            throw new EvioException("no data to add");
        }
        if (this.currentStructure == null) {
            throw new EvioException("add a bank, segment, or tagsegment first");
        }
        if (this.currentStructure.dataType != DataType.INT32 && this.currentStructure.dataType != DataType.UINT32 && this.currentStructure.dataType != DataType.UNKNOWN32) {
            throw new EvioException("may only add " + (Object)((Object)this.currentStructure.dataType) + " data");
        }
        this.buffer.clear();
        int len = data.length - offset;
        if (this.buffer.limit() - this.position < 4 * len) {
            throw new EvioException("no room in buffer");
        }
        this.addToAllLengths(len);
        if (this.useByteBuffer) {
            this.buffer.position(this.position);
            IntBuffer db = this.buffer.asIntBuffer();
            db.put(data, offset, len);
            this.buffer.position(0);
        } else {
            int pos = this.position;
            if (this.order == ByteOrder.BIG_ENDIAN) {
                for (int i = offset; i < data.length; ++i) {
                    int j = data[i];
                    this.array[pos++] = (byte)(j >> 24);
                    this.array[pos++] = (byte)(j >> 16);
                    this.array[pos++] = (byte)(j >> 8);
                    this.array[pos++] = (byte)j;
                }
            } else {
                for (int i = offset; i < data.length; ++i) {
                    int j = data[i];
                    this.array[pos++] = (byte)j;
                    this.array[pos++] = (byte)(j >> 8);
                    this.array[pos++] = (byte)(j >> 16);
                    this.array[pos++] = (byte)(j >> 24);
                }
            }
        }
        this.position += 4 * len;
    }

    public void addShortData(short[] data) throws EvioException {
        if (data == null || data.length < 1) {
            throw new EvioException("no data to add");
        }
        if (this.currentStructure == null) {
            throw new EvioException("add a bank, segment, or tagsegment first");
        }
        if (this.currentStructure.dataType != DataType.SHORT16 && this.currentStructure.dataType != DataType.USHORT16) {
            throw new EvioException("may only add " + (Object)((Object)this.currentStructure.dataType) + " data");
        }
        this.buffer.clear();
        int len = data.length;
        if (this.buffer.limit() - this.position < 2 * len) {
            throw new EvioException("no room in buffer");
        }
        int lastWordLen = (this.currentStructure.dataLen + 1) / 2;
        if (this.currentStructure.dataLen > 0) {
            this.position -= this.currentStructure.padding;
        }
        this.currentStructure.dataLen += len;
        int totalWordLen = (this.currentStructure.dataLen + 1) / 2;
        this.addToAllLengths(totalWordLen - lastWordLen);
        if (this.useByteBuffer) {
            this.buffer.position(this.position);
            ShortBuffer db = this.buffer.asShortBuffer();
            db.put(data, 0, len);
            this.buffer.position(0);
        } else {
            int pos = this.position;
            if (this.order == ByteOrder.BIG_ENDIAN) {
                for (short aData : data) {
                    this.array[pos++] = (byte)(aData >> 8);
                    this.array[pos++] = (byte)aData;
                }
            } else {
                for (short aData : data) {
                    this.array[pos++] = (byte)aData;
                    this.array[pos++] = (byte)(aData >> 8);
                }
            }
        }
        this.currentStructure.padding = 2 * (this.currentStructure.dataLen % 2);
        this.position += 2 * len + this.currentStructure.padding;
    }

    public void addShortData(short data) throws EvioException {
        if (this.currentStructure == null) {
            throw new EvioException("add a bank, segment, or tagsegment first");
        }
        if (this.currentStructure.dataType != DataType.SHORT16 && this.currentStructure.dataType != DataType.USHORT16) {
            throw new EvioException("may only add " + (Object)((Object)this.currentStructure.dataType) + " data");
        }
        this.buffer.clear();
        if (this.buffer.limit() - this.position < 2) {
            throw new EvioException("no room in buffer");
        }
        int lastWordLen = (this.currentStructure.dataLen + 1) / 2;
        if (this.currentStructure.dataLen > 0) {
            this.position -= this.currentStructure.padding;
        }
        ++this.currentStructure.dataLen;
        int totalWordLen = (this.currentStructure.dataLen + 1) / 2;
        this.addToAllLengths(totalWordLen - lastWordLen);
        if (this.useByteBuffer) {
            this.buffer.position(this.position);
            this.buffer.putShort(data);
            this.buffer.position(0);
        } else {
            int pos = this.position;
            if (this.order == ByteOrder.BIG_ENDIAN) {
                this.array[pos++] = (byte)(data >> 8);
                this.array[pos] = (byte)data;
            } else {
                this.array[pos++] = (byte)data;
                this.array[pos] = (byte)(data >> 8);
            }
        }
        this.currentStructure.padding = 2 * (this.currentStructure.dataLen % 2);
        this.position += 2 + this.currentStructure.padding;
    }

    public void addLongData(long[] data) throws EvioException {
        if (data == null || data.length < 1) {
            throw new EvioException("no data to add");
        }
        if (this.currentStructure == null) {
            throw new EvioException("add a bank, segment, or tagsegment first");
        }
        if (this.currentStructure.dataType != DataType.LONG64 && this.currentStructure.dataType != DataType.ULONG64) {
            throw new EvioException("may only add " + (Object)((Object)this.currentStructure.dataType) + " data");
        }
        this.buffer.clear();
        int len = data.length;
        if (this.buffer.limit() - this.position < 8 * len) {
            throw new EvioException("no room in buffer");
        }
        this.addToAllLengths(2 * len);
        if (this.useByteBuffer) {
            this.buffer.position(this.position);
            LongBuffer db = this.buffer.asLongBuffer();
            db.put(data, 0, len);
            this.buffer.position(0);
        } else {
            int pos = this.position;
            if (this.order == ByteOrder.BIG_ENDIAN) {
                for (long aData : data) {
                    this.array[pos++] = (byte)(aData >> 56);
                    this.array[pos++] = (byte)(aData >> 48);
                    this.array[pos++] = (byte)(aData >> 40);
                    this.array[pos++] = (byte)(aData >> 32);
                    this.array[pos++] = (byte)(aData >> 24);
                    this.array[pos++] = (byte)(aData >> 16);
                    this.array[pos++] = (byte)(aData >> 8);
                    this.array[pos++] = (byte)aData;
                }
            } else {
                for (long aData : data) {
                    this.array[pos++] = (byte)aData;
                    this.array[pos++] = (byte)(aData >> 8);
                    this.array[pos++] = (byte)(aData >> 16);
                    this.array[pos++] = (byte)(aData >> 24);
                    this.array[pos++] = (byte)(aData >> 32);
                    this.array[pos++] = (byte)(aData >> 40);
                    this.array[pos++] = (byte)(aData >> 48);
                    this.array[pos++] = (byte)(aData >> 56);
                }
            }
        }
        this.position += 8 * len;
    }

    public void addFloatData(float[] data) throws EvioException {
        if (data == null || data.length < 1) {
            throw new EvioException("no data to add");
        }
        if (this.currentStructure == null) {
            throw new EvioException("add a bank, segment, or tagsegment first");
        }
        if (this.currentStructure.dataType != DataType.FLOAT32) {
            throw new EvioException("may only add " + (Object)((Object)this.currentStructure.dataType) + " data");
        }
        this.buffer.clear();
        int len = data.length;
        if (this.buffer.limit() - this.position < 4 * len) {
            throw new EvioException("no room in buffer");
        }
        this.addToAllLengths(len);
        if (this.useByteBuffer) {
            this.buffer.position(this.position);
            FloatBuffer db = this.buffer.asFloatBuffer();
            db.put(data, 0, len);
            this.buffer.position(0);
        } else {
            int pos = this.position;
            if (this.order == ByteOrder.BIG_ENDIAN) {
                for (float fData : data) {
                    int aData = Float.floatToRawIntBits(fData);
                    this.array[pos++] = (byte)(aData >> 24);
                    this.array[pos++] = (byte)(aData >> 16);
                    this.array[pos++] = (byte)(aData >> 8);
                    this.array[pos++] = (byte)aData;
                }
            } else {
                for (float fData : data) {
                    int aData = Float.floatToRawIntBits(fData);
                    this.array[pos++] = (byte)aData;
                    this.array[pos++] = (byte)(aData >> 8);
                    this.array[pos++] = (byte)(aData >> 16);
                    this.array[pos++] = (byte)(aData >> 24);
                }
            }
        }
        this.position += 4 * len;
    }

    public void addDoubleData(double[] data) throws EvioException {
        if (data == null || data.length < 1) {
            throw new EvioException("no data to add");
        }
        if (this.currentStructure == null) {
            throw new EvioException("add a bank, segment, or tagsegment first");
        }
        if (this.currentStructure.dataType != DataType.DOUBLE64) {
            throw new EvioException("may only add " + (Object)((Object)this.currentStructure.dataType) + " data");
        }
        this.buffer.clear();
        int len = data.length;
        if (this.buffer.limit() - this.position < 8 * len) {
            throw new EvioException("no room in buffer");
        }
        this.addToAllLengths(2 * len);
        if (this.useByteBuffer) {
            this.buffer.position(this.position);
            DoubleBuffer db = this.buffer.asDoubleBuffer();
            db.put(data, 0, len);
            this.buffer.position(0);
        } else {
            int pos = this.position;
            if (this.order == ByteOrder.BIG_ENDIAN) {
                for (double dData : data) {
                    long aData = Double.doubleToRawLongBits(dData);
                    this.array[pos++] = (byte)(aData >> 56);
                    this.array[pos++] = (byte)(aData >> 48);
                    this.array[pos++] = (byte)(aData >> 40);
                    this.array[pos++] = (byte)(aData >> 32);
                    this.array[pos++] = (byte)(aData >> 24);
                    this.array[pos++] = (byte)(aData >> 16);
                    this.array[pos++] = (byte)(aData >> 8);
                    this.array[pos++] = (byte)aData;
                }
            } else {
                for (double dData : data) {
                    long aData = Double.doubleToRawLongBits(dData);
                    this.array[pos++] = (byte)aData;
                    this.array[pos++] = (byte)(aData >> 8);
                    this.array[pos++] = (byte)(aData >> 16);
                    this.array[pos++] = (byte)(aData >> 24);
                    this.array[pos++] = (byte)(aData >> 32);
                    this.array[pos++] = (byte)(aData >> 40);
                    this.array[pos++] = (byte)(aData >> 48);
                    this.array[pos++] = (byte)(aData >> 56);
                }
            }
        }
        this.position += 8 * len;
    }

    public void addStringData(String[] strings) throws EvioException {
        if (strings == null || strings.length < 1) {
            throw new EvioException("no data to add");
        }
        if (this.currentStructure == null) {
            throw new EvioException("add a bank, segment, or tagsegment first");
        }
        if (this.currentStructure.dataType != DataType.CHARSTAR8) {
            throw new EvioException("may only add " + (Object)((Object)this.currentStructure.dataType) + " data");
        }
        byte[] data = BaseStructure.stringsToRawBytes(strings);
        this.buffer.clear();
        int len = data.length;
        if (this.buffer.limit() - this.position < len) {
            throw new EvioException("no room in buffer");
        }
        if (this.currentStructure.dataLen > 0) {
            throw new EvioException("addStringData() may only be called once per structure");
        }
        if (this.useByteBuffer) {
            this.buffer.position(this.position);
            this.buffer.put(data);
            this.buffer.position(0);
        } else {
            System.arraycopy(data, 0, this.array, this.position, len);
        }
        this.currentStructure.dataLen += len;
        this.addToAllLengths(len / 4);
        this.position += len;
    }

    public void addCompositeData(CompositeData[] data) throws EvioException {
        if (data == null || data.length < 1) {
            throw new EvioException("no data to add");
        }
        if (this.currentStructure == null) {
            throw new EvioException("add a bank, segment, or tagsegment first");
        }
        if (this.currentStructure.dataType != DataType.COMPOSITE) {
            throw new EvioException("may only add " + (Object)((Object)this.currentStructure.dataType) + " data");
        }
        byte[] rawBytes = CompositeData.generateRawBytes(data);
        this.buffer.clear();
        int len = rawBytes.length;
        if (this.buffer.limit() - this.position < len) {
            throw new EvioException("no room in buffer");
        }
        if (this.currentStructure.dataLen > 0) {
            throw new EvioException("addCompositeData() may only be called once per structure");
        }
        if (this.useByteBuffer) {
            this.buffer.position(this.position);
            this.buffer.put(rawBytes);
            this.buffer.position(0);
        } else {
            System.arraycopy(rawBytes, 0, this.array, this.position, len);
        }
        this.currentStructure.dataLen += len;
        this.addToAllLengths(len / 4);
        this.position += len;
    }

    public void toFile(String filename) {
        try {
            File file = new File(filename);
            FileOutputStream fos = new FileOutputStream(file);
            DataOutputStream dos = new DataOutputStream(fos);
            boolean writeLastBlock = false;
            this.buffer.limit(this.position);
            this.buffer.position(0);
            int len = this.buffer.remaining();
            int len2 = len / 4 + 8;
            int blockNum = 1;
            int headerLen = 8;
            int evCount = 1;
            int info = 516;
            if (writeLastBlock) {
                info = 4;
            }
            int magicNum = -1059454720;
            if (this.order == ByteOrder.LITTLE_ENDIAN) {
                len2 = Integer.reverseBytes(len2);
                blockNum = Integer.reverseBytes(blockNum);
                headerLen = Integer.reverseBytes(headerLen);
                evCount = Integer.reverseBytes(evCount);
                info = Integer.reverseBytes(info);
                magicNum = Integer.reverseBytes(magicNum);
            }
            dos.writeInt(len2);
            dos.writeInt(blockNum);
            dos.writeInt(headerLen);
            dos.writeInt(evCount);
            dos.writeInt(0);
            dos.writeInt(info);
            dos.writeInt(0);
            dos.writeInt(magicNum);
            dos.write(this.array, 0, len);
            dos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.buffer.clear();
    }

    private final class StructureContent {
        int pos;
        int dataLen;
        int padding;
        DataType type;
        DataType dataType;

        private StructureContent() {
        }

        void setData(int pos, DataType type, DataType dataType) {
            this.pos = pos;
            this.type = type;
            this.dataType = dataType;
            this.dataLen = 0;
            this.padding = 0;
        }
    }
}

