/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.hipo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jlab.coda.hipo.FileEventIndex;
import org.jlab.coda.hipo.FileHeader;
import org.jlab.coda.hipo.HipoException;
import org.jlab.coda.hipo.RecordHeader;
import org.jlab.coda.hipo.RecordInputStream;
import org.jlab.coda.jevio.BlockNode;
import org.jlab.coda.jevio.BufferNode;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;

public class Reader {
    protected final List<RecordPosition> recordPositions = new ArrayList<RecordPosition>();
    protected RandomAccessFile inStreamRandom;
    protected ByteBuffer buffer;
    protected int bufferOffset;
    protected int bufferLimit;
    protected final RecordInputStream inputRecordStream = new RecordInputStream();
    protected int currentRecordLoaded;
    protected FileHeader fileHeader;
    protected RecordHeader firstRecordHeader;
    protected String dictionaryXML;
    protected byte[] firstEvent;
    protected FileEventIndex eventIndex = new FileEventIndex();
    protected boolean fromFile = true;
    private boolean closed;
    private ByteOrder byteOrder;
    private int evioVersion;
    private final ArrayList<EvioNode> eventNodes = new ArrayList(1000);
    private final HashMap<Integer, BlockNode> blockNodes = new HashMap(20);

    public Reader() {
    }

    public Reader(RandomAccessFile file) {
        this.inStreamRandom = file;
    }

    public Reader(String filename) {
        this.open(filename);
        this.scanFile(false);
    }

    public Reader(String filename, boolean forceScan) {
        this.open(filename);
        if (forceScan) {
            this.forceScanFile();
        } else {
            this.scanFile(forceScan);
        }
    }

    public Reader(ByteBuffer buffer) {
        this.buffer = buffer;
        this.bufferOffset = buffer.position();
        this.scanBuffer();
    }

    public final void open(String filename) {
        if (this.inStreamRandom != null && this.inStreamRandom.getChannel().isOpen()) {
            try {
                System.out.println("[READER] ---> closing current file : " + this.inStreamRandom.getFilePointer());
                this.inStreamRandom.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Reader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        try {
            System.out.println("[READER] ----> opening current file : " + filename);
            this.inStreamRandom = new RandomAccessFile(filename, "r");
            System.out.println("[READER] ---> open successful, size : " + this.inStreamRandom.length());
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Reader.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Reader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.fromFile) {
            this.inStreamRandom.close();
        }
        this.closed = true;
    }

    public void setBuffer(ByteBuffer buf) {
        if (buf == null) {
            return;
        }
        this.buffer = buf;
        this.bufferLimit = this.buffer.limit();
        this.bufferOffset = this.buffer.position();
        this.scanBuffer();
        this.closed = false;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    private void setByteOrder(ByteOrder order) {
        this.byteOrder = order;
    }

    public int getVersion() {
        return this.evioVersion;
    }

    public String getDictionary() {
        this.extractDictionary();
        return this.dictionaryXML;
    }

    public boolean hasDictionary() {
        if (this.fromFile) {
            return this.fileHeader.hasDictionary();
        }
        return this.firstRecordHeader.hasDictionary();
    }

    public byte[] getFirstEvent() {
        this.extractDictionary();
        return this.firstEvent;
    }

    public boolean hasFirstEvent() {
        if (this.fromFile) {
            return this.fileHeader.hasFirstEvent();
        }
        return this.firstRecordHeader.hasFirstEvent();
    }

    public int getEventCount() {
        return this.eventIndex.getMaxEvents();
    }

    public int getRecordCount() {
        return this.recordPositions.size();
    }

    public byte[] getNextEvent() throws HipoException {
        if (!this.eventIndex.canAdvance()) {
            return null;
        }
        if (this.eventIndex.advance()) {
            this.readRecord(this.eventIndex.getRecordNumber());
        }
        if (this.inputRecordStream.getEntries() == 0) {
            System.out.println("[READER] first time reading");
            this.readRecord(this.eventIndex.getRecordNumber());
        }
        return this.inputRecordStream.getEvent(this.eventIndex.getRecordEventNumber());
    }

    public byte[] getPrevEvent() throws HipoException {
        if (!this.eventIndex.canRetreat()) {
            return null;
        }
        if (this.eventIndex.retreat()) {
            this.readRecord(this.eventIndex.getRecordNumber());
        }
        return this.inputRecordStream.getEvent(this.eventIndex.getRecordEventNumber());
    }

    public ByteBuffer readUserHeader() {
        int userLen = this.fileHeader.getUserHeaderLength();
        System.out.println("  " + this.fileHeader.getUserHeaderLength() + "  " + this.fileHeader.getHeaderLength() + "  " + this.fileHeader.getIndexLength());
        try {
            byte[] userBytes = new byte[userLen];
            if (this.fromFile) {
                this.inStreamRandom.getChannel().position(this.fileHeader.getHeaderLength() + this.fileHeader.getIndexLength());
                this.inStreamRandom.read(userBytes);
            } else {
                this.buffer.position(this.firstRecordHeader.getHeaderLength() + this.firstRecordHeader.getIndexLength());
                this.buffer.get(userBytes, 0, userLen);
            }
            return ByteBuffer.wrap(userBytes);
        }
        catch (IOException ex) {
            Logger.getLogger(Reader.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public byte[] getEvent(int index) throws HipoException {
        if (index < 0 || index >= this.eventIndex.getMaxEvents()) {
            return null;
        }
        if (this.eventIndex.setEvent(index)) {
            this.readRecord(this.eventIndex.getRecordNumber());
        }
        if (this.inputRecordStream.getEntries() == 0) {
            System.out.println("[READER] first time reading");
            this.readRecord(this.eventIndex.getRecordNumber());
        }
        return this.inputRecordStream.getEvent(this.eventIndex.getRecordEventNumber());
    }

    public ByteBuffer getEvent(ByteBuffer buf, int index) throws HipoException {
        if (index < 0 || index >= this.eventIndex.getMaxEvents()) {
            return null;
        }
        if (this.eventIndex.setEvent(index)) {
            this.readRecord(this.eventIndex.getRecordNumber());
        }
        return this.inputRecordStream.getEvent(buf, this.eventIndex.getRecordEventNumber());
    }

    public boolean hasNext() {
        return this.eventIndex.canAdvance();
    }

    public boolean hasPrev() {
        return this.eventIndex.canRetreat();
    }

    public int getRecordEventCount() {
        return this.inputRecordStream.getEntries();
    }

    public int getCurrentRecord() {
        return this.currentRecordLoaded;
    }

    public RecordInputStream getCurrentRecordStream() {
        return this.inputRecordStream;
    }

    public boolean readRecord(int index) throws HipoException {
        if (index >= 0 && index < this.recordPositions.size()) {
            RecordPosition pos = this.recordPositions.get(index);
            if (this.fromFile) {
                this.inputRecordStream.readRecord(this.inStreamRandom, pos.getPosition());
            } else {
                this.inputRecordStream.readRecord(this.buffer, (int)pos.getPosition());
            }
            this.currentRecordLoaded = index;
            return true;
        }
        return false;
    }

    protected void extractDictionary() {
        if (this.dictionaryXML != null || this.firstEvent != null) {
            return;
        }
        if (this.fromFile) {
            this.extractDictionaryFromFile();
            return;
        }
        this.extractDictionaryFromBuffer();
    }

    protected void extractDictionaryFromBuffer() {
        RecordInputStream record;
        if (!this.firstRecordHeader.hasDictionary() && !this.firstRecordHeader.hasFirstEvent()) {
            return;
        }
        int userLen = this.firstRecordHeader.getUserHeaderLength();
        if (userLen < 8) {
            return;
        }
        try {
            this.buffer.position(this.bufferOffset + this.firstRecordHeader.getHeaderLength() + this.firstRecordHeader.getIndexLength());
            byte[] userBytes = new byte[userLen];
            this.buffer.get(userBytes, 0, userLen);
            ByteBuffer userBuffer = ByteBuffer.wrap(userBytes);
            record = new RecordInputStream(this.firstRecordHeader.getByteOrder());
            record.readRecord(userBuffer, 0);
        }
        catch (HipoException e) {
            return;
        }
        int eventIndex = 0;
        if (this.firstRecordHeader.hasDictionary()) {
            byte[] dict = record.getEvent(eventIndex++);
            try {
                this.dictionaryXML = new String(dict, "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (this.firstRecordHeader.hasFirstEvent()) {
            this.firstEvent = record.getEvent(eventIndex);
        }
    }

    protected void extractDictionaryFromFile() {
        RecordInputStream record;
        if (!this.fileHeader.hasDictionary() && !this.fileHeader.hasFirstEvent()) {
            return;
        }
        int userLen = this.fileHeader.getUserHeaderLength();
        if (userLen < 8) {
            return;
        }
        try {
            this.inStreamRandom.getChannel().position(this.fileHeader.getHeaderLength() + this.fileHeader.getIndexLength());
            byte[] userBytes = new byte[userLen];
            this.inStreamRandom.read(userBytes);
            ByteBuffer userBuffer = ByteBuffer.wrap(userBytes);
            record = new RecordInputStream(this.fileHeader.getByteOrder());
            record.readRecord(userBuffer, 0);
        }
        catch (IOException e) {
            return;
        }
        catch (HipoException e) {
            return;
        }
        int eventIndex = 0;
        if (this.fileHeader.hasDictionary()) {
            byte[] dict = record.getEvent(eventIndex++);
            try {
                this.dictionaryXML = new String(dict, "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (this.fileHeader.hasFirstEvent()) {
            this.firstEvent = record.getEvent(eventIndex);
        }
    }

    public void scanBuffer() {
        byte[] headerBytes = new byte[56];
        ByteBuffer headerBuffer = ByteBuffer.wrap(headerBytes);
        RecordHeader recordHeader = new RecordHeader();
        boolean haveFirstRecordHeader = false;
        try {
            int offset;
            int bufSize = this.buffer.remaining();
            int maximumSize = bufSize - 56;
            this.recordPositions.clear();
            for (int recordPosition = this.bufferOffset; recordPosition < maximumSize; recordPosition += offset) {
                this.buffer.position(recordPosition);
                this.buffer.get(headerBytes, 0, 56);
                recordHeader.readHeader(headerBuffer);
                this.byteOrder = recordHeader.getByteOrder();
                this.evioVersion = recordHeader.getVersion();
                if (!haveFirstRecordHeader) {
                    this.firstRecordHeader = new RecordHeader(recordHeader);
                    haveFirstRecordHeader = true;
                }
                offset = recordHeader.getLength();
                RecordPosition pos = new RecordPosition(recordPosition, offset, recordHeader.getEntries());
                this.recordPositions.add(pos);
                this.eventIndex.addEventSize(recordHeader.getEntries());
            }
        }
        catch (HipoException ex) {
            Logger.getLogger(Reader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void scanBufferNew() throws HipoException, EvioException {
        byte[] headerBytes = new byte[56];
        ByteBuffer headerBuffer = ByteBuffer.wrap(headerBytes);
        RecordHeader recordHeader = new RecordHeader();
        boolean haveFirstRecordHeader = false;
        BufferNode bufferNode = new BufferNode(this.buffer);
        int position = this.bufferOffset;
        int bytesLeft = this.bufferLimit - this.bufferOffset;
        int eventCount = 0;
        this.recordPositions.clear();
        try {
            while (bytesLeft >= 56) {
                this.buffer.position(position);
                this.buffer.get(headerBytes, 0, 56);
                recordHeader.readHeader(headerBuffer);
                if (!haveFirstRecordHeader) {
                    this.byteOrder = recordHeader.getByteOrder();
                    this.evioVersion = recordHeader.getVersion();
                    this.firstRecordHeader = new RecordHeader(recordHeader);
                    haveFirstRecordHeader = true;
                }
                if (recordHeader.getLength() > bytesLeft) {
                    throw new HipoException("Bad hipo format: not enough data to read record");
                }
                int recordBytes = recordHeader.getLength();
                int eventsInRecord = recordHeader.getEntries();
                RecordPosition rp = new RecordPosition(position, recordBytes, eventsInRecord);
                this.recordPositions.add(rp);
                this.eventIndex.addEventSize(eventsInRecord);
                int byteLen = recordHeader.getHeaderLength() + recordHeader.getUserHeaderLength() + recordHeader.getIndexLength();
                position += byteLen;
                bytesLeft -= byteLen;
                for (int i = 0; i < eventsInRecord; ++i) {
                    if (bytesLeft < 8) {
                        throw new HipoException("Bad evio format: not enough data to read event (bad bank len?)");
                    }
                    EvioNode node = EvioNode.extractEventNode(bufferNode, null, position, eventCount + i);
                    this.eventNodes.add(node);
                    byteLen = node.getTotalBytes();
                    position += byteLen;
                    if (byteLen >= 8 && (bytesLeft -= byteLen) >= 0) continue;
                    throw new HipoException("Bad evio format: bad bank length");
                }
                eventCount += eventsInRecord;
            }
            this.buffer.position(this.bufferOffset);
        }
        catch (HipoException ex) {
            Logger.getLogger(Reader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void forceScanFile() {
        byte[] headerBytes = new byte[56];
        ByteBuffer headerBuffer = ByteBuffer.wrap(headerBytes);
        this.fileHeader = new FileHeader();
        RecordHeader recordHeader = new RecordHeader();
        boolean haveFirstRecordHeader = false;
        try {
            int offset;
            long fileSize = this.inStreamRandom.length();
            long maximumSize = fileSize - 56L;
            this.recordPositions.clear();
            FileChannel channel = this.inStreamRandom.getChannel().position(0L);
            this.inStreamRandom.read(headerBytes);
            this.fileHeader.readHeader(headerBuffer);
            this.byteOrder = this.fileHeader.getByteOrder();
            this.evioVersion = this.fileHeader.getVersion();
            for (long recordPosition = (long)(this.fileHeader.getHeaderLength() + this.fileHeader.getUserHeaderLength() + this.fileHeader.getIndexLength()); recordPosition < maximumSize; recordPosition += (long)offset) {
                channel.position(recordPosition);
                this.inStreamRandom.read(headerBytes);
                recordHeader.readHeader(headerBuffer);
                if (!haveFirstRecordHeader) {
                    this.firstRecordHeader = new RecordHeader(recordHeader);
                    haveFirstRecordHeader = true;
                }
                offset = recordHeader.getLength();
                RecordPosition pos = new RecordPosition(recordPosition, offset, recordHeader.getEntries());
                this.recordPositions.add(pos);
                this.eventIndex.addEventSize(recordHeader.getEntries());
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Reader.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (HipoException ex) {
            Logger.getLogger(Reader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void scanFile(boolean force) {
        if (force) {
            this.forceScanFile();
            return;
        }
        byte[] headerBytes = new byte[56];
        ByteBuffer headerBuffer = ByteBuffer.wrap(headerBytes);
        this.fileHeader = new FileHeader();
        RecordHeader recordHeader = new RecordHeader();
        try {
            int indexLength;
            boolean fileHasIndex;
            FileChannel channel = this.inStreamRandom.getChannel().position(0L);
            this.inStreamRandom.read(headerBytes);
            this.fileHeader.readHeader(headerBuffer);
            this.byteOrder = this.fileHeader.getByteOrder();
            this.evioVersion = this.fileHeader.getVersion();
            boolean bl = fileHasIndex = this.fileHeader.hasTrailerWithIndex() || this.fileHeader.hasIndex();
            if (!fileHasIndex) {
                this.forceScanFile();
                return;
            }
            channel.position(this.fileHeader.getHeaderLength());
            long recordPosition = this.fileHeader.getLength();
            if (this.fileHeader.hasTrailerWithIndex()) {
                channel.position(this.fileHeader.getTrailerPosition());
                this.inStreamRandom.read(headerBytes);
                recordHeader.readHeader(headerBuffer);
                indexLength = recordHeader.getIndexLength();
            } else {
                indexLength = this.fileHeader.getIndexLength();
            }
            byte[] index = new byte[indexLength];
            this.inStreamRandom.read(index);
            try {
                int[] intData = ByteDataTransformer.toIntArray(index, this.fileHeader.getByteOrder());
                this.recordPositions.clear();
                for (int i = 0; i < intData.length; i += 2) {
                    int len = intData[i];
                    int count = intData[i + 1];
                    RecordPosition pos = new RecordPosition(recordPosition, len, count);
                    this.recordPositions.add(pos);
                    this.eventIndex.addEventSize(count);
                    recordPosition += (long)len;
                }
            }
            catch (EvioException e) {
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Reader.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (HipoException ex) {
            Logger.getLogger(Reader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void show() {
        System.out.println(" ***** FILE: (info), RECORDS = " + this.recordPositions.size() + " *****");
        for (RecordPosition entry : this.recordPositions) {
            System.out.println(entry);
        }
    }

    public static void main(String[] args) {
        Reader reader = new Reader("/Users/gavalian/Work/Software/project-3a.0.0/Distribution/clas12-offline-software/coatjava/clas_000810_324.hipo", true);
        int icounter = 0;
        while (reader.hasNext()) {
            System.out.println(" reading event # " + icounter);
            try {
                byte[] event = reader.getNextEvent();
            }
            catch (HipoException ex) {
                Logger.getLogger(Reader.class.getName()).log(Level.SEVERE, null, ex);
            }
            ++icounter;
        }
    }

    private static class RecordPosition {
        private long position;
        private int length;
        private int count;

        RecordPosition(long pos) {
            this.position = pos;
        }

        RecordPosition(long pos, int len, int cnt) {
            this.position = pos;
            this.length = len;
            this.count = cnt;
        }

        public RecordPosition setPosition(long _pos) {
            this.position = _pos;
            return this;
        }

        public RecordPosition setLength(int _len) {
            this.length = _len;
            return this;
        }

        public RecordPosition setCount(int _cnt) {
            this.count = _cnt;
            return this;
        }

        public long getPosition() {
            return this.position;
        }

        public int getLength() {
            return this.length;
        }

        public int getCount() {
            return this.count;
        }

        public String toString() {
            return String.format(" POSITION = %16d, LENGTH = %12d, COUNT = %8d", this.position, this.length, this.count);
        }
    }
}

