/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.hipo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import org.jlab.coda.hipo.HipoException;

public class Compressor {
    public static final int RECORD_UNCOMPRESSED = 0;
    public static final int RECORD_COMPRESSION_LZ4 = 1;
    public static final int RECORD_COMPRESSION_LZ4_BEST = 2;
    public static final int RECORD_COMPRESSION_GZIP = 3;
    private static final int MTU = 0x100000;
    private static final LZ4Factory factory = LZ4Factory.fastestInstance();
    private static final LZ4Compressor lz4_compressor = factory.fastCompressor();
    private static final LZ4Compressor lz4_compressor_best = factory.highCompressor();
    private static final LZ4SafeDecompressor lz4_decompressor = factory.safeDecompressor();
    private static Compressor instance = null;

    protected Compressor() {
    }

    public static Compressor getInstance() {
        if (instance == null) {
            instance = new Compressor();
        }
        return instance;
    }

    public static byte[] getCompressedBuffer(int compressionType, byte[] buffer) {
        switch (compressionType) {
            case 3: {
                return Compressor.compressGZIP(buffer);
            }
            case 2: {
                return lz4_compressor_best.compress(buffer);
            }
            case 1: {
                return lz4_compressor.compress(buffer);
            }
        }
        return buffer;
    }

    public static byte[] getUnCompressedBuffer(int compressionType, byte[] compressedBuffer) throws LZ4Exception {
        switch (compressionType) {
            case 3: {
                return Compressor.uncompressGZIP(compressedBuffer);
            }
            case 1: 
            case 2: {
                return lz4_decompressor.decompress(compressedBuffer, 3 * compressedBuffer.length);
            }
        }
        return compressedBuffer;
    }

    public static byte[] compressGZIP(byte[] ungzipped) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(bytes);
            gzipOutputStream.write(ungzipped);
            gzipOutputStream.close();
        }
        catch (IOException e) {
            System.out.println("[iG5DataCompressor] ERROR: Could not gzip the array....");
        }
        return bytes.toByteArray();
    }

    public static byte[] compressGZIP(byte[] ungzipped, int offset, int length) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(bytes);
            gzipOutputStream.write(ungzipped, offset, length);
            gzipOutputStream.close();
        }
        catch (IOException e) {
            System.out.println("[iG5DataCompressor] ERROR: Could not gzip the array....");
        }
        return bytes.toByteArray();
    }

    public static byte[] uncompressGZIP(byte[] gzipped) {
        byte[] ungzipped = new byte[]{};
        try {
            GZIPInputStream inputStream = new GZIPInputStream((InputStream)new ByteArrayInputStream(gzipped), 0x100000);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2 * gzipped.length);
            byte[] buffer = new byte[0x100000];
            int bytesRead = 0;
            while (bytesRead != -1) {
                bytesRead = inputStream.read(buffer, 0, 0x100000);
                if (bytesRead == -1) continue;
                byteArrayOutputStream.write(buffer, 0, bytesRead);
            }
            ungzipped = byteArrayOutputStream.toByteArray();
            inputStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException e) {
            System.out.println("[Evio::compressor] ERROR: could not uncompress the array. \n" + e.getMessage());
        }
        return ungzipped;
    }

    public static byte[] uncompressGZIP(byte[] gzipped, int off, int length) {
        byte[] ungzipped = new byte[]{};
        try {
            GZIPInputStream inputStream = new GZIPInputStream((InputStream)new ByteArrayInputStream(gzipped, off, length), 0x100000);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2 * length);
            byte[] buffer = new byte[0x100000];
            int bytesRead = 0;
            while (bytesRead != -1) {
                bytesRead = inputStream.read(buffer, 0, 0x100000);
                if (bytesRead == -1) continue;
                byteArrayOutputStream.write(buffer, 0, bytesRead);
            }
            ungzipped = byteArrayOutputStream.toByteArray();
            inputStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException e) {
            System.out.println("[Evio::compressor] ERROR: could not uncompress the array. \n" + e.getMessage());
        }
        return ungzipped;
    }

    public static int compressLZ4(ByteBuffer src, int srcSize, ByteBuffer dst, int maxSize) throws HipoException {
        if (lz4_compressor.maxCompressedLength(srcSize) > maxSize) {
            throw new HipoException("maxSize (" + maxSize + ") is < max # of compressed bytes (" + lz4_compressor.maxCompressedLength(srcSize) + ")");
        }
        return lz4_compressor.compress(src.array(), 0, srcSize, dst.array(), 0, maxSize);
    }

    public static int compressLZ4(byte[] src, int srcOff, int srcSize, byte[] dst, int dstOff, int maxSize) throws HipoException {
        if (lz4_compressor.maxCompressedLength(srcSize) > maxSize) {
            throw new HipoException("maxSize (" + maxSize + ") is < max # of compressed bytes (" + lz4_compressor.maxCompressedLength(srcSize) + ")");
        }
        return lz4_compressor.compress(src, srcOff, srcSize, dst, dstOff, maxSize);
    }

    public static int compressLZ4(ByteBuffer src, int srcOff, int srcSize, ByteBuffer dst, int dstOff, int maxSize) throws HipoException {
        if (lz4_compressor.maxCompressedLength(srcSize) > maxSize) {
            throw new HipoException("maxSize (" + maxSize + ") is < max # of compressed bytes (" + lz4_compressor.maxCompressedLength(srcSize) + ")");
        }
        return lz4_compressor.compress(src, srcOff, srcSize, dst, dstOff, maxSize);
    }

    public static int compressLZ4Best(ByteBuffer src, int srcSize, ByteBuffer dst, int maxSize) throws HipoException {
        if (lz4_compressor_best.maxCompressedLength(srcSize) > maxSize) {
            throw new HipoException("maxSize (" + maxSize + ") is < max # of compressed bytes (" + lz4_compressor_best.maxCompressedLength(srcSize) + ")");
        }
        return lz4_compressor_best.compress(src.array(), 0, srcSize, dst.array(), 0, maxSize);
    }

    public static int compressLZ4Best(byte[] src, int srcOff, int srcSize, byte[] dst, int dstOff, int maxSize) throws HipoException {
        if (lz4_compressor_best.maxCompressedLength(srcSize) > maxSize) {
            throw new HipoException("maxSize (" + maxSize + ") is < max # of compressed bytes (" + lz4_compressor_best.maxCompressedLength(srcSize) + ")");
        }
        return lz4_compressor_best.compress(src, srcOff, srcSize, dst, dstOff, maxSize);
    }

    public static int compressLZ4Best(ByteBuffer src, int srcOff, int srcSize, ByteBuffer dst, int dstOff, int maxSize) throws HipoException {
        if (lz4_compressor_best.maxCompressedLength(srcSize) > maxSize) {
            throw new HipoException("maxSize (" + maxSize + ") is < max # of compressed bytes (" + lz4_compressor_best.maxCompressedLength(srcSize) + ")");
        }
        return lz4_compressor_best.compress(src, srcOff, srcSize, dst, dstOff, maxSize);
    }

    public static int uncompressLZ4(ByteBuffer src, int srcSize, ByteBuffer dst) throws HipoException {
        try {
            int i = lz4_decompressor.decompress(src.array(), 0, srcSize, dst.array(), 0);
            dst.position(0).limit(i);
            return i;
        }
        catch (LZ4Exception e) {
            throw new HipoException(e);
        }
    }

    public static int uncompressLZ4(byte[] src, int srcOff, int srcSize, byte[] dst, int dstOff) throws HipoException {
        try {
            return lz4_decompressor.decompress(src, srcOff, srcSize, dst, dstOff);
        }
        catch (LZ4Exception e) {
            throw new HipoException(e);
        }
    }
}

