/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.CompactEventBuilder;
import org.jlab.coda.jevio.CompositeData;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventBuilder;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioReader;
import org.jlab.coda.jevio.EvioSegment;
import org.jlab.coda.jevio.EvioTagSegment;

public class SwapTest {
    static byte[] byteData = new byte[]{-1, 0, -128};
    static short[] shortData = new short[]{-1, 0, Short.MIN_VALUE};
    static int[] intData = new int[]{-1, 0, Integer.MIN_VALUE};
    static long[] longData = new long[]{-1L, 0L, Long.MIN_VALUE};
    static float[] floatData = new float[]{Float.MAX_VALUE, 0.0f, Float.MIN_VALUE};
    static double[] doubleData = new double[]{Double.MAX_VALUE, 0.0, Double.MIN_VALUE};
    static String[] stringData = new String[]{"123", "456", "789"};
    static ByteBuffer firstBlockHeader = ByteBuffer.allocate(32);
    static ByteBuffer emptyLastHeader = ByteBuffer.allocate(32);

    private static void printDoubleBuffer(ByteBuffer byteBuffer) {
        byteBuffer.flip();
        System.out.println();
        for (int i = 0; i < byteBuffer.limit() / 8; ++i) {
            System.out.print(byteBuffer.getDouble() + " ");
            if ((i + 1) % 8 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    private static void printIntBuffer(ByteBuffer byteBuffer) {
        byteBuffer.flip();
        System.out.println();
        for (int i = 0; i < byteBuffer.limit() / 4; ++i) {
            System.out.print(byteBuffer.getInt() + " ");
            if ((i + 1) % 16 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    private static void printBuffer(ByteBuffer buf, int lenInInts) {
        IntBuffer ibuf = buf.asIntBuffer();
        lenInInts = lenInInts > ibuf.capacity() ? ibuf.capacity() : lenInInts;
        for (int i = 0; i < lenInInts; ++i) {
            System.out.println("  Buf(" + i + ") = 0x" + Integer.toHexString(ibuf.get(i)));
        }
    }

    static void setFirstBlockHeader(int words, int count) {
        firstBlockHeader.putInt(0, words + 8);
        firstBlockHeader.putInt(4, 1);
        firstBlockHeader.putInt(8, 8);
        firstBlockHeader.putInt(12, count);
        firstBlockHeader.putInt(16, 0);
        firstBlockHeader.putInt(20, 4);
        firstBlockHeader.putInt(24, 0);
        firstBlockHeader.putInt(28, -1059454720);
    }

    static void swapBlockHeader(ByteBuffer buf, int index) {
        buf.putInt(index, Integer.reverseBytes(buf.getInt(index)));
        buf.putInt(index + 4, Integer.reverseBytes(buf.getInt(index + 4)));
        buf.putInt(index + 8, Integer.reverseBytes(buf.getInt(index + 8)));
        buf.putInt(index + 12, Integer.reverseBytes(buf.getInt(index + 12)));
        buf.putInt(index + 16, Integer.reverseBytes(buf.getInt(index + 16)));
        buf.putInt(index + 20, Integer.reverseBytes(buf.getInt(index + 20)));
        buf.putInt(index + 24, Integer.reverseBytes(buf.getInt(index + 24)));
        buf.putInt(index + 28, Integer.reverseBytes(buf.getInt(index + 28)));
    }

    static CompositeData[] createCompositeData() {
        String format1 = "N(NS,F,D)";
        CompositeData.Data myData1 = new CompositeData.Data();
        myData1.addN(2);
        myData1.addN(3);
        myData1.addShort(new short[]{1, 2, 3});
        myData1.addFloat(Float.MAX_VALUE);
        myData1.addDouble(Double.MAX_VALUE);
        myData1.addN(1);
        myData1.addShort((short)4);
        myData1.addFloat(Float.MIN_VALUE);
        myData1.addDouble(Double.MIN_VALUE);
        myData1.addN(1);
        myData1.addN(1);
        myData1.addShort((short)4);
        myData1.addFloat(4.0f);
        myData1.addDouble(4.0);
        CompositeData.Data myData2 = new CompositeData.Data();
        myData2.addUint(21);
        myData2.addUchar((byte)22);
        myData2.addN(1);
        String[] s = new String[]{"str1", "str2"};
        String asciiFormat = CompositeData.stringsToFormat(s);
        System.out.println("ascii format = " + asciiFormat);
        String format2 = "i,c,N(" + asciiFormat + ",L)";
        myData2.addString(s);
        myData2.addLong(24L);
        CompositeData.Data myData3 = new CompositeData.Data();
        myData3.addChar(byteData[0]);
        myData3.addChar(byteData[1]);
        myData3.addChar(byteData[2]);
        myData3.addUchar(byteData[0]);
        myData3.addUchar(byteData[1]);
        myData3.addUchar(byteData[2]);
        myData3.addShort(shortData[0]);
        myData3.addShort(shortData[1]);
        myData3.addShort(shortData[2]);
        myData3.addUshort(shortData[0]);
        myData3.addUshort(shortData[1]);
        myData3.addUshort(shortData[2]);
        myData3.addInt(intData[0]);
        myData3.addInt(intData[1]);
        myData3.addInt(intData[2]);
        myData3.addUint(intData[0]);
        myData3.addUint(intData[1]);
        myData3.addUint(intData[2]);
        myData3.addLong(longData[0]);
        myData3.addLong(longData[1]);
        myData3.addLong(longData[2]);
        myData3.addUlong(longData[0]);
        myData3.addUlong(longData[1]);
        myData3.addUlong(longData[2]);
        String format3 = "3C,3c,3S,3s,3I,3i,3L,3l";
        String format5 = "N(NS,4I)";
        CompositeData.Data myData5 = new CompositeData.Data();
        myData5.addN(2);
        myData5.addN(3);
        myData5.addShort(new short[]{1, 2, 3});
        myData5.addInt(1);
        myData5.addInt(2);
        myData5.addInt(3);
        myData5.addInt(4);
        myData5.addN(1);
        myData5.addShort((short)4);
        myData5.addInt(3);
        myData5.addInt(4);
        myData5.addInt(5);
        myData5.addInt(6);
        myData5.addN(1);
        myData5.addN(1);
        myData5.addShort((short)4);
        myData5.addInt(5);
        myData5.addInt(6);
        myData5.addInt(7);
        myData5.addInt(8);
        String format6 = "D,2D,3D,3F,4F,5F,5S,6S,7S,7C,8C,9C";
        CompositeData.Data myData6 = new CompositeData.Data();
        myData6.addDouble(Double.MIN_VALUE);
        myData6.addDouble(0.0);
        myData6.addDouble(Double.MAX_VALUE);
        myData6.addDouble(3.0);
        myData6.addDouble(3.0);
        myData6.addDouble(3.0);
        myData6.addFloat(3.0E-10f);
        myData6.addFloat(3.0E10f);
        myData6.addFloat(3.0E10f);
        myData6.addFloat(Float.MIN_VALUE);
        myData6.addFloat(0.0f);
        myData6.addFloat(4.0E11f);
        myData6.addFloat(Float.MAX_VALUE);
        myData6.addFloat(5.0f);
        myData6.addFloat(5.0f);
        myData6.addFloat(5.0f);
        myData6.addFloat(5.0f);
        myData6.addFloat(5.0f);
        short sh = 5;
        myData6.addShort(sh);
        myData6.addShort(sh);
        myData6.addShort(sh);
        myData6.addShort(sh);
        myData6.addShort(sh);
        sh = 6;
        myData6.addShort(sh);
        myData6.addShort(sh);
        myData6.addShort(sh);
        myData6.addShort(sh);
        myData6.addShort(sh);
        myData6.addShort(sh);
        sh = 7;
        myData6.addShort(sh);
        myData6.addShort(sh);
        myData6.addShort(sh);
        myData6.addShort(sh);
        myData6.addShort(sh);
        myData6.addShort(sh);
        myData6.addShort(sh);
        byte b = 8;
        myData6.addChar(b);
        myData6.addChar(b);
        myData6.addChar(b);
        myData6.addChar(b);
        myData6.addChar(b);
        myData6.addChar(b);
        myData6.addChar(b);
        b = 9;
        myData6.addChar(b);
        myData6.addChar(b);
        myData6.addChar(b);
        myData6.addChar(b);
        myData6.addChar(b);
        myData6.addChar(b);
        myData6.addChar(b);
        myData6.addChar(b);
        b = 10;
        myData6.addChar(b);
        myData6.addChar(b);
        myData6.addChar(b);
        myData6.addChar(b);
        myData6.addChar(b);
        myData6.addChar(b);
        myData6.addChar(b);
        myData6.addChar(b);
        myData6.addChar(b);
        CompositeData[] cData = new CompositeData[5];
        try {
            cData[0] = new CompositeData(format1, 1, myData1, 1, 1);
            cData[1] = new CompositeData(format2, 2, myData2, 2, 2);
            cData[2] = new CompositeData(format3, 3, myData3, 3, 3);
            cData[3] = new CompositeData(format5, 5, myData5, 5, 5);
            cData[4] = new CompositeData(format6, 6, myData6, 6, 6);
        }
        catch (EvioException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        return cData;
    }

    static EvioEvent createSingleEvent(int tag) {
        EvioEvent event = null;
        try {
            EventBuilder builder = new EventBuilder(tag, DataType.BANK, 1);
            event = builder.getEvent();
            EvioBank bankBanks = new EvioBank(tag + 1, DataType.BANK, 2);
            builder.addChild(event, bankBanks);
            EvioBank bankInts = new EvioBank(tag + 2, DataType.INT32, 3);
            builder.setIntData(bankInts, intData);
            builder.addChild(bankBanks, bankInts);
            EvioBank bankUInts = new EvioBank(tag + 2, DataType.UINT32, 33);
            builder.setIntData(bankUInts, intData);
            builder.addChild(bankBanks, bankUInts);
            EvioBank bankBytes = new EvioBank(tag + 3, DataType.CHAR8, 4);
            builder.setByteData(bankBytes, byteData);
            builder.addChild(bankBanks, bankBytes);
            EvioBank bankUBytes = new EvioBank(tag + 3, DataType.UCHAR8, 34);
            builder.setByteData(bankUBytes, byteData);
            builder.addChild(bankBanks, bankUBytes);
            EvioBank bankShorts = new EvioBank(tag + 4, DataType.SHORT16, 5);
            bankShorts.appendShortData(shortData);
            builder.addChild(bankBanks, bankShorts);
            EvioBank bankUShorts = new EvioBank(tag + 4, DataType.USHORT16, 35);
            bankUShorts.appendShortData(shortData);
            builder.addChild(bankBanks, bankUShorts);
            EvioBank bankLongs = new EvioBank(tag + 5, DataType.LONG64, 6);
            bankLongs.appendLongData(longData);
            builder.addChild(bankBanks, bankLongs);
            EvioBank bankULongs = new EvioBank(tag + 5, DataType.ULONG64, 6);
            bankULongs.appendLongData(longData);
            builder.addChild(bankBanks, bankULongs);
            EvioBank bankFloats = new EvioBank(tag + 6, DataType.FLOAT32, 7);
            bankFloats.appendFloatData(floatData);
            builder.addChild(bankBanks, bankFloats);
            EvioBank bankDoubles = new EvioBank(tag + 7, DataType.DOUBLE64, 8);
            bankDoubles.appendDoubleData(doubleData);
            builder.addChild(bankBanks, bankDoubles);
            EvioBank bankStrings = new EvioBank(tag + 8, DataType.CHARSTAR8, 9);
            bankStrings.appendStringData(stringData);
            builder.addChild(bankBanks, bankStrings);
            CompositeData[] cdata = SwapTest.createCompositeData();
            EvioBank bankComps = new EvioBank(tag + 9, DataType.COMPOSITE, 10);
            bankComps.appendCompositeData(cdata);
            builder.addChild(bankBanks, bankComps);
            EvioBank bankBanks2 = new EvioBank(tag + 10, DataType.SEGMENT, 11);
            builder.addChild(event, bankBanks2);
            EvioSegment segInts = new EvioSegment(tag + 11, DataType.INT32);
            segInts.appendIntData(intData);
            builder.addChild(bankBanks2, segInts);
            EvioSegment segShorts = new EvioSegment(tag + 12, DataType.SHORT16);
            segShorts.appendShortData(shortData);
            builder.addChild(bankBanks2, segShorts);
            EvioSegment segSegments = new EvioSegment(tag + 13, DataType.SEGMENT);
            builder.addChild(bankBanks2, segSegments);
            EvioSegment segBytes = new EvioSegment(tag + 14, DataType.CHAR8);
            segBytes.appendByteData(byteData);
            builder.addChild(segSegments, segBytes);
            EvioSegment segDoubles = new EvioSegment(tag + 15, DataType.DOUBLE64);
            segDoubles.appendDoubleData(doubleData);
            builder.addChild(segSegments, segDoubles);
            EvioBank bankBanks4 = new EvioBank(tag + 16, DataType.TAGSEGMENT, 17);
            builder.addChild(event, bankBanks4);
            EvioTagSegment tagSegBytes = new EvioTagSegment(tag + 17, DataType.CHAR8);
            tagSegBytes.appendByteData(byteData);
            builder.addChild(bankBanks4, tagSegBytes);
            EvioTagSegment tagSegShorts = new EvioTagSegment(tag + 18, DataType.SHORT16);
            tagSegShorts.appendShortData(shortData);
            builder.addChild(bankBanks4, tagSegShorts);
            EvioTagSegment tagsegLongs = new EvioTagSegment(tag + 19, DataType.LONG64);
            tagsegLongs.appendLongData(longData);
            builder.addChild(bankBanks4, tagsegLongs);
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return event;
    }

    static EvioEvent createBabyEvent(int tag) {
        EvioEvent event = null;
        try {
            EventBuilder builder = new EventBuilder(tag, DataType.BANK, 1);
            event = builder.getEvent();
            EvioBank bankInts = new EvioBank(tag + 2, DataType.INT32, 3);
            builder.setIntData(bankInts, intData);
            builder.addChild(event, bankInts);
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return event;
    }

    static ByteBuffer createCompactSingleEvent(int tag) {
        ByteBuffer buffer = ByteBuffer.allocate(1048);
        CompactEventBuilder builder = null;
        int num = tag;
        try {
            builder = new CompactEventBuilder(buffer);
            builder.openBank(tag, num, DataType.BANK);
            builder.openBank(tag + 1, num + 1, DataType.BANK);
            builder.openBank(tag + 2, num + 2, DataType.INT32);
            builder.addIntData(intData);
            builder.closeStructure();
            builder.openBank(tag + 2, num + 32, DataType.UINT32);
            builder.addIntData(intData);
            builder.closeStructure();
            builder.openBank(tag + 3, num + 3, DataType.CHAR8);
            builder.addByteData(byteData);
            builder.closeStructure();
            builder.openBank(tag + 3, num + 33, DataType.UCHAR8);
            builder.addByteData(byteData);
            builder.closeStructure();
            builder.openBank(tag + 4, num + 4, DataType.SHORT16);
            builder.addShortData(shortData);
            builder.closeStructure();
            builder.openBank(tag + 4, num + 34, DataType.USHORT16);
            builder.addShortData(shortData);
            builder.closeStructure();
            builder.openBank(tag + 5, num + 5, DataType.LONG64);
            builder.addLongData(longData);
            builder.closeStructure();
            builder.openBank(tag + 5, num + 35, DataType.ULONG64);
            builder.addLongData(longData);
            builder.closeStructure();
            builder.openBank(tag + 6, num + 6, DataType.FLOAT32);
            builder.addFloatData(floatData);
            builder.closeStructure();
            builder.openBank(tag + 7, num + 7, DataType.DOUBLE64);
            builder.addDoubleData(doubleData);
            builder.closeStructure();
            builder.openBank(tag + 8, num + 8, DataType.CHARSTAR8);
            builder.addStringData(stringData);
            builder.closeStructure();
            CompositeData[] cdata = SwapTest.createCompositeData();
            builder.openBank(tag + 9, num + 9, DataType.COMPOSITE);
            builder.addCompositeData(cdata);
            builder.closeStructure();
            builder.closeStructure();
            builder.openBank(tag + 10, num + 10, DataType.SEGMENT);
            builder.openSegment(tag + 11, DataType.INT32);
            builder.addIntData(intData);
            builder.closeStructure();
            builder.openSegment(tag + 12, DataType.SHORT16);
            builder.addShortData(shortData);
            builder.closeStructure();
            builder.openSegment(tag + 13, DataType.SEGMENT);
            builder.openSegment(tag + 14, DataType.CHAR8);
            builder.addByteData(byteData);
            builder.closeStructure();
            builder.openSegment(tag + 15, DataType.DOUBLE64);
            builder.addDoubleData(doubleData);
            builder.closeStructure();
            builder.closeStructure();
            builder.closeStructure();
            builder.openBank(tag + 16, num + 16, DataType.TAGSEGMENT);
            builder.openTagSegment(tag + 17, DataType.CHAR8);
            builder.addByteData(byteData);
            builder.closeStructure();
            builder.openTagSegment(tag + 18, DataType.SHORT16);
            builder.addShortData(shortData);
            builder.closeStructure();
            builder.openTagSegment(tag + 19, DataType.LONG64);
            builder.addLongData(longData);
            builder.closeStructure();
            builder.closeAll();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return builder.getBuffer();
    }

    static ByteBuffer createCompactBabyEvent(int tag) {
        ByteBuffer buffer = ByteBuffer.allocate(1048);
        CompactEventBuilder builder = null;
        int num = tag;
        try {
            builder = new CompactEventBuilder(buffer);
            builder.openBank(tag, num, DataType.BANK);
            builder.openBank(tag + 2, num + 2, DataType.INT32);
            builder.addIntData(intData);
            builder.closeStructure();
            builder.closeAll();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return builder.getBuffer();
    }

    public static void main1(String[] args) {
        try {
            EvioEvent bank = SwapTest.createSingleEvent(1);
            int byteSize = bank.getTotalBytes();
            ByteBuffer bb1 = ByteBuffer.allocate(byteSize);
            ByteBuffer bb2 = ByteBuffer.allocate(byteSize);
            bank.write(bb1);
            bb1.flip();
            for (int i = 0; i < 2000000; ++i) {
                ByteDataTransformer.swapEvent(bb1, bb2, 0, 0);
                ByteDataTransformer.swapEvent(bb2, bb1, 0, 0);
            }
            long t1 = System.currentTimeMillis();
            for (int i = 0; i < 2000000; ++i) {
                ByteDataTransformer.swapEvent(bb1, bb2, 0, 0);
                ByteDataTransformer.swapEvent(bb2, bb1, 0, 0);
            }
            long t2 = System.currentTimeMillis();
            System.out.println("Time = " + (t2 - t1) + " millisec");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main2(String[] args) {
        boolean useEventBuilder = false;
        try {
            ByteBuffer bb;
            if (useEventBuilder) {
                EvioEvent bank = SwapTest.createSingleEvent(1);
                int byteSize = bank.getTotalBytes();
                EvioEvent bank2 = SwapTest.createBabyEvent(100);
                int byteSize2 = bank2.getTotalBytes();
                bb = ByteBuffer.allocate(byteSize + byteSize2 + 64);
                SwapTest.setFirstBlockHeader(byteSize / 4, 2);
                bb.put(firstBlockHeader);
                firstBlockHeader.position(0);
                bank.write(bb);
                bank2.write(bb);
            } else {
                ByteBuffer buffie = SwapTest.createCompactSingleEvent(1);
                int byteSize = buffie.limit();
                ByteBuffer buffie2 = SwapTest.createCompactBabyEvent(100);
                int byteSize2 = buffie2.limit();
                bb = ByteBuffer.allocate(byteSize + byteSize2 + 64);
                SwapTest.setFirstBlockHeader(byteSize / 4, 2);
                bb.put(firstBlockHeader);
                firstBlockHeader.position(0);
                bb.put(buffie);
                bb.put(buffie2);
            }
            bb.put(emptyLastHeader);
            emptyLastHeader.position(0);
            bb.flip();
            File evFile = new File("/home/timmer/evioTestFiles/xmlTests/regularEvent2.evio");
            FileOutputStream fileOutputStream = new FileOutputStream(evFile);
            FileChannel fileChannel = fileOutputStream.getChannel();
            fileChannel.write(bb);
            fileChannel.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        boolean useEventBuilder = false;
        int byteSize = 0;
        try {
            ByteBuffer bb2;
            ByteBuffer bb1;
            if (useEventBuilder) {
                EvioEvent bank = SwapTest.createSingleEvent(1);
                byteSize = bank.getTotalBytes();
                bb1 = ByteBuffer.allocate(byteSize + 64);
                bb2 = ByteBuffer.allocate(byteSize + 64);
                SwapTest.setFirstBlockHeader(byteSize / 4, 1);
                bb1.put(firstBlockHeader);
                firstBlockHeader.position(0);
                bank.write(bb1);
            } else {
                ByteBuffer buffie = SwapTest.createCompactSingleEvent(1);
                byteSize = buffie.limit();
                bb1 = ByteBuffer.allocate(byteSize + 64);
                bb2 = ByteBuffer.allocate(byteSize + 64);
                SwapTest.setFirstBlockHeader(byteSize / 4, 1);
                bb1.put(firstBlockHeader);
                firstBlockHeader.position(0);
                bb1.put(buffie);
            }
            bb1.put(emptyLastHeader);
            emptyLastHeader.position(0);
            bb1.flip();
            ByteDataTransformer.swapEvent(bb1, bb2, 32, 32);
            bb2.position(0);
            bb2.put(firstBlockHeader);
            firstBlockHeader.position(0);
            SwapTest.swapBlockHeader(bb2, 0);
            bb2.position(32 + byteSize);
            bb2.put(emptyLastHeader);
            emptyLastHeader.position(0);
            SwapTest.swapBlockHeader(bb2, 32 + byteSize);
            bb2.position(0);
            File evFile = new File("/home/timmer/evioTestFiles/xmlTests/regularEvent.evio");
            FileOutputStream fileOutputStream = new FileOutputStream(evFile);
            FileChannel fileChannel = fileOutputStream.getChannel();
            fileChannel.write(bb1);
            fileChannel.close();
            File evFile2 = new File("/home/timmer/evioTestFiles/xmlTests/swappedEvent.evio");
            fileOutputStream = new FileOutputStream(evFile2);
            fileChannel = fileOutputStream.getChannel();
            fileChannel.write(bb2);
            fileChannel.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main3(String[] args) {
        try {
            EvioEvent bank = SwapTest.createSingleEvent(1);
            int byteSize = bank.getTotalBytes();
            ByteBuffer bb1 = ByteBuffer.allocate(byteSize + 64);
            ByteBuffer bb2 = ByteBuffer.allocate(byteSize + 64);
            ByteBuffer bb3 = ByteBuffer.allocate(byteSize + 64);
            SwapTest.setFirstBlockHeader(byteSize / 4, 1);
            bb1.put(firstBlockHeader);
            firstBlockHeader.position(0);
            bank.write(bb1);
            bb1.put(emptyLastHeader);
            emptyLastHeader.position(0);
            bb1.flip();
            System.out.println("bb1 limit = " + bb1.limit() + ", pos = " + bb1.position() + ", cap = " + bb1.capacity());
            System.out.println("XML:\n" + bank.toXML());
            System.out.println("\n*************\n");
            ByteDataTransformer.swapEvent(bb1, bb2, 32, 32);
            bb2.position(0);
            bb2.put(firstBlockHeader);
            firstBlockHeader.position(0);
            SwapTest.swapBlockHeader(bb2, 0);
            bb2.position(32 + byteSize);
            bb2.put(emptyLastHeader);
            emptyLastHeader.position(0);
            SwapTest.swapBlockHeader(bb2, 32 + byteSize);
            ByteDataTransformer.swapEvent(bb2, bb3, 32, 32);
            bb3.position(0);
            bb3.put(firstBlockHeader);
            firstBlockHeader.position(0);
            SwapTest.swapBlockHeader(bb3, 0);
            SwapTest.swapBlockHeader(bb3, 0);
            bb3.position(32 + byteSize);
            bb3.put(emptyLastHeader);
            emptyLastHeader.position(0);
            SwapTest.swapBlockHeader(bb3, 32 + byteSize);
            SwapTest.swapBlockHeader(bb3, 32 + byteSize);
            EvioReader reader = new EvioReader(bb3);
            EvioEvent ev = reader.parseEvent(1);
            bb3.position(0);
            System.out.println("\n\n reconstituted XML:\n" + ev.toXML());
            System.out.println("bb1 limit = " + bb1.limit() + ", pos = " + bb1.position() + ", cap = " + bb1.capacity());
            System.out.println("bb3 limit = " + bb3.limit() + ", pos = " + bb3.position() + ", cap = " + bb3.capacity());
            IntBuffer ibuf1 = bb1.asIntBuffer();
            IntBuffer ibuf2 = bb3.asIntBuffer();
            int lenInInts = ibuf1.limit() < ibuf1.capacity() ? ibuf1.limit() : ibuf1.capacity();
            System.out.println("ibuf1 limit = " + ibuf1.limit() + ", cap = " + ibuf1.capacity());
            System.out.println("ibuf2 limit = " + ibuf2.limit() + ", cap = " + ibuf2.capacity());
            System.out.println("bb1           bb2\n---------------------------");
            for (int i = 0; i < lenInInts; ++i) {
                if (ibuf1.get(i) == ibuf2.get(i)) continue;
                System.out.println("index " + i + ": 0x" + Integer.toHexString(ibuf1.get(i)) + " swapped to 0x" + Integer.toHexString(ibuf2.get(i)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        emptyLastHeader.putInt(0, 8);
        emptyLastHeader.putInt(4, 2);
        emptyLastHeader.putInt(8, 8);
        emptyLastHeader.putInt(12, 0);
        emptyLastHeader.putInt(16, 0);
        emptyLastHeader.putInt(20, 516);
        emptyLastHeader.putInt(24, 0);
        emptyLastHeader.putInt(28, -1059454720);
    }
}

