/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.IOException;
import java.nio.ByteOrder;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventBuilder;
import org.jlab.coda.jevio.EventWriter;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.Utilities;

public class SplitTest {
    static String xmlDictionary = "<xmlDict>\n  <dictEntry name=\"TAG1_NUM1\" tag=\"1\"  num=\"1\"/>\n  <dictEntry name=\"TAG1\"      tag=\"1\"  />\n</xmlDict>";

    static EvioEvent createEvent(int dataWordSize) {
        EvioEvent event = null;
        try {
            EventBuilder builder = new EventBuilder(1, DataType.BANK, 1);
            event = builder.getEvent();
            EvioBank bankInts = new EvioBank(2, DataType.INT32, 2);
            int[] data = new int[dataWordSize];
            for (int i = 0; i < dataWordSize; ++i) {
                data[i] = i;
            }
            bankInts.appendIntData(data);
            builder.addChild(event, bankInts);
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return event;
    }

    public static void main(String[] args) {
        try {
            String baseName = "my_$(FILE_ENV)_%s_run_%d_.dat_stuff";
            String runType = "RunType";
            int runNumber = 2;
            long split = 0L;
            int splitCount = 0;
            StringBuilder builder = new StringBuilder(100);
            int specifierCount = Utilities.generateBaseFileName(baseName, runType, builder);
            String baseFileName = builder.toString();
            String fileName = Utilities.generateFileName(baseFileName, specifierCount, runNumber, split, splitCount++);
            System.out.println("EventWriter const: filename = " + fileName);
            System.out.println("                   basename = " + baseName);
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
    }

    public static void main2(String[] args) {
        String fileName = "/daqfs/home/timmer/coda/evio-4.1/my$(FILE_ENV)run_%d_.dat_%4d";
        String fileName2 = "/daqfs/home/timmer/coda/evio-4.1/myFILE";
        EvioEvent littleEvent = SplitTest.createEvent(4);
        EvioEvent biggestEvent = SplitTest.createEvent(16);
        boolean append = false;
        int runNumber = 72;
        int split = 480;
        int blockSizeMax = 36;
        int blockCountMax = 2;
        int bufferSize = 240;
        try {
            EventWriter writer = new EventWriter(fileName, null, "runType", runNumber, split, blockSizeMax, blockCountMax, bufferSize, ByteOrder.BIG_ENDIAN, xmlDictionary, null, true, append);
            for (int i = 0; i < 20; ++i) {
                writer.writeEvent(littleEvent);
            }
            writer.close();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

