/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.EvioByteArrayOutputStream;
import org.jlab.coda.jevio.EvioException;

class GzipCompression4 {
    EvioByteArrayOutputStream byteArrayOut;
    GZIPOutputStream gzipOut;
    ByteBuffer buffer;
    int[] intData = new int[50];

    public GzipCompression4() {
        for (int i = 0; i < this.intData.length; ++i) {
            this.intData[i] = i;
        }
        byte[] bytes = new byte[]{};
        try {
            bytes = ByteDataTransformer.toBytes(this.intData, ByteOrder.BIG_ENDIAN);
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        this.buffer = ByteBuffer.wrap(bytes);
        this.byteArrayOut = new EvioByteArrayOutputStream(this.buffer.capacity() + 101);
        try {
            this.gzipOut = new GZIPOutputStream(this.byteArrayOut);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeFile() throws IOException {
        int bytesWritten = this.buffer.remaining();
        System.out.println("Writing " + bytesWritten + " uncompressed bytes");
        if (this.buffer.hasArray()) {
            this.gzipOut.write(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.position(), bytesWritten);
        } else {
            while (this.buffer.hasRemaining()) {
                this.gzipOut.write(this.buffer.get());
            }
        }
        this.gzipOut.finish();
        this.gzipOut.close();
        this.byteArrayOut.close();
        ByteBuffer compressedBuf = this.byteArrayOut.getByteBuffer();
        System.out.println("Compressed buf: cap = " + compressedBuf.capacity() + ", pos = " + compressedBuf.position() + ", lim = " + compressedBuf.limit());
        File currentFile = new File("/scratch/timmer/myIntDataFile");
        RandomAccessFile raf = new RandomAccessFile(currentFile, "rw");
        FileChannel fileChannel = raf.getChannel();
        while (compressedBuf.hasRemaining()) {
            fileChannel.write(compressedBuf);
        }
        fileChannel.close();
        System.out.println("\nFINISH Gzip output and close stream\n");
    }

    public void readAndPrintFile() throws IOException {
        int len;
        File inFile = new File("/scratch/timmer/myIntDataFile");
        int fileLength = (int)inFile.length();
        GZIPInputStream in = new GZIPInputStream(new FileInputStream(inFile));
        byte[] buf = new byte[2 * fileLength + 1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            int i;
            int intArrayLen = len / 4;
            int[] ints = new int[intArrayLen];
            for (i = 0; i < intArrayLen; ++i) {
                int indx = i * 4;
                ints[i] = ByteDataTransformer.toInt(buf[indx], buf[indx + 1], buf[indx + 2], buf[indx + 3], ByteOrder.BIG_ENDIAN);
            }
            for (i = 0; i < intArrayLen; ++i) {
                if (i % 5 == 0) {
                    System.out.print("\n  Buf(" + (i + 1) + "-" + (i + 5) + ") =  ");
                }
                System.out.print(String.format("%08x", ints[i]) + "  ");
            }
            System.out.println();
            System.out.println();
        }
        ((InputStream)in).close();
    }

    public static void main(String[] args) throws IOException, DataFormatException {
        GzipCompression4 comp = new GzipCompression4();
        comp.writeFile();
        comp.readAndPrintFile();
    }
}

