/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.jlab.coda.jevio.CompactEventBuilder;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventWriter;
import org.jlab.coda.jevio.EventWriterUnsync;
import org.jlab.coda.jevio.EvioException;

public class FileWritingSpeedTest {
    static String filename;
    static boolean unsync;

    private static void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                FileWritingSpeedTest.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-f")) {
                filename = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-unsync")) {
                unsync = true;
                continue;
            }
            FileWritingSpeedTest.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java BigFileWrite\n        [-f <filename>]     name of file to write\n        [-unsync]           use unsynchronized writer\n        [-h]                print this help\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        FileWritingSpeedTest.decodeCommandLine(args);
        if (filename == null) {
            filename = "/scratch/timmer/fileWritingSpeedTest.ev";
        }
        File file = new File(filename);
        EventWriter writer = null;
        EventWriterUnsync writerUnsync = null;
        try {
            try {
                long t2;
                long splitBytes = 20000000000L;
                if (unsync) {
                    writerUnsync = new EventWriterUnsync(file.getPath(), null, null, 0, splitBytes, ByteOrder.BIG_ENDIAN, null);
                } else {
                    writer = new EventWriter(file.getPath(), null, null, 0, splitBytes, ByteOrder.BIG_ENDIAN, null);
                }
                ByteBuffer eventBuf = FileWritingSpeedTest.createEventBuffer();
                int eventSize = eventBuf.remaining();
                System.out.println("event size = " + eventSize);
                int skip = 2;
                int printPeriod = 5000;
                long oldVal = 0L;
                long totalT = 0L;
                long totalCount = 0L;
                long counter = 0L;
                long byteCountTotal = 0L;
                long t1 = t2 = System.currentTimeMillis();
                while (true) {
                    long deltaT;
                    if (unsync) {
                        writerUnsync.writeEvent(eventBuf);
                    } else {
                        writer.writeEvent(eventBuf);
                    }
                    eventBuf.flip();
                    byteCountTotal += (long)eventSize;
                    if ((0xFFL & counter++) == 0L) {
                        t2 = System.currentTimeMillis();
                    }
                    if ((deltaT = t2 - t1) <= (long)printPeriod) continue;
                    if (skip-- < 1) {
                        long deltaCount = byteCountTotal - oldVal;
                        System.out.println("File writing: byte rate = " + String.format("%.3g", (double)deltaCount * 1000.0 / (double)deltaT) + ",  avg = " + String.format("%.3g", (double)(totalCount += deltaCount) * 1000.0 / (double)(totalT += deltaT)) + " Hz");
                    } else {
                        System.out.println("File writing: byte rate = " + String.format("%.3g", (double)(byteCountTotal - oldVal) * 1000.0 / (double)deltaT) + " Hz");
                    }
                    t1 = t2;
                    oldVal = byteCountTotal;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("FileTest, call close()");
                if (unsync) {
                    writerUnsync.close();
                } else {
                    writer.close();
                }
            }
        }
        catch (Throwable throwable) {
            System.out.println("FileTest, call close()");
            if (unsync) {
                writerUnsync.close();
            } else {
                writer.close();
            }
            throw throwable;
        }
    }

    private static ByteBuffer createEventBuffer() {
        try {
            int i;
            CompactEventBuilder b = new CompactEventBuilder(ByteBuffer.allocateDirect(31000));
            int EBid = 1;
            int numRocs = 100;
            int numEvents = 20;
            long startingEventNumber = 2L;
            b.openBank(65360, numEvents, DataType.BANK);
            b.openBank(65319, numRocs, DataType.SEGMENT);
            b.openSegment(EBid, DataType.ULONG64);
            long[] t = new long[numEvents + 2];
            for (int i2 = 0; i2 < numEvents; ++i2) {
                t[i2 + 1] = 10 + i2;
            }
            t[0] = startingEventNumber;
            t[numEvents + 1] = 0L;
            b.addLongData(t);
            b.closeStructure();
            b.openSegment(EBid, DataType.USHORT16);
            short[] s = new short[numEvents];
            Arrays.fill(s, (short)20);
            b.addShortData(s);
            b.closeStructure();
            int[] rocTS = new int[numEvents];
            for (i = 0; i < numEvents; ++i) {
                rocTS[i] = 10 + i;
            }
            i = 0;
            while (i < numRocs) {
                int rocId = i++;
                b.openSegment(rocId, DataType.UINT32);
                b.addIntData(rocTS);
                b.closeStructure();
            }
            b.closeStructure();
            int[] data = new int[50];
            Arrays.fill(data, -252645136);
            data[0] = (int)startingEventNumber;
            data[1] = 10;
            for (int i3 = 0; i3 < numRocs; ++i3) {
                int rocId = i3;
                b.openBank(rocId, numEvents, DataType.BANK);
                int detectorId = 10 * i3;
                b.openBank(detectorId, numEvents, DataType.INT32);
                b.addIntData(data);
                b.closeStructure();
                b.closeStructure();
            }
            b.closeAll();
            return b.getBuffer();
        }
        catch (EvioException e) {
            e.printStackTrace();
            return null;
        }
    }
}

