/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventBuilder;
import org.jlab.coda.jevio.EventParser;
import org.jlab.coda.jevio.EventWriter;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioReader;
import org.jlab.coda.jevio.EvioXMLDictionary;
import org.jlab.coda.jevio.IEvioFilter;
import org.jlab.coda.jevio.IEvioListener;
import org.jlab.coda.jevio.IEvioStructure;
import org.jlab.coda.jevio.NameProvider;
import org.jlab.coda.jevio.StructureFinder;
import org.jlab.coda.jevio.StructureType;

public class FileTest {
    static int[] data1 = new int[]{20, 1, 10, 2, 0, 4, 0, -1059454720, 3, 2, 4, 65793, 1, 1, 1, 4, 65793, 2, 2, 2, 25, 2, 10, 3, 0, 4, 0, -1059454720, 1, 2, 4, 65793, 3, 3, 3, 4, 65793, 4, 4, 4, 4, 65793, 5, 5, 5, 9, 3, 9, 0, 0, 516, 0, -1059454720, 3};

    public static void main(String[] args) {
        String fileName = "/home/timmer/fileTestSmall.ev";
        File file = new File(fileName);
        ByteBuffer myBuf = null;
        String xmlDictionary = "<xmlDict>\n  <bank name=\"My Event\"       tag=\"1\"   num=\"1\">\n     <bank name=\"Ints\"    tag=\"2\"   num=\"2\">\n       <leaf name=\"My Shorts\" tag=\"3\"   />\n     </bank>\n     <bank name=\"Banks\"       tag=\"4\"   num=\"4\">\n       <leaf name=\"My chars\"  tag=\"5\"   num=\"5\"/>\n     </bank>\n  </bank>\n  <dictEntry name=\"First Event\" tag=\"100\"  num=\"100\"/>\n  <dictEntry name=\"Test Bank\" tag=\"1\" />\n</xmlDict>";
        byte[] byteData1 = new byte[]{1, 2, 3, 4, 5};
        int[] intData1 = new int[]{1, 2, 3, 4};
        int[] intData2 = new int[]{7, 8, 9};
        short[] shortData = new short[]{11, 22, 33};
        double[] doubleData = new double[]{1.1, 2.2, 3.3};
        boolean append = false;
        boolean useFile = true;
        EvioEvent event = null;
        try {
            int i;
            EventWriter writer;
            EventBuilder builder = new EventBuilder(1, DataType.INT32, 1);
            event = builder.getEvent();
            event.appendIntData(intData1);
            EventBuilder builder3 = new EventBuilder(100, DataType.INT32, 100);
            EvioEvent eventFirst = builder3.getEvent();
            int[] intFirstData = new int[6];
            for (int i2 = 0; i2 < intFirstData.length; ++i2) {
                intFirstData[i2] = 256 * (i2 + 1);
            }
            eventFirst.appendIntData(intFirstData);
            if (useFile) {
                int splitBytes = 160;
                int targetBlockSize = 29;
                int internalBufSize = 148;
                writer = new EventWriter(file.getPath(), null, null, 0, splitBytes, targetBlockSize, 1000, internalBufSize, ByteOrder.nativeOrder(), xmlDictionary, null, true, append, eventFirst);
            } else {
                myBuf = ByteBuffer.allocate(10000);
                writer = new EventWriter(myBuf, 28, 1000, null, null, 0, 1, append, null);
            }
            EventBuilder builder2 = new EventBuilder(10, DataType.INT32, 10);
            EvioEvent event2 = builder2.getEvent();
            int[] intData = new int[5];
            for (i = 0; i < intData.length; ++i) {
                intData[i] = 2 * i;
            }
            event2.appendIntData(intData);
            for (i = 0; i < 6; ++i) {
                writer.writeEvent(event);
                System.out.println("Event #" + (i + 1) + ", Block #" + writer.getBlockNumber());
                if (useFile) continue;
                System.out.println("Buffer has " + myBuf.remaining() + " bytes left");
            }
            writer.writeEvent(event2);
            System.out.println("Event #7, Block #" + writer.getBlockNumber());
            writer.writeEvent(event);
            System.out.println("Event #8, Block #" + writer.getBlockNumber());
            System.out.println("FileTest, call close()");
            writer.close();
            if (xmlDictionary != null) {
                EvioXMLDictionary dict = new EvioXMLDictionary(xmlDictionary);
                NameProvider.setProvider(dict);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void removeBytesFromFileEnd(String fileName, int byteCount) {
        try {
            RandomAccessFile rafIn = new RandomAccessFile(fileName, "rw");
            RandomAccessFile rafOut = new RandomAccessFile(fileName + "out", "rw");
            long fileSize = rafIn.length();
            if (byteCount < 0) {
                byteCount *= -1;
            }
            long newSize = fileSize - (long)byteCount;
            System.out.println("File size = " + fileSize + ", reduce to " + newSize);
            for (long l = 0L; l < newSize; ++l) {
                rafOut.writeByte(rafIn.readByte());
            }
            rafIn.close();
            rafOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void readWrittenData(ByteBuffer buf) throws IOException, EvioException {
        EvioReader evioReader = new EvioReader(buf);
        int evCount = evioReader.getEventCount();
        System.out.println("\nRead buffer, got " + evCount + " events");
        EvioEvent ev = evioReader.parseEvent(evCount);
        System.out.println("Last event = " + ev.toString());
        int[] intData = ev.getIntData();
        if (intData != null) {
            for (int i = 0; i < 4; ++i) {
                System.out.println("intData[" + i + "] = " + intData[i]);
            }
        }
    }

    private static void readWrittenData(String fileName, boolean sequential) throws IOException, EvioException {
        File file = new File(fileName);
        EvioReader evioReader = new EvioReader(fileName, false, sequential);
        System.out.println("read ev file: " + fileName + ", size: " + file.length());
        int evCount = evioReader.getEventCount();
        System.out.println("Read file, got " + evCount + " events:\n");
        EvioEvent ev = evioReader.parseEvent(evCount);
        System.out.println("Last event = " + ev.toString());
        int[] intData = ev.getIntData();
        if (intData != null) {
            for (int i = 0; i < 4; ++i) {
                System.out.println("intData[" + i + "] = " + intData[i]);
            }
        }
    }

    private static void appendEvents(String fileName, EvioEvent ev, int count) throws IOException, EvioException {
        File file = new File(fileName);
        EventWriter writer = new EventWriter(file, 16, 1000, ByteOrder.nativeOrder(), null, null, true, true);
        for (int i = 0; i < count; ++i) {
            writer.writeEvent(ev);
            System.out.println("Appended event #" + (i + 1) + ", Block #" + writer.getBlockNumber());
        }
        writer.close();
    }

    private static void readWrittenDataOrig(String fileName, File file, ByteBuffer myBuf, boolean useFile, EvioEvent event) {
        try {
            EvioReader evioReader;
            if (useFile) {
                System.out.println("read ev file: " + fileName + ", size: " + file.length());
                evioReader = new EvioReader(fileName);
            } else {
                myBuf.flip();
                evioReader = new EvioReader(myBuf);
            }
            EventParser parser = evioReader.getParser();
            IEvioListener listener = new IEvioListener(){

                @Override
                public void gotStructure(BaseStructure topStructure, IEvioStructure structure) {
                    System.out.println("Parsed structure of type " + (Object)((Object)structure.getStructureType()));
                }

                @Override
                public void startEventParse(BaseStructure structure) {
                    System.out.println("Starting event parse");
                }

                @Override
                public void endEventParse(BaseStructure structure) {
                    System.out.println("Ended event parse");
                }
            };
            parser.addEvioListener(listener);
            String xmlDictString = evioReader.getDictionaryXML();
            EvioXMLDictionary dictionary = null;
            if (xmlDictString == null) {
                System.out.println("Ain't got no dictionary!");
            } else {
                dictionary = new EvioXMLDictionary(xmlDictString);
                System.out.println("Got a dictionary:\n" + dictionary.toString());
            }
            int evCount = evioReader.getEventCount();
            System.out.println("Read file, got " + evCount + " events:\n");
            EvioEvent ev = evioReader.parseEvent(evCount);
            System.out.println("Last event = " + ev.toString());
            ev.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            int[] intData = ev.getIntData();
            if (intData != null) {
                for (int i = 0; i < intData.length; ++i) {
                    System.out.println("intData[" + i + "] = " + intData[i]);
                }
            }
            if (dictionary != null) {
                String eventName = dictionary.getName(ev);
                System.out.println("Name of last event = " + eventName);
            }
            while ((ev = evioReader.parseNextEvent()) != null) {
                System.out.println("Event = " + ev.toString());
            }
            evioReader.rewind();
            int tag = 1;
            int num = 1;
            ev = evioReader.parseNextEvent();
            List<BaseStructure> list = StructureFinder.getMatchingBanks(ev, tag, num);
            System.out.println("Event = " + ev.toString());
            for (BaseStructure s : list) {
                if (dictionary == null) {
                    System.out.println("Evio structure named \"" + s.toString() + "\" has tag=1 & num=1");
                    continue;
                }
                System.out.println("Evio structure named \"" + dictionary.getName(s) + "\" has tag=1 & num=1");
            }
            class MyEvioFilter
            implements IEvioFilter {
                MyEvioFilter() {
                }

                @Override
                public boolean accept(StructureType structureType, IEvioStructure struct) {
                    return structureType == StructureType.SEGMENT && struct.getHeader().getTag() % 2 == 1;
                }
            }
            MyEvioFilter filter = new MyEvioFilter();
            list = StructureFinder.getMatchingStructures((BaseStructure)event, filter);
            if (list != null) {
                System.out.println("list size = " + list.size());
                for (BaseStructure s : list) {
                    if (dictionary == null) {
                        System.out.println("Evio structure named \"" + s.toString() + "\" has tag=1 & num=1");
                        continue;
                    }
                    System.out.println("Evio structure named " + dictionary.getName(s) + " is a segment with an odd numbered tag");
                }
            }
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main9(String[] args) {
        String fileName = "/daqfs/home/timmer/coda/jevio-4.3/testdata/BigOut2.ev";
        File file = new File(fileName);
        ByteBuffer myBuf = ByteBuffer.allocate(800);
        String dictionary = "<xmlDict>\n  <xmldumpDictEntry name=\"bank\"           tag=\"1\"   num=\"1\"/>\n  <xmldumpDictEntry name=\"bank of shorts\" tag=\"2\"   num=\"2\"/>\n  <xmldumpDictEntry name=\"shorts pad0\"    tag=\"3\"   num=\"3\"/>\n  <xmldumpDictEntry name=\"shorts pad2\"    tag=\"4\"   num=\"4\"/>\n  <xmldumpDictEntry name=\"bank of chars\"  tag=\"5\"   num=\"5\"/>\n</xmlDict>";
        short[] shortData1 = new short[]{11, 22};
        short[] shortData2 = new short[]{11, 22, 33};
        BaseStructure event = null;
        try {
            EventWriter eventWriterNew = new EventWriter(file, 1000, 3, ByteOrder.BIG_ENDIAN, dictionary, null);
            EventBuilder eventBuilder2 = new EventBuilder(1, DataType.BANK, 1);
            event = eventBuilder2.getEvent();
            EvioBank bankBanks = new EvioBank(2, DataType.BANK, 2);
            EvioBank shortBank1 = new EvioBank(3, DataType.SHORT16, 3);
            shortBank1.appendShortData(shortData1);
            eventBuilder2.addChild(bankBanks, shortBank1);
            EvioBank shortBank2 = new EvioBank(3, DataType.SHORT16, 3);
            shortBank2.appendShortData(shortData2);
            eventBuilder2.addChild(bankBanks, shortBank2);
            eventBuilder2.addChild(event, bankBanks);
            eventWriterNew.writeEvent((EvioBank)event);
            eventWriterNew.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        System.out.println("Event = \n" + event.toXML());
        File fileIn = new File(fileName);
        System.out.println("read ev file: " + fileName + " size: " + fileIn.length());
        try {
            EvioReader fileReader = new EvioReader(fileName);
            System.out.println("\nnum ev = " + fileReader.getEventCount());
            System.out.println("dictionary = " + fileReader.getDictionaryXML() + "\n");
            event = fileReader.parseNextEvent();
            if (event == null) {
                System.out.println("We got a NULL event !!!");
                return;
            }
            System.out.println("Event = \n" + event.toXML());
            while ((event = fileReader.parseNextEvent()) != null) {
                System.out.println("Event = " + ((EvioEvent)event).toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
    }

    public static void main22(String[] args) {
        String dictionary = "<xmlDict>\n\t<xmldumpDictEntry name=\"bank\"           tag=\"1\"   num=\"1\"/>\n\t<xmldumpDictEntry name=\"bank of shorts\" tag=\"2\"   num=\"2\"/>\n\t<xmldumpDictEntry name=\"shorts pad0\"    tag=\"3\"   num=\"3\"/>\n\t<xmldumpDictEntry name=\"shorts pad2\"    tag=\"4\"   num=\"4\"/>\n\t<xmldumpDictEntry name=\"bank of chars\"  tag=\"5\"   num=\"5\"/>\n</xmlDict>";
        String fileName = "/local/scratch/gagik.evio";
        File file = new File(fileName);
        System.out.println("\nTRY READING");
        File fileIn = new File(fileName);
        System.out.println("read ev file: " + fileName + " size: " + fileIn.length());
        try {
            EvioEvent event;
            EvioReader fileReader = new EvioReader(fileName, false, true);
            int evCount = fileReader.getEventCount();
            System.out.println("\nnum ev = " + evCount);
            System.out.println("blocks = " + fileReader.getBlockCount());
            System.out.println("dictionary = " + fileReader.getDictionaryXML() + "\n");
            boolean counter = false;
            long t1 = System.currentTimeMillis();
            while ((event = fileReader.parseNextEvent()) != null) {
                if (event != null) continue;
                System.out.println("We got a NULL event !!!");
                return;
            }
            long t2 = System.currentTimeMillis();
            System.out.println("Sequential Time = " + (t2 - t1) + " milliseconds");
            fileReader.rewind();
            t1 = System.currentTimeMillis();
            for (int i = 1; i <= evCount; ++i) {
                event = fileReader.parseEvent(i);
                if (event != null) continue;
                System.out.println("We got a NULL event !!!");
                return;
            }
            t2 = System.currentTimeMillis();
            System.out.println("Random access Time = " + (t2 - t1) + " milliseconds");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        System.out.println("DONE READING");
    }
}

