/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.EvioCompactReader;
import org.jlab.coda.jevio.EvioNode;

public class CompactReaderBugTest {
    static int[] data1 = new int[]{20, 1, 8, 4, 0, 516, 0, -1059454720, 2, 116225, 16909060, 2, 165378, 84281096, 2, 214531, 151653132, 2, 263684, 235868177};

    public static void main1(String[] args) {
        int i;
        byte[] array = new byte[]{1, 2, 3, 4};
        ByteBuffer bb1 = ByteBuffer.wrap(array);
        System.out.println("Wrapped array: ");
        for (int i2 = 0; i2 < array.length; ++i2) {
            System.out.println("array[" + i2 + "] = " + array[i2]);
        }
        ByteBuffer bbDup = bb1.duplicate();
        bbDup.clear();
        System.out.println("\nDuplicate array: ");
        for (int i3 = 0; i3 < bbDup.remaining(); ++i3) {
            System.out.println("array[" + i3 + "] = " + bbDup.get(i3));
        }
        bb1.clear();
        ByteBuffer bbSlice = bb1.slice();
        bbSlice.clear();
        System.out.println("\nSlice array: ");
        for (i = 0; i < bbSlice.remaining(); ++i) {
            System.out.println("array[" + i + "] = " + bbSlice.get(i));
        }
        bbDup.limit(3).position(1);
        bbSlice = bbDup.slice();
        bbSlice.clear();
        System.out.println("\nSlice of Duplicate array: ");
        for (i = 0; i < bbSlice.remaining(); ++i) {
            System.out.println("array[" + i + "] = " + bbSlice.get(i));
        }
    }

    public static void main(String[] args) {
        File file;
        ByteBuffer buf;
        String fileName = "/tmp/testFile.ev";
        System.out.println("Write file " + fileName);
        try {
            byte[] be = ByteDataTransformer.toBytes(data1, ByteOrder.BIG_ENDIAN);
            buf = ByteBuffer.wrap(be);
            file = new File(fileName);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            FileChannel fileChannel = fileOutputStream.getChannel();
            fileChannel.write(buf);
            fileChannel.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        System.out.println("\nCompactEvioReader file: " + fileName);
        try {
            byte[] data = ByteDataTransformer.toBytes(data1, ByteOrder.BIG_ENDIAN);
            buf = ByteBuffer.wrap(data);
            EvioCompactReader reader = new EvioCompactReader(buf);
            int evCount = reader.getEventCount();
            for (int i = 0; i < evCount; ++i) {
                EvioNode node = reader.getEvent(i + 1);
                System.out.println("\nEvent " + (i + 1) + ", tag = " + node.getTag() + ", type = " + (Object)((Object)node.getDataTypeObj()) + ", num = " + node.getNum() + ", pad = " + node.getPad());
                ByteBuffer bb = node.getByteData(false);
                System.out.println("Buf: limit = " + bb.limit() + ", cap = " + bb.capacity() + ", pos = " + bb.position());
                byte[] array = ByteDataTransformer.toByteArray(bb);
                for (int j = 0; j < array.length; ++j) {
                    System.out.println("BDT data[" + j + "] = " + array[j]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        file.delete();
    }
}

