/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.jlab.coda.jevio.CompactEventBuilder;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventWriter;

public class BigFileWrite {
    private boolean debug;
    private boolean writeEvioFile;
    private boolean forceToDisk;
    private boolean random;
    private int bufferBytes = 15000;
    private long fileBytes = 2000000000L;
    private int repeat = 3;
    String filename;

    BigFileWrite(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                BigFileWrite.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-r")) {
                try {
                    this.repeat = Integer.parseInt(args[i + 1]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-file")) {
                this.filename = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-fsize")) {
                try {
                    this.fileBytes = Long.parseLong(args[i + 1]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-bsize")) {
                try {
                    this.bufferBytes = Integer.parseInt(args[i + 1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-raf")) {
                this.random = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-force")) {
                this.forceToDisk = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-evio")) {
                this.writeEvioFile = true;
                continue;
            }
            BigFileWrite.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java BigFileWrite\n        [-u <UDL>]             set UDL to connect to cMsg\n        [-file <filename>]     name of file to write\n        [-fsize <file size>]   final size of file to write (bytes)\n        [-bsize <buf size>]    size of buffer to write (bytes)\n        [-r <repeat>]          repeat file write this many times, track avg rate\n        [-force]               force every write to physical disk (each buffer written)\n        [-evio]                write evio data (if not given, just write empty buffer)\n        [-debug]               turn on printout\n        [-h]                   print this help\n");
    }

    public static void main(String[] args) {
        BigFileWrite receiver = new BigFileWrite(args);
        receiver.run();
    }

    public void run() {
        boolean count = false;
        long totalT = 0L;
        long totalCount = 0L;
        long loops = this.fileBytes / (long)this.bufferBytes;
        System.out.println("Write file of size " + (float)this.fileBytes + " bytes (chunks of " + this.bufferBytes + ", " + loops + " times), " + this.repeat + " times in a row");
        ByteBuffer dataBuf = ByteBuffer.allocate(this.bufferBytes);
        if (this.debug) {
            System.out.println("data buf: pos = " + dataBuf.position() + ", cap = " + dataBuf.capacity() + ", lim = " + dataBuf.limit());
        }
        for (int i = 0; i < dataBuf.capacity() / 4; ++i) {
            dataBuf.putInt(i * 4, i);
        }
        if (!this.writeEvioFile) {
            if (this.random) {
                try {
                    for (int i = 0; i < this.repeat; ++i) {
                        RandomAccessFile raf = new RandomAccessFile(this.filename, "rw");
                        long t1 = System.currentTimeMillis();
                        int j = 0;
                        while ((long)j < loops) {
                            raf.write(dataBuf.array(), 0, dataBuf.limit());
                            if (this.forceToDisk) {
                                raf.getFD().sync();
                            }
                            dataBuf.clear();
                            ++j;
                        }
                        raf.close();
                        long t2 = System.currentTimeMillis();
                        long time = t2 - t1;
                        double rate = (double)(loops * (long)this.bufferBytes / time) / 1000.0;
                        double avgRate = (double)(totalCount += loops * (long)this.bufferBytes) / (double)(totalT += time) / 1000.0;
                        System.out.println("rate = " + String.format("%.3g", rate) + ",  avg = " + String.format("%.3g", avgRate) + " MB/sec");
                        System.out.println("time = " + time + " milliseconds");
                        File f = new File(this.filename);
                        if (i >= this.repeat - 1) continue;
                        f.delete();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    for (int i = 0; i < this.repeat; ++i) {
                        FileOutputStream fileOutputStream = new FileOutputStream(this.filename, false);
                        FileChannel fileChannel = fileOutputStream.getChannel();
                        long t1 = System.currentTimeMillis();
                        int j = 0;
                        while ((long)j < loops) {
                            fileChannel.write(dataBuf);
                            if (this.forceToDisk) {
                                fileChannel.force(true);
                            }
                            dataBuf.clear();
                            ++j;
                        }
                        fileOutputStream.close();
                        long t2 = System.currentTimeMillis();
                        long time = t2 - t1;
                        double rate = (double)(loops * (long)this.bufferBytes / time) / 1000.0;
                        double avgRate = (double)(totalCount += loops * (long)this.bufferBytes) / (double)(totalT += time) / 1000.0;
                        System.out.println("rate = " + String.format("%.3g", rate) + ",  avg = " + String.format("%.3g", avgRate) + " MB/sec");
                        System.out.println("time = " + time + " milliseconds");
                        File f = new File(this.filename);
                        if (i >= this.repeat - 1) continue;
                        f.delete();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                int tag = 1;
                int num = 2;
                ByteBuffer buf = ByteBuffer.allocate(this.bufferBytes + 8);
                CompactEventBuilder builder = new CompactEventBuilder(buf);
                builder.openBank(tag, num, DataType.CHAR8);
                builder.addByteData(dataBuf.array());
                builder.closeAll();
                if (this.debug) {
                    System.out.println("buf: pos = " + buf.position() + ", cap = " + buf.capacity() + ", lim = " + buf.limit() + ", order = " + buf.order());
                }
                EventWriter eventWriter = new EventWriter(this.filename, false, ByteOrder.BIG_ENDIAN);
                for (int i = 0; i < this.repeat; ++i) {
                    long t1 = System.currentTimeMillis();
                    int j = 0;
                    while ((long)j < loops) {
                        eventWriter.writeEvent(buf, this.forceToDisk);
                        buf.clear();
                        ++j;
                    }
                    eventWriter.close();
                    long t2 = System.currentTimeMillis();
                    long time = t2 - t1;
                    double rate = (double)(loops * (long)(this.bufferBytes + 8) / time) / 1000.0;
                    double avgRate = (double)(totalCount += loops * (long)(this.bufferBytes + 8)) / (double)(totalT += time) / 1000.0;
                    System.out.println("rate = " + String.format("%.3g", rate) + ",  avg = " + String.format("%.3g", avgRate) + " MB/sec");
                    System.out.println("time = " + time + " milliseconds");
                    File f = new File(this.filename);
                    if (i < this.repeat - 1) {
                        f.delete();
                    }
                    eventWriter = new EventWriter(this.filename, false, ByteOrder.BIG_ENDIAN);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

