/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioException;

public final class TagSegmentHeader
extends BaseStructureHeader {
    public TagSegmentHeader() {
    }

    public TagSegmentHeader(int tag, DataType dataType) {
        super(tag, dataType);
    }

    @Override
    public int getHeaderLength() {
        return 1;
    }

    @Override
    protected void toArray(byte[] bArray, int offset, ByteOrder order) {
        short compositeWord = (short)(this.tag << 4 | this.dataType.getValue() & 0xF);
        try {
            if (order == ByteOrder.BIG_ENDIAN) {
                ByteDataTransformer.toBytes(compositeWord, order, bArray, offset);
                ByteDataTransformer.toBytes((short)this.length, order, bArray, offset + 2);
            } else {
                ByteDataTransformer.toBytes((short)this.length, order, bArray, offset);
                ByteDataTransformer.toBytes(compositeWord, order, bArray, offset + 2);
            }
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(512);
        sb.append(String.format("tag-seg length: %d\n", this.length));
        sb.append(String.format("number:         %d\n", this.number));
        sb.append(String.format("data type:      %s\n", this.getDataTypeName()));
        sb.append(String.format("tag:            %d\n", this.tag));
        return sb.toString();
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        short compositeWord = (short)(this.tag << 4 | this.dataType.getValue() & 0xF);
        if (byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            byteBuffer.putShort(compositeWord);
            byteBuffer.putShort((short)this.length);
        } else {
            byteBuffer.putShort((short)this.length);
            byteBuffer.putShort(compositeWord);
        }
        return 4;
    }
}

