/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.util.List;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.EvioXMLDictionary;
import org.jlab.coda.jevio.IBlockHeader;

public interface IEvioCompactReader {
    public static final int MAGIC_OFFSET = 28;
    public static final int VERSION_OFFSET = 20;
    public static final int VERSION_MASK = 255;

    public boolean isFile();

    public void setBuffer(ByteBuffer var1) throws EvioException;

    public boolean isClosed();

    public ByteOrder getByteOrder();

    public int getEvioVersion();

    public String getPath();

    public ByteOrder getFileByteOrder();

    public String getDictionaryXML() throws EvioException;

    public EvioXMLDictionary getDictionary() throws EvioException;

    public boolean hasDictionary();

    public MappedByteBuffer getMappedByteBuffer();

    public ByteBuffer getByteBuffer();

    public long fileSize();

    public EvioNode getEvent(int var1);

    public EvioNode getScannedEvent(int var1);

    public IBlockHeader getFirstBlockHeader();

    public List<EvioNode> searchEvent(int var1, int var2, int var3) throws EvioException;

    public List<EvioNode> searchEvent(int var1, String var2, EvioXMLDictionary var3) throws EvioException;

    public ByteBuffer removeEvent(int var1) throws EvioException;

    public ByteBuffer removeStructure(EvioNode var1) throws EvioException;

    public ByteBuffer addStructure(int var1, ByteBuffer var2) throws EvioException;

    public ByteBuffer getData(EvioNode var1) throws EvioException;

    public ByteBuffer getData(EvioNode var1, boolean var2) throws EvioException;

    public ByteBuffer getEventBuffer(int var1) throws EvioException;

    public ByteBuffer getEventBuffer(int var1, boolean var2) throws EvioException;

    public ByteBuffer getStructureBuffer(EvioNode var1) throws EvioException;

    public ByteBuffer getStructureBuffer(EvioNode var1, boolean var2) throws EvioException;

    public void close();

    public int getEventCount();

    public int getBlockCount();

    public void toFile(String var1) throws EvioException, IOException;

    public void toFile(File var1) throws EvioException, IOException;

    public static enum ReadStatus {
        SUCCESS,
        END_OF_FILE,
        EVIO_EXCEPTION,
        UNKNOWN_ERROR;

    }
}

