/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jlab.coda.hipo.FileHeader;
import org.jlab.coda.hipo.HipoException;
import org.jlab.coda.hipo.RecordHeader;
import org.jlab.coda.hipo.RecordOutputStream;
import org.jlab.coda.hipo.RecordRingItem;
import org.jlab.coda.hipo.RecordSupply;
import org.jlab.coda.jevio.BlockHeaderV4;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.Utilities;

public class EventWriterMT {
    static final int RECORD_LENGTH_OFFSET = 0;
    static final int RECORD_NUMBER_OFFSET = 4;
    static final int HEADER_LENGTH_OFFSET = 8;
    static final int EVENT_COUNT_OFFSET = 12;
    static final int RESERVED1_COUNT_OFFSET = 16;
    static final int BIT_INFO_OFFSET = 20;
    static final int MAGIC_OFFSET = 28;
    static final int VERSION_MASK = 255;
    static final int headerBytes = 32;
    private FileHeader fileHeader;
    private RecordOutputStream commonRecord;
    private RecordOutputStream currentRecord;
    private RecordRingItem currentRingItem;
    private RecordSupply supply;
    private int compressionType;
    private int compressionThreadCount = 1;
    private ArrayList<Integer> recordLengths = new ArrayList(1500);
    private long bytesWritten;
    private boolean addTrailer = true;
    private boolean addTrailerIndex = true;
    private byte[] headerArray = new byte[56];
    private RecordCompressor[] recordCompressorThreads;
    private RecordWriter recordWriterThread;
    private int recordsWritten;
    private int recordNumber;
    private String xmlDictionary;
    private byte[] dictionaryByteArray;
    private byte[] firstEventByteArray;
    private boolean closed;
    private boolean toFile;
    private boolean append;
    private boolean hasAppendDictionary;
    private int eventsWrittenTotal;
    private ByteOrder byteOrder;
    private int bufferSize;
    private ByteBuffer buffer;
    private long bytesWrittenToBuffer;
    private int eventsWrittenToBuffer;
    private File currentFile;
    private RandomAccessFile raf;
    private FileChannel fileChannel;
    private int splitCount;
    public String baseFileName;
    public int specifierCount;
    public int runNumber;
    private long split;
    private int streamCount;
    private boolean overWriteOK;
    private long bytesWrittenToFile;
    private int eventsWrittenToFile;
    private FileCloser fileCloser;

    public EventWriterMT(File file) throws EvioException {
        this(file, false);
    }

    public EventWriterMT(File file, boolean append) throws EvioException {
        this(file, null, append);
    }

    public EventWriterMT(File file, String dictionary, boolean append) throws EvioException {
        this(file.getPath(), null, null, 0, 0L, 0, 0, ByteOrder.nativeOrder(), dictionary, false, append, null, 0, 1, 0, 1, 8);
    }

    public EventWriterMT(String filename) throws EvioException {
        this(filename, false);
    }

    public EventWriterMT(String filename, boolean append) throws EvioException {
        this(filename, append, ByteOrder.nativeOrder());
    }

    public EventWriterMT(String filename, boolean append, ByteOrder byteOrder) throws EvioException {
        this(filename, null, null, 0, 0L, 0, 0, byteOrder, null, false, append, null, 0, 1, 0, 1, 8);
    }

    public EventWriterMT(String baseName, String directory, String runType, int runNumber, long split, int maxRecordSize, int maxEventCount, ByteOrder byteOrder, String xmlDictionary, boolean overWriteOK, boolean append, EvioBank firstEvent, int streamId, int streamCount, int compressionType, int compressionThreads, int ringSize) throws EvioException {
        if (baseName == null) {
            throw new EvioException("baseName arg is null");
        }
        if (byteOrder == null) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        this.createCommonRecord(xmlDictionary, firstEvent, null);
        this.split = split;
        this.append = false;
        this.runNumber = runNumber;
        this.byteOrder = byteOrder;
        this.overWriteOK = overWriteOK;
        this.xmlDictionary = xmlDictionary;
        this.streamCount = streamCount;
        if (compressionType < 0 || compressionType > 3) {
            compressionType = 0;
        }
        this.compressionType = compressionType;
        if (compressionThreads < 1) {
            compressionThreads = 1;
        }
        this.compressionThreadCount = compressionThreads;
        if (ringSize < this.compressionThreadCount) {
            ringSize = this.compressionThreadCount;
        }
        ringSize = Utilities.powerOfTwo(ringSize, true);
        this.toFile = true;
        this.recordNumber = 1;
        this.splitCount = 0;
        if (streamCount > 1) {
            this.splitCount = streamId * streamCount;
        } else {
            streamCount = 1;
        }
        if (directory != null) {
            baseName = directory + "/" + baseName;
        }
        StringBuilder builder = new StringBuilder(100);
        this.specifierCount = Utilities.generateBaseFileName(baseName, runType, builder);
        this.baseFileName = builder.toString();
        String fileName = Utilities.generateFileName(this.baseFileName, this.specifierCount, runNumber, split, this.splitCount, streamId);
        this.splitCount += streamCount;
        this.currentFile = new File(fileName);
        if (!overWriteOK && !append && this.currentFile.exists() && this.currentFile.isFile()) {
            throw new EvioException("File exists but user requested no over-writing or appending, " + this.currentFile.getPath());
        }
        this.fileHeader = new FileHeader(true);
        this.supply = new RecordSupply(ringSize, byteOrder, compressionThreads, maxEventCount, maxRecordSize, compressionType);
        this.recordCompressorThreads = new RecordCompressor[this.compressionThreadCount];
        for (int i = 0; i < this.compressionThreadCount; ++i) {
            this.recordCompressorThreads[i] = new RecordCompressor(i);
            this.recordCompressorThreads[i].start();
        }
        this.recordWriterThread = new RecordWriter();
        this.recordWriterThread.start();
        if (split > 0L) {
            this.fileCloser = new FileCloser();
        }
    }

    public EventWriterMT(ByteBuffer buf) throws EvioException {
        this(buf, 0, 0, null, 1, false, null, 0);
    }

    public EventWriterMT(ByteBuffer buf, boolean append) throws EvioException {
        this(buf, 0, 0, null, 1, append, null, 0);
    }

    public EventWriterMT(ByteBuffer buf, String xmlDictionary, boolean append) throws EvioException {
        this(buf, 0, 0, xmlDictionary, 1, append, null, 0);
    }

    public EventWriterMT(ByteBuffer buf, int maxRecordSize, int maxEventCount, String xmlDictionary, int recordNumber) throws EvioException {
        this(buf, maxRecordSize, maxEventCount, xmlDictionary, recordNumber, false, null, 0);
    }

    public EventWriterMT(ByteBuffer buf, int maxRecordSize, int maxEventCount, String xmlDictionary, int recordNumber, boolean append, EvioBank firstEvent, int compressionType) throws EvioException {
        if (buf == null) {
            throw new EvioException("Buffer arg cannot be null");
        }
        if (append && (xmlDictionary != null || firstEvent != null)) {
            throw new EvioException("Cannot specify dictionary or first event when appending");
        }
        this.createCommonRecord(xmlDictionary, firstEvent, null);
        this.append = append;
        this.buffer = buf;
        this.byteOrder = buf.order();
        this.recordNumber = recordNumber;
        this.xmlDictionary = xmlDictionary;
        this.compressionType = compressionType;
        this.buffer.position(0);
        this.bufferSize = buf.capacity();
        this.currentRecord = new RecordOutputStream(this.byteOrder, maxEventCount, maxRecordSize, compressionType);
    }

    private void reInitializeBuffer(ByteBuffer buf, int recordNumber) {
        this.buffer = buf;
        this.byteOrder = buf.order();
        this.recordNumber = recordNumber;
        this.split = 0L;
        this.toFile = false;
        this.closed = false;
        this.eventsWrittenTotal = 0;
        this.eventsWrittenToBuffer = 0;
        this.bytesWrittenToBuffer = 0L;
        this.bytesWritten = 0L;
        this.currentRecord.reset();
        this.buffer.position(0);
        this.bufferSize = buf.capacity();
    }

    public void setBuffer(ByteBuffer buf, int recordNumber) throws EvioException {
        if (this.toFile) {
            return;
        }
        if (buf == null) {
            throw new EvioException("Buffer arg null");
        }
        if (this.append) {
            throw new EvioException("Method not for use if appending");
        }
        if (!this.closed) {
            throw new EvioException("Close EventWriter before changing buffers");
        }
        this.reInitializeBuffer(buf, recordNumber);
    }

    public void setBuffer(ByteBuffer buf) throws EvioException {
        this.setBuffer(buf, 1);
    }

    private ByteBuffer getBuffer() {
        if (this.toFile()) {
            return null;
        }
        return this.buffer;
    }

    public ByteBuffer getByteBuffer() {
        if (this.toFile()) {
            return null;
        }
        ByteBuffer buf = this.buffer.duplicate().order(this.buffer.order());
        buf.flip();
        return buf;
    }

    public boolean toFile() {
        return this.toFile;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getCurrentFilename() {
        if (this.currentFile != null) {
            return this.currentFile.getName();
        }
        return null;
    }

    public String getCurrentFilePath() {
        if (this.currentFile != null) {
            return this.currentFile.getPath();
        }
        return null;
    }

    public int getSplitCount() {
        return this.splitCount;
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public int getEventsWritten() {
        return this.eventsWrittenTotal;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setStartingRecordNumber(int startingRecordNumber) {
        if (this.eventsWrittenTotal > 0) {
            return;
        }
        this.recordNumber = startingRecordNumber;
    }

    public void setFirstEvent(EvioNode node) throws EvioException {
        this.createCommonRecord(this.xmlDictionary, null, node);
        boolean writeEvent = true;
        if (this.toFile && this.recordsWritten < 1) {
            writeEvent = false;
        }
        if (writeEvent) {
            this.writeEvent(node, false);
        }
    }

    public void setFirstEvent(EvioBank bank) throws EvioException {
        this.createCommonRecord(this.xmlDictionary, bank, null);
        boolean writeEvent = true;
        if (this.toFile && this.recordsWritten < 1) {
            writeEvent = false;
        }
        if (writeEvent) {
            this.writeEvent(bank, null, false);
        }
    }

    private void createCommonRecord(String xmlDictionary, EvioBank firstBank, EvioNode firstNode) throws EvioException {
        if (this.commonRecord == null) {
            this.commonRecord = new RecordOutputStream(this.byteOrder, 0, 0, this.compressionType);
        } else {
            this.commonRecord.reset();
        }
        if (xmlDictionary != null) {
            if (xmlDictionary.length() < 56) {
                throw new EvioException("Dictionary improper format");
            }
            this.dictionaryByteArray = Utilities.stringToBank(xmlDictionary, 0, 0, this.byteOrder);
            this.commonRecord.addEvent(this.dictionaryByteArray);
        } else {
            this.dictionaryByteArray = null;
        }
        if (firstBank != null) {
            this.firstEventByteArray = Utilities.bankToBytes(firstBank, this.byteOrder);
            this.commonRecord.addEvent(this.firstEventByteArray);
        } else if (firstNode != null) {
            ByteBuffer firstEventBuf = firstNode.getStructureBuffer(true);
            this.firstEventByteArray = firstEventBuf.array();
            this.commonRecord.addEvent(this.firstEventByteArray);
        } else {
            this.firstEventByteArray = null;
        }
        this.commonRecord.build();
    }

    private void writeFileHeader() throws IOException {
        this.fileHeader.reset();
        this.fileHeader.setFileNumber(this.splitCount - this.streamCount);
        int commonSize = this.commonRecord.getHeader().getLength();
        this.fileHeader.setUserHeaderLength(commonSize);
        int bytes = 56 + commonSize;
        this.fileHeader.setLength(bytes);
        byte[] array = new byte[bytes];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.order(this.byteOrder);
        try {
            this.fileHeader.writeHeader(buffer, 0);
        }
        catch (HipoException e) {
            // empty catch block
        }
        System.arraycopy(this.commonRecord.getBinaryBuffer().array(), 0, array, 56, commonSize);
        this.raf.write(array, 0, bytes);
        this.eventsWrittenTotal = this.eventsWrittenToFile = this.commonRecord.getEventCount();
        this.bytesWrittenToFile = this.bytesWritten = (long)bytes;
    }

    public void flush() {
        if (this.closed || !this.toFile) {
            return;
        }
        this.currentRingItem.forceToDisk(true);
        this.supply.publish(this.currentRingItem);
        this.currentRingItem = this.supply.get();
        this.currentRecord = this.currentRingItem.getRecord();
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (this.toFile) {
            if (this.currentRecord.getEventCount() > 0) {
                this.supply.publish(this.currentRingItem);
            }
            this.recordWriterThread.waitForLastItem();
            for (RecordCompressor rc : this.recordCompressorThreads) {
                rc.interrupt();
            }
        } else if (this.currentRecord.getEventCount() > 0) {
            // empty if block
        }
        if (this.toFile) {
            if (this.raf != null && this.addTrailer) {
                try {
                    this.writeTrailerToFile(this.addTrailerIndex);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                this.writeTrailerToBuffer(this.addTrailerIndex);
            }
            catch (EvioException e) {
                e.printStackTrace();
            }
        }
        if (this.toFile) {
            try {
                if (this.raf != null) {
                    this.raf.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.fileCloser != null) {
                this.fileCloser.close();
            }
        }
        this.closed = true;
    }

    protected IOStatus examineFirstBlockHeader() throws IOException, EvioException {
        int currentPosition;
        if (!this.append) {
            throw new EvioException("need to be in append mode");
        }
        if (this.toFile) {
            this.buffer.clear();
            this.buffer.limit(32);
            int nBytes = this.fileChannel.read(this.buffer);
            if (nBytes != 32) {
                throw new EvioException("bad file format");
            }
            currentPosition = 0;
            this.fileChannel.position(0L);
        } else {
            if (this.buffer.remaining() < 32) {
                return IOStatus.END_OF_FILE;
            }
            currentPosition = this.buffer.position();
        }
        try {
            int bitInfo;
            int evioVersion;
            this.byteOrder = this.buffer.order();
            int magicNumber = this.buffer.getInt(currentPosition + 28);
            if (magicNumber != -1059454720) {
                this.byteOrder = this.byteOrder == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                this.buffer.order(this.byteOrder);
                magicNumber = this.buffer.getInt(currentPosition + 28);
                if (magicNumber != -1059454720) {
                    System.out.println("ERROR: reread magic # (" + magicNumber + ") & still not right");
                    return IOStatus.EVIO_EXCEPTION;
                }
            }
            if ((evioVersion = (bitInfo = this.buffer.getInt(currentPosition + 20)) & 0xFF) < 6) {
                System.out.println("ERROR: evio version# = " + evioVersion);
                return IOStatus.EVIO_EXCEPTION;
            }
            this.hasAppendDictionary = BlockHeaderV4.hasDictionary(bitInfo);
        }
        catch (BufferUnderflowException a) {
            System.err.println("ERROR endOfBuffer " + a);
            return IOStatus.UNKNOWN_ERROR;
        }
        return IOStatus.SUCCESS;
    }

    private void toAppendPosition() throws EvioException, IOException {
        int headerLength;
        int blockLength;
        int bitInfo;
        if (!this.append) {
            throw new EvioException("need to be in append mode");
        }
        boolean readEOF = false;
        long bytesLeftInFile = 0L;
        if (this.toFile) {
            bytesLeftInFile = this.fileChannel.size();
        }
        this.recordNumber = 1;
        while (true) {
            int currentPosition;
            int nBytes = 0;
            if (this.toFile) {
                this.buffer.clear();
                this.buffer.limit(32);
                while (nBytes < 32) {
                    int partial = this.fileChannel.read(this.buffer);
                    if (partial < 0) {
                        if (nBytes != 0) {
                            throw new EvioException("bad buffer format");
                        }
                        readEOF = true;
                        break;
                    }
                    nBytes += partial;
                    bytesLeftInFile -= (long)partial;
                }
                if (nBytes != 0 && nBytes != 32) {
                    throw new EvioException("internal file reading error");
                }
                currentPosition = 0;
            } else {
                if (this.buffer.remaining() < 32) {
                    throw new EvioException("bad buffer format");
                }
                currentPosition = this.buffer.position();
            }
            bitInfo = this.buffer.getInt(currentPosition + 20);
            blockLength = this.buffer.getInt(currentPosition + 0);
            headerLength = this.buffer.getInt(currentPosition + 8);
            int blockEventCount = this.buffer.getInt(currentPosition + 12);
            boolean lastBlock = BlockHeaderV4.isLastBlock(bitInfo);
            this.eventsWrittenTotal += blockEventCount;
            ++this.recordNumber;
            if (lastBlock || readEOF) break;
            if (this.toFile) {
                int bytesToNextBlockHeader = 4 * blockLength - 32;
                if (bytesLeftInFile < (long)bytesToNextBlockHeader) {
                    throw new EvioException("bad file format");
                }
                this.fileChannel.position(this.fileChannel.position() + (long)bytesToNextBlockHeader);
                bytesLeftInFile -= (long)bytesToNextBlockHeader;
                continue;
            }
            if (this.buffer.remaining() < 4 * blockLength) {
                throw new EvioException("bad buffer format");
            }
            this.buffer.position(this.buffer.position() + 4 * blockLength);
        }
        this.eventsWrittenToFile = this.hasAppendDictionary ? (this.eventsWrittenToBuffer = this.eventsWrittenTotal + 1) : (this.eventsWrittenToBuffer = this.eventsWrittenTotal);
        if (readEOF) {
            --this.recordNumber;
        } else if (blockLength > headerLength) {
            bitInfo = BlockHeaderV4.clearLastBlockBit(bitInfo);
            if (this.toFile) {
                this.fileChannel.position(this.fileChannel.position() - 12L);
                this.buffer.clear();
                this.buffer.putInt(bitInfo);
                this.buffer.flip();
                while (this.buffer.hasRemaining()) {
                    this.fileChannel.write(this.buffer);
                }
                this.fileChannel.position(this.fileChannel.position() + (long)(4 * blockLength) - 21L);
            } else {
                this.buffer.putInt(this.buffer.position() + 20, bitInfo);
                this.buffer.position(this.buffer.position() + 4 * blockLength);
            }
        } else {
            --this.recordNumber;
            if (this.toFile) {
                this.fileChannel.position(this.fileChannel.position() - 32L);
            }
        }
        if (this.toFile) {
            this.bytesWrittenToFile = this.fileChannel.position();
        } else {
            this.bytesWrittenToBuffer = this.buffer.position() + 32;
        }
    }

    public boolean hasRoom(int bytes) {
        return this.toFile() || (long)this.bufferSize - this.bytesWrittenToBuffer >= (long)(bytes + 32);
    }

    public void writeEvent(EvioNode node, boolean force) throws EvioException {
        this.writeEvent(node, force, true);
    }

    public void writeEvent(EvioNode node, boolean force, boolean duplicate) throws EvioException {
        if (node == null) {
            throw new EvioException("null node arg");
        }
        ByteBuffer bb = node.getBufferNode().getBuffer();
        ByteBuffer eventBuffer = duplicate ? bb.duplicate().order(bb.order()) : bb;
        int pos = node.getPosition();
        eventBuffer.limit(pos + node.getTotalBytes()).position(pos);
        this.writeEvent(null, eventBuffer, force);
    }

    public void writeEvent(ByteBuffer eventBuffer) throws EvioException {
        this.writeEvent(null, eventBuffer, false);
    }

    public void writeEvent(EvioBank bank) throws EvioException {
        this.writeEvent(bank, null, false);
    }

    public void writeEvent(ByteBuffer bankBuffer, boolean force) throws EvioException {
        this.writeEvent(null, bankBuffer, force);
    }

    public void writeEvent(EvioBank bank, boolean force) throws EvioException {
        this.writeEvent(bank, null, force);
    }

    private void writeEvent(EvioBank bank, ByteBuffer bankBuffer, boolean force) throws EvioException {
        boolean fitInRecord;
        long totalSize;
        int currentEventBytes;
        if (this.closed) {
            throw new EvioException("close() has already been called");
        }
        boolean splittingFile = false;
        if (bankBuffer != null) {
            if (bankBuffer.order() != this.byteOrder) {
                throw new EvioException("event buf is " + bankBuffer.order() + ", and writer is " + this.byteOrder);
            }
            currentEventBytes = bankBuffer.remaining();
            if ((currentEventBytes & 3) != 0) {
                throw new EvioException("bad bankBuffer format");
            }
            if (currentEventBytes != 4 * (bankBuffer.getInt(bankBuffer.position()) + 1)) {
                throw new EvioException("inconsistent event lengths");
            }
        } else if (bank != null) {
            currentEventBytes = bank.getTotalBytes();
        } else {
            return;
        }
        if (!this.toFile) {
            this.writeToBuffer(bank, bankBuffer);
            return;
        }
        if (this.split > 0L && this.eventsWrittenToBuffer > 0 && (totalSize = (long)currentEventBytes + this.bytesWrittenToFile + (long)this.currentRecord.getUncompressedSize() + 112L + (long)(4 * this.recordNumber)) > this.split) {
            splittingFile = true;
        }
        if (splittingFile) {
            ++this.recordsWritten;
            this.currentRingItem.splitFileAfterWrite(true);
            this.supply.publish(this.currentRingItem);
            this.currentRingItem = this.supply.get();
            this.currentRecord = this.currentRingItem.getRecord();
        }
        if (!(fitInRecord = bankBuffer != null ? this.currentRecord.addEvent(bankBuffer) : this.currentRecord.addEvent(bank))) {
            ++this.recordsWritten;
            this.supply.publish(this.currentRingItem);
            this.currentRingItem = this.supply.get();
            this.currentRecord = this.currentRingItem.getRecord();
            if (bankBuffer != null) {
                this.currentRecord.addEvent(bankBuffer);
            } else {
                this.currentRecord.addEvent(bank);
            }
        }
        if (force) {
            ++this.recordsWritten;
            this.currentRingItem.forceToDisk(true);
            this.supply.publish(this.currentRingItem);
            this.currentRingItem = this.supply.get();
            this.currentRecord = this.currentRingItem.getRecord();
        }
    }

    private boolean writeToFile(RecordRingItem item, boolean force) throws EvioException, IOException {
        if (this.closed) {
            throw new EvioException("close() has already been called");
        }
        if (this.bytesWrittenToFile < 1L) {
            try {
                this.raf = new RandomAccessFile(this.currentFile, "rw");
                this.fileChannel = this.raf.getChannel();
            }
            catch (FileNotFoundException e) {
                throw new EvioException("File could not be opened for writing, " + this.currentFile.getPath(), e);
            }
            this.writeFileHeader();
        }
        RecordOutputStream record = item.getRecord();
        RecordHeader header = record.getHeader();
        int bytesToWrite = header.getLength();
        this.recordLengths.add(bytesToWrite);
        int eventCount = header.getEntries();
        try {
            ByteBuffer buf = record.getBinaryBuffer();
            if (buf.hasArray()) {
                this.raf.write(buf.array(), 0, bytesToWrite);
            } else {
                while (buf.hasRemaining()) {
                    this.fileChannel.write(buf);
                }
            }
            record.reset();
        }
        catch (IOException ex) {
            throw new EvioException("Error writing to file, " + this.currentFile.getPath(), ex);
        }
        if (force) {
            this.fileChannel.force(false);
        }
        ++this.recordNumber;
        ++this.recordsWritten;
        this.bytesWritten += (long)bytesToWrite;
        this.bytesWrittenToFile += (long)bytesToWrite;
        this.eventsWrittenToFile += eventCount;
        this.eventsWrittenTotal += eventCount;
        return true;
    }

    private void splitFile() throws EvioException, IOException {
        if (this.raf != null) {
            if (this.addTrailer) {
                this.writeTrailerToFile(this.addTrailerIndex);
            }
            this.fileCloser.closeFile(this.raf);
        }
        this.raf = null;
        String fileName = Utilities.generateFileName(this.baseFileName, this.specifierCount, this.runNumber, this.split, this.splitCount);
        this.splitCount += this.streamCount;
        this.currentFile = new File(fileName);
        if (!this.overWriteOK && this.currentFile.exists() && this.currentFile.isFile()) {
            throw new EvioException("File exists but user requested no over-writing, " + this.currentFile.getPath());
        }
        this.recordNumber = 1;
        this.recordsWritten = 0;
        this.bytesWritten = 0L;
        this.bytesWrittenToFile = 0L;
        this.eventsWrittenToFile = 0;
    }

    private void writeTrailerToFile(boolean writeIndex) throws IOException {
        int bytesToWrite;
        long trailerPosition = this.bytesWritten;
        if (!writeIndex) {
            try {
                FileHeader.writeTrailer(this.headerArray, this.recordNumber, this.byteOrder, null);
            }
            catch (HipoException e) {
                // empty catch block
            }
            bytesToWrite = 56;
            this.raf.write(this.headerArray, 0, 56);
        } else {
            byte[] recordIndex = new byte[4 * this.recordLengths.size()];
            try {
                for (int i = 0; i < this.recordLengths.size(); ++i) {
                    ByteDataTransformer.toBytes(this.recordLengths.get(i), this.byteOrder, recordIndex, 4 * i);
                }
            }
            catch (EvioException e) {
                // empty catch block
            }
            if (this.headerArray.length < (bytesToWrite = 56 + recordIndex.length)) {
                this.headerArray = new byte[bytesToWrite];
            }
            try {
                FileHeader.writeTrailer(this.headerArray, this.recordNumber, this.byteOrder, recordIndex);
            }
            catch (HipoException e) {
                // empty catch block
            }
            this.raf.write(this.headerArray, 0, bytesToWrite);
        }
        this.raf.seek(40L);
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            this.raf.writeLong(Long.reverseBytes(trailerPosition));
        } else {
            this.raf.writeLong(trailerPosition);
        }
        if (this.addTrailerIndex) {
            this.raf.seek(20L);
            int bitInfo = this.fileHeader.setBitInfo(false, false, true);
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                this.raf.writeInt(Integer.reverseBytes(bitInfo));
            } else {
                this.raf.writeInt(bitInfo);
            }
        }
        ++this.recordNumber;
        ++this.recordsWritten;
        this.bytesWritten += (long)bytesToWrite;
        this.bytesWrittenToFile += (long)bytesToWrite;
    }

    private void writeToBuffer(EvioBank bank, ByteBuffer bankBuffer) throws EvioException {
        if (this.closed) {
            throw new EvioException("close() has already been called");
        }
        boolean fitInRecord = bankBuffer != null ? this.currentRecord.addEvent(bankBuffer) : this.currentRecord.addEvent(bank);
        if (fitInRecord) {
            return;
        }
        RecordHeader header = this.currentRecord.getHeader();
        header.setRecordNumber(this.recordNumber);
        int bytesToWrite = header.getLength();
        this.recordLengths.add(bytesToWrite);
        int eventCount = header.getEntries();
        this.currentRecord.build();
        ByteBuffer buf = this.currentRecord.getBinaryBuffer();
        if (buf.hasArray() && this.buffer.hasArray()) {
            System.arraycopy(buf.array(), 0, this.buffer.array(), this.buffer.position(), bytesToWrite);
        } else {
            this.buffer.put(buf);
        }
        ++this.recordNumber;
        ++this.recordsWritten;
        this.bytesWritten += (long)bytesToWrite;
        this.bytesWrittenToBuffer += (long)bytesToWrite;
        this.eventsWrittenToBuffer += eventCount;
        this.eventsWrittenTotal += eventCount;
        this.currentRecord.reset();
        if (bankBuffer != null) {
            this.currentRecord.addEvent(bankBuffer);
        } else {
            this.currentRecord.addEvent(bank);
        }
    }

    private void writeTrailerToBuffer(boolean writeIndex) throws EvioException {
        int bytesToWrite;
        if (!writeIndex) {
            if (this.buffer.capacity() - (int)this.bytesWritten < 56) {
                throw new EvioException("not enough room in buffer");
            }
            try {
                FileHeader.writeTrailer(this.buffer, (int)this.bytesWritten, this.recordNumber, this.byteOrder, null);
            }
            catch (HipoException e) {
                // empty catch block
            }
            bytesToWrite = 56;
        } else {
            byte[] recordIndex = new byte[4 * this.recordLengths.size()];
            try {
                for (int i = 0; i < this.recordLengths.size(); ++i) {
                    ByteDataTransformer.toBytes(this.recordLengths.get(i), this.byteOrder, recordIndex, 4 * i);
                }
            }
            catch (EvioException e) {
                // empty catch block
            }
            bytesToWrite = 56 + recordIndex.length;
            if (this.buffer.capacity() - (int)this.bytesWritten < bytesToWrite) {
                throw new EvioException("not enough room in buffer");
            }
            try {
                FileHeader.writeTrailer(this.buffer, (int)this.bytesWritten, this.recordNumber, this.byteOrder, recordIndex);
            }
            catch (HipoException e) {
                // empty catch block
            }
        }
        ++this.recordNumber;
        ++this.recordsWritten;
        this.bytesWritten += (long)bytesToWrite;
        this.bytesWrittenToBuffer += (long)bytesToWrite;
    }

    class RecordWriter
    extends Thread {
        private volatile long lastSeqProcessed = -1L;

        RecordWriter() {
        }

        void waitForLastItem() {
            while (EventWriterMT.this.supply.getLastSequence() > this.lastSeqProcessed) {
                Thread.yield();
            }
            this.interrupt();
        }

        @Override
        public void run() {
            try {
                while (true) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    RecordRingItem item = EventWriterMT.this.supply.getToWrite();
                    long currentSeq = item.getSequence();
                    boolean split = item.splitFileAfterWrite();
                    EventWriterMT.this.writeToFile(item, item.forceToDisk());
                    EventWriterMT.this.supply.releaseWriter(item);
                    this.lastSeqProcessed = currentSeq;
                    if (!split) continue;
                    EventWriterMT.this.splitFile();
                }
            }
            catch (InterruptedException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class RecordCompressor
    extends Thread {
        private final int num;

        RecordCompressor(int threadNumber) {
            this.num = threadNumber;
        }

        @Override
        public void run() {
            try {
                EventWriterMT.this.supply.release(this.num, this.num - 1);
                while (true) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    RecordRingItem item = EventWriterMT.this.supply.getToCompress(this.num);
                    RecordOutputStream record = item.getRecord();
                    RecordHeader header = record.getHeader();
                    header.setRecordNumber((int)(item.getSequence() + 1L));
                    header.setCompressionType(EventWriterMT.this.compressionType);
                    record.build();
                    EventWriterMT.this.supply.releaseCompressor(item);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    private final class FileCloser {
        private final ExecutorService threadPool = Executors.newSingleThreadExecutor();

        FileCloser() {
        }

        void closeFile(RandomAccessFile raf) {
            this.threadPool.submit(new CloseThd(raf));
        }

        void close() {
            this.threadPool.shutdown();
        }

        private final class CloseThd
        implements Runnable {
            private final RandomAccessFile raf;

            CloseThd(RandomAccessFile raf) {
                this.raf = raf;
            }

            @Override
            public final void run() {
                try {
                    this.raf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static enum IOStatus {
        SUCCESS,
        END_OF_FILE,
        EVIO_EXCEPTION,
        CANNOT_OPEN_FILE,
        UNKNOWN_ERROR;

    }
}

