/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.hipo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jlab.coda.hipo.FileHeader;
import org.jlab.coda.hipo.HipoException;
import org.jlab.coda.hipo.RecordHeader;
import org.jlab.coda.hipo.RecordOutputStream;
import org.jlab.coda.hipo.RecordRingItem;
import org.jlab.coda.hipo.RecordSupply;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.Utilities;

public class WriterMT
implements AutoCloseable {
    private boolean toFile = true;
    private RandomAccessFile outStream;
    private FileChannel fileChannel;
    private FileHeader fileHeader;
    private ByteBuffer buffer;
    private RecordSupply supply;
    private int compressionThreadCount = 1;
    private RecordCompressor[] recordCompressorThreads;
    private RecordWriter recordWriterThread;
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private RecordOutputStream record;
    private RecordRingItem ringItem;
    private byte[] headerArray = new byte[56];
    private int compressionType;
    private long writerBytesWritten;
    private int recordNumber = 1;
    private boolean addTrailer;
    private boolean addTrailerIndex;
    private ArrayList<Integer> recordLengths = new ArrayList(1500);

    public WriterMT() {
        this.compressionThreadCount = 1;
        this.fileHeader = new FileHeader(true);
        this.supply = new RecordSupply(8, this.byteOrder, this.compressionThreadCount, 0, 0, 1);
        this.ringItem = this.supply.get();
        this.record = this.ringItem.getRecord();
    }

    public WriterMT(ByteOrder order, int maxEventCount, int maxBufferSize, int compressionType, int compressionThreads, int ringSize) throws IllegalArgumentException {
        if (order != null) {
            this.byteOrder = order;
        }
        if (compressionType <= -1 || compressionType >= 4) {
            throw new IllegalArgumentException("compressionType must be 0,1,2,or 3");
        }
        this.compressionType = compressionType;
        this.compressionThreadCount = compressionThreads;
        int finalRingSize = ringSize;
        if (finalRingSize < compressionThreads) {
            finalRingSize = compressionThreads;
        }
        if ((finalRingSize = Utilities.powerOfTwo(finalRingSize, true)) != ringSize) {
            System.out.println("WriterMT: change to ring size = " + finalRingSize);
        }
        this.fileHeader = new FileHeader(true);
        this.supply = new RecordSupply(ringSize, this.byteOrder, compressionThreads, maxEventCount, maxBufferSize, compressionType);
        this.ringItem = this.supply.get();
        this.record = this.ringItem.getRecord();
    }

    public WriterMT(String filename) {
        this();
        this.open(filename);
    }

    public WriterMT(String filename, ByteOrder order, int maxEventCount, int maxBufferSize, int compressionType, int compressionThreads, int ringSize) {
        this(order, maxEventCount, maxBufferSize, compressionType, compressionThreads, ringSize);
        this.open(filename);
    }

    public WriterMT(ByteBuffer buf, int maxEventCount, int maxBufferSize) {
        this.buffer = buf;
        this.byteOrder = buf.order();
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public FileHeader getFileHeader() {
        return this.fileHeader;
    }

    public boolean addTrailer() {
        return this.addTrailer;
    }

    public void addTrailer(boolean addTrailer) {
        this.addTrailer = addTrailer;
    }

    public boolean addTrailerWithIndex() {
        return this.addTrailerIndex;
    }

    public void addTrailerWithIndex(boolean addTrailingIndex) {
        this.addTrailerIndex = addTrailingIndex;
        if (addTrailingIndex) {
            this.addTrailer = true;
        }
    }

    public final void open(String filename) {
        this.open(filename, new byte[0]);
    }

    public final void open(String filename, byte[] userHeader) {
        if (userHeader == null) {
            userHeader = new byte[]{};
        }
        try {
            this.outStream = new RandomAccessFile(filename, "rw");
            this.fileChannel = this.outStream.getChannel();
            ByteBuffer headerBuffer = this.createHeader(userHeader);
            this.outStream.write(headerBuffer.array());
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(WriterMT.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(WriterMT.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.writerBytesWritten = this.fileHeader.getLength();
        this.recordCompressorThreads = new RecordCompressor[this.compressionThreadCount];
        for (int i = 0; i < this.compressionThreadCount; ++i) {
            this.recordCompressorThreads[i] = new RecordCompressor(i);
            this.recordCompressorThreads[i].start();
        }
        this.recordWriterThread = new RecordWriter();
        this.recordWriterThread.start();
    }

    public final WriterMT setCompressionType(int compression) {
        if (compression > -1 && compression < 4) {
            this.compressionType = compression;
        }
        return this;
    }

    public ByteBuffer createHeader(byte[] userHeader) {
        int userHeaderBytes = userHeader.length;
        this.fileHeader.reset();
        this.fileHeader.setUserHeaderLength(userHeaderBytes);
        int userHeaderPaddedBytes = 4 * this.fileHeader.getUserHeaderLengthWords();
        int bytes = 56 + userHeaderPaddedBytes;
        this.fileHeader.setLength(bytes);
        byte[] array = new byte[bytes];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.order(this.byteOrder);
        try {
            this.fileHeader.writeHeader(buffer, 0);
        }
        catch (HipoException e) {
            // empty catch block
        }
        System.arraycopy(userHeader, 0, array, 56, userHeaderBytes);
        return buffer;
    }

    private void writeTrailer(boolean writeIndex) throws IOException {
        long trailerPosition = this.writerBytesWritten;
        if (!writeIndex) {
            try {
                FileHeader.writeTrailer(this.headerArray, this.recordNumber, this.byteOrder, null);
            }
            catch (HipoException e) {
                // empty catch block
            }
            this.writerBytesWritten += 56L;
            this.outStream.write(this.headerArray, 0, 56);
        } else {
            int dataBytes;
            byte[] recordIndex = new byte[4 * this.recordLengths.size()];
            try {
                for (int i = 0; i < this.recordLengths.size(); ++i) {
                    ByteDataTransformer.toBytes(this.recordLengths.get(i), this.byteOrder, recordIndex, 4 * i);
                }
            }
            catch (EvioException e) {
                // empty catch block
            }
            if (this.headerArray.length < (dataBytes = 56 + recordIndex.length)) {
                this.headerArray = new byte[dataBytes];
            }
            try {
                FileHeader.writeTrailer(this.headerArray, this.recordNumber, this.byteOrder, recordIndex);
            }
            catch (HipoException e) {
                // empty catch block
            }
            this.writerBytesWritten += (long)dataBytes;
            this.outStream.write(this.headerArray, 0, dataBytes);
        }
        this.outStream.seek(40L);
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            this.outStream.writeLong(Long.reverseBytes(trailerPosition));
        } else {
            this.outStream.writeLong(trailerPosition);
        }
        if (this.addTrailerIndex) {
            this.outStream.seek(20L);
            int bitInfo = this.fileHeader.setBitInfo(false, false, true);
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                this.outStream.writeInt(Integer.reverseBytes(bitInfo));
            } else {
                this.outStream.writeInt(bitInfo);
            }
        }
    }

    public void writeRecord(RecordOutputStream rec) throws IllegalArgumentException {
        if (rec.getByteOrder() != this.byteOrder) {
            throw new IllegalArgumentException("byte order of record is wrong");
        }
        if (this.record.getEventCount() > 0) {
            this.supply.publish(this.ringItem);
            this.ringItem = this.supply.get();
            this.record = this.ringItem.getRecord();
        }
        this.record.copy(rec);
        RecordHeader header = this.record.getHeader();
        header.setCompressionType(this.compressionType);
        header.setRecordNumber(this.recordNumber++);
        this.record.setByteOrder(this.byteOrder);
        this.supply.publish(this.ringItem);
        this.ringItem = this.supply.get();
        this.record = this.ringItem.getRecord();
    }

    public void addEvent(byte[] buffer, int offset, int length) {
        boolean status = this.record.addEvent(buffer, offset, length);
        if (!status) {
            this.supply.publish(this.ringItem);
            this.ringItem = this.supply.get();
            this.record = this.ringItem.getRecord();
            this.record.addEvent(buffer, offset, length);
        }
    }

    public void addEvent(byte[] buffer) {
        this.addEvent(buffer, 0, buffer.length);
    }

    public void reset() {
        this.record.reset();
        this.fileHeader.reset();
        this.writerBytesWritten = 0L;
        this.recordNumber = 1;
        this.addTrailer = false;
    }

    @Override
    public void close() {
        if (this.record.getEventCount() > 0) {
            this.supply.publish(this.ringItem);
        }
        this.recordWriterThread.waitForLastItem();
        for (RecordCompressor rc : this.recordCompressorThreads) {
            rc.interrupt();
        }
        try {
            if (this.addTrailer) {
                this.writeTrailer(this.addTrailerIndex);
            }
            this.outStream.close();
        }
        catch (IOException ex) {
            Logger.getLogger(WriterMT.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    class RecordWriter
    extends Thread {
        private volatile long lastSeqProcessed = -1L;

        RecordWriter() {
        }

        void waitForLastItem() {
            while (WriterMT.this.supply.getLastSequence() > this.lastSeqProcessed) {
                Thread.yield();
            }
            this.interrupt();
        }

        @Override
        public void run() {
            try {
                while (true) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    RecordRingItem item = WriterMT.this.supply.getToWrite();
                    long currentSeq = item.getSequence();
                    RecordOutputStream record = item.getRecord();
                    RecordHeader header = record.getHeader();
                    int bytesToWrite = header.getLength();
                    WriterMT.this.recordLengths.add(bytesToWrite);
                    WriterMT.this.recordLengths.add(header.getEntries());
                    WriterMT.this.writerBytesWritten += bytesToWrite;
                    try {
                        ByteBuffer buf = record.getBinaryBuffer();
                        if (buf.hasArray()) {
                            WriterMT.this.outStream.write(buf.array(), 0, bytesToWrite);
                        } else {
                            WriterMT.this.fileChannel.write(buf);
                        }
                        record.reset();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        Logger.getLogger(WriterMT.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    WriterMT.this.supply.releaseWriter(item);
                    this.lastSeqProcessed = currentSeq;
                }
            }
            catch (InterruptedException e) {
                System.out.println("   Writer: thread INTERRUPTED");
                return;
            }
        }
    }

    class RecordCompressor
    extends Thread {
        private final int num;

        RecordCompressor(int threadNumber) {
            this.num = threadNumber;
        }

        @Override
        public void run() {
            try {
                WriterMT.this.supply.release(this.num, this.num - 1);
                while (true) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    RecordRingItem item = WriterMT.this.supply.getToCompress(this.num);
                    RecordOutputStream record = item.getRecord();
                    RecordHeader header = record.getHeader();
                    header.setRecordNumber((int)(item.getSequence() + 1L));
                    header.setCompressionType(WriterMT.this.compressionType);
                    record.build();
                    WriterMT.this.supply.releaseCompressor(item);
                }
            }
            catch (InterruptedException e) {
                System.out.println("   Compressor: thread " + this.num + " INTERRUPTED");
                return;
            }
        }
    }
}

