/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.hipo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jlab.coda.hipo.FileHeader;
import org.jlab.coda.hipo.HeaderType;
import org.jlab.coda.hipo.HipoException;
import org.jlab.coda.hipo.RecordHeader;
import org.jlab.coda.hipo.RecordOutputStream;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.EvioException;

public class Writer
implements AutoCloseable {
    private boolean toFile = true;
    private RandomAccessFile outStream;
    private FileChannel fileChannel;
    private FileHeader fileHeader;
    private ByteBuffer buffer;
    private String dictionary;
    private byte[] firstEvent;
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private RecordOutputStream outputRecord;
    private byte[] headerArray = new byte[56];
    private int compressionType;
    private long writerBytesWritten;
    private int recordNumber = 1;
    private boolean addTrailer;
    private boolean addTrailerIndex;
    private ArrayList<Integer> recordLengths = new ArrayList(1500);

    public Writer() {
        this.outputRecord = new RecordOutputStream();
        this.fileHeader = new FileHeader(true);
    }

    public Writer(ByteOrder order, int maxEventCount, int maxBufferSize) {
        this(HeaderType.EVIO_FILE, order, maxEventCount, maxBufferSize, null, null);
    }

    public Writer(HeaderType hType, ByteOrder order, int maxEventCount, int maxBufferSize) {
        this(hType, order, maxEventCount, maxBufferSize, null, null);
    }

    public Writer(HeaderType hType, ByteOrder order, int maxEventCount, int maxBufferSize, String dictionary, byte[] firstEvent) {
        if (order != null) {
            this.byteOrder = order;
        }
        this.dictionary = dictionary;
        this.firstEvent = firstEvent;
        this.outputRecord = new RecordOutputStream(order, maxEventCount, maxBufferSize, 1);
        this.fileHeader = hType == HeaderType.HIPO_FILE ? new FileHeader(false) : new FileHeader(true);
    }

    public Writer(String filename) {
        this();
        this.open(filename);
    }

    public Writer(String filename, ByteOrder order, int maxEventCount, int maxBufferSize) {
        this(order, maxEventCount, maxBufferSize);
        this.open(filename);
    }

    public Writer(ByteBuffer buf, int maxEventCount, int maxBufferSize) {
        this.buffer = buf;
        this.byteOrder = buf.order();
        this.outputRecord = new RecordOutputStream(this.byteOrder, maxEventCount, maxBufferSize, 1);
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public FileHeader getFileHeader() {
        return this.fileHeader;
    }

    public RecordHeader getRecordHeader() {
        return this.outputRecord.getHeader();
    }

    public RecordOutputStream getRecord() {
        return this.outputRecord;
    }

    public boolean addTrailer() {
        return this.addTrailer;
    }

    public void addTrailer(boolean addTrailer) {
        this.addTrailer = addTrailer;
    }

    public boolean addTrailerWithIndex() {
        return this.addTrailerIndex;
    }

    public void addTrailerWithIndex(boolean addTrailingIndex) {
        this.addTrailerIndex = addTrailingIndex;
        if (addTrailingIndex) {
            this.addTrailer = true;
        }
    }

    public final void open(String filename) {
        this.open(filename, new byte[0]);
    }

    public final void open(String filename, byte[] userHeader) {
        if (userHeader == null) {
            userHeader = this.dictionary == null && this.firstEvent == null ? new byte[]{} : this.createDictionaryRecord();
        }
        try {
            this.outStream = new RandomAccessFile(filename, "rw");
            this.fileChannel = this.outStream.getChannel();
            ByteBuffer headerBuffer = this.createHeader(userHeader);
            this.outStream.write(headerBuffer.array());
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(Writer.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Writer.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.writerBytesWritten = this.fileHeader.getLength();
    }

    private byte[] createDictionaryRecord() {
        if (this.dictionary == null && this.firstEvent == null) {
            return null;
        }
        RecordOutputStream record = new RecordOutputStream(this.byteOrder, 2, 0, 0);
        int bytes = 0;
        if (this.dictionary != null) {
            bytes += this.dictionary.length();
        }
        if (this.firstEvent != null) {
            bytes += this.firstEvent.length;
        }
        if (bytes > record.getInternalBufferCapacity()) {
            record = new RecordOutputStream(this.byteOrder, 2, bytes, 0);
        }
        if (this.dictionary != null) {
            try {
                record.addEvent(this.dictionary.getBytes("US-ASCII"));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (this.firstEvent != null) {
            record.addEvent(this.firstEvent);
        }
        record.build();
        ByteBuffer buf = record.getBinaryBuffer();
        byte[] rec = new byte[buf.limit()];
        if (buf.hasArray()) {
            System.arraycopy(buf.array(), buf.arrayOffset(), rec, 0, rec.length);
        }
        buf.get(rec);
        return rec;
    }

    public final Writer setCompressionType(int compression) {
        this.outputRecord.getHeader().setCompressionType(compression);
        this.compressionType = this.outputRecord.getHeader().getCompressionType();
        return this;
    }

    public int getCompressionType() {
        return this.outputRecord.getHeader().getCompressionType();
    }

    public ByteBuffer createHeader(byte[] userHeader) {
        int userHeaderBytes = userHeader.length;
        this.fileHeader.reset();
        this.fileHeader.setUserHeaderLength(userHeaderBytes);
        byte[] array = new byte[this.fileHeader.getLength()];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.order(this.byteOrder);
        try {
            this.fileHeader.writeHeader(buffer, 0);
        }
        catch (HipoException e) {
            // empty catch block
        }
        System.arraycopy(userHeader, 0, array, 56, userHeaderBytes);
        return buffer;
    }

    public void writeTrailer(boolean writeIndex) {
        int dataBytes;
        if (!writeIndex) {
            try {
                FileHeader.writeTrailer(this.headerArray, this.recordNumber, this.byteOrder, null);
                this.writerBytesWritten += 56L;
                this.outStream.write(this.headerArray, 0, 56);
            }
            catch (HipoException ex) {
            }
            catch (IOException ex) {
                Logger.getLogger(Writer.class.getName()).log(Level.SEVERE, null, ex);
            }
            return;
        }
        byte[] recordIndex = new byte[4 * this.recordLengths.size()];
        try {
            for (int i = 0; i < this.recordLengths.size(); ++i) {
                ByteDataTransformer.toBytes(this.recordLengths.get(i), this.byteOrder, recordIndex, 4 * i);
            }
        }
        catch (EvioException e) {
            // empty catch block
        }
        if (this.headerArray.length < (dataBytes = 56 + recordIndex.length)) {
            this.headerArray = new byte[dataBytes];
        }
        try {
            FileHeader.writeTrailer(this.headerArray, this.recordNumber, this.byteOrder, recordIndex);
            this.writerBytesWritten += (long)dataBytes;
            this.outStream.write(this.headerArray, 0, dataBytes);
        }
        catch (HipoException ex) {
        }
        catch (IOException ex) {
            Logger.getLogger(Writer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void writeRecord(RecordOutputStream record) {
        RecordHeader header = record.getHeader();
        header.setCompressionType(this.compressionType);
        header.setRecordNumber(this.recordNumber++);
        record.getHeader().setCompressionType(this.compressionType);
        record.setByteOrder(this.byteOrder);
        record.build();
        int bytesToWrite = header.getLength();
        this.recordLengths.add(bytesToWrite);
        this.recordLengths.add(header.getEntries());
        this.writerBytesWritten += (long)bytesToWrite;
        try {
            this.outStream.write(record.getBinaryBuffer().array(), 0, bytesToWrite);
        }
        catch (IOException ex) {
            Logger.getLogger(Writer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void addEvent(byte[] buffer, int offset, int length) {
        boolean status = this.outputRecord.addEvent(buffer, offset, length);
        if (!status) {
            this.writeOutput();
            this.outputRecord.addEvent(buffer, offset, length);
        }
    }

    public void addEvent(byte[] buffer) {
        this.addEvent(buffer, 0, buffer.length);
    }

    private void writeOutput() {
        RecordHeader header = this.outputRecord.getHeader();
        header.setRecordNumber(this.recordNumber++);
        header.setCompressionType(this.compressionType);
        this.outputRecord.build();
        int bytesToWrite = header.getLength();
        this.recordLengths.add(bytesToWrite);
        this.recordLengths.add(header.getEntries());
        this.writerBytesWritten += (long)bytesToWrite;
        try {
            if (this.outputRecord.getBinaryBuffer().hasArray()) {
                this.outStream.write(this.outputRecord.getBinaryBuffer().array(), 0, bytesToWrite);
            } else {
                this.fileChannel.write(this.outputRecord.getBinaryBuffer());
            }
            this.outputRecord.reset();
        }
        catch (IOException ex) {
            Logger.getLogger(Writer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void reset() {
        this.outputRecord.reset();
        this.fileHeader.reset();
        this.writerBytesWritten = 0L;
        this.recordNumber = 1;
        this.addTrailer = false;
    }

    @Override
    public void close() {
        if (this.outputRecord.getEventCount() > 0) {
            this.writeOutput();
        }
        try {
            if (this.addTrailer) {
                long trailerPosition = this.writerBytesWritten;
                this.writeTrailer(this.addTrailerIndex);
                this.outStream.seek(40L);
                if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    this.outStream.writeLong(Long.reverseBytes(trailerPosition));
                } else {
                    this.outStream.writeLong(trailerPosition);
                }
                if (this.addTrailerIndex) {
                    this.outStream.seek(20L);
                    int bitInfo = this.fileHeader.setBitInfo(false, false, true);
                    if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                        this.outStream.writeInt(Integer.reverseBytes(bitInfo));
                    } else {
                        this.outStream.writeInt(bitInfo);
                    }
                }
            }
            this.outStream.close();
        }
        catch (IOException ex) {
            Logger.getLogger(Writer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

