/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.hipo;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.jlab.coda.hipo.HeaderType;
import org.jlab.coda.hipo.HipoException;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.IBlockHeader;

public class RecordHeader
implements IBlockHeader {
    private static final int[] padValue = new int[]{0, 3, 2, 1};
    public static final int HEADER_SIZE_WORDS = 14;
    public static final int HEADER_SIZE_BYTES = 56;
    public static final int HEADER_MAGIC = -1059454720;
    static final int HEADER_MAGIC_LE = -1059454720;
    static final int HEADER_MAGIC_BE = Integer.reverseBytes(-1059454720);
    public static final int BIT_INFO_OFFSET = 20;
    static final int DICTIONARY_BIT = 256;
    static final int FIRST_EVENT_BIT = 512;
    static final int LAST_RECORD_BIT = 1024;
    static final int DATA_ROC_RAW_BITS = 0;
    static final int DATA_PHYSICS_BITS = 2048;
    static final int DATA_PARTIAL_BITS = 4096;
    static final int DATA_DISENTANGLED_BITS = 6144;
    static final int DATA_USER_BITS = 8192;
    static final int DATA_CONTROL_BITS = 10240;
    static final int DATA_OTHER_BITS = 30720;
    private long position;
    private int recordLength;
    private int recordLengthWords;
    private int recordNumber;
    private long recordUserRegisterFirst;
    private long recordUserRegisterSecond;
    private HeaderType headerType = HeaderType.HIPO_RECORD;
    private int entries;
    private int bitInfo = -1;
    private int eventType;
    private int headerLength = 56;
    private int headerLengthWords = 14;
    private int userHeaderLength;
    private int userHeaderLengthWords;
    private int indexLength;
    private int dataLength;
    private int dataLengthWords;
    private int compressedDataLength;
    private int compressedDataLengthWords;
    private int compressionType;
    private int headerVersion = 6;
    private int headerMagicWord = -1059454720;
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private int userHeaderLengthPadding;
    private int dataLengthPadding;
    private int compressedDataLengthPadding;

    public RecordHeader() {
    }

    public RecordHeader(HeaderType type) throws HipoException {
        this.headerType = type;
        if (type.isFileHeader()) {
            throw new HipoException("use FileHeader class for a file");
        }
    }

    public RecordHeader(RecordHeader header) {
        this.copy(header);
    }

    public RecordHeader(long _pos, int _l, int _e) {
        this.position = _pos;
        this.recordLength = _l;
        this.entries = _e;
    }

    public void copy(RecordHeader head) {
        if (head == null) {
            return;
        }
        this.position = head.position;
        this.recordLength = head.recordLength;
        this.recordNumber = head.recordNumber;
        this.recordLengthWords = head.recordLengthWords;
        this.recordUserRegisterFirst = head.recordUserRegisterFirst;
        this.recordUserRegisterSecond = head.recordUserRegisterSecond;
        this.headerType = head.headerType;
        this.entries = head.entries;
        this.bitInfo = head.bitInfo;
        this.eventType = head.eventType;
        this.headerLength = head.headerLength;
        this.headerLengthWords = head.headerLengthWords;
        this.userHeaderLength = head.userHeaderLength;
        this.userHeaderLengthWords = head.userHeaderLengthWords;
        this.indexLength = head.indexLength;
        this.dataLength = head.dataLength;
        this.dataLengthWords = head.dataLengthWords;
        this.compressedDataLength = head.compressedDataLength;
        this.compressedDataLengthWords = head.compressedDataLengthWords;
        this.compressionType = head.compressionType;
        this.headerMagicWord = head.headerMagicWord;
        this.userHeaderLengthPadding = head.userHeaderLengthPadding;
        this.dataLengthPadding = head.dataLengthPadding;
        this.compressedDataLengthPadding = head.compressedDataLengthPadding;
    }

    public void reset() {
        this.position = 0L;
        this.recordLength = 0;
        this.recordNumber = 0;
        this.recordLengthWords = 0;
        this.recordUserRegisterFirst = 0L;
        this.recordUserRegisterSecond = 0L;
        this.entries = 0;
        this.bitInfo = -1;
        this.eventType = 0;
        this.headerLength = 56;
        this.headerLengthWords = 14;
        this.userHeaderLength = 0;
        this.userHeaderLengthWords = 0;
        this.indexLength = 0;
        this.dataLength = 0;
        this.dataLengthWords = 0;
        this.compressedDataLength = 0;
        this.compressedDataLengthWords = 0;
        this.userHeaderLengthPadding = 0;
        this.dataLengthPadding = 0;
        this.compressedDataLengthPadding = 0;
    }

    private static int getWords(int length) {
        int words = length / 4;
        if (RecordHeader.getPadding(length) > 0) {
            ++words;
        }
        return words;
    }

    private static int getPadding(int length) {
        return padValue[length % 4];
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public long getPosition() {
        return this.position;
    }

    public int getLength() {
        return this.recordLength;
    }

    public int getEntries() {
        return this.entries;
    }

    public int getCompressionType() {
        return this.compressionType;
    }

    public int getUserHeaderLength() {
        return this.userHeaderLength;
    }

    public int getUserHeaderLengthWords() {
        return this.userHeaderLengthWords;
    }

    @Override
    public int getVersion() {
        return this.headerVersion;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public int getDataLengthWords() {
        return this.dataLengthWords;
    }

    public int getIndexLength() {
        return this.indexLength;
    }

    public int getCompressedDataLength() {
        return this.compressedDataLength;
    }

    public int getCompressedDataLengthPadding() {
        return this.compressedDataLengthPadding;
    }

    public int getCompressedDataLengthWords() {
        return this.compressedDataLengthWords;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    @Override
    public int getHeaderWords() {
        return this.headerLengthWords;
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public long getUserRegisterFirst() {
        return this.recordUserRegisterFirst;
    }

    public long getUserRegisterSecond() {
        return this.recordUserRegisterSecond;
    }

    public HeaderType getHeaderType() {
        return this.headerType;
    }

    public int getBitInfoWord() {
        if (this.bitInfo < 0) {
            this.setBitInfo(false, false, false);
        }
        return this.bitInfo;
    }

    public int setBitInfo(boolean isLastRecord, boolean haveFirstEvent, boolean haveDictionary) {
        this.bitInfo = this.headerType.getValue() << 28 | this.compressedDataLengthPadding << 24 | this.dataLengthPadding << 22 | this.userHeaderLengthPadding << 20 | this.headerVersion & 0xFF;
        if (haveDictionary) {
            this.bitInfo |= 0x100;
        }
        if (haveFirstEvent) {
            this.bitInfo |= 0x200;
        }
        if (isLastRecord) {
            this.bitInfo |= 0x400;
        }
        return this.bitInfo;
    }

    public int setBitInfoEventType(int type) {
        switch (type) {
            case 0: {
                this.bitInfo |= 0;
                this.eventType = type;
                break;
            }
            case 1: {
                this.bitInfo |= 0x800;
                this.eventType = type;
                break;
            }
            case 2: {
                this.bitInfo |= 0x1000;
                this.eventType = type;
                break;
            }
            case 3: {
                this.bitInfo |= 0x1800;
                this.eventType = type;
                break;
            }
            case 4: {
                this.bitInfo |= 0x2000;
                this.eventType = type;
                break;
            }
            case 5: {
                this.bitInfo |= 0x2800;
                this.eventType = type;
                break;
            }
            case 15: {
                this.bitInfo |= 0x7800;
                this.eventType = type;
                break;
            }
        }
        return this.bitInfo;
    }

    void setBitInfoWord(int word) {
        this.bitInfo = word;
        this.decodeBitInfoWord(word);
    }

    private void decodeBitInfoWord(int word) {
        this.compressedDataLengthPadding = word >>> 24 & 3;
        this.dataLengthPadding = word >>> 22 & 3;
        this.userHeaderLengthPadding = word >>> 20 & 3;
        this.headerType = HeaderType.getHeaderType(word >>> 28);
        if (this.headerType == null) {
            this.headerType = HeaderType.EVIO_RECORD;
        }
        this.eventType = word >> 11 & 0xF;
    }

    @Override
    public boolean hasDictionary() {
        return (this.bitInfo & 0x100) != 0;
    }

    @Override
    public boolean hasFirstEvent() {
        return (this.bitInfo & 0x200) != 0;
    }

    public boolean isLastRecord() {
        return (this.bitInfo & 0x400) != 0;
    }

    RecordHeader setHeaderType(HeaderType type) {
        this.headerType = type;
        return this;
    }

    public RecordHeader setPosition(long pos) {
        this.position = pos;
        return this;
    }

    public RecordHeader setRecordNumber(int num) {
        this.recordNumber = num;
        return this;
    }

    public RecordHeader setLength(int length) {
        this.recordLength = length;
        this.recordLengthWords = length / 4;
        return this;
    }

    public RecordHeader setDataLength(int length) {
        this.dataLength = length;
        this.dataLengthWords = RecordHeader.getWords(length);
        this.dataLengthPadding = RecordHeader.getPadding(length);
        return this;
    }

    public RecordHeader setCompressedDataLength(int length) {
        this.compressedDataLength = length;
        this.compressedDataLengthWords = RecordHeader.getWords(length);
        this.compressedDataLengthPadding = RecordHeader.getPadding(length);
        return this;
    }

    public RecordHeader setIndexLength(int length) {
        this.indexLength = length / 4 * 4;
        return this;
    }

    public RecordHeader setCompressionType(int type) {
        if (type < 0 || type > 3) {
            type = 0;
        }
        this.compressionType = type;
        return this;
    }

    public RecordHeader setEntries(int n) {
        this.entries = n;
        return this;
    }

    public RecordHeader setUserHeaderLength(int length) {
        this.userHeaderLength = length;
        this.userHeaderLengthWords = RecordHeader.getWords(length);
        this.userHeaderLengthPadding = RecordHeader.getPadding(length);
        return this;
    }

    public RecordHeader setHeaderLength(int length) {
        this.headerLength = length;
        this.headerLengthWords = length / 4;
        return this;
    }

    public RecordHeader setUserRegisterFirst(long reg) {
        this.recordUserRegisterFirst = reg;
        return this;
    }

    public RecordHeader setUserRegisterSecond(long reg) {
        this.recordUserRegisterSecond = reg;
        return this;
    }

    public void writeHeader(ByteBuffer buf, int off) throws HipoException {
        if (buf == null || buf.capacity() - off < 56) {
            throw new HipoException("null or too small buf arg");
        }
        int compressedWord = this.compressedDataLengthWords & 0xFFFFFFF | (this.compressionType & 0xF) << 28;
        buf.putInt(off, this.recordLengthWords);
        buf.putInt(4 + off, this.recordNumber);
        buf.putInt(8 + off, this.headerLengthWords);
        buf.putInt(12 + off, this.entries);
        buf.putInt(16 + off, this.indexLength);
        buf.putInt(20 + off, this.getBitInfoWord());
        buf.putInt(24 + off, this.userHeaderLength);
        buf.putInt(28 + off, this.headerMagicWord);
        buf.putInt(32 + off, this.dataLength);
        buf.putInt(36 + off, compressedWord);
        buf.putLong(40 + off, this.recordUserRegisterFirst);
        buf.putLong(48 + off, this.recordUserRegisterSecond);
    }

    public void writeHeader(ByteBuffer buffer) throws HipoException {
        this.writeHeader(buffer, 0);
    }

    public static void writeTrailer(byte[] array, int recordNumber, ByteOrder order) throws HipoException {
        RecordHeader.writeTrailer(array, 0, recordNumber, order);
    }

    public static void writeTrailer(byte[] array, int off, int recordNumber, ByteOrder order) throws HipoException {
        int indexLength = 0;
        int totalLength = 56;
        if (array == null || array.length < totalLength) {
            throw new HipoException("null or too small array arg");
        }
        int bitInfo = HeaderType.EVIO_TRAILER.getValue() << 28 | 0x400 | 6;
        try {
            ByteDataTransformer.toBytes(totalLength, order, array, off);
            ByteDataTransformer.toBytes(recordNumber, order, array, 4 + off);
            ByteDataTransformer.toBytes(14, order, array, 8 + off);
            ByteDataTransformer.toBytes(0, order, array, 12 + off);
            ByteDataTransformer.toBytes(indexLength, order, array, 16 + off);
            ByteDataTransformer.toBytes(bitInfo, order, array, 20 + off);
            ByteDataTransformer.toBytes(0, order, array, 24 + off);
            ByteDataTransformer.toBytes(-1059454720, order, array, 28 + off);
            Arrays.fill(array, 32 + off, 56 + off, (byte)0);
        }
        catch (EvioException e) {
            // empty catch block
        }
    }

    public static void writeTrailer(ByteBuffer buf, int off, int recordNumber, ByteOrder order) throws HipoException {
        int totalLength = 56;
        if (buf == null || buf.capacity() - off < totalLength) {
            throw new HipoException("null or too small buf arg");
        }
        if (buf.hasArray()) {
            RecordHeader.writeTrailer(buf.array(), off, recordNumber, order);
        } else {
            int bitInfo = HeaderType.EVIO_TRAILER.getValue() << 28 | 0x400 | 6;
            buf.position(off);
            buf.putInt(totalLength);
            buf.putInt(recordNumber);
            buf.putInt(14);
            buf.putInt(0);
            buf.putInt(bitInfo);
            buf.putInt(0);
            buf.putInt(-1059454720);
            buf.putLong(0L);
            buf.putLong(0L);
            buf.putLong(0L);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readHeader(ByteBuffer buffer, int offset) throws HipoException {
        if (buffer == null || buffer.capacity() - offset < 56) {
            throw new HipoException("null or too small buffer arg");
        }
        this.headerMagicWord = buffer.getInt(28 + offset);
        if (this.headerMagicWord != -1059454720) {
            if (this.headerMagicWord != HEADER_MAGIC_BE) throw new HipoException("buffer arg not in evio/hipo format");
            this.byteOrder = buffer.order() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
            buffer.order(this.byteOrder);
        } else {
            this.byteOrder = buffer.order();
        }
        int bitInfoWord = buffer.getInt(20 + offset);
        this.decodeBitInfoWord(bitInfoWord);
        int version = bitInfoWord & 0xFF;
        if (version < 6) {
            throw new HipoException("buffer is in evio format version " + version);
        }
        this.headerVersion = version;
        this.recordLengthWords = buffer.getInt(offset);
        this.recordLength = 4 * this.recordLengthWords;
        this.recordNumber = buffer.getInt(4 + offset);
        this.headerLengthWords = buffer.getInt(8 + offset);
        this.setHeaderLength(4 * this.headerLengthWords);
        this.entries = buffer.getInt(12 + offset);
        this.indexLength = buffer.getInt(16 + offset);
        this.setIndexLength(this.indexLength);
        this.userHeaderLength = buffer.getInt(24 + offset);
        this.setUserHeaderLength(this.userHeaderLength);
        this.dataLength = buffer.getInt(32 + offset);
        this.setDataLength(this.dataLength);
        int compressionWord = buffer.getInt(36 + offset);
        this.compressionType = compressionWord >>> 28;
        this.compressedDataLengthWords = compressionWord & 0xFFFFFFF;
        this.compressedDataLengthPadding = bitInfoWord >>> 24 & 3;
        this.compressedDataLength = this.compressedDataLengthWords * 4 - this.compressedDataLengthPadding;
        this.recordUserRegisterFirst = buffer.getLong(40 + offset);
        this.recordUserRegisterSecond = buffer.getLong(48 + offset);
    }

    public void readHeader(ByteBuffer buffer) throws HipoException {
        this.readHeader(buffer, 0);
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(String.format("%24s : %d\n", "version", this.headerVersion));
        str.append(String.format("%24s : %d\n", "record #", this.recordNumber));
        str.append(String.format("%24s : %8d / %8d / %8d\n", "user header length", this.userHeaderLength, this.userHeaderLengthWords, this.userHeaderLengthPadding));
        str.append(String.format("%24s : %8d / %8d / %8d\n", "   data length", this.dataLength, this.dataLengthWords, this.dataLengthPadding));
        str.append(String.format("%24s : %8d / %8d\n", "record length", this.recordLength, this.recordLengthWords));
        str.append(String.format("%24s : %8d / %8d / %8d\n", "compressed length", this.compressedDataLength, this.compressedDataLengthWords, this.compressedDataLengthPadding));
        str.append(String.format("%24s : %d\n", "header length", this.headerLength));
        str.append(String.format("%24s : 0x%X\n", "magic word", this.headerMagicWord));
        Integer bitInfo = this.getBitInfoWord();
        str.append(String.format("%24s : %s\n", "bit info word", Integer.toBinaryString(bitInfo)));
        str.append(String.format("%24s : %d\n", "record entries", this.entries));
        str.append(String.format("%24s : %d\n", "   compression type", this.compressionType));
        str.append(String.format("%24s : %d\n", "  index length", this.indexLength));
        str.append(String.format("%24s : %d\n", "user register #1", this.recordUserRegisterFirst));
        str.append(String.format("%24s : %d\n", "user register #2", this.recordUserRegisterSecond));
        return str.toString();
    }

    @Override
    public int getSize() {
        return this.recordLengthWords;
    }

    @Override
    public int getNumber() {
        return this.recordNumber;
    }

    @Override
    public int getMagicNumber() {
        return this.headerMagicWord;
    }

    @Override
    public boolean isLastBlock() {
        return this.isLastRecord();
    }

    @Override
    public int getSourceId() {
        return (int)this.recordUserRegisterFirst;
    }

    @Override
    public int getEventType() {
        return this.eventType;
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        try {
            this.writeHeader(byteBuffer, byteBuffer.position());
        }
        catch (HipoException e) {
            System.out.println("RecordHeader.write(): buffer is null or contains too little room");
            return 0;
        }
        return 56;
    }

    @Override
    public long getBufferEndingPosition() {
        return 0L;
    }

    @Override
    public long getBufferStartingPosition() {
        return 0L;
    }

    @Override
    public void setBufferStartingPosition(long bufferStartingPosition) {
    }

    @Override
    public long nextBufferStartingPosition() {
        return 0L;
    }

    @Override
    public long firstEventStartingPosition() {
        return 0L;
    }

    @Override
    public int bytesRemaining(long position) throws EvioException {
        return 0;
    }

    private static String padLeft(String original, String pad, int upTo) {
        int npadding = upTo - original.length();
        StringBuilder str = new StringBuilder();
        if (npadding > 0) {
            for (int i = 0; i < npadding; ++i) {
                str.append(pad);
            }
        }
        str.append(original);
        return str.toString();
    }

    public static void byteBufferBinaryString(ByteBuffer buffer) {
        int nwords = buffer.array().length / 4;
        for (int i = 0; i < nwords; ++i) {
            int value = buffer.getInt(i * 4);
            System.out.println(String.format("  word %4d : %36s  0x%8s : %18d", i, RecordHeader.padLeft(Integer.toBinaryString(value), "0", 32), RecordHeader.padLeft(Integer.toHexString(value), "0", 8), value));
        }
    }

    public static void main(String[] args) {
        RecordHeader header = new RecordHeader();
        header.setCompressedDataLength(861);
        header.setDataLength(12457);
        header.setUserHeaderLength(459);
        header.setIndexLength(324);
        header.setLength(16 + header.getCompressedDataLengthWords());
        header.setUserRegisterFirst(1234567L);
        header.setUserRegisterSecond(4567890L);
        header.setRecordNumber(23);
        header.setEntries(3245);
        header.setHeaderLength(14);
        header.setCompressionType(1);
        System.out.println(header);
        byte[] array = new byte[56];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        try {
            header.writeHeader(buffer);
        }
        catch (HipoException e) {
            // empty catch block
        }
        RecordHeader header2 = new RecordHeader();
        try {
            header2.readHeader(buffer);
            System.out.println(header2);
        }
        catch (HipoException e) {
            e.printStackTrace();
        }
    }
}

