/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.hipo;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.jlab.coda.hipo.Compressor;
import org.jlab.coda.hipo.RecordHeader;

public class Record {
    private final Integer recordUID = 1128616520;
    private final Integer recordHeaderSize = 48;
    private Long UniqueID_First = 0L;
    private Long UniqueID_Second = 0L;
    private final List<byte[]> recordEvents = new ArrayList<byte[]>();
    private Integer bytesWritten = 0;
    private Integer MAXIMUM_BYTES = 0x800000;
    private Integer compressionType = 0;
    private RecordHeader recordHeader = new RecordHeader();

    public Record() {
        this.recordHeader.setHeaderLength(14);
    }

    public Record setCompressionType(int compression) {
        if (compression >= 0 || compression <= 3) {
            this.compressionType = compression;
        }
        return this;
    }

    public Integer getCompressionType() {
        return this.compressionType;
    }

    public void setMaximumCapacity(int max_capacity) {
        this.MAXIMUM_BYTES = max_capacity;
    }

    public boolean addEvent(byte[] buffer) {
        if (buffer.length + this.bytesWritten > this.MAXIMUM_BYTES) {
            return false;
        }
        this.recordEvents.add(buffer);
        this.bytesWritten = this.bytesWritten + buffer.length;
        return true;
    }

    public byte[] getEventNoCopy(int index) {
        return this.recordEvents.get(index);
    }

    public byte[] getEvent(int index) {
        int size = this.recordEvents.get(index).length;
        byte[] event = new byte[size];
        System.arraycopy(this.recordEvents.get(index), 0, event, 0, size);
        return event;
    }

    private byte[] getDataBuffer() {
        byte[] dataBuffer = new byte[this.bytesWritten.intValue()];
        int offset = 0;
        for (int entry = 0; entry < this.recordEvents.size(); ++entry) {
            byte[] item = this.recordEvents.get(entry);
            System.arraycopy(item, 0, dataBuffer, offset, item.length);
            offset += item.length;
        }
        return dataBuffer;
    }

    public void build(ByteBuffer userHeader) {
        int userHeaderSize = userHeader.array().length;
    }

    public ByteBuffer build() {
        int record_size = this.recordHeaderSize + 4 * this.recordEvents.size();
        int data_size_unc = this.bytesWritten;
        int indexOffset = this.recordHeaderSize;
        int dataOffset = this.recordHeaderSize + 4 * this.recordEvents.size();
        byte[] dataBuffer = this.getDataBuffer();
        byte[] compressedData = Compressor.getCompressedBuffer(this.compressionType, dataBuffer);
        byte[] recordBuffer = new byte[record_size + compressedData.length];
        ByteBuffer byteBuffer = ByteBuffer.wrap(recordBuffer);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        System.arraycopy(compressedData, 0, recordBuffer, dataOffset, compressedData.length);
        byteBuffer.putInt(0, this.recordUID);
        byteBuffer.putInt(4, recordBuffer.length);
        byteBuffer.putInt(8, dataBuffer.length);
        byteBuffer.putInt(12, Record.encodeCompressionWord(this.compressionType, compressedData.length));
        byteBuffer.putInt(16, this.recordEvents.size());
        byteBuffer.putInt(20, 0);
        byteBuffer.putInt(24, 4 * this.recordEvents.size());
        byteBuffer.putLong(32, this.UniqueID_First);
        byteBuffer.putLong(40, this.UniqueID_Second);
        for (int entry = 0; entry < this.recordEvents.size(); ++entry) {
            byteBuffer.putInt(indexOffset + entry * 4, this.recordEvents.get(entry).length);
        }
        return byteBuffer;
    }

    public void reset() {
        this.recordEvents.clear();
        this.bytesWritten = 0;
    }

    public int getEntries() {
        return this.recordEvents.size();
    }

    public static int encodeCompressionWord(int compression, int length) {
        int word = compression << 24 & 0xFF000000;
        return word |= length;
    }

    public static int decodeCompressionType(int word) {
        int type = (word & 0xFF000000) >> 24;
        return type;
    }

    public static int decodeCompressionLength(int word) {
        int length = word & 0xFFFFFF;
        return length;
    }

    public static Record initBinary(byte[] buffer) {
        Record record = new Record();
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        Integer recordLength = byteBuffer.getInt(4);
        Integer recordUniqueID = byteBuffer.getInt(0);
        Integer dataLength = byteBuffer.getInt(8);
        Integer uncompWord = byteBuffer.getInt(12);
        Integer eventCount = byteBuffer.getInt(16);
        Integer indexLength = byteBuffer.getInt(24);
        Integer compressionLength = Record.decodeCompressionLength(uncompWord);
        Integer compression = Record.decodeCompressionType(uncompWord);
        record.setCompressionType(compression);
        int dataOffset = record.recordHeaderSize + indexLength;
        int indexOffset = record.recordHeaderSize;
        byte[] data = new byte[compressionLength.intValue()];
        System.arraycopy(buffer, dataOffset, data, 0, data.length);
        byte[] dataUncompressed = Compressor.getUnCompressedBuffer(compression, data);
        int position = 0;
        for (int entry = 0; entry < eventCount; ++entry) {
            Integer eventLength = byteBuffer.getInt(indexOffset + 4 * entry);
            byte[] event = new byte[eventLength.intValue()];
            System.arraycopy(dataUncompressed, position, event, 0, eventLength);
            record.addEvent(event);
            position += eventLength.intValue();
        }
        return record;
    }

    public void show() {
        System.out.println("RECORD:: LENGTH = " + this.bytesWritten + "  EVENTS = " + this.recordEvents.size());
        for (int i = 0; i < this.recordEvents.size(); ++i) {
            System.out.println(String.format("Entry %8d : Length = %8d", i, this.recordEvents.get(i).length));
        }
    }

    public static void main(String[] args) {
        System.out.println("----");
    }
}

