/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventBuilder;
import org.jlab.coda.jevio.EventWriter;
import org.jlab.coda.jevio.EvioCompactReader;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.Utilities;

public class FirstEventTest {
    public static void main1(String[] args) {
        boolean useBuffer = false;
        boolean append = false;
        String fileName = "/tmp/firstEventTestJava.ev";
        File file = new File(fileName);
        ByteBuffer myBuf = ByteBuffer.allocate(800);
        String dictionary = "<xmlDict>\n  <dictEntry name=\"regular event\" tag=\"1\"   num=\"1\"/>\n  <dictEntry name=\"FIRST EVENT\"   tag=\"2\"   num=\"2\"/>\n</xmlDict>";
        int[] intData1 = new int[]{1, 2, 3, 4, 5, 6, 7};
        int[] intData2 = new int[]{8, 9, 10, 11, 12, 13, 14};
        try {
            EventBuilder EB = new EventBuilder(2, DataType.UINT32, 2);
            EvioEvent eventFirst = EB.getEvent();
            eventFirst.appendIntData(intData1);
            EventBuilder EB2 = new EventBuilder(1, DataType.UINT32, 1);
            EvioEvent event = EB2.getEvent();
            event.appendIntData(intData2);
            if (!useBuffer) {
                int split = 100;
                System.out.println("FirstEventTest: create EventWriter for file");
                EventWriter ER = new EventWriter(fileName, null, "runType", 1, split, 1000, 4, 0, ByteOrder.BIG_ENDIAN, dictionary, null, true, false, eventFirst);
                System.out.println("FirstEventTest: write event #1");
                ER.writeEvent(event);
                System.out.println("FirstEventTest: write event #2");
                ER.writeEvent(event);
                System.out.println("FirstEventTest: write event #3");
                ER.writeEvent(event);
                ER.close();
                if (append) {
                    split = 0;
                    System.out.println("FirstEventTest: opening first file");
                    ER = new EventWriter(fileName + ".0", null, "runType", 1, split, 1000, 4, 0, ByteOrder.BIG_ENDIAN, null, null, true, true, null);
                    System.out.println("FirstEventTest: append event #1");
                    ER.writeEvent(event);
                    ER.close();
                }
            } else {
                System.out.println("FirstEventTest: create EventWriter for buffer");
                EventWriter ER = new EventWriter(myBuf, 1000, 3, dictionary, null, 0, 1, false, eventFirst);
                System.out.println("FirstEventTest: write event #1");
                ER.writeEvent(event);
                System.out.println("FirstEventTest: write event #2");
                ER.writeEvent(event);
                System.out.println("FirstEventTest: write event #3");
                ER.writeEvent(event);
                ER.close();
                myBuf.flip();
                System.out.println("FirstEventTest: before writing to file, buf pos = " + myBuf.position() + ", lim = " + myBuf.limit());
                Utilities.bufferToFile(fileName, myBuf, true, false);
                if (append) {
                    System.out.println("FirstEventTest: opening buffer");
                    myBuf.limit(myBuf.capacity());
                    System.out.println("FirstEventTest: before appending to buf, buf pos = " + myBuf.position() + ", lim = " + myBuf.limit());
                    ER = new EventWriter(myBuf, 1000, 3, null, null, 0, 1, append, eventFirst);
                    System.out.println("FirstEventTest: append event #1");
                    ER.writeEvent(event);
                    ER.close();
                    myBuf.flip();
                    Utilities.bufferToFile(fileName + ".app", myBuf, true, false);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String fileName = "/tmp/firstEventTestJava.ev";
        ByteBuffer myBuf = ByteBuffer.allocate(800);
        String dictionary = "<xmlDict>\n  <dictEntry name=\"regular event\" tag=\"1\"   num=\"1\"/>\n  <dictEntry name=\"FIRST EVENT\"   tag=\"2\"   num=\"2\"/>\n</xmlDict>";
        int[] intData1 = new int[]{1, 2, 3, 4, 5, 6, 7};
        int[] intData2 = new int[]{8, 9, 10, 11, 12, 13, 14};
        try {
            EventBuilder EB = new EventBuilder(2, DataType.UINT32, 2);
            EvioEvent eventFirst = EB.getEvent();
            eventFirst.appendIntData(intData1);
            EventBuilder EB2 = new EventBuilder(1, DataType.UINT32, 1);
            EvioEvent event = EB2.getEvent();
            event.appendIntData(intData2);
            int split = 100;
            System.out.println("FirstEventTest: create EventWriter for buffer w/o first event");
            EventWriter bufWriter = new EventWriter(myBuf, 1000, 3, dictionary, null, 0, 1, false, null);
            bufWriter.writeEvent(eventFirst);
            bufWriter.close();
            ByteBuffer dataBuf = bufWriter.getByteBuffer();
            EvioCompactReader cReader = new EvioCompactReader(dataBuf);
            EvioNode firstEventNode = cReader.getEvent(1);
            System.out.println("FirstEventTest: create EventWriter for file");
            EventWriter ER = new EventWriter(fileName, null, "runType", 1, split, 1000, 4, 0, ByteOrder.BIG_ENDIAN, dictionary, null, true, false);
            System.out.println("FirstEventTest: write event #1");
            ER.writeEvent(event);
            System.out.println("FirstEventTest: set first event");
            ER.setFirstEvent(eventFirst);
            System.out.println("FirstEventTest: write event #2");
            ER.writeEvent(event);
            System.out.println("FirstEventTest: write event #3");
            ER.writeEvent(event);
            ER.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
    }
}

