/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.jlab.coda.jevio.CompositeData;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioCompactReader;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.Utilities;

public class CompositeDebugger {
    private int filterTag = -1;
    private int filterNum = -1;
    private int bytesViewed = 80;
    private int eventNumber;
    private boolean lookAtAllCompositeData = false;
    private String fileName = "/daqfs/home/timmer/rafopar044.evio";

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                CompositeDebugger.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-a")) {
                this.lookAtAllCompositeData = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-t")) {
                this.filterTag = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.filterNum = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-e")) {
                this.eventNumber = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-b")) {
                this.bytesViewed = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-f")) {
                this.fileName = args[i + 1];
                ++i;
                continue;
            }
            CompositeDebugger.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java org.jlab.coda.jevio.test.CompositeDebugger\n        [-t <tag>]     tag of structures to look for\n        [-n <num>]     num of structures to look for\n        [-e <event #>] number of specific event to look at\n        [-b <bytes>]   bytes of bad structure to view\n        [-f <file>]    file to read\n        [-a]           show ALL composite data (not just errors)\n        [-h]           print this help\n");
    }

    CompositeDebugger(String[] args) {
        this.decodeCommandLine(args);
    }

    public static void main(String[] args) {
        CompositeDebugger debugger = new CompositeDebugger(args);
        debugger.run();
    }

    public void run() {
        try {
            EvioCompactReader reader = new EvioCompactReader(this.fileName);
            int evCount = reader.getEventCount();
            System.out.println("Event count = " + evCount);
            for (int i = 1; i <= evCount; ++i) {
                if (this.eventNumber > 0 && this.eventNumber != i) continue;
                EvioNode eventNode = reader.getScannedEvent(i);
                ArrayList<EvioNode> nodeList = eventNode.getAllNodes();
                for (EvioNode node : nodeList) {
                    if (node.getDataTypeObj() != DataType.COMPOSITE) continue;
                    ByteBuffer compBuffer = node.getByteData(true);
                    try {
                        CompositeData compData = new CompositeData(compBuffer.array(), reader.getByteOrder());
                        if (!this.lookAtAllCompositeData) continue;
                        this.printData(i, node, compBuffer, false);
                    }
                    catch (EvioException e) {
                        this.printData(i, node, compBuffer, true);
                        System.out.println("ERROR: " + e.getMessage());
                    }
                }
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void printData(int eventNumber, EvioNode node, ByteBuffer compBuffer, boolean hasError) {
        int tag = node.getTag();
        int num = node.getNum();
        if (this.filterTag > -1 && tag != this.filterTag) {
            return;
        }
        if (this.filterNum > -1 && num != this.filterNum) {
            return;
        }
        String label = hasError ? "Composite bank (contains error) for event " + eventNumber : "Composite bank for event " + eventNumber;
        label = label + ", tag = " + tag + "(0x" + Integer.toHexString(tag) + "), num = " + num + "(0x" + Integer.toHexString(num) + "), pad = " + node.getPad() + ", pos = " + node.getPosition() + ", data len = " + node.getDataLength() + " words";
        Utilities.printBufferBytes(compBuffer, 0, this.bytesViewed, label);
    }
}

