/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.BlockHeaderV2;
import org.jlab.coda.jevio.BlockHeaderV4;
import org.jlab.coda.jevio.EventParser;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.IBlockHeader;
import org.jlab.coda.jevio.IEvioProgressListener;
import org.jlab.coda.jevio.MappedMemoryHandler;

public class EvioReader {
    private static final int MAGIC_OFFSET = 28;
    private static final int VERSION_OFFSET = 20;
    private static final int BLOCK_SIZE_OFFSET = 0;
    private static final int VERSION_MASK = 255;
    private static final String ROOT_ELEMENT = "evio-data";
    private static final int DEFAULT_READ_BYTES = 0xFA0000;
    private int eventNumber = 0;
    private int eventCount = -1;
    private int evioVersion;
    private ByteOrder byteOrder;
    private int firstBlockSize;
    private int blockCount = -1;
    private BlockHeaderV2 blockHeader2 = new BlockHeaderV2();
    private BlockHeaderV4 blockHeader4 = new BlockHeaderV4();
    private IBlockHeader blockHeader;
    private IBlockHeader firstBlockHeader;
    private int blockNumberExpected = 1;
    private boolean checkBlockNumberSequence;
    private boolean lastBlock;
    private String dictionaryXML;
    private ByteBuffer byteBuffer;
    private EventParser parser;
    private int initialPosition;
    private MappedMemoryHandler mappedMemoryHandler;
    private String path;
    private File file;
    private long fileSize;
    private FileChannel fileChannel;
    private DataInputStream dataStream;
    private boolean swap;
    private boolean sequentialRead;
    private boolean closed;

    private ReaderState getState() {
        ReaderState currentState = new ReaderState();
        currentState.lastBlock = this.lastBlock;
        currentState.eventNumber = this.eventNumber;
        currentState.blockNumberExpected = this.blockNumberExpected;
        if (this.sequentialRead) {
            try {
                currentState.filePosition = this.fileChannel.position();
                currentState.byteBufferLimit = this.byteBuffer.limit();
                currentState.byteBufferPosition = this.byteBuffer.position();
            }
            catch (IOException iOException) {}
        } else if (this.byteBuffer != null) {
            currentState.byteBufferLimit = this.byteBuffer.limit();
            currentState.byteBufferPosition = this.byteBuffer.position();
        }
        if (this.evioVersion > 3) {
            currentState.blockHeader4 = (BlockHeaderV4)this.blockHeader4.clone();
        } else {
            currentState.blockHeader2 = (BlockHeaderV2)this.blockHeader2.clone();
        }
        return currentState;
    }

    private void restoreState(ReaderState state) {
        this.lastBlock = state.lastBlock;
        this.eventNumber = state.eventNumber;
        this.blockNumberExpected = state.blockNumberExpected;
        if (this.sequentialRead) {
            try {
                this.fileChannel.position(state.filePosition);
                this.byteBuffer.limit(state.byteBufferLimit);
                this.byteBuffer.position(state.byteBufferPosition);
            }
            catch (IOException iOException) {}
        } else if (this.byteBuffer != null) {
            this.byteBuffer.limit(state.byteBufferLimit);
            this.byteBuffer.position(state.byteBufferPosition);
        }
        if (this.evioVersion > 3) {
            this.blockHeader4 = state.blockHeader4;
            this.blockHeader = this.blockHeader4;
        } else {
            this.blockHeader2 = state.blockHeader2;
            this.blockHeader = this.blockHeader2;
        }
    }

    private void printBuffer(ByteBuffer buf, int lenInInts) {
        IntBuffer ibuf = buf.asIntBuffer();
        lenInInts = lenInInts > ibuf.capacity() ? ibuf.capacity() : lenInInts;
        for (int i = 0; i < lenInInts; ++i) {
            System.out.println("  Buf(" + i + ") = 0x" + Integer.toHexString(ibuf.get(i)));
        }
    }

    public EvioReader(String path) throws EvioException, IOException {
        this(new File(path));
    }

    public EvioReader(String path, boolean checkBlkNumSeq) throws EvioException, IOException {
        this(new File(path), checkBlkNumSeq);
    }

    public EvioReader(File file) throws EvioException, IOException {
        this(file, false);
    }

    public EvioReader(File file, boolean checkBlkNumSeq) throws EvioException, IOException {
        this(file, checkBlkNumSeq, true);
    }

    public EvioReader(String path, boolean checkBlkNumSeq, boolean sequential) throws EvioException, IOException {
        this(new File(path), checkBlkNumSeq, sequential);
    }

    public EvioReader(File file, boolean checkBlkNumSeq, boolean sequential) throws EvioException, IOException {
        if (file == null) {
            throw new EvioException("File arg is null");
        }
        this.file = file;
        this.checkBlockNumberSequence = checkBlkNumSeq;
        this.sequentialRead = sequential;
        this.initialPosition = 0;
        FileInputStream fileInputStream = new FileInputStream(file);
        this.path = file.getAbsolutePath();
        this.fileChannel = fileInputStream.getChannel();
        this.fileSize = this.fileChannel.size();
        if (this.fileSize < 40L) {
            throw new EvioException("File too small to have valid evio data");
        }
        ByteBuffer headerBuf = ByteBuffer.allocate(32);
        for (int bytesRead = 0; bytesRead < 32; bytesRead += this.fileChannel.read(headerBuf)) {
        }
        this.parseFirstHeader(headerBuf);
        this.fileChannel.position(0L);
        this.parser = new EventParser();
        if (this.evioVersion < 4) {
            if (this.fileSize > Integer.MAX_VALUE) {
                this.sequentialRead = true;
            }
            if (this.sequentialRead) {
                this.dataStream = new DataInputStream(fileInputStream);
                this.prepareForSequentialRead();
            } else {
                this.byteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.fileSize);
                this.byteBuffer.order(this.byteOrder);
                this.prepareForBufferRead(this.byteBuffer);
            }
        } else if (this.sequentialRead) {
            EvioEvent dict;
            this.dataStream = new DataInputStream(fileInputStream);
            this.prepareForSequentialRead();
            if (this.blockHeader4.hasDictionary() && (dict = this.parseNextEvent()) != null) {
                String[] strs = dict.getStringData();
                this.dictionaryXML = strs[0];
            }
        } else {
            this.mappedMemoryHandler = new MappedMemoryHandler(this.fileChannel, this.byteOrder);
            if (this.blockHeader4.hasDictionary()) {
                ByteBuffer buf = this.mappedMemoryHandler.getFirstMap();
                this.prepareForBufferRead(buf);
                this.readDictionary(buf);
            }
        }
    }

    public EvioReader(ByteBuffer byteBuffer) throws EvioException {
        this(byteBuffer, false);
    }

    public EvioReader(ByteBuffer byteBuffer, boolean checkBlkNumSeq) throws EvioException {
        if (byteBuffer == null) {
            throw new EvioException("Buffer arg is null");
        }
        this.checkBlockNumberSequence = checkBlkNumSeq;
        this.byteBuffer = byteBuffer.slice();
        this.parseFirstHeader(byteBuffer);
        byteBuffer.position(0);
        if (this.evioVersion > 3) {
            this.mappedMemoryHandler = new MappedMemoryHandler(byteBuffer);
            if (this.blockHeader4.hasDictionary()) {
                ByteBuffer buf = this.mappedMemoryHandler.getFirstMap();
                this.prepareForBufferRead(buf);
                this.readDictionary(buf);
            }
        } else {
            byteBuffer.order(this.byteOrder);
            this.prepareForBufferRead(byteBuffer);
        }
        this.parser = new EventParser();
    }

    public synchronized void setBuffer(ByteBuffer buf) throws EvioException, IOException {
        if (buf == null) {
            throw new EvioException("arg is null");
        }
        this.close();
        this.lastBlock = false;
        this.eventNumber = 0;
        this.blockCount = -1;
        this.eventCount = -1;
        this.blockNumberExpected = 1;
        this.dictionaryXML = null;
        this.initialPosition = buf.position();
        this.byteBuffer = buf.slice();
        this.sequentialRead = false;
        this.parseFirstHeader(this.byteBuffer);
        this.byteBuffer.position(0);
        if (this.evioVersion > 3) {
            this.mappedMemoryHandler = new MappedMemoryHandler(this.byteBuffer);
            if (this.blockHeader4.hasDictionary()) {
                ByteBuffer bb = this.mappedMemoryHandler.getFirstMap();
                this.prepareForBufferRead(bb);
                this.readDictionary(bb);
            }
        } else {
            this.byteBuffer.order(this.byteOrder);
            this.prepareForBufferRead(this.byteBuffer);
        }
        this.closed = false;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public boolean checkBlockNumberSequence() {
        return this.checkBlockNumberSequence;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int getEvioVersion() {
        return this.evioVersion;
    }

    public String getPath() {
        return this.path;
    }

    public EventParser getParser() {
        return this.parser;
    }

    public void setParser(EventParser parser) {
        if (parser != null) {
            this.parser = parser;
        }
    }

    public String getDictionaryXML() {
        return this.dictionaryXML;
    }

    public boolean hasDictionaryXML() {
        return this.dictionaryXML != null;
    }

    public int getNumEventsRemaining() throws IOException, EvioException {
        return this.getEventCount() - this.eventNumber;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public long fileSize() {
        return this.fileSize;
    }

    public IBlockHeader getFirstBlockHeader() {
        return this.firstBlockHeader;
    }

    protected void parseFirstHeader(ByteBuffer headerBuf) throws EvioException {
        headerBuf.position(0);
        if (headerBuf.remaining() < 32) {
            throw new EvioException("buffer too small");
        }
        this.byteOrder = headerBuf.order();
        int magicNumber = headerBuf.getInt(28);
        if (magicNumber != -1059454720) {
            this.swap = true;
            this.byteOrder = this.byteOrder == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
            headerBuf.order(this.byteOrder);
            magicNumber = headerBuf.getInt(28);
            if (magicNumber != -1059454720) {
                System.out.println("ERROR reread magic # (" + magicNumber + ") & still not right");
                throw new EvioException("bad magic #");
            }
        }
        this.evioVersion = headerBuf.getInt(20) & 0xFF;
        if (this.evioVersion < 1) {
            throw new EvioException("bad version");
        }
        if (this.evioVersion >= 4) {
            this.blockHeader4.setBufferStartingPosition(0L);
            this.blockHeader4.setSize(headerBuf.getInt());
            this.blockHeader4.setNumber(headerBuf.getInt());
            this.blockHeader4.setHeaderLength(headerBuf.getInt());
            this.blockHeader4.setEventCount(headerBuf.getInt());
            this.blockHeader4.setReserved1(headerBuf.getInt());
            this.blockHeader4.parseToBitInfo(headerBuf.getInt());
            this.blockHeader4.setVersion(this.evioVersion);
            this.lastBlock = this.blockHeader4.getBitInfo(1);
            this.blockHeader4.setReserved2(headerBuf.getInt());
            this.blockHeader4.setMagicNumber(headerBuf.getInt());
            this.blockHeader4.setByteOrder(this.byteOrder);
            this.blockHeader = this.blockHeader4;
            this.firstBlockHeader = new BlockHeaderV4(this.blockHeader4);
            int headerLenDiff = this.blockHeader4.getHeaderLength() - 8;
            if (headerLenDiff < 0) {
                throw new EvioException("header size too small");
            }
        } else {
            this.blockHeader2.setBufferStartingPosition(0L);
            this.blockHeader2.setSize(headerBuf.getInt());
            this.blockHeader2.setNumber(headerBuf.getInt());
            this.blockHeader2.setHeaderLength(headerBuf.getInt());
            this.blockHeader2.setStart(headerBuf.getInt());
            this.blockHeader2.setEnd(headerBuf.getInt());
            headerBuf.getInt();
            this.blockHeader2.setVersion(this.evioVersion);
            this.blockHeader2.setReserved1(headerBuf.getInt());
            this.blockHeader2.setMagicNumber(headerBuf.getInt());
            this.blockHeader2.setByteOrder(this.byteOrder);
            this.blockHeader = this.blockHeader2;
            this.firstBlockHeader = new BlockHeaderV2(this.blockHeader2);
        }
        this.firstBlockSize = 4 * this.blockHeader.getSize();
        if (this.checkBlockNumberSequence) {
            if (this.blockHeader.getNumber() != this.blockNumberExpected) {
                System.out.println("block # out of sequence, got " + this.blockHeader.getNumber() + " expecting " + this.blockNumberExpected);
                throw new EvioException("bad block # sequence");
            }
            ++this.blockNumberExpected;
        }
    }

    private void prepareForSequentialRead() throws IOException {
        int bytesToRead;
        if (this.evioVersion > 3) {
            bytesToRead = 4 * this.firstBlockHeader.getSize();
        } else {
            long bytesLeftInFile = this.fileSize - this.fileChannel.position();
            int n = bytesToRead = 0xFA0000L < bytesLeftInFile ? 0xFA0000 : (int)bytesLeftInFile;
        }
        if (this.byteBuffer == null || this.byteBuffer.capacity() < bytesToRead) {
            this.byteBuffer = ByteBuffer.allocate(bytesToRead);
            this.byteBuffer.order(this.byteOrder);
        }
        this.byteBuffer.clear().limit(bytesToRead);
        this.fileChannel.read(this.byteBuffer);
        this.byteBuffer.flip();
        this.prepareForBufferRead(this.byteBuffer);
    }

    private void prepareForBufferRead(ByteBuffer buffer) {
        int pos = 32;
        buffer.position(pos);
        if (this.evioVersion < 4) {
            return;
        }
        int headerLenDiff = this.blockHeader4.getHeaderLength() - 8;
        if (headerLenDiff > 0) {
            for (int i = 0; i < headerLenDiff; ++i) {
                buffer.position(pos += 4);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ReadStatus processNextBlock() throws IOException {
        if (this.lastBlock) {
            return ReadStatus.END_OF_FILE;
        }
        try {
            if (this.sequentialRead) {
                if (this.evioVersion < 4) {
                    int bytesInBuf = this.bufferBytesRemaining();
                    if (bytesInBuf == 0) {
                        long bytesLeftInFile = this.fileSize - this.fileChannel.position();
                        if (bytesLeftInFile < 32L) {
                            return ReadStatus.END_OF_FILE;
                        }
                        int bytesToRead = 0xFA0000L < bytesLeftInFile ? 0xFA0000 : (int)bytesLeftInFile;
                        this.byteBuffer.position(0).limit(bytesToRead);
                        for (int bytesActuallyRead = this.fileChannel.read(this.byteBuffer); bytesActuallyRead < bytesToRead; bytesActuallyRead += this.fileChannel.read(this.byteBuffer)) {
                        }
                        this.byteBuffer.flip();
                        this.blockHeader.setBufferStartingPosition(0L);
                    } else {
                        if (bytesInBuf % 32768 != 0) throw new IOException("file contains non-integral # of 32768 byte blocks");
                        this.blockHeader.setBufferStartingPosition(this.byteBuffer.position());
                    }
                } else {
                    if (this.fileSize - this.fileChannel.position() < 4L) {
                        return ReadStatus.END_OF_FILE;
                    }
                    int blkSize = this.dataStream.readInt();
                    if (this.swap) {
                        blkSize = Integer.reverseBytes(blkSize);
                    }
                    int blkBytes = 4 * blkSize;
                    if (this.fileSize - this.fileChannel.position() < (long)(blkBytes - 4)) {
                        return ReadStatus.END_OF_FILE;
                    }
                    if (this.byteBuffer.capacity() >= blkBytes) {
                        this.byteBuffer.clear();
                        this.byteBuffer.limit(blkBytes);
                    } else {
                        this.byteBuffer = ByteBuffer.allocate(blkBytes + 10000);
                        this.byteBuffer.limit(blkBytes);
                        this.byteBuffer.order(this.byteOrder);
                    }
                    this.byteBuffer.putInt(blkSize);
                    for (int bytesActuallyRead = this.fileChannel.read(this.byteBuffer) + 4; bytesActuallyRead < blkBytes; bytesActuallyRead += this.fileChannel.read(this.byteBuffer)) {
                    }
                    this.byteBuffer.flip();
                    this.blockHeader.setBufferStartingPosition(0L);
                }
            } else {
                if (this.byteBuffer.remaining() < 32) {
                    this.byteBuffer.clear();
                    return ReadStatus.END_OF_FILE;
                }
                this.blockHeader.setBufferStartingPosition(this.byteBuffer.position());
            }
            if (this.evioVersion >= 4) {
                this.blockHeader4.setSize(this.byteBuffer.getInt());
                this.blockHeader4.setNumber(this.byteBuffer.getInt());
                this.blockHeader4.setHeaderLength(this.byteBuffer.getInt());
                this.blockHeader4.setEventCount(this.byteBuffer.getInt());
                this.blockHeader4.setReserved1(this.byteBuffer.getInt());
                this.blockHeader4.parseToBitInfo(this.byteBuffer.getInt());
                this.blockHeader4.setVersion(this.evioVersion);
                this.lastBlock = this.blockHeader4.getBitInfo(1);
                this.blockHeader4.setReserved2(this.byteBuffer.getInt());
                this.blockHeader4.setMagicNumber(this.byteBuffer.getInt());
                this.blockHeader = this.blockHeader4;
                int headerLenDiff = this.blockHeader4.getHeaderLength() - 8;
                if (headerLenDiff < 0) {
                    return ReadStatus.EVIO_EXCEPTION;
                }
                if (headerLenDiff > 0) {
                    for (int i = 0; i < headerLenDiff; ++i) {
                        this.byteBuffer.getInt();
                    }
                }
            } else {
                if (this.evioVersion >= 4) return ReadStatus.EVIO_EXCEPTION;
                this.blockHeader2.setSize(this.byteBuffer.getInt());
                this.blockHeader2.setNumber(this.byteBuffer.getInt());
                this.blockHeader2.setHeaderLength(this.byteBuffer.getInt());
                this.blockHeader2.setStart(this.byteBuffer.getInt());
                this.blockHeader2.setEnd(this.byteBuffer.getInt());
                this.byteBuffer.getInt();
                this.blockHeader2.setVersion(this.evioVersion);
                this.blockHeader2.setReserved1(this.byteBuffer.getInt());
                this.blockHeader2.setMagicNumber(this.byteBuffer.getInt());
                this.blockHeader = this.blockHeader2;
            }
            if (!this.checkBlockNumberSequence) return ReadStatus.SUCCESS;
            if (this.blockHeader.getNumber() != this.blockNumberExpected) {
                System.out.println("block # out of sequence, got " + this.blockHeader.getNumber() + " expecting " + this.blockNumberExpected);
                return ReadStatus.EVIO_EXCEPTION;
            }
            ++this.blockNumberExpected;
            return ReadStatus.SUCCESS;
        }
        catch (EvioException e) {
            e.printStackTrace();
            return ReadStatus.EVIO_EXCEPTION;
        }
        catch (BufferUnderflowException a) {
            System.err.println("ERROR endOfBuffer " + a);
            this.byteBuffer.clear();
            return ReadStatus.UNKNOWN_ERROR;
        }
    }

    private void readDictionary(ByteBuffer buffer) throws EvioException {
        if (this.evioVersion < 4) {
            throw new EvioException("Unsupported version (" + this.evioVersion + ")");
        }
        int bytesRemaining = buffer.remaining();
        if (bytesRemaining < 12) {
            throw new EvioException("Not enough data in buffer");
        }
        int length = buffer.getInt();
        if (length < 1) {
            throw new EvioException("Bad value for dictionary length");
        }
        bytesRemaining -= 4;
        buffer.getInt();
        int eventDataSizeBytes = 4 * (length - 1);
        if ((bytesRemaining -= 4) < eventDataSizeBytes) {
            throw new EvioException("Not enough data in buffer");
        }
        byte[] bytes = new byte[eventDataSizeBytes];
        try {
            buffer.get(bytes, 0, eventDataSizeBytes);
        }
        catch (Exception e) {
            throw new EvioException("Problems reading buffer");
        }
        String[] strs = BaseStructure.unpackRawBytesToStrings(bytes, 0);
        if (strs == null) {
            throw new EvioException("Data in bad format");
        }
        this.dictionaryXML = strs[0];
    }

    public EvioEvent getEvent(int index) throws IOException, EvioException {
        if (index < 1) {
            throw new EvioException("index arg starts at 1");
        }
        if (this.sequentialRead || this.evioVersion < 4) {
            return this.gotoEventNumber(index, false);
        }
        return this.getEventV4(index);
    }

    private synchronized EvioEvent getEventV4(int index) throws EvioException {
        ByteBuffer buf;
        int length;
        if (index > this.mappedMemoryHandler.getEventCount()) {
            return null;
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        EvioEvent event = new EvioEvent();
        BaseStructureHeader header = event.getHeader();
        int eventDataSizeBytes = 0;
        if ((length = (buf = this.mappedMemoryHandler.getByteBuffer(--index)).getInt()) < 1) {
            throw new EvioException("Bad file/buffer format");
        }
        header.setLength(length);
        int word = buf.getInt();
        header.setTag(word >>> 16);
        int dt = word >> 8 & 0xFF;
        int type = dt & 0x3F;
        int padding = dt >>> 6;
        header.setDataType(type);
        header.setPadding(padding);
        header.setNumber(word & 0xFF);
        event.setXmlNames();
        try {
            eventDataSizeBytes = 4 * (length - 1);
            byte[] bytes = new byte[eventDataSizeBytes];
            buf.get(bytes, 0, eventDataSizeBytes);
            event.setRawBytes(bytes);
            event.setByteOrder(this.byteOrder);
            event.setEventNumber(++this.eventNumber);
        }
        catch (OutOfMemoryError e) {
            throw new EvioException("Out Of Memory: (event size = " + eventDataSizeBytes + ")", e);
        }
        catch (Exception e) {
            throw new EvioException("Error", e);
        }
        return event;
    }

    public synchronized EvioEvent parseEvent(int index) throws IOException, EvioException {
        EvioEvent event = this.getEvent(index);
        if (event != null) {
            this.parseEvent(event);
        }
        return event;
    }

    public synchronized EvioEvent nextEvent() throws IOException, EvioException {
        if (!this.sequentialRead && this.evioVersion > 3) {
            return this.getEvent(this.eventNumber + 1);
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        EvioEvent event = new EvioEvent();
        BaseStructureHeader header = event.getHeader();
        long currentPosition = this.byteBuffer.position();
        int blockBytesRemaining = this.blockBytesRemaining();
        if (blockBytesRemaining < 0) {
            throw new EvioException("Number of block bytes remaining is negative.");
        }
        if (blockBytesRemaining == 0) {
            ReadStatus status = this.processNextBlock();
            if (status == ReadStatus.SUCCESS) {
                return this.nextEvent();
            }
            if (status == ReadStatus.END_OF_FILE) {
                return null;
            }
            throw new EvioException("Failed reading block header in nextEvent.");
        }
        if (this.blockHeader.getBufferEndingPosition() == currentPosition) {
            return null;
        }
        int length = this.byteBuffer.getInt();
        if (length < 1) {
            throw new EvioException("non-positive length (0x" + Integer.toHexString(length) + ")");
        }
        header.setLength(length);
        blockBytesRemaining -= 4;
        if (this.evioVersion < 4 && this.bufferBytesRemaining() == 0) {
            ReadStatus status = this.processNextBlock();
            if (status == ReadStatus.END_OF_FILE) {
                return null;
            }
            if (status != ReadStatus.SUCCESS) {
                throw new EvioException("Failed reading block header in nextEvent.");
            }
            blockBytesRemaining = this.blockBytesRemaining();
        }
        int word = this.byteBuffer.getInt();
        header.setTag(word >>> 16);
        int dt = word >> 8 & 0xFF;
        int type = dt & 0x3F;
        int padding = dt >>> 6;
        header.setDataType(type);
        header.setPadding(padding);
        header.setNumber(word & 0xFF);
        blockBytesRemaining -= 4;
        int eventDataSizeBytes = 4 * (length - 1);
        try {
            int bytesToGo;
            byte[] bytes = new byte[eventDataSizeBytes];
            int offset = 0;
            if (this.evioVersion < 4) {
                int bytesToReadNow;
                for (bytesToGo = eventDataSizeBytes; bytesToGo > 0; bytesToGo -= bytesToReadNow) {
                    bytesToReadNow = bytesToGo > blockBytesRemaining ? blockBytesRemaining : bytesToGo;
                    this.byteBuffer.get(bytes, offset, bytesToReadNow);
                    offset += bytesToReadNow;
                    if ((blockBytesRemaining -= bytesToReadNow) != 0) continue;
                    ReadStatus status = this.processNextBlock();
                    if (status == ReadStatus.END_OF_FILE) {
                        return null;
                    }
                    if (status != ReadStatus.SUCCESS) {
                        throw new EvioException("Failed reading block header after crossing boundary in nextEvent.");
                    }
                    blockBytesRemaining = this.blockBytesRemaining();
                }
            }
            this.byteBuffer.get(bytes, offset, bytesToGo);
            event.setRawBytes(bytes);
            event.setByteOrder(this.byteOrder);
            event.setEventNumber(++this.eventNumber);
            return event;
        }
        catch (OutOfMemoryError ome) {
            System.out.println("Out Of Memory\neventDataSizeBytes = " + eventDataSizeBytes + "\n" + "bytes Remaining = " + blockBytesRemaining + "\n" + "event Count: " + this.eventCount);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized EvioEvent parseNextEvent() throws IOException, EvioException {
        EvioEvent event = this.nextEvent();
        if (event != null) {
            this.parseEvent(event);
        }
        return event;
    }

    public void parseEvent(EvioEvent evioEvent) throws EvioException {
        this.parser.parseEvent(evioEvent);
    }

    public byte[] getEventArray(int eventNumber) throws EvioException, IOException {
        EvioEvent ev = this.gotoEventNumber(eventNumber, false);
        if (ev == null) {
            throw new EvioException("event number must be > 0");
        }
        return ev.toArray();
    }

    public ByteBuffer getEventBuffer(int eventNumber) throws EvioException, IOException {
        return ByteBuffer.wrap(this.getEventArray(eventNumber));
    }

    private int bufferBytesRemaining() {
        return this.byteBuffer.remaining();
    }

    private int blockBytesRemaining() {
        try {
            return this.blockHeader.bytesRemaining(this.byteBuffer.position());
        }
        catch (EvioException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public synchronized void rewind() throws IOException, EvioException {
        if (this.closed) {
            throw new EvioException("object closed");
        }
        if (this.sequentialRead) {
            this.fileChannel.position(this.initialPosition);
            this.prepareForSequentialRead();
        } else if (this.evioVersion < 4) {
            this.byteBuffer.position(this.initialPosition);
            this.prepareForBufferRead(this.byteBuffer);
        }
        this.lastBlock = false;
        this.eventNumber = 0;
        this.blockNumberExpected = 1;
        if (this.evioVersion < 4) {
            this.blockHeader2 = new BlockHeaderV2((BlockHeaderV2)this.firstBlockHeader);
            this.blockHeader = this.blockHeader2;
        } else {
            this.blockHeader4 = new BlockHeaderV4((BlockHeaderV4)this.firstBlockHeader);
            this.blockHeader = this.blockHeader4;
        }
        this.blockHeader.setBufferStartingPosition(this.initialPosition);
        if (this.sequentialRead && this.hasDictionaryXML()) {
            this.nextEvent();
        }
    }

    public synchronized long position() throws IOException, EvioException {
        if (!this.sequentialRead && this.evioVersion > 3) {
            return -1L;
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        if (this.sequentialRead) {
            return this.fileChannel.position();
        }
        return this.byteBuffer.position();
    }

    public synchronized void position(long position) throws IOException, EvioException {
        if (!this.sequentialRead && this.evioVersion > 3) {
            return;
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        if (this.sequentialRead) {
            this.fileChannel.position(position);
        } else {
            this.byteBuffer.position((int)position);
        }
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (!this.sequentialRead && this.evioVersion > 3) {
            if (this.byteBuffer != null) {
                this.byteBuffer.position(this.initialPosition);
            }
            this.mappedMemoryHandler = null;
            if (this.fileChannel != null) {
                this.fileChannel.close();
                this.fileChannel = null;
            }
            this.closed = true;
            return;
        }
        if (this.sequentialRead) {
            this.fileChannel.close();
            this.dataStream.close();
        } else {
            this.byteBuffer.position(this.initialPosition);
        }
        this.closed = true;
    }

    public IBlockHeader getCurrentBlockHeader() {
        return this.blockHeader;
    }

    public EvioEvent gotoEventNumber(int evNumber) throws IOException, EvioException {
        return this.gotoEventNumber(evNumber, true);
    }

    private synchronized EvioEvent gotoEventNumber(int evNumber, boolean parse) throws IOException, EvioException {
        if (evNumber < 1) {
            return null;
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        if (!this.sequentialRead && this.evioVersion > 3) {
            try {
                if (parse) {
                    return this.parseEvent(evNumber);
                }
                return this.getEvent(evNumber);
            }
            catch (EvioException e) {
                return null;
            }
        }
        this.rewind();
        try {
            for (int i = 1; i < evNumber; ++i) {
                EvioEvent event = this.nextEvent();
                if (event != null) continue;
                throw new EvioException("Asked to go to event: " + evNumber + ", which is beyond the end of file");
            }
            if (parse) {
                return this.parseNextEvent();
            }
            return this.nextEvent();
        }
        catch (EvioException e) {
            e.printStackTrace();
            return null;
        }
    }

    public WriteStatus toXMLFile(String path) throws IOException, EvioException {
        return this.toXMLFile(path, false);
    }

    public WriteStatus toXMLFile(String path, boolean hex) throws IOException, EvioException {
        return this.toXMLFile(path, null, hex);
    }

    public WriteStatus toXMLFile(String path, IEvioProgressListener progressListener) throws IOException, EvioException {
        return this.toXMLFile(path, progressListener, false);
    }

    public synchronized WriteStatus toXMLFile(String path, IEvioProgressListener progressListener, boolean hex) throws IOException, EvioException {
        FileOutputStream fos;
        if (this.closed) {
            throw new EvioException("object closed");
        }
        try {
            fos = new FileOutputStream(path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return WriteStatus.CANNOT_OPEN_FILE;
        }
        try {
            XMLStreamWriter xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(fos);
            xmlWriter.writeStartDocument();
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeComment("Event source file: " + path);
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeStartElement(ROOT_ELEMENT);
            xmlWriter.writeAttribute("numevents", "" + this.getEventCount());
            xmlWriter.writeCharacters("\n");
            ReaderState state = this.getState();
            this.rewind();
            try {
                EvioEvent event;
                while ((event = this.parseNextEvent()) != null) {
                    event.toXML(xmlWriter, hex);
                    if (progressListener == null) continue;
                    progressListener.completed(event.getEventNumber(), this.getEventCount());
                }
            }
            catch (EvioException e) {
                e.printStackTrace();
                return WriteStatus.UNKNOWN_ERROR;
            }
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
            xmlWriter.flush();
            xmlWriter.close();
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.restoreState(state);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            return WriteStatus.UNKNOWN_ERROR;
        }
        catch (FactoryConfigurationError e) {
            return WriteStatus.UNKNOWN_ERROR;
        }
        catch (EvioException e) {
            return WriteStatus.EVIO_EXCEPTION;
        }
        return WriteStatus.SUCCESS;
    }

    public synchronized int getEventCount() throws IOException, EvioException {
        if (this.closed) {
            throw new EvioException("object closed");
        }
        if (!this.sequentialRead && this.evioVersion > 3) {
            return this.mappedMemoryHandler.getEventCount();
        }
        if (this.eventCount < 0) {
            ReaderState state = this.getState();
            this.rewind();
            this.eventCount = 0;
            while (this.nextEvent() != null) {
                ++this.eventCount;
            }
            if (this.sequentialRead) {
                this.rewind();
                if (this.hasDictionaryXML()) {
                    this.nextEvent();
                }
                for (int i = 1; i < state.eventNumber; ++i) {
                    this.nextEvent();
                }
            }
            this.restoreState(state);
        }
        return this.eventCount;
    }

    public synchronized int getBlockCount() throws EvioException {
        if (this.closed) {
            throw new EvioException("object closed");
        }
        if (!this.sequentialRead && this.evioVersion > 3) {
            return this.mappedMemoryHandler.getBlockCount();
        }
        if (this.blockCount < 0) {
            this.blockCount = (int)(this.fileSize / (long)this.firstBlockSize);
        }
        return this.blockCount;
    }

    private static final class ReaderState {
        private boolean lastBlock;
        private int eventNumber;
        private long filePosition;
        private int byteBufferLimit;
        private int byteBufferPosition;
        private int blockNumberExpected;
        private BlockHeaderV2 blockHeader2;
        private BlockHeaderV4 blockHeader4;

        private ReaderState() {
        }
    }

    public static enum WriteStatus {
        SUCCESS,
        CANNOT_OPEN_FILE,
        EVIO_EXCEPTION,
        UNKNOWN_ERROR;

    }

    public static enum ReadStatus {
        SUCCESS,
        END_OF_FILE,
        EVIO_EXCEPTION,
        UNKNOWN_ERROR;

    }
}

