/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.jlab.coda.jevio.BlockNode;
import org.jlab.coda.jevio.BufferNode;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioException;

public class EvioNode
implements Cloneable {
    int len;
    int tag;
    int num;
    int pad;
    int pos;
    int type;
    int dataLen;
    int dataPos;
    int dataType;
    int[] data;
    boolean isEvent;
    boolean obsolete;
    public BlockNode blockNode;
    BufferNode bufferNode;
    ArrayList<EvioNode> childNodes;
    int place;
    boolean scanned;
    ArrayList<EvioNode> allNodes;
    EvioNode eventNode;
    EvioNode parentNode;

    public EvioNode() {
        this.allNodes = new ArrayList(5);
        this.allNodes.add(this);
    }

    EvioNode(EvioNode firstNode) {
        this.allNodes = new ArrayList(5);
        this.allNodes.add(this);
        this.scanned = true;
        this.eventNode = firstNode;
    }

    public EvioNode(int pos, int place, BufferNode bufferNode, BlockNode blockNode) {
        this.pos = pos;
        this.place = place;
        this.blockNode = blockNode;
        this.bufferNode = bufferNode;
        this.isEvent = true;
        this.type = DataType.BANK.getValue();
        this.allNodes = new ArrayList(5);
        this.allNodes.add(this);
    }

    EvioNode(int tag, int num, int pos, int dataPos, DataType type, DataType dataType, BufferNode bufferNode) {
        this.tag = tag;
        this.num = num;
        this.pos = pos;
        this.dataPos = dataPos;
        this.type = type.getValue();
        this.dataType = dataType.getValue();
        this.bufferNode = bufferNode;
    }

    public final Object clone() {
        try {
            EvioNode result = (EvioNode)super.clone();
            result.childNodes = null;
            result.data = null;
            return result;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder(100);
        builder.append("tag = ");
        builder.append(this.tag);
        builder.append(", num = ");
        builder.append(this.num);
        builder.append(", type = ");
        builder.append((Object)this.getTypeObj());
        builder.append(", dataType = ");
        builder.append((Object)this.getDataTypeObj());
        builder.append(", pos = ");
        builder.append(this.pos);
        builder.append(", dataPos = ");
        builder.append(this.dataPos);
        builder.append(", len = ");
        builder.append(this.len);
        builder.append(", dataLen = ");
        builder.append(this.dataLen);
        return builder.toString();
    }

    public final void clearLists() {
        if (this.childNodes != null) {
            this.childNodes.clear();
        }
        if (this.allNodes != null) {
            this.allNodes.clear();
            if (this.eventNode == null) {
                this.allNodes.add(this);
            } else {
                this.allNodes.add(this.eventNode);
            }
        }
    }

    public final void clear() {
        if (this.allNodes != null) {
            this.allNodes.clear();
        }
        this.place = 0;
        this.dataType = 0;
        this.dataPos = 0;
        this.dataLen = 0;
        this.type = 0;
        this.pos = 0;
        this.pad = 0;
        this.num = 0;
        this.tag = 0;
        this.len = 0;
        this.clearObjects();
    }

    public final void clearObjects() {
        if (this.childNodes != null) {
            this.childNodes.clear();
        }
        this.scanned = false;
        this.obsolete = false;
        this.isEvent = false;
        this.blockNode = null;
        this.bufferNode = null;
        this.eventNode = null;
        this.parentNode = null;
    }

    public final void clearAll() {
        this.allNodes = null;
        this.clearObjects();
    }

    public final void clearIntArray() {
        if (this.data != null) {
            this.data = null;
        }
    }

    public static final EvioNode extractEventNode(BufferNode bufferNode, BlockNode blockNode, int position, int place) throws EvioException {
        ByteBuffer buffer = bufferNode.buffer;
        if (buffer.remaining() < 8) {
            throw new EvioException("buffer underflow");
        }
        EvioNode node = new EvioNode(position, place, bufferNode, blockNode);
        return EvioNode.extractNode(node, position);
    }

    public static final EvioNode extractNode(EvioNode bankNode, int position) throws EvioException {
        int len;
        ByteBuffer buffer = bankNode.bufferNode.buffer;
        if (buffer.remaining() < 8) {
            throw new EvioException("buffer underflow");
        }
        bankNode.len = len = buffer.getInt(position);
        bankNode.pos = position;
        bankNode.type = DataType.BANK.getValue();
        bankNode.dataPos = position + 8;
        bankNode.dataLen = len - 1;
        if (buffer.remaining() < 4 * (len + 1)) {
            throw new EvioException("buffer underflow");
        }
        int word = buffer.getInt(position += 4);
        bankNode.tag = word >>> 16;
        int dt = word >> 8 & 0xFF;
        bankNode.dataType = dt & 0x3F;
        bankNode.pad = dt >>> 6;
        bankNode.num = word & 0xFF;
        return bankNode;
    }

    static final void scanStructure(EvioNode node) {
        int position;
        int dType = node.dataType;
        if (!DataType.isStructure(dType)) {
            return;
        }
        int endingPos = position + 4 * node.dataLen;
        ByteBuffer buffer = node.bufferNode.buffer;
        if (DataType.isBank(dType)) {
            int dataLen;
            endingPos -= 8;
            for (position = node.dataPos; position <= endingPos; position += 4 * dataLen) {
                EvioNode kidNode = (EvioNode)node.clone();
                int len = buffer.getInt(position);
                kidNode.pos = position;
                dataLen = len - 1;
                int word = buffer.getInt(position += 4);
                position += 4;
                kidNode.tag = word >>> 16;
                int dt = word >> 8 & 0xFF;
                int dataType = dt & 0x3F;
                kidNode.pad = dt >>> 6;
                kidNode.num = word & 0xFF;
                kidNode.len = len;
                kidNode.type = DataType.BANK.getValue();
                kidNode.dataLen = dataLen;
                kidNode.dataPos = position;
                kidNode.dataType = dataType;
                kidNode.isEvent = false;
                kidNode.parentNode = node;
                node.addChild(kidNode);
                if (!DataType.isStructure(dataType)) continue;
                EvioNode.scanStructure(kidNode);
            }
        } else if (DataType.isSegment(dType)) {
            endingPos -= 4;
            while (position <= endingPos) {
                EvioNode kidNode = (EvioNode)node.clone();
                kidNode.pos = position;
                int word = buffer.getInt(position);
                position += 4;
                kidNode.tag = word >>> 24;
                int dt = word >>> 16 & 0xFF;
                int dataType = dt & 0x3F;
                kidNode.pad = dt >>> 6;
                int len = word & 0xFFFF;
                kidNode.num = 0;
                kidNode.len = len;
                kidNode.type = DataType.SEGMENT.getValue();
                kidNode.dataLen = len;
                kidNode.dataPos = position;
                kidNode.dataType = dataType;
                kidNode.isEvent = false;
                kidNode.parentNode = node;
                node.addChild(kidNode);
                if (DataType.isStructure(dataType)) {
                    EvioNode.scanStructure(kidNode);
                }
                position += 4 * len;
            }
        } else {
            endingPos -= 4;
            while (position <= endingPos) {
                EvioNode kidNode = (EvioNode)node.clone();
                kidNode.pos = position;
                int word = buffer.getInt(position);
                position += 4;
                kidNode.tag = word >>> 20;
                int dataType = word >>> 16 & 0xF;
                int len = word & 0xFFFF;
                kidNode.pad = 0;
                kidNode.num = 0;
                kidNode.len = len;
                kidNode.type = DataType.TAGSEGMENT.getValue();
                kidNode.dataLen = len;
                kidNode.dataPos = position;
                kidNode.dataType = dataType;
                kidNode.isEvent = false;
                kidNode.parentNode = node;
                node.addChild(kidNode);
                if (DataType.isStructure(dataType)) {
                    EvioNode.scanStructure(kidNode);
                }
                position += 4 * len;
            }
        }
    }

    private final void addToAllNodes(EvioNode node) {
        if (this.allNodes == null || node == null) {
            return;
        }
        this.allNodes.add(node);
    }

    private final void removeFromAllNodes(EvioNode node) {
        if (this.allNodes == null || node == null) {
            return;
        }
        this.allNodes.remove(node);
        if (node.childNodes != null) {
            for (EvioNode n : node.childNodes) {
                this.removeFromAllNodes(n);
            }
        }
    }

    final void addChild(EvioNode node) {
        if (node == null) {
            return;
        }
        if (this.childNodes == null) {
            this.childNodes = new ArrayList(5);
        }
        this.childNodes.add(node);
        if (this.allNodes != null) {
            this.allNodes.add(node);
        }
    }

    final void removeChild(EvioNode node) {
        if (node == null) {
            return;
        }
        boolean isChild = false;
        if (this.childNodes != null) {
            isChild = this.childNodes.remove(node);
        }
        if (isChild) {
            this.removeFromAllNodes(node);
        }
    }

    final BlockNode getBlockNode() {
        return this.blockNode;
    }

    public final boolean isObsolete() {
        return this.obsolete;
    }

    final void setObsolete(boolean obsolete) {
        this.obsolete = obsolete;
        if (this.childNodes != null) {
            for (EvioNode n : this.childNodes) {
                n.setObsolete(obsolete);
            }
        }
    }

    public final ArrayList<EvioNode> getAllNodes() {
        return this.allNodes;
    }

    public final ArrayList<EvioNode> getChildNodes() {
        return this.childNodes;
    }

    public final void getAllDescendants(List<EvioNode> descendants) {
        if (this.childNodes == null || descendants == null) {
            return;
        }
        for (EvioNode n : this.childNodes) {
            descendants.add(n);
            n.getAllDescendants(descendants);
        }
    }

    public final EvioNode getChildAt(int index) {
        if (this.childNodes == null || this.childNodes.size() < index + 1) {
            return null;
        }
        return this.childNodes.get(index);
    }

    public final int getChildCount() {
        if (this.childNodes == null) {
            return 0;
        }
        return this.childNodes.size();
    }

    public final BufferNode getBufferNode() {
        return this.bufferNode;
    }

    public final int getLength() {
        return this.len;
    }

    public final int getTotalBytes() {
        return 4 * this.dataLen + this.dataPos - this.pos;
    }

    public final int getTag() {
        return this.tag;
    }

    public final int getNum() {
        return this.num;
    }

    public final int getPad() {
        return this.pad;
    }

    public final int getPosition() {
        return this.pos;
    }

    public final int getType() {
        return this.type;
    }

    public final DataType getTypeObj() {
        return DataType.getDataType(this.type);
    }

    public final int getDataLength() {
        return this.dataLen;
    }

    public final int getDataPosition() {
        return this.dataPos;
    }

    public final int getDataType() {
        return this.dataType;
    }

    public final DataType getDataTypeObj() {
        return DataType.getDataType(this.dataType);
    }

    public final int getEventNumber() {
        return this.place + 1;
    }

    public final boolean isEvent() {
        return this.isEvent;
    }

    public final void updateTag(int newTag) {
        ByteBuffer buffer = this.bufferNode.buffer;
        switch (DataType.getDataType(this.type)) {
            case BANK: 
            case ALSOBANK: {
                if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                    buffer.putShort(this.pos + 4, (short)newTag);
                } else {
                    buffer.putShort(this.pos + 6, (short)newTag);
                }
                return;
            }
            case SEGMENT: 
            case ALSOSEGMENT: {
                if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                    buffer.put(this.pos, (byte)newTag);
                } else {
                    buffer.put(this.pos + 3, (byte)newTag);
                }
                return;
            }
            case TAGSEGMENT: {
                short compositeWord = (short)(this.tag << 4 | this.dataType & 0xF);
                if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                    buffer.putShort(this.pos, compositeWord);
                } else {
                    buffer.putShort(this.pos + 2, compositeWord);
                }
                return;
            }
        }
    }

    public final void updateNum(int newNum) {
        ByteBuffer buffer = this.bufferNode.buffer;
        switch (DataType.getDataType(this.type)) {
            case BANK: 
            case ALSOBANK: {
                if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                    buffer.put(this.pos + 7, (byte)newNum);
                } else {
                    buffer.put(this.pos + 4, (byte)newNum);
                }
                return;
            }
        }
    }

    public final ByteBuffer getByteData(boolean copy) {
        ByteOrder order = this.bufferNode.buffer.order();
        ByteBuffer buffer = this.bufferNode.buffer.duplicate().order(order);
        buffer.limit(this.dataPos + 4 * this.dataLen - this.pad).position(this.dataPos);
        if (copy) {
            ByteBuffer newBuf = ByteBuffer.allocate(4 * this.dataLen - this.pad).order(order);
            newBuf.put(buffer);
            newBuf.flip();
            return newBuf;
        }
        return buffer;
    }

    public final int[] getIntData() {
        if (this.data != null) {
            return this.data;
        }
        this.data = new int[this.dataLen];
        ByteBuffer buf = this.bufferNode.buffer;
        for (int i = this.dataPos; i < this.dataPos + 4 * this.dataLen; i += 4) {
            this.data[(i - this.dataPos) / 4] = buf.getInt(i);
        }
        return this.data;
    }

    public final long[] getLongData() {
        int effectiveLen = this.dataLen / 2 * 2;
        long[] data = new long[effectiveLen / 2];
        ByteBuffer buf = this.bufferNode.buffer;
        for (int i = this.dataPos; i < this.dataPos + 4 * effectiveLen; i += 8) {
            data[(i - this.dataPos) / 8] = buf.getLong(i);
        }
        return data;
    }

    public final short[] getShortData() {
        short[] data = new short[2 * this.dataLen];
        ByteBuffer buf = this.bufferNode.buffer;
        for (int i = this.dataPos; i < this.dataPos + 4 * this.dataLen; i += 2) {
            data[(i - this.dataPos) / 2] = buf.getShort(i);
        }
        return data;
    }

    public final ByteBuffer getStructureBuffer(boolean copy) {
        ByteOrder order = this.bufferNode.buffer.order();
        ByteBuffer buffer = this.bufferNode.buffer.duplicate().order(order);
        buffer.limit(this.dataPos + 4 * this.dataLen).position(this.pos);
        if (copy) {
            ByteBuffer newBuf = ByteBuffer.allocate(this.getTotalBytes()).order(order);
            newBuf.put(buffer);
            newBuf.flip();
            return newBuf;
        }
        return buffer;
    }
}

