/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioDictionaryEntryType;

public class EvioDictionaryEntry {
    private final Integer tag;
    private final Integer tagEnd;
    private final Integer num;
    private DataType type;
    private final String format;
    private final String description;
    private final EvioDictionaryEntryType entryType;
    private EvioDictionaryEntry parentEntry;

    EvioDictionaryEntry(Integer tag) {
        this(tag, null, null, null, null);
    }

    public EvioDictionaryEntry(Integer tag, Integer num) {
        this(tag, num, null, null, null);
    }

    EvioDictionaryEntry(Integer tag, Integer num, String type) {
        this(tag, num, type, null, null);
    }

    public EvioDictionaryEntry(Integer tag, Integer num, Integer tagEnd, String type) {
        this(tag, num, tagEnd, type, null, null);
    }

    EvioDictionaryEntry(Integer tag, Integer num, String type, String description, String format) {
        this(tag, num, 0, type, description, format);
    }

    public EvioDictionaryEntry(Integer tag, Integer num, Integer tagEnd, String type, String description, String format) {
        this(tag, num, tagEnd, type, description, format, null);
    }

    public EvioDictionaryEntry(Integer tag, Integer num, Integer tagEnd, String type, String description, String format, EvioDictionaryEntry parentEntry) {
        boolean isRange = true;
        if (tagEnd == null || tagEnd.equals(tag) || tagEnd <= 0) {
            this.tag = tag;
            this.tagEnd = 0;
            isRange = false;
        } else if (tagEnd < tag) {
            this.tag = tagEnd;
            this.tagEnd = tag;
        } else {
            this.tag = tag;
            this.tagEnd = tagEnd;
        }
        this.num = num;
        this.format = format;
        this.description = description;
        if (type != null) {
            try {
                this.type = DataType.valueOf(type.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        this.entryType = !isRange ? (num != null ? EvioDictionaryEntryType.TAG_NUM : EvioDictionaryEntryType.TAG_ONLY) : EvioDictionaryEntryType.TAG_RANGE;
        this.parentEntry = parentEntry;
    }

    public boolean inRange(int tagArg) {
        return this.tagEnd != 0 && tagArg >= this.tag && tagArg <= this.tagEnd;
    }

    public boolean inRange(EvioDictionaryEntry entry) {
        return entry != null && this.tagEnd != 0 && entry.tag >= this.tag && entry.tag <= this.tagEnd;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.tag;
        hash = hash * 31 + this.tagEnd;
        if (this.num != null) {
            hash = hash * 31 + this.num;
        }
        return hash;
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        EvioDictionaryEntry otherEntry = (EvioDictionaryEntry)other;
        EvioDictionaryEntry otherParent = otherEntry.getParentEntry();
        boolean match = this.tag.equals(otherEntry.tag);
        if (this.num == null) {
            if (otherEntry.num != null) {
                return false;
            }
        } else {
            match = match && this.num.equals(otherEntry.num);
        }
        match = match && this.tagEnd.equals(otherEntry.tagEnd);
        boolean bl = match = match && this.entryType.equals((Object)otherEntry.entryType);
        if (this.parentEntry != null && otherParent != null) {
            Integer pNum = this.parentEntry.getNum();
            boolean bl2 = match = match && this.parentEntry.getTag().equals(otherParent.getTag());
            if (pNum == null) {
                if (otherParent.getNum() != null) {
                    return false;
                }
            } else {
                match = match && pNum.equals(otherParent.getNum());
            }
            match = match && this.parentEntry.getTagEnd().equals(otherParent.getTagEnd());
        }
        return match;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder(60);
        switch (this.entryType) {
            case TAG_NUM: {
                builder.append("(tag=");
                builder.append(this.tag);
                builder.append(",num =");
                builder.append(this.num);
                builder.append(")");
                break;
            }
            case TAG_ONLY: {
                builder.append("(tag=");
                builder.append(this.tag);
                builder.append(")");
                break;
            }
            case TAG_RANGE: {
                builder.append("(tag=");
                builder.append(this.tag);
                builder.append("-");
                builder.append(this.tagEnd);
                builder.append(")");
            }
        }
        return builder.toString();
    }

    public final Integer getTag() {
        return this.tag;
    }

    public final Integer getTagEnd() {
        return this.tagEnd;
    }

    public final Integer getNum() {
        return this.num;
    }

    public final DataType getType() {
        return this.type;
    }

    public final String getFormat() {
        return this.format;
    }

    public final String getDescription() {
        return this.description;
    }

    public EvioDictionaryEntryType getEntryType() {
        return this.entryType;
    }

    public EvioDictionaryEntry getParentEntry() {
        return this.parentEntry;
    }
}

