/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.util.List;
import org.jlab.coda.jevio.EvioCompactReaderUnsyncV4;
import org.jlab.coda.jevio.EvioCompactReaderV4;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.EvioXMLDictionary;
import org.jlab.coda.jevio.IBlockHeader;
import org.jlab.coda.jevio.IEvioCompactReader;

public class EvioCompactReader
implements IEvioCompactReader {
    private int evioVersion;
    private ByteOrder byteOrder;
    private final ByteBuffer byteBuffer;
    private final int initialPosition;
    private final IEvioCompactReader reader;

    public EvioCompactReader(String path) throws EvioException, IOException {
        this(new File(path));
    }

    public EvioCompactReader(File file) throws EvioException, IOException {
        if (file == null) {
            throw new EvioException("File arg is null");
        }
        this.initialPosition = 0;
        RandomAccessFile rFile = new RandomAccessFile(file, "r");
        this.byteBuffer = ByteBuffer.wrap(new byte[32]);
        rFile.read(this.byteBuffer.array());
        if (this.findEvioVersion() != IEvioCompactReader.ReadStatus.SUCCESS) {
            throw new EvioException("Failed reading first block header");
        }
        rFile.close();
        if (this.evioVersion < 4) {
            throw new EvioException("unsupported evio version (" + this.evioVersion + "), only 4+");
        }
        if (this.evioVersion == 4) {
            this.reader = new EvioCompactReaderV4(file);
        } else if (this.evioVersion == 6) {
            this.reader = new EvioCompactReaderV4(file);
        } else {
            throw new EvioException("unsupported evio version (" + this.evioVersion + ")");
        }
    }

    public EvioCompactReader(ByteBuffer byteBuffer) throws EvioException {
        this(byteBuffer, true);
    }

    public EvioCompactReader(ByteBuffer byteBuffer, boolean synced) throws EvioException {
        if (byteBuffer == null) {
            throw new EvioException("Buffer arg is null");
        }
        this.initialPosition = byteBuffer.position();
        this.byteBuffer = byteBuffer;
        if (this.findEvioVersion() != IEvioCompactReader.ReadStatus.SUCCESS) {
            throw new EvioException("Failed reading first block header");
        }
        if (this.evioVersion < 4) {
            throw new EvioException("unsupported evio version (" + this.evioVersion + "), only 4+");
        }
        if (this.evioVersion == 4) {
            this.reader = synced ? new EvioCompactReaderV4(byteBuffer) : new EvioCompactReaderUnsyncV4(byteBuffer);
        } else if (this.evioVersion == 6) {
            this.reader = synced ? new EvioCompactReaderV4(byteBuffer) : new EvioCompactReaderUnsyncV4(byteBuffer);
        } else {
            throw new EvioException("unsupported evio version (" + this.evioVersion + ")");
        }
    }

    private IEvioCompactReader.ReadStatus findEvioVersion() {
        if (this.byteBuffer.limit() - this.initialPosition < 32) {
            return IEvioCompactReader.ReadStatus.END_OF_FILE;
        }
        try {
            this.byteOrder = this.byteBuffer.order();
            int magicNumber = this.byteBuffer.getInt(this.initialPosition + 28);
            if (magicNumber != -1059454720) {
                this.byteOrder = this.byteOrder == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                this.byteBuffer.order(this.byteOrder);
                magicNumber = this.byteBuffer.getInt(this.initialPosition + 28);
                if (magicNumber != -1059454720) {
                    return IEvioCompactReader.ReadStatus.EVIO_EXCEPTION;
                }
            }
            int bitInfo = this.byteBuffer.getInt(this.initialPosition + 20);
            this.evioVersion = bitInfo & 0xFF;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        return IEvioCompactReader.ReadStatus.SUCCESS;
    }

    @Override
    public boolean isFile() {
        return this.reader.isFile();
    }

    @Override
    public void setBuffer(ByteBuffer buf) throws EvioException {
        this.reader.setBuffer(buf);
    }

    @Override
    public synchronized boolean isClosed() {
        return this.reader.isClosed();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.reader.getByteOrder();
    }

    @Override
    public int getEvioVersion() {
        return this.evioVersion;
    }

    @Override
    public String getPath() {
        return this.reader.getPath();
    }

    @Override
    public ByteOrder getFileByteOrder() {
        return this.reader.getFileByteOrder();
    }

    @Override
    public synchronized String getDictionaryXML() throws EvioException {
        return this.reader.getDictionaryXML();
    }

    @Override
    public synchronized EvioXMLDictionary getDictionary() throws EvioException {
        return this.reader.getDictionary();
    }

    @Override
    public boolean hasDictionary() {
        return this.reader.hasDictionary();
    }

    @Override
    public MappedByteBuffer getMappedByteBuffer() {
        return this.reader.getMappedByteBuffer();
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.reader.getByteBuffer();
    }

    @Override
    public long fileSize() {
        return this.reader.fileSize();
    }

    @Override
    public EvioNode getEvent(int eventNumber) {
        return this.reader.getEvent(eventNumber);
    }

    @Override
    public EvioNode getScannedEvent(int eventNumber) {
        return this.reader.getScannedEvent(eventNumber);
    }

    @Override
    public IBlockHeader getFirstBlockHeader() {
        return this.reader.getFirstBlockHeader();
    }

    @Override
    public synchronized List<EvioNode> searchEvent(int eventNumber, int tag, int num) throws EvioException {
        return this.reader.searchEvent(eventNumber, tag, num);
    }

    @Override
    public synchronized List<EvioNode> searchEvent(int eventNumber, String dictName, EvioXMLDictionary dictionary) throws EvioException {
        return this.reader.searchEvent(eventNumber, dictName, dictionary);
    }

    @Override
    public synchronized ByteBuffer removeEvent(int eventNumber) throws EvioException {
        return this.reader.removeEvent(eventNumber);
    }

    @Override
    public synchronized ByteBuffer removeStructure(EvioNode removeNode) throws EvioException {
        return this.reader.removeStructure(removeNode);
    }

    @Override
    public synchronized ByteBuffer addStructure(int eventNumber, ByteBuffer addBuffer) throws EvioException {
        return this.reader.addStructure(eventNumber, addBuffer);
    }

    @Override
    public ByteBuffer getData(EvioNode node) throws EvioException {
        return this.reader.getData(node);
    }

    @Override
    public synchronized ByteBuffer getData(EvioNode node, boolean copy) throws EvioException {
        return this.reader.getData(node, copy);
    }

    @Override
    public ByteBuffer getEventBuffer(int eventNumber) throws EvioException {
        return this.reader.getEventBuffer(eventNumber);
    }

    @Override
    public synchronized ByteBuffer getEventBuffer(int eventNumber, boolean copy) throws EvioException {
        return this.reader.getEventBuffer(eventNumber, copy);
    }

    @Override
    public ByteBuffer getStructureBuffer(EvioNode node) throws EvioException {
        return this.reader.getStructureBuffer(node);
    }

    @Override
    public synchronized ByteBuffer getStructureBuffer(EvioNode node, boolean copy) throws EvioException {
        return this.reader.getStructureBuffer(node, copy);
    }

    @Override
    public synchronized void close() {
        this.reader.close();
    }

    @Override
    public int getEventCount() {
        return this.reader.getEventCount();
    }

    @Override
    public int getBlockCount() {
        return this.reader.getBlockCount();
    }

    @Override
    public void toFile(String fileName) throws EvioException, IOException {
        this.reader.toFile(fileName);
    }

    @Override
    public synchronized void toFile(File file) throws EvioException, IOException {
        this.reader.toFile(file);
    }
}

