/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class EvioByteArrayOutputStream
extends OutputStream {
    byte[] buf;
    ByteBuffer byteBuf;
    int count;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public EvioByteArrayOutputStream(int size) {
        this.buf = new byte[size];
        this.byteBuf = ByteBuffer.wrap(this.buf);
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buf.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = EvioByteArrayOutputStream.hugeCapacity(minCapacity);
        }
        this.buf = Arrays.copyOf(this.buf, newCapacity);
        this.byteBuf = ByteBuffer.wrap(this.buf);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    @Override
    public void write(int b) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.ensureCapacity(this.count + len);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
        this.byteBuf.limit(this.count);
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public void reset() {
        this.count = 0;
        this.byteBuf.clear();
    }

    public byte[] getByteArray() {
        return this.buf;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuf;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    public int size() {
        return this.count;
    }

    @Override
    public void close() throws IOException {
    }
}

