/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.hipo;

import java.nio.ByteOrder;
import org.jlab.coda.hipo.RecordRingItem;
import org.jlab.coda.hipo.RecordSupply;

public class RecordSupplyTester {
    RecordSupply supply;
    int compressThreadCount = 1;
    ByteOrder order = ByteOrder.LITTLE_ENDIAN;

    RecordSupplyTester(int threadCount) {
        this.supply = new RecordSupply(8, this.order, threadCount, 0, 0, 1);
        this.compressThreadCount = threadCount;
        Writerr writer = new Writerr();
        writer.start();
        for (int i = 0; i < threadCount; ++i) {
            System.out.println("Starting compressor #" + (i + 1));
            Compressor comp = new Compressor(i);
            comp.start();
        }
        Producer producer = new Producer();
        producer.start();
    }

    public static void main(String[] args) {
        RecordSupplyTester tester = new RecordSupplyTester(8);
    }

    class Writerr
    extends Thread {
        Writerr() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    RecordRingItem item = RecordSupplyTester.this.supply.getToWrite();
                    RecordSupplyTester.this.supply.releaseWriter(item);
                    System.out.print(".");
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    class Compressor
    extends Thread {
        int num;

        Compressor(int threadNumber) {
            this.num = threadNumber;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    RecordRingItem item = RecordSupplyTester.this.supply.getToCompress(this.num);
                    Thread.sleep(3000L);
                    RecordSupplyTester.this.supply.releaseCompressor(item);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    class Producer
    extends Thread {
        Producer() {
        }

        @Override
        public void run() {
            while (true) {
                RecordRingItem item = RecordSupplyTester.this.supply.get();
                RecordSupplyTester.this.supply.publish(item);
            }
        }
    }
}

