/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.hipo;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.coda.hipo.Compressor;
import org.jlab.coda.hipo.HipoException;
import org.jlab.coda.hipo.RecordHeader;
import org.jlab.coda.jevio.EvioBank;

public class RecordOutputStream {
    private static final int ONE_MEG = 0x100000;
    private int MAX_EVENT_COUNT = 0x100000;
    private int MAX_BUFFER_SIZE = 0x800000;
    private int RECORD_BUFFER_SIZE = 0x900000;
    private ByteBuffer recordIndex;
    private ByteBuffer recordEvents;
    private ByteBuffer recordData;
    private ByteBuffer recordBinary;
    private Compressor dataCompressor = Compressor.getInstance();
    private RecordHeader header = new RecordHeader();
    private int eventCount;
    private int indexSize;
    private int eventSize;
    private ByteOrder byteOrder;

    public RecordOutputStream() {
        this.header.setCompressionType(1);
        this.byteOrder = ByteOrder.LITTLE_ENDIAN;
        this.allocate();
    }

    public RecordOutputStream(ByteOrder order, int maxEventCount, int maxBufferSize, int compressionType) {
        this.header.setCompressionType(compressionType);
        this.byteOrder = order;
        if (maxEventCount > 0) {
            this.MAX_EVENT_COUNT = maxEventCount;
        }
        if (maxBufferSize > this.MAX_BUFFER_SIZE) {
            this.MAX_BUFFER_SIZE = maxBufferSize;
            this.RECORD_BUFFER_SIZE = maxBufferSize + 0x100000;
        }
        this.allocate();
    }

    public void copy(RecordOutputStream rec) {
        if (rec == null) {
            return;
        }
        this.eventCount = rec.eventCount;
        this.indexSize = rec.indexSize;
        this.eventSize = rec.eventSize;
        this.byteOrder = rec.byteOrder;
        this.header.copy(rec.header);
        if (rec.MAX_BUFFER_SIZE > this.MAX_BUFFER_SIZE) {
            this.MAX_BUFFER_SIZE = rec.MAX_BUFFER_SIZE;
            this.RECORD_BUFFER_SIZE = rec.RECORD_BUFFER_SIZE;
            this.allocate();
        }
        System.arraycopy(rec.recordIndex.array(), 0, this.recordIndex.array(), 0, this.indexSize);
        System.arraycopy(rec.recordEvents.array(), 0, this.recordEvents.array(), 0, this.eventSize);
        if (rec.recordBinary.hasArray() && this.recordBinary.hasArray()) {
            System.arraycopy(rec.recordBinary.array(), 0, this.recordBinary.array(), 0, rec.recordBinary.limit());
            this.recordBinary.position(0).limit(rec.recordBinary.limit());
        } else {
            this.recordBinary.position(0);
            this.recordBinary.put(rec.recordBinary);
            this.recordBinary.flip();
            rec.recordBinary.flip();
        }
    }

    public int getUncompressedSize() {
        return this.eventSize + this.indexSize + 56;
    }

    public int getInternalBufferCapacity() {
        return this.MAX_BUFFER_SIZE;
    }

    public RecordHeader getHeader() {
        return this.header;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public ByteBuffer getBinaryBuffer() {
        return this.recordBinary;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    void setByteOrder(ByteOrder order) {
        this.byteOrder = order;
    }

    private void allocate() {
        this.recordIndex = ByteBuffer.wrap(new byte[this.MAX_EVENT_COUNT * 4]);
        this.recordIndex.order(this.byteOrder);
        this.recordEvents = ByteBuffer.wrap(new byte[this.MAX_BUFFER_SIZE]);
        this.recordEvents.order(this.byteOrder);
        this.recordData = ByteBuffer.wrap(new byte[this.MAX_BUFFER_SIZE]);
        this.recordData.order(this.byteOrder);
        this.recordBinary = ByteBuffer.wrap(new byte[this.RECORD_BUFFER_SIZE]);
        this.recordBinary.order(this.byteOrder);
    }

    public boolean roomForEvent(int length) {
        return this.indexSize + 4 + this.eventSize + 56 + length <= this.MAX_BUFFER_SIZE;
    }

    public boolean oneTooMany() {
        return this.eventCount + 1 > this.MAX_EVENT_COUNT;
    }

    public boolean addEvent(byte[] event, int position, int length) {
        if (this.eventCount < 1 && !this.roomForEvent(length)) {
            this.MAX_BUFFER_SIZE = length + 0x100000;
            this.RECORD_BUFFER_SIZE = this.MAX_BUFFER_SIZE + 0x100000;
            this.allocate();
            this.reset();
        }
        if (this.oneTooMany() || !this.roomForEvent(length)) {
            return false;
        }
        int pos = this.recordEvents.position();
        System.arraycopy(event, position, this.recordEvents.array(), pos, length);
        this.recordEvents.position(pos + length);
        this.eventSize += length;
        this.recordIndex.putInt(this.indexSize, length);
        this.indexSize += 4;
        ++this.eventCount;
        return true;
    }

    public boolean addEvent(byte[] event) {
        return this.addEvent(event, 0, event.length);
    }

    public boolean addEvent(ByteBuffer event) {
        int length = event.remaining();
        if (this.eventCount < 1 && !this.roomForEvent(length)) {
            this.MAX_BUFFER_SIZE = length + 0x100000;
            this.RECORD_BUFFER_SIZE = this.MAX_BUFFER_SIZE + 0x100000;
            this.allocate();
            this.reset();
        }
        if (this.oneTooMany() || !this.roomForEvent(length)) {
            return false;
        }
        if (event.hasArray()) {
            int pos = this.recordEvents.position();
            System.arraycopy(event.array(), event.arrayOffset() + event.position(), this.recordEvents.array(), pos, length);
            this.recordEvents.position(pos + length);
        } else {
            this.recordEvents.put(event);
        }
        this.eventSize += length;
        this.recordIndex.putInt(this.indexSize, length);
        this.indexSize += 4;
        ++this.eventCount;
        return true;
    }

    public boolean addEvent(EvioBank event) {
        int length = event.getTotalBytes();
        if (this.eventCount < 1 && !this.roomForEvent(length)) {
            this.MAX_BUFFER_SIZE = length + 0x100000;
            this.RECORD_BUFFER_SIZE = this.MAX_BUFFER_SIZE + 0x100000;
            this.allocate();
            this.reset();
        }
        if (this.oneTooMany() || !this.roomForEvent(length)) {
            return false;
        }
        event.write(this.recordEvents);
        this.eventSize += length;
        this.recordIndex.putInt(this.indexSize, length);
        this.indexSize += 4;
        ++this.eventCount;
        return true;
    }

    public void reset() {
        this.indexSize = 0;
        this.eventSize = 0;
        this.eventCount = 0;
        this.recordData.clear();
        this.recordIndex.clear();
        this.recordEvents.clear();
        this.recordBinary.clear();
        this.header.reset();
    }

    public void setBuffer(ByteBuffer buf) throws HipoException {
        if (buf.order() != this.byteOrder) {
            System.out.println("setBuffer(): warning, changing buffer's byte order!");
        }
        if (buf.capacity() < this.RECORD_BUFFER_SIZE) {
            throw new HipoException("buffer too small, must be >= " + this.RECORD_BUFFER_SIZE + " bytes");
        }
        this.reset();
        this.recordBinary = buf;
        this.recordBinary.order(this.byteOrder);
    }

    public void build() {
        if (this.eventCount < 1) {
            this.header.setEntries(0);
            this.header.setDataLength(0);
            this.header.setIndexLength(0);
            this.header.setCompressedDataLength(0);
            this.header.setLength(56);
            this.recordBinary.position(0);
            try {
                this.header.writeHeader(this.recordBinary);
            }
            catch (HipoException e) {
                // empty catch block
            }
            this.recordBinary.position(0).limit(56);
            return;
        }
        int compressionType = this.header.getCompressionType();
        if (compressionType > 0) {
            this.recordData.position(0);
            this.recordData.put(this.recordIndex.array(), 0, this.indexSize);
            this.recordData.put(this.recordEvents.array(), 0, this.eventSize);
        } else {
            this.recordBinary.position(56);
            this.recordBinary.put(this.recordIndex.array(), 0, this.indexSize);
            this.recordBinary.put(this.recordEvents.array(), 0, this.eventSize);
        }
        int uncompressedDataSize = this.indexSize + this.eventSize;
        try {
            switch (compressionType) {
                case 1: {
                    int compressedSize = this.recordBinary.hasArray() && this.recordData.hasArray() ? Compressor.compressLZ4(this.recordData.array(), 0, uncompressedDataSize, this.recordBinary.array(), 56, this.recordBinary.array().length - 56) : Compressor.compressLZ4(this.recordData, 0, uncompressedDataSize, this.recordBinary, 56, this.recordBinary.capacity() - 56);
                    this.header.setCompressedDataLength(compressedSize);
                    this.header.setLength(4 * this.header.getCompressedDataLengthWords() + 56);
                    break;
                }
                case 2: {
                    int compressedSize = this.recordBinary.hasArray() && this.recordData.hasArray() ? Compressor.compressLZ4Best(this.recordData.array(), 0, uncompressedDataSize, this.recordBinary.array(), 56, this.recordBinary.array().length - 56) : Compressor.compressLZ4Best(this.recordData, 0, uncompressedDataSize, this.recordBinary, 56, this.recordBinary.capacity() - 56);
                    this.header.setCompressedDataLength(compressedSize);
                    this.header.setLength(4 * this.header.getCompressedDataLengthWords() + 56);
                    break;
                }
                case 3: {
                    byte[] gzippedData = Compressor.compressGZIP(this.recordData.array(), 0, uncompressedDataSize);
                    this.recordBinary.position(56);
                    this.recordBinary.put(gzippedData);
                    int compressedSize = gzippedData.length;
                    this.header.setCompressedDataLength(compressedSize);
                    this.header.setLength(4 * this.header.getCompressedDataLengthWords() + 56);
                    break;
                }
                default: {
                    this.header.setCompressedDataLength(0);
                    int words = uncompressedDataSize / 4;
                    if (uncompressedDataSize % 4 != 0) {
                        ++words;
                    }
                    this.header.setLength(words * 4 + 56);
                    break;
                }
            }
        }
        catch (HipoException e) {
            // empty catch block
        }
        this.header.setEntries(this.eventCount);
        this.header.setDataLength(this.eventSize);
        this.header.setIndexLength(this.indexSize);
        this.recordBinary.position(0);
        try {
            this.header.writeHeader(this.recordBinary);
        }
        catch (HipoException e) {
            // empty catch block
        }
        this.recordBinary.position(0).limit(this.header.getLength());
    }

    public void build(ByteBuffer userHeader) {
        int pos;
        if (userHeader == null) {
            this.build();
            return;
        }
        int userHeaderSize = userHeader.remaining();
        if (userHeaderSize < 1) {
            this.build();
            return;
        }
        int compressionType = this.header.getCompressionType();
        int uncompressedDataSize = this.indexSize;
        if (compressionType > 0) {
            this.recordData.position(0);
            this.recordData.put(this.recordIndex.array(), 0, this.indexSize);
            if (userHeader.hasArray()) {
                this.recordData.put(userHeader.array(), 0, userHeaderSize);
            } else {
                pos = userHeader.position();
                this.recordData.put(userHeader);
                userHeader.position(pos);
            }
            this.header.setUserHeaderLength(userHeaderSize);
            this.recordData.position(uncompressedDataSize += 4 * this.header.getUserHeaderLengthWords());
            this.recordData.put(this.recordEvents.array(), 0, this.eventSize);
            uncompressedDataSize += this.eventSize;
        } else {
            this.recordBinary.position(56);
            this.recordBinary.put(this.recordIndex.array(), 0, this.indexSize);
            if (userHeader.hasArray()) {
                this.recordBinary.put(userHeader.array(), 0, userHeaderSize);
            } else {
                pos = userHeader.position();
                this.recordBinary.put(userHeader);
                userHeader.position(pos);
            }
            this.header.setUserHeaderLength(userHeaderSize);
            this.recordBinary.position((uncompressedDataSize += 4 * this.header.getUserHeaderLengthWords()) + 56);
            this.recordBinary.put(this.recordEvents.array(), 0, this.eventSize);
            uncompressedDataSize += this.eventSize;
        }
        try {
            switch (compressionType) {
                case 1: {
                    int compressedSize = this.recordBinary.hasArray() && this.recordData.hasArray() ? Compressor.compressLZ4(this.recordData.array(), 0, uncompressedDataSize, this.recordBinary.array(), 56, this.recordBinary.array().length - 56) : Compressor.compressLZ4(this.recordData, 0, uncompressedDataSize, this.recordBinary, 56, this.recordBinary.capacity() - 56);
                    this.header.setCompressedDataLength(compressedSize);
                    this.header.setLength(4 * this.header.getCompressedDataLengthWords() + 56);
                    break;
                }
                case 2: {
                    int compressedSize = this.recordBinary.hasArray() && this.recordData.hasArray() ? Compressor.compressLZ4Best(this.recordData.array(), 0, uncompressedDataSize, this.recordBinary.array(), 56, this.recordBinary.array().length - 56) : Compressor.compressLZ4Best(this.recordData, 0, uncompressedDataSize, this.recordBinary, 56, this.recordBinary.capacity() - 56);
                    this.header.setCompressedDataLength(compressedSize);
                    this.header.setLength(4 * this.header.getCompressedDataLengthWords() + 56);
                    break;
                }
                case 3: {
                    byte[] gzippedData = Compressor.compressGZIP(this.recordData.array(), 0, uncompressedDataSize);
                    this.recordBinary.position(56);
                    this.recordBinary.put(gzippedData);
                    int compressedSize = gzippedData.length;
                    this.header.setCompressedDataLength(compressedSize);
                    this.header.setLength(4 * this.header.getCompressedDataLengthWords() + 56);
                    break;
                }
                default: {
                    this.header.setCompressedDataLength(0);
                    this.header.setLength(uncompressedDataSize + 56);
                    break;
                }
            }
        }
        catch (HipoException e) {
            // empty catch block
        }
        this.header.setEntries(this.eventCount);
        this.header.setDataLength(this.eventSize);
        this.header.setIndexLength(this.indexSize);
        this.recordBinary.position(0);
        try {
            this.header.writeHeader(this.recordBinary);
        }
        catch (HipoException e) {
            // empty catch block
        }
        this.recordBinary.position(0).limit(this.header.getLength());
    }
}

