/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.hipo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FileEventIndex {
    private List<Integer> recordIndex = new ArrayList<Integer>();
    private int currentEvent = 0;
    private int currentRecord = 0;
    private int currentRecordEvent = 0;

    public void resetIndex() {
        this.currentEvent = 0;
        this.setEvent(this.currentEvent);
    }

    public void addEventSize(int size) {
        if (this.recordIndex.isEmpty()) {
            this.recordIndex.add(0);
            this.recordIndex.add(size);
        } else {
            int cz = this.recordIndex.get(this.recordIndex.size() - 1) + size;
            this.recordIndex.add(cz);
        }
    }

    public int getEventNumber() {
        return this.currentEvent;
    }

    public int getRecordNumber() {
        return this.currentRecord;
    }

    public int getRecordEventNumber() {
        return this.currentRecordEvent;
    }

    public boolean canAdvance() {
        return this.currentEvent < this.getMaxEvents() - 1;
    }

    public boolean advance() {
        if (this.recordIndex.isEmpty()) {
            System.out.println("advance(): Warning, no entries in recordIndex!");
            return false;
        }
        if (this.currentEvent + 1 < this.recordIndex.get(this.currentRecord + 1)) {
            ++this.currentEvent;
            ++this.currentRecordEvent;
            return false;
        }
        if (this.recordIndex.size() < this.currentRecord + 2 + 1) {
            System.out.println("advance(): Warning, reached recordIndex limit!");
            return false;
        }
        ++this.currentEvent;
        ++this.currentRecord;
        this.currentRecordEvent = 0;
        return true;
    }

    public boolean canRetreat() {
        return this.currentEvent > 0;
    }

    public boolean retreat() {
        if (this.currentEvent == 0) {
            return false;
        }
        --this.currentEvent;
        if (this.currentRecordEvent > 0) {
            --this.currentRecordEvent;
            return false;
        }
        --this.currentRecord;
        this.currentRecordEvent = this.currentEvent - this.recordIndex.get(this.currentRecord);
        return true;
    }

    public int getMaxEvents() {
        return this.recordIndex.isEmpty() ? 0 : this.recordIndex.get(this.recordIndex.size() - 1);
    }

    public void show() {
        System.out.println("[FILERECORDINDEX] number of records    : " + this.recordIndex.size());
        System.out.println("[FILERECORDINDEX] max number of events : " + this.getMaxEvents());
        for (int i = 0; i < this.recordIndex.size(); ++i) {
            System.out.print(String.format("%6d ", this.recordIndex.get(i)));
            if ((i + 1) % 15 != 0) continue;
            System.out.println();
        }
        System.out.println("\n--\n");
    }

    public boolean setEvent(int event) {
        boolean hasRecordChanged = true;
        if (event < 0 || event >= this.getMaxEvents()) {
            System.out.println("[record-index] ** error ** can't change event  to " + event + ". choose value [ 0-" + (this.getMaxEvents() - 1) + " ]");
            return false;
        }
        int index = Collections.binarySearch(this.recordIndex, event);
        if (index >= 0) {
            if (this.currentRecord == index) {
                hasRecordChanged = false;
            }
            this.currentRecord = index;
            this.currentRecordEvent = 0;
            this.currentEvent = event;
        } else {
            if (this.currentRecord == -index - 2) {
                hasRecordChanged = false;
            }
            this.currentRecord = -index - 2;
            this.currentEvent = event;
            this.currentRecordEvent = this.currentEvent - this.recordIndex.get(this.currentRecord);
        }
        return hasRecordChanged;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(String.format("n events %6d ", this.getMaxEvents()));
        str.append(String.format(" event = %6d,", this.currentEvent));
        str.append(String.format(" record = %5d,", this.currentRecord));
        str.append(String.format(" offset = %6d", this.currentRecordEvent));
        return str.toString();
    }

    public static void main(String[] args) {
        boolean status;
        int i;
        FileEventIndex index = new FileEventIndex();
        int nevents = 10;
        index.addEventSize(nevents);
        for (i = 0; i < 5; ++i) {
            index.addEventSize(5 + i * 2);
        }
        index.show();
        index.setEvent(0);
        System.out.println(index);
        System.out.println(" **** START ADVANCING ****");
        for (i = 0; i < 60; ++i) {
            status = index.advance();
            System.out.println(index + " status = " + status);
        }
        System.out.println(" **** START RETREATING ****");
        for (i = 0; i < 54; ++i) {
            status = index.retreat();
            System.out.println(index + " status = " + status);
        }
        System.out.println(" **** START SETTING EVENT NUMBER ****");
        for (i = 0; i < 55; ++i) {
            status = index.setEvent(i);
            System.out.println(index + " status = " + status);
        }
    }
}

