/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.CompactEventBuilder;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventWriter;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioReader;
import org.jlab.coda.jevio.Utilities;

public class UnpackStringTest {
    private static byte[] good1 = new byte[]{101, 118, 105, 111, 0, 4, 4, 4};
    private static byte[] good2 = new byte[]{101, 118, 105, 111, 0, 72, 69, 89, 72, 79, 0, 4};
    private static byte[] good3 = new byte[]{101, 118, 105, 111, 0, 120, 121, 122};
    private static byte[] bad1 = new byte[]{101, 118, 105, 111, 45, 120, 121, 122};
    private static byte[] bad2 = new byte[]{101, 118, 105, 111, 3, 4, 4, 4};
    private static byte[] bad3 = new byte[]{101, 118, 105, 111, 0, 4, 3, 3, 3, 3, 3, 4};
    private static byte[] bad4 = new byte[]{101, 118, 105, 111, 0, 72, 69, 89, 72, 79, 3, 4};
    private static byte[] bad5 = new byte[]{101, 118, 105, 111, 0, 4, 3, 4};
    private static byte[] ws = new byte[]{9, 10, 11, 12, 13, 28, 29, 30, 31};
    private static byte[] bad6 = new byte[]{101, 118, 105, 111, 9, 10, 11, 12, 13, 28, 29, 30, 31, 0, 4, 4};
    private static byte[] bad7 = new byte[]{101, 0, 4};
    static int[] data1 = new int[]{11, 0, 8, 1, 0, 516, 0, -1059454720, 2, 66306, 1627390980};
    static int[] data2 = new int[]{11, 0, 8, 1, 0, 516, 0, -1059454720, 2, 66306, 0x4040404};
    static int[] data3 = new int[]{11, 0, 8, 1, 0, 516, 0, -1059454720, 2, 66306, 1028};

    public static void mainMakeEvioBuffer(String[] args) {
        ByteBuffer buffer1 = ByteBuffer.allocate(256);
        CompactEventBuilder builder = null;
        int num = 2;
        int tag = 1;
        try {
            builder = new CompactEventBuilder(buffer1);
            builder.openBank(tag, num, DataType.CHARSTAR8);
            builder.addStringData(new String[]{"a"});
            builder.closeAll();
            buffer1 = builder.getBuffer();
            ByteBuffer buffer2 = ByteBuffer.allocate(512);
            EventWriter writer = new EventWriter(buffer2);
            writer.writeEvent(buffer1);
            Utilities.printBuffer(buffer2, 0, 20, "Strings");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main2(String[] args) {
        try {
            byte[] b = ByteDataTransformer.toBytes(data2, ByteOrder.BIG_ENDIAN);
            ByteBuffer buf = ByteBuffer.wrap(b);
            EvioReader reader = new EvioReader(buf);
            EvioEvent event = reader.getEvent(1);
            String[] strings = event.getStringData();
            if (strings == null) {
                System.out.println("Strings are NULL");
                return;
            }
            System.out.println("Have " + strings.length + " number of strings in bank:");
            for (String s : strings) {
                System.out.println("  string = \"" + s + "\"");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            EvioBank bank = new EvioBank(1, DataType.CHARSTAR8, 2);
            bank.setRawBytes(bad7);
            String[] sa = bank.getStringData();
            int i = 1;
            if (sa != null) {
                System.out.println("Decoded strings:");
                for (String s : sa) {
                    System.out.print("string " + i++ + ": ");
                    System.out.println(s);
                }
            } else {
                System.out.println("No decoded strings");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main1(String[] args) {
        byte[] b = new byte[400];
        Arrays.fill(b, 0, 396, (byte)101);
        b[396] = 0;
        b[397] = 4;
        b[398] = 4;
        b[399] = 4;
        EvioBank bank = new EvioBank(1, DataType.CHARSTAR8, 2);
        bank.setRawBytes(b);
        long t1 = System.currentTimeMillis();
        for (int i = 0; i < 2000000; ++i) {
        }
        long t2 = System.currentTimeMillis();
        System.out.println("Time = " + (t2 - t1) + " millisec");
    }
}

