/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jlab.coda.jevio.EvioByteArrayOutputStream;

class GzipCompression3 {
    EvioByteArrayOutputStream byteArrayOut;
    GZIPOutputStream gzipOut;
    ByteBuffer buffer = ByteBuffer.allocate(201);

    public GzipCompression3() {
        this.byteArrayOut = new EvioByteArrayOutputStream(this.buffer.capacity() + 101);
        try {
            this.gzipOut = new GZIPOutputStream(this.byteArrayOut);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeFile() throws IOException {
        for (int i = 0; i < this.buffer.capacity(); ++i) {
            this.buffer.put((byte)i);
        }
        this.buffer.flip();
        int bytesWritten = this.buffer.remaining();
        System.out.println("Writing " + bytesWritten + " uncompressed bytes");
        if (this.buffer.hasArray()) {
            this.gzipOut.write(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.position(), bytesWritten);
        } else {
            while (this.buffer.hasRemaining()) {
                this.gzipOut.write(this.buffer.get());
            }
        }
        this.gzipOut.finish();
        this.gzipOut.close();
        this.byteArrayOut.close();
        ByteBuffer compressedBuf = this.byteArrayOut.getByteBuffer();
        System.out.println("Compressed buf: cap = " + compressedBuf.capacity() + ", pos = " + compressedBuf.position() + ", lim = " + compressedBuf.limit());
        File currentFile = new File("/scratch/timmer/myDataFile5");
        RandomAccessFile raf = new RandomAccessFile(currentFile, "rw");
        FileChannel fileChannel = raf.getChannel();
        while (compressedBuf.hasRemaining()) {
            fileChannel.write(compressedBuf);
        }
        fileChannel.close();
        System.out.println("\nFINISH Gzip output and close stream\n");
    }

    public void readAndPrintFile() throws IOException {
        int len;
        File inFile = new File("/scratch/timmer/myDataFile5");
        int fileLength = (int)inFile.length();
        GZIPInputStream in = new GZIPInputStream(new FileInputStream(inFile));
        byte[] buffer = new byte[fileLength];
        while ((len = ((InputStream)in).read(buffer)) > 0) {
            for (int i = 0; i < len; ++i) {
                if (i % 20 == 0) {
                    System.out.print("\n  Buf(" + (i + 1) + "-" + (i + 20) + ") =  ");
                } else if (i % 4 == 0) {
                    System.out.print("  ");
                }
                System.out.print(String.format("%02x", buffer[i]) + " ");
            }
            System.out.println();
            System.out.println();
        }
        ((InputStream)in).close();
    }

    public static void main(String[] args) throws IOException, DataFormatException {
        GzipCompression3 comp = new GzipCompression3();
        comp.writeFile();
        comp.readAndPrintFile();
    }
}

