/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import org.jlab.coda.jevio.CompactEventBuilder;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventBuilder;
import org.jlab.coda.jevio.EventWriter;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioCompactStructureHandler;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.Utilities;

public class CompactStructureHandlerTest {
    static void printBytes(ByteBuffer buf) {
        for (int i = buf.position(); i < buf.capacity(); ++i) {
            System.out.println("byte = " + buf.get(i));
        }
        System.out.println("\n");
    }

    static EvioEvent createSingleEvent(int tag) {
        EvioEvent event = null;
        int[] intData1 = new int[1];
        Arrays.fill(intData1, 7);
        int[] intData2 = new int[1];
        Arrays.fill(intData2, 8);
        int[] intData3 = new int[1];
        Arrays.fill(intData3, 9);
        try {
            EventBuilder builder = new EventBuilder(tag, DataType.BANK, 1);
            event = builder.getEvent();
            EvioBank bankInts = new EvioBank(tag + 1, DataType.INT32, 2);
            bankInts.appendIntData(intData1);
            builder.addChild(event, bankInts);
            EvioBank bankBanks = new EvioBank(tag + 2, DataType.BANK, 3);
            builder.addChild(event, bankBanks);
            EvioBank bankInts2 = new EvioBank(tag + 19, DataType.INT32, 20);
            bankInts2.appendIntData(intData2);
            builder.addChild(bankBanks, bankInts2);
            EvioBank bankInts3 = new EvioBank(tag + 3, DataType.INT32, 4);
            bankInts3.appendIntData(intData3);
            builder.addChild(event, bankInts3);
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return event;
    }

    static ByteBuffer createBuffer(int tag, int num) {
        EvioEvent bank = CompactStructureHandlerTest.createSingleEvent(tag);
        int byteSize = bank.getTotalBytes();
        ByteBuffer bb = ByteBuffer.allocate(byteSize);
        bank.write(bb);
        bb.flip();
        return bb;
    }

    static ByteBuffer createAddBuffer(int tag, int num) {
        ByteBuffer bb = null;
        try {
            CompactEventBuilder builder = new CompactEventBuilder(20, ByteOrder.BIG_ENDIAN);
            builder.openBank(tag, num, DataType.BANK);
            builder.openBank(tag + 1, num + 1, DataType.INT32);
            builder.addIntData(new int[]{6});
            builder.closeAll();
            bb = builder.getBuffer();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return bb;
    }

    public static void main(String[] args) {
        try {
            ByteBuffer buf = ByteBuffer.allocate(1024);
            EvioEvent event = CompactStructureHandlerTest.createSingleEvent(1);
            EventWriter writer = new EventWriter(buf);
            writer.writeEvent(event);
            System.out.println("After writer, buf pos = " + buf.position() + ", lim = " + buf.limit());
            buf.limit(84).position(32);
            Utilities.printBuffer(buf, 0, 29, "EVENT");
            EvioCompactStructureHandler handler = new EvioCompactStructureHandler(buf, DataType.BANK);
            List<EvioNode> list = handler.getNodes();
            handler.removeStructure(list.get(4));
            ByteBuffer bb = CompactStructureHandlerTest.createAddBuffer(6, 6);
            ByteBuffer newBuf = handler.addStructure(bb);
            Utilities.printBuffer(newBuf, 0, 29, "New event");
            list = handler.getNodes();
            System.out.println("Got " + list.size() + " nodes after everything");
            int i = 0;
            for (EvioNode n : list) {
                ByteBuffer dd = handler.getStructureBuffer(list.get(i));
                Utilities.printBuffer(dd, 0, 29, "Struct buf for node " + ++i);
            }
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

