/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventBuilder;
import org.jlab.coda.jevio.EventWriter;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioCompactReader;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;

public class CompactReaderAddSubtractTest {
    static EvioEvent createSingleEvent(int tag) {
        EvioEvent event = null;
        int[] intData = new int[2];
        Arrays.fill(intData, tag);
        try {
            EventBuilder builder = new EventBuilder(tag, DataType.BANK, 1);
            event = builder.getEvent();
            EvioBank bankBanks = new EvioBank(tag + 1, DataType.BANK, 2);
            builder.addChild(event, bankBanks);
            EvioBank bankInts = new EvioBank(tag + 2, DataType.INT32, 3);
            bankInts.appendIntData(intData);
            builder.addChild(bankBanks, bankInts);
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return event;
    }

    static EvioEvent createComplexEvent(int tag) {
        EvioEvent event = null;
        int[] intData = new int[2];
        Arrays.fill(intData, tag);
        int[] intData2 = new int[2];
        Arrays.fill(intData2, tag * 10);
        try {
            EventBuilder builder = new EventBuilder(tag, DataType.BANK, 1);
            event = builder.getEvent();
            EvioBank bankBanks = new EvioBank(tag + 1, DataType.BANK, 2);
            builder.addChild(event, bankBanks);
            EvioBank bankInts = new EvioBank(tag + 2, DataType.INT32, 3);
            bankInts.appendIntData(intData);
            builder.addChild(bankBanks, bankInts);
            EvioBank bankBanks2 = new EvioBank(tag + 3, DataType.BANK, 4);
            builder.addChild(event, bankBanks2);
            EvioBank bankInts2 = new EvioBank(tag + 4, DataType.INT32, 5);
            bankInts2.appendIntData(intData2);
            builder.addChild(bankBanks2, bankInts2);
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return event;
    }

    static ByteBuffer createComplexBuffer() {
        ByteBuffer myBuf = ByteBuffer.allocate(184);
        try {
            EventWriter writer = new EventWriter(myBuf, 1000, 1, null, null);
            EvioEvent ev1 = CompactReaderAddSubtractTest.createComplexEvent(1);
            EvioEvent ev2 = CompactReaderAddSubtractTest.createSingleEvent(100);
            writer.writeEvent(ev1);
            writer.writeEvent(ev2);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        myBuf.flip();
        return myBuf;
    }

    static ByteBuffer createBuffer() {
        ByteBuffer myBuf = ByteBuffer.allocate(160);
        try {
            EventWriter writer = new EventWriter(myBuf, 1000, 1, null, null);
            EvioEvent ev1 = CompactReaderAddSubtractTest.createSingleEvent(1);
            EvioEvent ev2 = CompactReaderAddSubtractTest.createSingleEvent(100);
            writer.writeEvent(ev1);
            writer.writeEvent(ev2);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        myBuf.flip();
        return myBuf;
    }

    public static void main(String[] args) {
        try {
            ByteBuffer buf = CompactReaderAddSubtractTest.createComplexBuffer();
            EvioCompactReader reader = new EvioCompactReader(buf);
            System.out.println("# of events = " + reader.getEventCount());
            EvioNode node1 = reader.getScannedEvent(1);
            EvioNode node2 = reader.getScannedEvent(2);
            int i = 0;
            System.out.println("1st event all:");
            for (EvioNode n : node1.getAllNodes()) {
                System.out.println("node " + ++i + ": " + n);
            }
            System.out.println("1st event children:");
            i = 0;
            ArrayList<EvioNode> kids = node1.getChildNodes();
            if (kids != null) {
                for (EvioNode n : kids) {
                    System.out.println("child node " + ++i + ": " + n);
                }
            }
            i = 0;
            System.out.println("2nd event all:");
            for (EvioNode n : node2.getAllNodes()) {
                System.out.println("node " + ++i + ": " + n);
            }
            System.out.println("\nBlock 1: " + node1.blockNode);
            System.out.println("Block 2: " + node2.blockNode + "\n");
            System.out.println("node 1 has all-node-count = " + node1.getAllNodes().size());
            int[] data1 = new int[]{2, 396038, 1};
            ByteBuffer newBuf = ByteBuffer.wrap(ByteDataTransformer.toBytes(data1, ByteOrder.BIG_ENDIAN));
            reader.addStructure(1, newBuf);
            System.out.println("1st event after:");
            for (EvioNode n : node1.getAllNodes()) {
                System.out.println("node " + ++i + ": " + n);
                System.out.println("nodeBB = " + n.getBufferNode().getBuffer());
            }
            System.out.println("reader.byteBuffer = " + reader.getByteBuffer());
            if (reader.getByteBuffer() == node1.getBufferNode().getBuffer()) {
                System.out.println("reader and node have same buffer");
            } else {
                System.out.println("reader and node have DIFFERENT buffer");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main2(String[] args) {
        try {
            EvioCompactReader reader;
            boolean useFile = false;
            if (useFile) {
                reader = new EvioCompactReader("/tmp/removeTest.evio");
            } else {
                ByteBuffer buf = CompactReaderAddSubtractTest.createComplexBuffer();
                reader = new EvioCompactReader(buf);
            }
            System.out.println("Using file = " + reader.isFile());
            System.out.println("# of events = " + reader.getEventCount());
            EvioNode node1 = reader.getScannedEvent(1);
            EvioNode node2 = reader.getScannedEvent(2);
            reader.toFile("/tmp/junk1");
            int i = 0;
            System.out.println("1st event all:");
            for (EvioNode n : node1.getAllNodes()) {
                System.out.println("node " + ++i + ": " + n);
            }
            System.out.println("1st event children:");
            i = 0;
            ArrayList<EvioNode> kids = node1.getChildNodes();
            if (kids != null) {
                for (EvioNode n : kids) {
                    System.out.println("child node " + ++i + ": " + n);
                }
            }
            i = 0;
            System.out.println("2nd event all:");
            for (EvioNode n : node2.getAllNodes()) {
                System.out.println("node " + ++i + ": " + n);
            }
            System.out.println("\nBlock 1: " + node1.blockNode + "\n");
            System.out.println("\nBlock 2: " + node2.blockNode + "\n");
            System.out.println("node 1 has all-node-count = " + node1.getAllNodes().size());
            System.out.println("removing node = " + node1.getAllNodes().get(1));
            ByteBuffer newBuf = reader.removeStructure(node1.getAllNodes().get(1));
            System.out.println("node 1 now has all-node-count = " + node1.getAllNodes().size());
            System.out.println("REMOVE node 1");
            newBuf = reader.removeEvent(1);
            System.out.println("Re-get scanned events 1 & 2");
            node1 = reader.getScannedEvent(1);
            reader.removeStructure(node1.getChildAt(0));
            node2 = reader.getScannedEvent(2);
            reader.toFile("/tmp/junk2");
            i = 0;
            if (node1 == null) {
                System.out.println("event 1 = null");
            } else if (node1.isObsolete()) {
                System.out.println("OBSOLETE event 1");
            } else {
                System.out.println("1st event after:");
                for (EvioNode n : node1.getAllNodes()) {
                    ++i;
                    if (n.isObsolete()) {
                        System.out.println("OBSOLETE node " + i + ": " + n);
                        continue;
                    }
                    System.out.println("node " + i + ": " + n);
                }
                System.out.println("1st event children after:");
                i = 0;
                kids = node1.getChildNodes();
                if (kids != null) {
                    for (EvioNode n : kids) {
                        System.out.println("child node: " + ++i + ": " + n);
                    }
                }
            }
            i = 0;
            if (node2 == null) {
                System.out.println("event 2 = null");
            } else if (node2.isObsolete()) {
                System.out.println("OBSOLETE event 2");
            } else {
                System.out.println("2nd event after:");
                for (EvioNode n : node2.getAllNodes()) {
                    System.out.println("node " + ++i + ": " + n);
                }
            }
            if (node1 != null) {
                System.out.println("\nBlock 1 after: " + node1.blockNode + "\n");
            }
            if (node2 != null) {
                System.out.println("\nBlock 2 after: " + node2.blockNode + "\n");
            }
            System.out.println("\n\n\nReanalyze");
            System.out.println("# of events = " + reader.getEventCount());
            EvioCompactReader reader2 = new EvioCompactReader(newBuf);
            node1 = reader2.getScannedEvent(1);
            node2 = reader2.getScannedEvent(2);
            i = 0;
            if (node1 == null) {
                System.out.println("event 1 is NULL");
            } else if (node1.isObsolete()) {
                System.out.println("event 1 is obsolete");
            } else {
                System.out.println("1st event all:");
                for (EvioNode n : node1.getAllNodes()) {
                    System.out.println("node " + ++i + ": " + n);
                }
                System.out.println("1st event children:");
                i = 0;
                kids = node1.getChildNodes();
                if (kids != null) {
                    for (EvioNode n : kids) {
                        System.out.println("child node " + ++i + ": " + n);
                    }
                }
                System.out.println("\nBlock 1: " + node1.blockNode + "\n");
            }
            i = 0;
            if (node2 == null) {
                System.out.println("event 2 is NULL");
            } else if (node2.isObsolete()) {
                System.out.println("event 2 is obsolete");
            } else {
                System.out.println("2nd event all:");
                for (EvioNode n : node2.getAllNodes()) {
                    System.out.println("node " + ++i + ": " + n);
                }
                System.out.println("\nBlock 2: " + node2.blockNode + "\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main1(String[] args) {
        try {
            ByteBuffer buf = CompactReaderAddSubtractTest.createBuffer();
            ByteBuffer evBuf = ByteBuffer.allocate(32);
            try {
                EvioEvent ev = CompactReaderAddSubtractTest.createSingleEvent(10);
                ev.write(evBuf);
                evBuf.flip();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            EvioCompactReader reader = new EvioCompactReader(buf);
            EvioNode node1 = reader.getEvent(1);
            EvioNode node2 = reader.getScannedEvent(2);
            int i = 0;
            System.out.println("1st event all:");
            for (EvioNode n : node1.getAllNodes()) {
                System.out.println("node " + ++i + ": " + n);
            }
            System.out.println("1st event children:");
            i = 0;
            ArrayList<EvioNode> kids = node1.getChildNodes();
            if (kids != null) {
                for (EvioNode n : kids) {
                    System.out.println("child node " + ++i + ": " + n);
                }
            }
            i = 0;
            System.out.println("2nd event all:");
            for (EvioNode n : node2.getAllNodes()) {
                System.out.println("node " + ++i + ": " + n);
            }
            System.out.println("\nBlock 1: " + node1.blockNode + "\n");
            System.out.println("\nBlock 2: " + node2.blockNode + "\n");
            ByteBuffer newBuf = reader.addStructure(1, evBuf);
            i = 0;
            System.out.println("1st event after:");
            for (EvioNode n : node1.getAllNodes()) {
                System.out.println("node " + ++i + ": " + n);
            }
            System.out.println("1st event children after:");
            i = 0;
            kids = node1.getChildNodes();
            if (kids != null) {
                for (EvioNode n : kids) {
                    System.out.println("child node: " + ++i + ": " + n);
                }
            }
            i = 0;
            System.out.println("2nd event after:");
            for (EvioNode n : node2.getAllNodes()) {
                System.out.println("node " + ++i + ": " + n);
            }
            System.out.println("\nBlock 1 after: " + node1.blockNode + "\n");
            System.out.println("\nBlock 2 after: " + node2.blockNode + "\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

