/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jlab.coda.jevio.BlockNode;
import org.jlab.coda.jevio.BufferNode;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.EvioXMLDictionary;

public class EvioCompactStructureHandler {
    private EvioNode node;
    private ByteBuffer byteBuffer;
    private ByteOrder byteOrder;
    private boolean closed;

    public EvioCompactStructureHandler(EvioNode node) throws EvioException {
        if (node == null) {
            throw new EvioException("node arg is null");
        }
        ByteBuffer byteBuffer = node.getBufferNode().getBuffer();
        this.byteOrder = byteBuffer.order();
        this.byteBuffer = byteBuffer.duplicate().order(this.byteOrder);
        this.bufferInit(node);
    }

    public EvioCompactStructureHandler(ByteBuffer byteBuffer, DataType type) throws EvioException {
        this.setBuffer(byteBuffer, type);
    }

    public synchronized void setBuffer(ByteBuffer buf, DataType type) throws EvioException {
        if (buf == null) {
            throw new EvioException("buffer arg is null");
        }
        if (type == null || !type.isStructure()) {
            throw new EvioException("type arg is null or is not an evio structure");
        }
        if (buf.remaining() < 1) {
            throw new EvioException("buffer has too little data");
        }
        if ((type == DataType.BANK || type == DataType.ALSOBANK) && buf.remaining() < 2) {
            throw new EvioException("buffer has too little data");
        }
        this.closed = true;
        this.byteOrder = buf.order();
        this.byteBuffer = buf.duplicate().order(this.byteOrder);
        this.node = EvioCompactStructureHandler.extractNode(this.byteBuffer, null, null, type, this.byteBuffer.position(), 0, true);
        if (this.node.len + 1 > this.byteBuffer.remaining() / 4) {
            throw new EvioException("buffer has too little data");
        }
        this.bufferInit(this.node);
        this.closed = false;
    }

    private void bufferInit(EvioNode node) {
        int endPos = node.dataPos + 4 * node.dataLen;
        int startPos = node.pos;
        ByteBuffer newBuffer = ByteBuffer.allocate(5 * (endPos - startPos) / 4).order(this.byteOrder);
        this.byteBuffer.limit(endPos).position(startPos);
        newBuffer.put(this.byteBuffer);
        newBuffer.position(0).limit(endPos - startPos);
        node.isEvent = true;
        node.allNodes = new ArrayList();
        node.allNodes.add(node);
        node.parentNode = null;
        node.dataPos -= startPos;
        node.pos -= startPos;
        node.bufferNode.buffer = newBuffer;
        EvioNode.scanStructure(node);
        node.scanned = true;
        this.byteBuffer = newBuffer;
        this.node = node;
    }

    private void expandBuffer(int byteSize) {
        ByteBuffer newBuffer = ByteBuffer.allocate(5 * byteSize / 4).order(this.byteOrder);
        int endPos = this.node.dataPos + 4 * this.node.dataLen;
        this.byteBuffer.position(0).limit(endPos);
        newBuffer.put(this.byteBuffer);
        newBuffer.position(0).limit(endPos);
        for (EvioNode n : this.node.allNodes) {
            n.bufferNode.buffer = newBuffer;
        }
        this.byteBuffer = newBuffer;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public EvioNode getStructure() {
        return this.node;
    }

    public EvioNode getScannedStructure() {
        EvioNode.scanStructure(this.node);
        return this.node;
    }

    private static EvioNode extractNode(ByteBuffer buffer, BlockNode blockNode, EvioNode eventNode, DataType type, int position, int place, boolean isEvent) throws EvioException {
        EvioNode node = new EvioNode();
        node.pos = position;
        node.place = place;
        node.blockNode = blockNode;
        node.eventNode = eventNode;
        node.isEvent = isEvent;
        node.type = type.getValue();
        node.bufferNode = new BufferNode(buffer);
        if (eventNode != null) {
            node.allNodes = eventNode.allNodes;
        }
        try {
            switch (type) {
                case BANK: 
                case ALSOBANK: {
                    node.len = buffer.getInt(position);
                    node.dataPos = position + 8;
                    node.dataLen = node.len - 1;
                    int word = buffer.getInt(position += 4);
                    node.tag = word >>> 16;
                    int dt = word >> 8 & 0xFF;
                    node.dataType = dt & 0x3F;
                    node.pad = dt >>> 6;
                    node.num = word & 0xFF;
                    break;
                }
                case SEGMENT: 
                case ALSOSEGMENT: {
                    node.dataPos = position + 4;
                    int word = buffer.getInt(position);
                    node.tag = word >>> 24;
                    int dt = word >>> 16 & 0xFF;
                    node.dataType = dt & 0x3F;
                    node.pad = dt >>> 6;
                    node.dataLen = node.len = word & 0xFFFF;
                    break;
                }
                case TAGSEGMENT: {
                    node.dataPos = position + 4;
                    int word = buffer.getInt(position);
                    node.tag = word >>> 20;
                    node.dataType = word >>> 16 & 0xF;
                    node.dataLen = node.len = word & 0xFFFF;
                    break;
                }
                default: {
                    throw new EvioException("File/buffer bad format");
                }
            }
        }
        catch (BufferUnderflowException a) {
            throw new EvioException("File/buffer bad format");
        }
        return node;
    }

    private ArrayList<EvioNode> scanStructure() {
        if (!this.node.scanned) {
            this.node.scanned = true;
            EvioNode.scanStructure(this.node);
        }
        return this.node.allNodes;
    }

    public synchronized List<EvioNode> searchStructure(int tag, int num) throws EvioException {
        if (tag < 0 || num < 0) {
            throw new EvioException("bad arg value(s)");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        ArrayList<EvioNode> returnList = new ArrayList<EvioNode>(100);
        ArrayList<EvioNode> list = this.scanStructure();
        for (EvioNode enode : list) {
            if (enode.tag != tag || enode.num != num) continue;
            returnList.add(enode);
        }
        return returnList;
    }

    public List<EvioNode> searchStructure(String dictName, EvioXMLDictionary dictionary) throws EvioException {
        if (dictName == null || dictionary == null) {
            throw new EvioException("null dictionary and/or entry name");
        }
        int tag = dictionary.getTag(dictName);
        int num = dictionary.getNum(dictName);
        if (tag == -1 || num == -1) {
            throw new EvioException("no dictionary entry for " + dictName);
        }
        return this.searchStructure(tag, num);
    }

    public synchronized ByteBuffer addStructure(ByteBuffer addBuffer) throws EvioException {
        if (!this.node.getDataTypeObj().isStructure()) {
            throw new EvioException("cannot add structure to bank of primitive type");
        }
        if (addBuffer == null || addBuffer.remaining() < 4) {
            throw new EvioException("null, empty, or non-evio format buffer arg");
        }
        if (addBuffer.order() != this.byteOrder) {
            throw new EvioException("trying to add wrong endian buffer");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        int endPos = this.node.dataPos + 4 * this.node.dataLen;
        int origAddBufPos = addBuffer.position();
        int appendDataLen = addBuffer.remaining();
        if (appendDataLen % 4 != 0) {
            throw new EvioException("data added is not in evio format");
        }
        this.node.clearIntArray();
        int appendDataWordLen = appendDataLen / 4;
        DataType eventDataType = this.node.getDataTypeObj();
        if (this.byteBuffer.capacity() - this.byteBuffer.limit() < appendDataLen) {
            this.expandBuffer(this.byteBuffer.limit() + appendDataLen);
        }
        this.byteBuffer.limit(this.byteBuffer.capacity()).position(endPos);
        this.byteBuffer.put(addBuffer);
        this.byteBuffer.flip();
        addBuffer.position(origAddBufPos);
        int eventLenPos = 0;
        this.node.len += appendDataWordLen;
        this.node.dataLen += appendDataWordLen;
        switch (eventDataType) {
            case BANK: 
            case ALSOBANK: {
                this.byteBuffer.putInt(eventLenPos, this.node.len);
                break;
            }
            case SEGMENT: 
            case ALSOSEGMENT: 
            case TAGSEGMENT: {
                if (this.byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
                    this.byteBuffer.putShort(eventLenPos + 2, (short)this.node.len);
                    break;
                }
                this.byteBuffer.putShort(eventLenPos, (short)this.node.len);
                break;
            }
            default: {
                throw new EvioException("internal programming error");
            }
        }
        EvioNode newNode = EvioCompactStructureHandler.extractNode(this.byteBuffer, null, this.node, eventDataType, endPos, 0, false);
        this.node.addChild(newNode);
        EvioNode.scanStructure(newNode);
        return this.byteBuffer;
    }

    public synchronized ByteBuffer removeStructure(EvioNode removeNode) throws EvioException {
        EvioNode parent;
        if (removeNode == null) {
            return this.byteBuffer;
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        if (removeNode.isObsolete()) {
            return this.byteBuffer;
        }
        boolean foundNode = false;
        int removeNodePlace = 0;
        for (EvioNode n : this.node.allNodes) {
            if (removeNode == n) {
                foundNode = true;
                break;
            }
            ++removeNodePlace;
        }
        if (!foundNode) {
            throw new EvioException("removeNode not found");
        }
        removeNode.setObsolete(true);
        int removeDataLen = removeNode.getTotalBytes();
        int removeWordLen = removeDataLen / 4;
        int copyFromPos = removeNode.pos + removeDataLen;
        int copyToPos = removeNode.pos;
        if (copyFromPos == this.byteBuffer.limit()) {
            this.byteBuffer.limit(copyToPos);
        } else {
            ByteBuffer srcBuf = this.byteBuffer.duplicate().order(this.byteOrder);
            srcBuf.position(copyFromPos);
            this.byteBuffer.limit(this.byteBuffer.capacity()).position(copyToPos);
            this.byteBuffer.put(srcBuf);
            this.byteBuffer.flip();
        }
        int i = 0;
        for (EvioNode n : this.node.allNodes) {
            if (n.obsolete) {
                ++i;
                continue;
            }
            if (i > removeNodePlace) {
                n.pos -= removeDataLen;
                n.dataPos -= removeDataLen;
            }
            ++i;
        }
        EvioNode removeParent = parent = removeNode.parentNode;
        while (parent != null) {
            parent.len -= removeWordLen;
            parent.dataLen -= removeWordLen;
            int parentPos = parent.pos;
            parent.clearIntArray();
            switch (parent.getDataTypeObj()) {
                case BANK: 
                case ALSOBANK: {
                    this.byteBuffer.putInt(parentPos, parent.len);
                    break;
                }
                case SEGMENT: 
                case ALSOSEGMENT: 
                case TAGSEGMENT: {
                    if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
                        this.byteBuffer.putShort(parentPos + 2, (short)parent.len);
                        break;
                    }
                    this.byteBuffer.putShort(parentPos, (short)parent.len);
                    break;
                }
                default: {
                    throw new EvioException("internal programming error");
                }
            }
            parent = parent.parentNode;
        }
        if (removeParent != null) {
            removeParent.removeChild(removeNode);
        }
        return this.byteBuffer;
    }

    public ByteBuffer getData(EvioNode node) throws EvioException {
        return this.getData(node, false);
    }

    public synchronized ByteBuffer getData(EvioNode node, boolean copy) throws EvioException {
        if (this.closed) {
            throw new EvioException("object closed");
        }
        int lim = this.byteBuffer.limit();
        this.byteBuffer.limit(node.dataPos + 4 * node.dataLen - node.pad).position(node.dataPos);
        if (copy) {
            ByteBuffer newBuf = ByteBuffer.allocate(4 * node.dataLen - node.pad).order(this.byteOrder);
            newBuf.put(this.byteBuffer);
            newBuf.flip();
            this.byteBuffer.limit(lim).position(0);
            return newBuf;
        }
        ByteBuffer buf = this.byteBuffer.slice().order(this.byteOrder);
        this.byteBuffer.limit(lim).position(0);
        return buf;
    }

    public ByteBuffer getStructureBuffer(EvioNode node) throws EvioException {
        return this.getStructureBuffer(node, false);
    }

    public synchronized ByteBuffer getStructureBuffer(EvioNode node, boolean copy) throws EvioException {
        if (node == null) {
            throw new EvioException("node arg is null");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        int lim = this.byteBuffer.limit();
        this.byteBuffer.limit(node.dataPos + 4 * node.dataLen).position(node.pos);
        if (copy) {
            ByteBuffer newBuf = ByteBuffer.allocate(node.getTotalBytes()).order(this.byteOrder);
            newBuf.put(this.byteBuffer);
            newBuf.flip();
            this.byteBuffer.limit(lim).position(0);
            return newBuf;
        }
        ByteBuffer buf = this.byteBuffer.slice().order(this.byteOrder);
        this.byteBuffer.limit(lim).position(0);
        return buf;
    }

    public synchronized List<EvioNode> getNodes() throws EvioException {
        if (this.closed) {
            throw new EvioException("object closed");
        }
        return Collections.unmodifiableList(this.scanStructure());
    }

    public synchronized List<EvioNode> getChildNodes() throws EvioException {
        if (this.closed) {
            throw new EvioException("object closed");
        }
        this.scanStructure();
        return Collections.unmodifiableList(this.node.childNodes);
    }

    public synchronized void close() {
        this.byteBuffer.position(0);
        this.closed = true;
    }
}

