/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jlab.coda.hipo.Reader;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.BlockHeaderV4;
import org.jlab.coda.jevio.BlockNode;
import org.jlab.coda.jevio.BufferNode;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.EvioXMLDictionary;
import org.jlab.coda.jevio.IBlockHeader;
import org.jlab.coda.jevio.IEvioCompactReader;
import org.jlab.coda.jevio.Utilities;

class EvioCompactReaderUnsyncV6
implements IEvioCompactReader {
    static final int BLOCK_SIZE_OFFSET = 0;
    static final int BLOCK_NUMBER = 4;
    static final int BLOCK_HEADER_SIZE_OFFSET = 8;
    static final int BLOCK_EVENT_COUNT = 12;
    static final int VERSION_MASK = 255;
    private final ArrayList<EvioNode> eventNodes = new ArrayList(1000);
    private final HashMap<Integer, BlockNode> blockNodes = new HashMap(20);
    private int eventCount = -1;
    private int evioVersion;
    private ByteOrder byteOrder;
    private int blockCount = -1;
    private int firstBlockHeaderWords;
    private BlockHeaderV4 blockHeader = new BlockHeaderV4();
    private boolean hasDictionary;
    private String dictionaryXML;
    private EvioXMLDictionary dictionary;
    private ByteBuffer byteBuffer;
    BufferNode bufferNode;
    private int initialPosition;
    private int validDataWords;
    private boolean closed;
    private Reader reader;

    public EvioCompactReaderUnsyncV6(ByteBuffer byteBuffer) throws EvioException {
        if (byteBuffer == null) {
            throw new EvioException("Buffer arg is null");
        }
        this.initialPosition = byteBuffer.position();
        this.byteBuffer = byteBuffer;
        this.reader = new Reader(byteBuffer);
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public void setBuffer(ByteBuffer buf) throws EvioException {
        this.reader.setBuffer(buf);
        this.closed = false;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.reader.getByteOrder();
    }

    @Override
    public int getEvioVersion() {
        return this.reader.getVersion();
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public ByteOrder getFileByteOrder() {
        return null;
    }

    @Override
    public String getDictionaryXML() {
        return this.reader.getDictionary();
    }

    @Override
    public EvioXMLDictionary getDictionary() throws EvioException {
        if (this.dictionary != null) {
            return this.dictionary;
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        if (this.hasDictionary) {
            try {
                if (this.dictionaryXML == null) {
                    this.readDictionary();
                }
                this.dictionary = new EvioXMLDictionary(this.dictionaryXML);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.dictionary;
    }

    @Override
    public boolean hasDictionary() {
        return this.reader.hasDictionary();
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public MappedByteBuffer getMappedByteBuffer() {
        return null;
    }

    @Override
    public long fileSize() {
        return 0L;
    }

    @Override
    public EvioNode getEvent(int eventNumber) {
        try {
            return this.eventNodes.get(eventNumber - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public EvioNode getScannedEvent(int eventNumber) {
        try {
            return this.scanStructure(eventNumber);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    void generateEventPositionTable() throws EvioException {
        boolean firstBlock = true;
        boolean hasDictionary = false;
        this.bufferNode = new BufferNode(this.byteBuffer);
        int position = this.initialPosition;
        int bytesLeft = this.byteBuffer.limit() - position;
        this.blockCount = 0;
        this.eventCount = 0;
        this.validDataWords = 0;
        Object previousBlockNode = null;
        try {
            while (bytesLeft > 0) {
                int byteLen;
                if (bytesLeft < 32) {
                    throw new EvioException("Bad evio format: extra " + bytesLeft + " bytes at file end");
                }
                int blockSize = this.byteBuffer.getInt(position);
                int byteInfo = this.byteBuffer.getInt(position + 20);
                int blockHdrSize = this.byteBuffer.getInt(position + 8);
                int blockEventCount = this.byteBuffer.getInt(position + 12);
                int magicNum = this.byteBuffer.getInt(position + 28);
                if (magicNum != -1059454720) {
                    throw new EvioException("Bad evio format: block header magic # incorrect");
                }
                if (blockSize < 8 || blockHdrSize < 8) {
                    throw new EvioException("Bad evio format (block: len = " + blockSize + ", blk header len = " + blockHdrSize + ")");
                }
                if (4 * blockSize > bytesLeft) {
                    throw new EvioException("Bad evio format: not enough data to read block");
                }
                BlockNode blockNode = new BlockNode();
                blockNode.pos = position;
                blockNode.len = blockSize;
                blockNode.count = blockEventCount;
                this.blockNodes.put(this.blockCount, blockNode);
                this.bufferNode.blockNodes.add(blockNode);
                ++this.blockCount;
                blockNode.place = blockNode.place;
                this.validDataWords += blockSize;
                if (firstBlock) {
                    hasDictionary = BlockHeaderV4.hasDictionary(byteInfo);
                }
                position += 4 * blockHdrSize;
                bytesLeft -= 4 * blockHdrSize;
                if (firstBlock && hasDictionary) {
                    firstBlock = false;
                    byteLen = 4 * (this.byteBuffer.getInt(position) + 1);
                    position += byteLen;
                    bytesLeft -= byteLen;
                }
                for (int i = 0; i < blockEventCount; ++i) {
                    if (bytesLeft < 8) {
                        throw new EvioException("Bad evio format: not enough data to read event (bad bank len?)");
                    }
                    EvioNode node = EvioNode.extractEventNode(this.bufferNode, blockNode, position, this.eventCount + i);
                    this.eventNodes.add(node);
                    byteLen = 8 + 4 * node.dataLen;
                    position += byteLen;
                    if (byteLen >= 8 && (bytesLeft -= byteLen) >= 0) continue;
                    throw new EvioException("Bad evio format: bad bank length");
                }
                this.eventCount += blockEventCount;
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.bufferNode = null;
            throw new EvioException("Bad evio format", e);
        }
    }

    private IEvioCompactReader.ReadStatus readFirstHeader() {
        int pos = this.initialPosition;
        if (this.byteBuffer.limit() - pos < 32) {
            System.out.println("EvioCompactReader: EOF, remaining = " + (this.byteBuffer.limit() - pos));
            this.byteBuffer.clear();
            return IEvioCompactReader.ReadStatus.END_OF_FILE;
        }
        try {
            this.byteOrder = this.byteBuffer.order();
            int magicNumber = this.byteBuffer.getInt(pos + 28);
            if (magicNumber != -1059454720) {
                this.byteOrder = this.byteOrder == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                this.byteBuffer.order(this.byteOrder);
                magicNumber = this.byteBuffer.getInt(pos + 28);
                if (magicNumber != -1059454720) {
                    System.out.println("ERROR reread magic # (" + magicNumber + ") & still not right");
                    Utilities.printBuffer(this.byteBuffer, 0, 8, "Tried to parse this as block header");
                    return IEvioCompactReader.ReadStatus.EVIO_EXCEPTION;
                }
            }
            int bitInfo = this.byteBuffer.getInt(pos + 20);
            this.evioVersion = bitInfo & 0xFF;
            if (this.evioVersion < 4) {
                System.out.println("EvioCompactReader: unsupported evio version (" + this.evioVersion + ")");
                return IEvioCompactReader.ReadStatus.EVIO_EXCEPTION;
            }
            this.hasDictionary = BlockHeaderV4.hasDictionary(bitInfo);
            this.firstBlockHeaderWords = this.byteBuffer.getInt(pos + 8);
            this.blockHeader.setSize(this.byteBuffer.getInt(pos + 0));
            this.blockHeader.setNumber(this.byteBuffer.getInt(pos + 4));
            this.blockHeader.setHeaderLength(this.firstBlockHeaderWords);
            this.blockHeader.setEventCount(this.byteBuffer.getInt(pos + 12));
            this.blockHeader.setReserved1(this.byteBuffer.getInt(pos + 0));
            this.blockHeader.parseToBitInfo(bitInfo);
            this.blockHeader.setVersion(this.evioVersion);
            this.blockHeader.setReserved2(0);
            this.blockHeader.setMagicNumber(magicNumber);
            this.blockHeader.setByteOrder(this.byteOrder);
        }
        catch (EvioException a) {
            this.byteBuffer.clear();
            Utilities.printBuffer(this.byteBuffer, 0, 8, "Tried to parse this as block header");
            return IEvioCompactReader.ReadStatus.EVIO_EXCEPTION;
        }
        catch (BufferUnderflowException a) {
            System.err.println("EvioCompactReader: end of Buffer: " + a.getMessage());
            this.byteBuffer.clear();
            return IEvioCompactReader.ReadStatus.UNKNOWN_ERROR;
        }
        return IEvioCompactReader.ReadStatus.SUCCESS;
    }

    @Override
    public IBlockHeader getFirstBlockHeader() {
        return this.blockHeader;
    }

    private void readDictionary() throws EvioException {
        int originalPos = this.byteBuffer.position();
        int pos = this.initialPosition + 4 * this.firstBlockHeaderWords;
        int length = this.byteBuffer.getInt(pos);
        if (length < 1) {
            throw new EvioException("Bad value for dictionary length");
        }
        this.byteBuffer.getInt(pos += 4);
        pos += 4;
        int eventDataSizeBytes = 4 * (length - 1);
        byte[] bytes = new byte[eventDataSizeBytes];
        try {
            this.byteBuffer.position(pos);
            this.byteBuffer.get(bytes, 0, eventDataSizeBytes);
        }
        catch (Exception e) {
            throw new EvioException("Problems reading buffer");
        }
        String[] strs = BaseStructure.unpackRawBytesToStrings(bytes, 0);
        if (strs == null) {
            throw new EvioException("Data in bad format");
        }
        this.dictionaryXML = strs[0];
        this.byteBuffer.position(originalPos);
    }

    private EvioNode scanStructure(int eventNumber) {
        EvioNode node = this.eventNodes.get(eventNumber - 1);
        if (node.scanned) {
            node.clearLists();
        }
        node.scanned = true;
        EvioNode.scanStructure(node);
        return node;
    }

    @Override
    public List<EvioNode> searchEvent(int eventNumber, int tag, int num) throws EvioException {
        if (tag < 0 || num < 0 || eventNumber < 1 || eventNumber > this.eventCount) {
            throw new EvioException("bad arg value(s)");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        ArrayList<EvioNode> returnList = new ArrayList<EvioNode>(100);
        ArrayList<EvioNode> list = this.scanStructure((int)eventNumber).allNodes;
        for (EvioNode enode : list) {
            if (enode.tag != tag || enode.num != num) continue;
            returnList.add(enode);
        }
        return returnList;
    }

    @Override
    public List<EvioNode> searchEvent(int eventNumber, String dictName, EvioXMLDictionary dictionary) throws EvioException {
        int num;
        int tag;
        if (dictName == null) {
            throw new EvioException("null dictionary entry name");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        if (dictionary == null && this.hasDictionary) {
            dictionary = this.getDictionary();
        }
        if (dictionary != null) {
            tag = dictionary.getTag(dictName);
            num = dictionary.getNum(dictName);
            if (tag == -1 || num == -1) {
                throw new EvioException("no dictionary entry for " + dictName);
            }
        } else {
            throw new EvioException("no dictionary available");
        }
        return this.searchEvent(eventNumber, tag, num);
    }

    @Override
    public ByteBuffer removeEvent(int eventNumber) throws EvioException {
        EvioNode eventNode;
        if (eventNumber < 1) {
            throw new EvioException("event number must be > 0");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        try {
            eventNode = this.eventNodes.get(eventNumber - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EvioException("event " + eventNumber + " does not exist", e);
        }
        return this.removeStructure(eventNode);
    }

    @Override
    public ByteBuffer removeStructure(EvioNode removeNode) throws EvioException {
        EvioNode parent;
        int i;
        if (removeNode == null) {
            return this.byteBuffer;
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        if (removeNode.isObsolete()) {
            return this.byteBuffer;
        }
        EvioNode eventNode = null;
        boolean isEvent = false;
        boolean foundNode = false;
        int removeNodePlace = 0;
        block4: for (EvioNode ev : this.eventNodes) {
            removeNodePlace = 0;
            if (removeNode == ev) {
                eventNode = ev;
                isEvent = true;
                foundNode = true;
                break;
            }
            for (EvioNode n : ev.allNodes) {
                if (removeNode == n) {
                    eventNode = ev;
                    foundNode = true;
                    break block4;
                }
                ++removeNodePlace;
            }
        }
        if (!foundNode) {
            throw new EvioException("removeNode not found in any event");
        }
        removeNode.setObsolete(true);
        int removeDataLen = removeNode.getTotalBytes();
        int removeWordLen = removeDataLen / 4;
        int startPos = removeNode.pos + removeDataLen;
        int moveLen = this.initialPosition + 4 * this.validDataWords - startPos;
        ByteBuffer moveBuffer = this.byteBuffer.duplicate().order(this.byteBuffer.order());
        moveBuffer.position(startPos).limit(startPos + moveLen);
        this.byteBuffer.position(removeNode.pos);
        this.byteBuffer.put(moveBuffer);
        this.validDataWords -= removeWordLen;
        this.byteBuffer.position(this.initialPosition);
        this.byteBuffer.limit(4 * this.validDataWords + this.initialPosition);
        int place = eventNode.place;
        for (i = 0; i < this.eventCount; ++i) {
            int level = 0;
            ArrayList<EvioNode> nodeList = this.eventNodes.get((int)i).allNodes;
            for (EvioNode n : nodeList) {
                if (i > place) {
                    n.pos -= removeDataLen;
                    n.dataPos -= removeDataLen;
                } else if (i == place && !isEvent && level > removeNodePlace) {
                    n.pos -= removeDataLen;
                    n.dataPos -= removeDataLen;
                }
                ++level;
            }
        }
        place = eventNode.blockNode.place;
        for (i = 0; i < this.blockCount; ++i) {
            if (i <= place) continue;
            this.blockNodes.get((Object)Integer.valueOf((int)i)).pos -= removeDataLen;
        }
        if (isEvent) {
            --this.eventCount;
            --eventNode.blockNode.count;
            this.byteBuffer.putInt(eventNode.blockNode.pos + 12, eventNode.blockNode.count);
        }
        eventNode.blockNode.len -= removeWordLen;
        this.byteBuffer.putInt(eventNode.blockNode.pos, eventNode.blockNode.len);
        EvioNode removeParent = parent = removeNode.parentNode;
        while (parent != null) {
            parent.len -= removeWordLen;
            parent.dataLen -= removeWordLen;
            int parentPos = parent.pos;
            parent.clearIntArray();
            switch (parent.getDataTypeObj()) {
                case BANK: 
                case ALSOBANK: {
                    this.byteBuffer.putInt(parentPos, parent.len);
                    break;
                }
                case SEGMENT: 
                case ALSOSEGMENT: 
                case TAGSEGMENT: {
                    if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
                        this.byteBuffer.putShort(parentPos + 2, (short)parent.len);
                        break;
                    }
                    this.byteBuffer.putShort(parentPos, (short)parent.len);
                    break;
                }
                default: {
                    throw new EvioException("internal programming error");
                }
            }
            parent = parent.parentNode;
        }
        if (removeParent != null) {
            removeParent.removeChild(removeNode);
        }
        if (isEvent) {
            this.eventNodes.remove(removeNode);
        }
        return this.byteBuffer;
    }

    @Override
    public ByteBuffer addStructure(int eventNumber, ByteBuffer addBuffer) throws EvioException {
        int i;
        EvioNode eventNode;
        if (addBuffer == null || addBuffer.remaining() < 8) {
            throw new EvioException("null, empty, or non-evio format buffer arg");
        }
        if (addBuffer.order() != this.byteOrder) {
            throw new EvioException("trying to add wrong endian buffer");
        }
        if (eventNumber < 1) {
            throw new EvioException("event number must be > 0");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        try {
            eventNode = this.eventNodes.get(eventNumber - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EvioException("event " + eventNumber + " does not exist", e);
        }
        int endPos = eventNode.dataPos + 4 * eventNode.dataLen;
        int origAddBufPos = addBuffer.position();
        int appendDataLen = addBuffer.remaining();
        if (appendDataLen % 4 != 0) {
            throw new EvioException("data added is not in evio format");
        }
        eventNode.clearIntArray();
        int appendDataWordLen = appendDataLen / 4;
        DataType eventDataType = eventNode.getDataTypeObj();
        ByteBuffer newBuffer = ByteBuffer.allocate(4 * this.validDataWords + appendDataLen);
        newBuffer.order(this.byteOrder);
        this.byteBuffer.limit(endPos).position(this.initialPosition);
        newBuffer.put(this.byteBuffer);
        int newBankBufPos = newBuffer.position();
        newBuffer.put(addBuffer);
        this.byteBuffer.limit(4 * this.validDataWords + this.initialPosition).position(endPos);
        newBuffer.put(this.byteBuffer);
        newBuffer.flip();
        this.byteBuffer.position(this.initialPosition);
        addBuffer.position(origAddBufPos);
        int place = eventNode.place;
        for (i = 0; i < this.eventCount; ++i) {
            for (EvioNode n : this.eventNodes.get((int)i).allNodes) {
                n.bufferNode.setBuffer(newBuffer);
                if (i > place) {
                    n.pos += appendDataLen - this.initialPosition;
                    n.dataPos += appendDataLen - this.initialPosition;
                    continue;
                }
                n.pos -= this.initialPosition;
                n.dataPos -= this.initialPosition;
            }
        }
        place = eventNode.blockNode.place;
        for (i = 0; i < this.blockCount; ++i) {
            if (i > place) {
                this.blockNodes.get((Object)Integer.valueOf((int)i)).pos += appendDataLen - this.initialPosition;
                continue;
            }
            this.blockNodes.get((Object)Integer.valueOf((int)i)).pos -= this.initialPosition;
        }
        this.byteBuffer = newBuffer;
        this.initialPosition = newBuffer.position();
        this.validDataWords += appendDataWordLen;
        int eventLenPos = eventNode.pos;
        eventNode.blockNode.len += appendDataWordLen;
        newBuffer.putInt(eventNode.blockNode.pos, eventNode.blockNode.len);
        eventNode.len += appendDataWordLen;
        eventNode.dataLen += appendDataWordLen;
        switch (eventDataType) {
            case BANK: 
            case ALSOBANK: {
                newBuffer.putInt(eventLenPos, eventNode.len);
                break;
            }
            case SEGMENT: 
            case ALSOSEGMENT: 
            case TAGSEGMENT: {
                if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
                    newBuffer.putShort(eventLenPos + 2, (short)eventNode.len);
                    break;
                }
                newBuffer.putShort(eventLenPos, (short)eventNode.len);
                break;
            }
            default: {
                throw new EvioException("internal programming error");
            }
        }
        if (eventNode.scanned) {
            EvioNode newNode = (EvioNode)eventNode.clone();
            newNode.isEvent = false;
            newNode.eventNode = newNode.parentNode = eventNode;
            EvioNode.extractNode(newNode, newBankBufPos);
            eventNode.addChild(newNode);
            EvioNode.scanStructure(newNode);
        }
        return newBuffer;
    }

    @Override
    public ByteBuffer getData(EvioNode node) throws EvioException {
        return this.getData(node, false);
    }

    @Override
    public ByteBuffer getData(EvioNode node, boolean copy) throws EvioException {
        return node.getByteData(copy);
    }

    @Override
    public ByteBuffer getEventBuffer(int eventNumber) throws EvioException {
        return this.getEventBuffer(eventNumber, false);
    }

    @Override
    public ByteBuffer getEventBuffer(int eventNumber, boolean copy) throws EvioException {
        EvioNode node;
        if (eventNumber < 1) {
            throw new EvioException("event number must be > 0");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        try {
            node = this.eventNodes.get(eventNumber - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EvioException("event " + eventNumber + " does not exist");
        }
        return node.getStructureBuffer(copy);
    }

    @Override
    public ByteBuffer getStructureBuffer(EvioNode node) throws EvioException {
        return this.getStructureBuffer(node, false);
    }

    @Override
    public ByteBuffer getStructureBuffer(EvioNode node, boolean copy) throws EvioException {
        if (node == null) {
            throw new EvioException("node arg is null");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        return node.getStructureBuffer(copy);
    }

    @Override
    public void close() {
        this.byteBuffer.position(this.initialPosition);
        this.closed = true;
    }

    @Override
    public int getEventCount() {
        return this.eventCount;
    }

    @Override
    public int getBlockCount() {
        return this.blockCount;
    }

    @Override
    public void toFile(String fileName) throws EvioException, IOException {
        if (fileName == null) {
            throw new EvioException("null fileName arg");
        }
        File f = new File(fileName);
        this.toFile(f);
    }

    @Override
    public void toFile(File file) throws EvioException, IOException {
        if (file == null) {
            throw new EvioException("null file arg");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        int pos = this.byteBuffer.position();
        FileOutputStream fos = new FileOutputStream(file);
        FileChannel channel = fos.getChannel();
        channel.write(this.byteBuffer);
        channel.close();
        this.byteBuffer.position(pos);
    }
}

