/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.hipo;

public enum HeaderType {
    EVIO_RECORD(0),
    EVIO_FILE(1),
    EVIO_FILE_EXTENDED(2),
    EVIO_TRAILER(3),
    HIPO_RECORD(4),
    HIPO_FILE(5),
    HIPO_FILE_EXTENDED(6),
    HIPO_TRAILER(7);

    private int value;
    private static HeaderType[] intToType;

    private HeaderType(int val) {
        this.value = val;
    }

    int getValue() {
        return this.value;
    }

    public boolean isEvioFileHeader() {
        return this == EVIO_FILE || this == EVIO_FILE_EXTENDED;
    }

    public boolean isHipoFileHeader() {
        return this == HIPO_FILE || this == HIPO_FILE_EXTENDED;
    }

    public boolean isFileHeader() {
        return this.isEvioFileHeader() | this.isHipoFileHeader();
    }

    public static HeaderType getHeaderType(int val) {
        if (val > 7 || val < 0) {
            return null;
        }
        return intToType[val];
    }

    public static String getName(int val) {
        if (val > 7 || val < 0) {
            return null;
        }
        HeaderType type = HeaderType.getHeaderType(val);
        if (type == null) {
            return null;
        }
        return type.name();
    }

    static {
        intToType = new HeaderType[8];
        HeaderType[] arr$ = HeaderType.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            HeaderType type;
            HeaderType.intToType[type.value] = type = arr$[i$];
        }
    }
}

