/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.graphics;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.CompositeData;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.graphics.EventInfoPanel;
import org.jlab.coda.jevio.graphics.HeaderPanel;

public class EventTreePanel
extends JPanel
implements TreeSelectionListener {
    private HeaderPanel headerPanel = new HeaderPanel();
    private EventInfoPanel eventInfoPanel = new EventInfoPanel();
    private JTree tree;
    private EvioEvent event;
    private JTextArea textArea;
    private JProgressBar progressBar;
    private boolean intsInHex;
    LinkedList<SelectionInfo> structureSelection = new LinkedList();

    public EventTreePanel() {
        this.setLayout(new BorderLayout());
        this.addComponents();
    }

    public LinkedList<SelectionInfo> getStructureSelection() {
        return this.structureSelection;
    }

    public void setIntsInHex(boolean intsInHex) {
        this.intsInHex = intsInHex;
    }

    public EventInfoPanel getEventInfoPanel() {
        return this.eventInfoPanel;
    }

    public HeaderPanel getHeaderPanel() {
        return this.headerPanel;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void refreshDisplay() {
        this.valueChanged(null);
    }

    public void refreshDescription() {
        this.headerPanel.setDescription(this.event);
    }

    protected void addComponents() {
        this.add((Component)this.eventInfoPanel, "North");
        this.add((Component)this.createTree(), "Center");
        this.add((Component)this.createTextArea(), "West");
        this.progressBar = new JProgressBar();
        this.progressBar.setBorder(BorderFactory.createTitledBorder(null, "progress", 4, 2, null, Color.blue));
        this.progressBar.setPreferredSize(new Dimension(200, 20));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.headerPanel, "Center");
        panel.add((Component)this.progressBar, "West");
        this.add((Component)panel, "South");
    }

    private JScrollPane createTree() {
        this.tree = new JTree();
        this.tree.setModel(null);
        this.tree.setBorder(BorderFactory.createTitledBorder(null, "EVIO event tree", 4, 2, null, Color.blue));
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setShowsRootHandles(true);
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().setView(this.tree);
        return scrollPane;
    }

    private JScrollPane createTextArea() {
        this.textArea = new JTextArea();
        this.textArea.setBorder(BorderFactory.createTitledBorder(null, "Data", 4, 2, null, Color.blue));
        this.textArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().setView(this.textArea);
        scrollPane.setPreferredSize(new Dimension(200, 1000));
        return scrollPane;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        BaseStructure structure = (BaseStructure)this.tree.getLastSelectedPathComponent();
        this.textArea.setText("");
        int blankLineEveryNth = 5;
        if (structure == null) {
            return;
        }
        this.headerPanel.setHeader(structure);
        this.structureSelection.clear();
        if (structure.isLeaf()) {
            Object[] pathItems;
            TreePath selectionPath = this.tree.getSelectionPath();
            if (selectionPath != null && (pathItems = selectionPath.getPath()) != null && pathItems.length > 0) {
                for (int i = 0; i < pathItems.length; ++i) {
                    BaseStructure bs = (BaseStructure)pathItems[i];
                    int pos = 0;
                    BaseStructure parent = bs.getParent();
                    if (parent != null) {
                        Iterator<BaseStructure> iter = parent.getChildren().iterator();
                        int j = 0;
                        while (iter.hasNext()) {
                            BaseStructure bsKid = iter.next();
                            if (bsKid == bs) {
                                pos = j;
                                break;
                            }
                            ++j;
                        }
                    }
                    this.structureSelection.add(new SelectionInfo(bs.getHeader().getTag(), pos));
                }
            }
            int lineCounter = 1;
            int index = 1;
            BaseStructureHeader header = structure.getHeader();
            switch (header.getDataType()) {
                case DOUBLE64: {
                    double[] doubledata = structure.getDoubleData();
                    if (doubledata != null) {
                        for (double d : doubledata) {
                            String s = String.format("[%02d]  %15.11e", index++, d);
                            this.textArea.append(s);
                            if (lineCounter >= doubledata.length) continue;
                            if (lineCounter % blankLineEveryNth == 0) {
                                this.textArea.append("\n\n");
                            } else {
                                this.textArea.append("\n");
                            }
                            ++lineCounter;
                        }
                        break;
                    }
                    this.textArea.append("null data\n");
                    break;
                }
                case FLOAT32: {
                    float[] floatdata = structure.getFloatData();
                    if (floatdata != null) {
                        for (float d : floatdata) {
                            String s = String.format("[%02d]  %10.6e", index++, Float.valueOf(d));
                            this.textArea.append(s);
                            if (lineCounter >= floatdata.length) continue;
                            if (lineCounter % blankLineEveryNth == 0) {
                                this.textArea.append("\n\n");
                            } else {
                                this.textArea.append("\n");
                            }
                            ++lineCounter;
                        }
                        break;
                    }
                    this.textArea.append("null data\n");
                    break;
                }
                case LONG64: 
                case ULONG64: {
                    long[] longdata = structure.getLongData();
                    if (longdata != null) {
                        for (long i : longdata) {
                            String s = this.intsInHex ? String.format("[%02d]  %#018X", index++, i) : String.format("[%02d]  %d", index++, i);
                            this.textArea.append(s);
                            if (lineCounter >= longdata.length) continue;
                            if (lineCounter % blankLineEveryNth == 0) {
                                this.textArea.append("\n\n");
                            } else {
                                this.textArea.append("\n");
                            }
                            ++lineCounter;
                        }
                        break;
                    }
                    this.textArea.append("null data\n");
                    break;
                }
                case INT32: 
                case UINT32: {
                    int[] intdata = structure.getIntData();
                    if (intdata != null) {
                        for (int i : intdata) {
                            String s = this.intsInHex ? String.format("[%02d]  %#010X", index++, i) : String.format("[%02d]  %d", index++, i);
                            this.textArea.append(s);
                            if (lineCounter >= intdata.length) continue;
                            if (lineCounter % blankLineEveryNth == 0) {
                                this.textArea.append("\n\n");
                            } else {
                                this.textArea.append("\n");
                            }
                            ++lineCounter;
                        }
                        break;
                    }
                    this.textArea.append("null data\n");
                    break;
                }
                case SHORT16: 
                case USHORT16: {
                    short[] shortdata = structure.getShortData();
                    if (shortdata != null) {
                        for (short i : shortdata) {
                            String s = this.intsInHex ? String.format("[%02d]  %#06X", index++, i) : String.format("[%02d]  %d", index++, i);
                            this.textArea.append(s);
                            if (lineCounter >= shortdata.length) continue;
                            if (lineCounter % blankLineEveryNth == 0) {
                                this.textArea.append("\n\n");
                            } else {
                                this.textArea.append("\n");
                            }
                            ++lineCounter;
                        }
                        break;
                    }
                    this.textArea.append("null data\n");
                    break;
                }
                case CHAR8: 
                case UCHAR8: {
                    byte[] bytedata = structure.getByteData();
                    if (bytedata != null) {
                        for (byte i : bytedata) {
                            String s = String.format("[%02d]  %d", index++, i);
                            this.textArea.append(s);
                            if (lineCounter >= bytedata.length) continue;
                            if (lineCounter % blankLineEveryNth == 0) {
                                this.textArea.append("\n\n");
                            } else {
                                this.textArea.append("\n");
                            }
                            ++lineCounter;
                        }
                        break;
                    }
                    this.textArea.append("null data\n");
                    break;
                }
                case CHARSTAR8: {
                    String[] stringdata;
                    for (String str : stringdata = structure.getStringData()) {
                        String s;
                        this.textArea.append((s = String.format("[%02d]  %s\n", index++, str)) != null ? s : "null data\n");
                    }
                    break;
                }
                case COMPOSITE: {
                    try {
                        CompositeData[] cData = structure.getCompositeData();
                        if (cData != null) {
                            for (int i = 0; i < cData.length; ++i) {
                                this.textArea.append("composite data object ");
                                this.textArea.append(i + ":\n");
                                this.textArea.append(cData[i].toString(this.intsInHex));
                                this.textArea.append("\n\n");
                            }
                            break;
                        }
                        this.textArea.append("null data\n");
                    }
                    catch (EvioException e) {}
                    break;
                }
            }
        }
        this.tree.repaint();
    }

    public EvioEvent getEvent() {
        return this.event;
    }

    public void setEvent(EvioEvent event) {
        this.event = event;
        if (event != null) {
            this.tree.setModel(event.getTreeModel());
            this.headerPanel.setHeader(event);
            this.eventInfoPanel.setEventNumber(event.getEventNumber());
            this.expandAll();
            if (this.structureSelection.size() > 0) {
                BaseStructure parent = (BaseStructure)event.getTreeModel().getRoot();
                SelectionInfo info = this.structureSelection.get(0);
                if (info.tag != parent.getHeader().getTag()) {
                    return;
                }
                Object[] objs = new Object[this.structureSelection.size()];
                objs[0] = parent;
                for (int i = 1; i < this.structureSelection.size(); ++i) {
                    info = this.structureSelection.get(i);
                    if (info.pos + 1 > parent.getChildCount()) {
                        return;
                    }
                    BaseStructure kid = parent.getChildren().get(info.pos);
                    if (info.tag != kid.getHeader().getTag()) {
                        return;
                    }
                    parent = kid;
                    objs[i] = parent;
                }
                this.tree.setSelectionPath(new TreePath(objs));
            }
        } else {
            this.tree.setModel(null);
            this.headerPanel.setHeader(null);
            this.eventInfoPanel.setEventNumber(0);
        }
    }

    public void expandAll() {
        if (this.tree != null) {
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                this.tree.expandRow(i);
            }
        }
    }

    private class SelectionInfo {
        int tag;
        int pos;

        SelectionInfo(int tag, int pos) {
            this.tag = tag;
            this.pos = pos;
        }
    }
}

