/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioDictionaryEntry;
import org.jlab.coda.jevio.INameProvider;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EvioXMLDictionary
implements INameProvider {
    private static String DICT_TOP_LEVEL = "xmlDict";
    private static String ENTRY = "xmldumpDictEntry";
    private static String ENTRY_ALT = "dictEntry";
    private static String ENTRY_BANK = "bank";
    private static String ENTRY_LEAF = "leaf";
    private static String DESCRIPTION = "description";
    private static String FORMAT = "format";
    private static String TYPE = "type";
    private static String NAME = "name";
    private static String TAG = "tag";
    private static String NUM = "num";
    private String delimiter = ".";
    private LinkedHashMap<EvioDictionaryEntry, String> dictMap = new LinkedHashMap(100);
    private LinkedHashMap<Integer, String> tagOnlyMap = new LinkedHashMap(100);
    private LinkedHashMap<String, EvioDictionaryEntry> reverseMap = new LinkedHashMap(100);
    private Node topLevelDoc;
    private String stringRepresentation;
    private String xmlRepresentation;

    public EvioXMLDictionary(File file) {
        this(EvioXMLDictionary.getDomObject(file));
    }

    public EvioXMLDictionary(File file, String delimiter) {
        this(EvioXMLDictionary.getDomObject(file), delimiter);
    }

    public EvioXMLDictionary(String xmlString) {
        this(EvioXMLDictionary.getDomObject(xmlString));
    }

    public EvioXMLDictionary(String xmlString, String delimiter) {
        this(EvioXMLDictionary.getDomObject(xmlString), delimiter);
    }

    public EvioXMLDictionary(Document domDocument) {
        this(domDocument, null);
    }

    public EvioXMLDictionary(Document domDocument, String delimiter) {
        Node topNode;
        NodeList list;
        if (domDocument == null) {
            return;
        }
        if (delimiter != null) {
            this.delimiter = delimiter;
        }
        if ((list = domDocument.getElementsByTagName(DICT_TOP_LEVEL)).getLength() < 1) {
            return;
        }
        this.topLevelDoc = topNode = list.item(0);
        NodeList kidList = topNode.getChildNodes();
        if (kidList.getLength() < 1) {
            return;
        }
        for (int index = 0; index < kidList.getLength(); ++index) {
            NodeList children;
            Node node = kidList.item(index);
            if (node == null || !node.getNodeName().equalsIgnoreCase(ENTRY) && !node.getNodeName().equalsIgnoreCase(ENTRY_ALT) || !node.hasAttributes()) continue;
            int num = 0;
            int tag = 0;
            boolean badEntry = false;
            String description = null;
            String format = null;
            String type = null;
            String tagStr = null;
            String numStr = null;
            String name = null;
            NamedNodeMap map = node.getAttributes();
            Node attrNode = map.getNamedItem(NAME);
            if (attrNode != null) {
                name = attrNode.getNodeValue();
            }
            if ((attrNode = map.getNamedItem(TAG)) != null) {
                tagStr = attrNode.getNodeValue();
                try {
                    tag = Integer.decode(tagStr);
                    if (tag < 0) {
                        badEntry = true;
                    }
                }
                catch (NumberFormatException e) {
                    badEntry = true;
                }
            }
            if ((attrNode = map.getNamedItem(NUM)) != null) {
                numStr = attrNode.getNodeValue();
                try {
                    num = Integer.decode(numStr);
                    if (num < 0) {
                        badEntry = true;
                    }
                }
                catch (NumberFormatException e) {
                    badEntry = true;
                }
            }
            if ((attrNode = map.getNamedItem(TYPE)) != null) {
                type = attrNode.getNodeValue();
            }
            if ((children = node.getChildNodes()).getLength() > 0) {
                for (int i = 0; i < children.getLength(); ++i) {
                    Node childNode = children.item(i);
                    if (childNode == null || !childNode.getNodeName().equalsIgnoreCase(DESCRIPTION)) continue;
                    description = childNode.getTextContent();
                    if (!childNode.hasAttributes() || (attrNode = (map = childNode.getAttributes()).getNamedItem(FORMAT)) == null) break;
                    format = attrNode.getNodeValue();
                    break;
                }
            }
            if (name == null || tagStr == null || badEntry) {
                System.out.println("IGNORING badly formatted dictionary entry 1: name = " + name);
                continue;
            }
            if (numStr == null && (type != null || description != null || format != null)) {
                System.out.println("IGNORING badly formatted dictionary entry 2: name = " + name);
                continue;
            }
            if (numStr == null) {
                if (!this.tagOnlyMap.containsKey(tag)) {
                    boolean forgetIt = false;
                    for (EvioDictionaryEntry data : this.dictMap.keySet()) {
                        if (data.getTag() != tag) continue;
                        forgetIt = true;
                        break;
                    }
                    if (!forgetIt) {
                        this.tagOnlyMap.put(tag, name);
                        continue;
                    }
                    System.out.println("IGNORING duplicate dictionary entry: name = " + name);
                    continue;
                }
                System.out.println("IGNORING duplicate dictionary entry: name = " + name);
                continue;
            }
            EvioDictionaryEntry key = new EvioDictionaryEntry(tag, num, type, description, format);
            if (!this.dictMap.containsKey(key) && !this.reverseMap.containsKey(name)) {
                this.dictMap.put(key, name);
                this.reverseMap.put(name, key);
                continue;
            }
            System.out.println("IGNORING duplicate dictionary entry: name = " + name);
        }
        this.addHierachicalDictEntries(kidList, null);
    }

    public Map<String, EvioDictionaryEntry> getMap() {
        return Collections.unmodifiableMap(this.reverseMap);
    }

    private void addHierachicalDictEntries(NodeList kidList, String parentName) {
        if (kidList == null || kidList.getLength() < 1) {
            return;
        }
        for (int i = 0; i < kidList.getLength(); ++i) {
            NodeList children;
            Node numNode;
            Node tagNode;
            Node node = kidList.item(i);
            if (node == null) continue;
            boolean isLeaf = node.getNodeName().equalsIgnoreCase(ENTRY_LEAF);
            if (!node.getNodeName().equalsIgnoreCase(ENTRY_BANK) && !isLeaf || !node.hasAttributes()) continue;
            int num = 0;
            int tag = 0;
            boolean badEntry = false;
            String description = null;
            String format = null;
            String type = null;
            String tagStr = null;
            String numStr = null;
            String name = null;
            NamedNodeMap map = node.getAttributes();
            Node attrNode = map.getNamedItem(NAME);
            if (attrNode != null) {
                name = attrNode.getNodeValue();
            }
            if ((tagNode = map.getNamedItem(TAG)) != null) {
                tagStr = tagNode.getNodeValue();
                try {
                    tag = Integer.decode(tagStr);
                    if (tag < 0) {
                        badEntry = true;
                    }
                }
                catch (NumberFormatException e) {
                    badEntry = true;
                }
            }
            if ((numNode = map.getNamedItem(NUM)) != null) {
                numStr = numNode.getNodeValue();
                try {
                    num = Integer.decode(numStr);
                    if (num < 0) {
                        badEntry = true;
                    }
                }
                catch (NumberFormatException e) {
                    badEntry = true;
                }
            }
            if ((attrNode = map.getNamedItem(TYPE)) != null) {
                type = attrNode.getNodeValue();
            }
            if ((children = node.getChildNodes()).getLength() > 0) {
                for (int j = 0; j < children.getLength(); ++j) {
                    Node childNode = children.item(j);
                    if (childNode == null || !childNode.getNodeName().equalsIgnoreCase(DESCRIPTION)) continue;
                    description = childNode.getTextContent();
                    if (!childNode.hasAttributes() || (attrNode = (map = childNode.getAttributes()).getNamedItem(FORMAT)) == null) break;
                    format = attrNode.getNodeValue();
                    break;
                }
            }
            if (name == null || tagStr == null || badEntry) {
                System.out.println("IGNORING badly formatted dictionary entry 3: name = " + name);
                continue;
            }
            if (numStr == null && (type != null || description != null || format != null)) {
                System.out.println("IGNORING badly formatted dictionary entry 4: name = " + name);
                continue;
            }
            if (parentName != null) {
                name = parentName + this.delimiter + name;
            }
            if (numStr == null) {
                if (!this.tagOnlyMap.containsKey(tag)) {
                    boolean forgetIt = false;
                    for (EvioDictionaryEntry data : this.dictMap.keySet()) {
                        if (data.getTag() != tag) continue;
                        forgetIt = true;
                        break;
                    }
                    if (!forgetIt) {
                        this.tagOnlyMap.put(tag, name);
                    } else {
                        System.out.println("IGNORING duplicate dictionary entry: name = " + name);
                    }
                } else {
                    System.out.println("IGNORING duplicate dictionary entry: name = " + name);
                }
            } else {
                EvioDictionaryEntry key = new EvioDictionaryEntry(tag, num, type, description, format);
                if (!this.dictMap.containsKey(key) && !this.reverseMap.containsKey(name)) {
                    this.dictMap.put(key, name);
                    this.reverseMap.put(name, key);
                } else {
                    System.out.println("IGNORING duplicate dictionary entry: name = " + name);
                }
            }
            if (!isLeaf) {
                this.addHierachicalDictEntries(node.getChildNodes(), name);
                continue;
            }
            if (!node.hasChildNodes()) continue;
            System.out.println("IGNORING children of \"leaf\" element " + name);
        }
    }

    @Override
    public String getName(BaseStructure structure) {
        int tag = structure.getHeader().getTag();
        int num = structure.getHeader().getNumber();
        return this.getName(tag, num);
    }

    public String getName(int tag, int num) {
        EvioDictionaryEntry key = new EvioDictionaryEntry(tag, num);
        String name = this.dictMap.get(key);
        if (name == null && (name = this.tagOnlyMap.get(tag)) == null) {
            return "???";
        }
        return name;
    }

    public String getDescription(int tag, int num) {
        EvioDictionaryEntry key = new EvioDictionaryEntry(tag, num);
        String name = this.dictMap.get(key);
        if (name == null) {
            System.out.println("getDescription: no entry for that key (tag/num)");
            return null;
        }
        EvioDictionaryEntry origKey = this.reverseMap.get(name);
        if (origKey == null) {
            System.out.println("getDescription: no orig entry for that key (tag/num)");
            return null;
        }
        return origKey.getDescription();
    }

    public String getDescription(String name) {
        EvioDictionaryEntry entry = this.reverseMap.get(name);
        if (entry == null) {
            return null;
        }
        return entry.getDescription();
    }

    public String getFormat(int tag, int num) {
        EvioDictionaryEntry key = new EvioDictionaryEntry(tag, num);
        String name = this.dictMap.get(key);
        if (name == null) {
            return null;
        }
        EvioDictionaryEntry origKey = this.reverseMap.get(name);
        if (origKey == null) {
            return null;
        }
        return origKey.getFormat();
    }

    public String getFormat(String name) {
        EvioDictionaryEntry data = this.reverseMap.get(name);
        if (data == null) {
            return null;
        }
        return data.getFormat();
    }

    public DataType getType(int tag, int num) {
        EvioDictionaryEntry key = new EvioDictionaryEntry(tag, num);
        String name = this.dictMap.get(key);
        if (name == null) {
            return null;
        }
        EvioDictionaryEntry origKey = this.reverseMap.get(name);
        if (origKey == null) {
            return null;
        }
        return origKey.getType();
    }

    public DataType getType(String name) {
        EvioDictionaryEntry data = this.reverseMap.get(name);
        if (data == null) {
            return null;
        }
        return data.getType();
    }

    public int[] getTagNum(String name) {
        EvioDictionaryEntry pair = this.reverseMap.get(name);
        if (pair == null) {
            return null;
        }
        return new int[]{pair.getTag(), pair.getNum()};
    }

    public int getTag(String name) {
        EvioDictionaryEntry data = this.reverseMap.get(name);
        if (data == null) {
            for (Map.Entry<Integer, String> entry : this.tagOnlyMap.entrySet()) {
                if (!entry.getValue().equals(name)) continue;
                return entry.getKey();
            }
            return -1;
        }
        return data.getTag();
    }

    public int getNum(String name) {
        EvioDictionaryEntry data = this.reverseMap.get(name);
        if (data == null) {
            return -1;
        }
        return data.getNum();
    }

    private static Document getDomObject(File file) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document dom = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            dom = db.parse(file);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dom;
    }

    private static Document getDomObject(String xmlString) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document dom = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
            dom = db.parse(bais);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dom;
    }

    public String toXML() {
        return this.nodeToString(this.topLevelDoc);
    }

    private String nodeToString(Node node) {
        if (this.xmlRepresentation != null) {
            return this.xmlRepresentation;
        }
        StringWriter sw = new StringWriter();
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 3);
            Transformer t = transformerFactory.newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("indent", "yes");
            t.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            return null;
        }
        this.xmlRepresentation = sw.toString();
        return this.xmlRepresentation;
    }

    public String toString() {
        if (this.stringRepresentation != null) {
            return this.stringRepresentation;
        }
        StringBuilder sb = new StringBuilder(4096);
        sb.append("-- Dictionary --\n");
        for (String name : this.reverseMap.keySet()) {
            EvioDictionaryEntry pair = this.reverseMap.get(name);
            sb.append(String.format("tag: %-15s num: %-15s name: %s\n", pair.getTag(), pair.getNum(), name));
        }
        this.stringRepresentation = sb.toString();
        return this.stringRepresentation;
    }
}

