/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.Console;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.coda.jevio.EvioCompactReader;
import org.jlab.coda.jevio.EvioNode;

public class GagikTest {
    int[] int1;
    byte[] byte1;
    short[] short1;
    long[] long1;
    float[] float1;
    double[] double1;
    String[] string1;
    int runLoops = 2;
    int bufferLoops = 20000;
    int dataElementCount = 3;
    int skip = 0;
    int bufSize = 200000;
    boolean oldEvio = false;
    boolean useBuf = false;
    ByteBuffer buffer;
    String fileName = "/home/timmer/evioTestFiles/svt45_000016.evio.0";
    ByteOrder order = ByteOrder.BIG_ENDIAN;

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                GagikTest.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-count")) {
                this.dataElementCount = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-loops")) {
                this.bufferLoops = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-size")) {
                this.bufSize = Integer.parseInt(args[i + 1]);
                System.out.println("SET buf size to " + this.bufSize);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-runs")) {
                this.runLoops = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-skip")) {
                this.skip = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-f")) {
                this.fileName = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-little")) {
                this.order = ByteOrder.LITTLE_ENDIAN;
                continue;
            }
            if (args[i].equalsIgnoreCase("-old")) {
                this.oldEvio = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-buf")) {
                this.useBuf = true;
                continue;
            }
            GagikTest.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java CompactBuilderTest\n        [-count <elements>]  number of data elements of each type\n        [-loops <loops>]     number of times to loop\n        [-size <buf size>]   use buffer of this size (bytes)\n        [-runs <runs>]       number of runs\n        [-skip <skip>]       number of runs to skip before finding avg\n        [-f <file>]          output to file\n        [-little]            use little endian buffer\n        [-old]               use old (orig) evio interface\n        [-buf]               use buffer (not array) in new interface\n        [-h]                 print this help\n");
    }

    public GagikTest(String[] args) {
        this.decodeCommandLine(args);
    }

    public static void main(String[] args) {
        GagikTest test = new GagikTest(args);
        test.run();
    }

    public void run() {
        System.out.println("Wait for it:");
        Console c = System.console();
        c.readLine();
        System.out.println("Opening file");
        try {
            EvioCompactReader evioReader = new EvioCompactReader(new File(this.fileName));
            System.out.println("Opened file");
            int count = evioReader.getEventCount();
            System.out.println("Count = " + count);
            for (int i = 0; i < count; ++i) {
                EvioNode node = evioReader.getEvent(i + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Done getting events");
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

