/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioException;

public final class SegmentHeader
extends BaseStructureHeader {
    public SegmentHeader() {
    }

    public SegmentHeader(int tag, DataType dataType) {
        super(tag, dataType);
    }

    @Override
    public int getHeaderLength() {
        return 1;
    }

    @Override
    protected void toArray(byte[] bArray, int offset, ByteOrder order) {
        try {
            if (order == ByteOrder.BIG_ENDIAN) {
                bArray[offset] = (byte)this.tag;
                bArray[offset + 1] = (byte)(this.dataType.getValue() & 0x3F | this.padding << 6);
                ByteDataTransformer.toBytes((short)this.length, order, bArray, offset + 2);
            } else {
                ByteDataTransformer.toBytes((short)this.length, order, bArray, offset);
                bArray[offset + 2] = (byte)(this.dataType.getValue() & 0x3F | this.padding << 6);
                bArray[offset + 3] = (byte)this.tag;
            }
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(512);
        sb.append(String.format("segment length: %d\n", this.length));
        sb.append(String.format("number:         %d\n", this.number));
        sb.append(String.format("data type:      %s\n", this.getDataTypeName()));
        sb.append(String.format("tag:            %d\n", this.tag));
        sb.append(String.format("padding:        %d\n", this.padding));
        return sb.toString();
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        if (byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            byteBuffer.put((byte)this.tag);
            byteBuffer.put((byte)(this.dataType.getValue() & 0x3F | this.padding << 6));
            byteBuffer.putShort((short)this.length);
        } else {
            byteBuffer.putShort((short)this.length);
            byteBuffer.put((byte)(this.dataType.getValue() & 0x3F | this.padding << 6));
            byteBuffer.put((byte)this.tag);
        }
        return 4;
    }
}

