/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import org.jlab.coda.jevio.DataType;

public class EvioDictionaryEntry {
    private final Integer tag;
    private final Integer num;
    private DataType type;
    private final String format;
    private final String description;

    EvioDictionaryEntry(Integer tag) {
        this(tag, null, null, null, null);
    }

    EvioDictionaryEntry(Integer tag, Integer num) {
        this(tag, num, null, null, null);
    }

    EvioDictionaryEntry(Integer tag, Integer num, String type) {
        this(tag, num, type, null, null);
    }

    EvioDictionaryEntry(Integer tag, Integer num, String type, String description, String format) {
        this.tag = tag;
        this.num = num;
        this.format = format;
        this.description = description;
        this.type = null;
        if (type != null) {
            try {
                this.type = DataType.valueOf(type.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
    }

    public final int hashCode() {
        int hashTag = this.tag.hashCode();
        int hashNum = this.num.hashCode();
        return (hashTag + hashNum) * hashNum + hashTag;
    }

    public final boolean equals(Object other) {
        if (other instanceof EvioDictionaryEntry) {
            EvioDictionaryEntry otherPair = (EvioDictionaryEntry)other;
            boolean match = this.tag.equals(otherPair.tag);
            if (this.num == null) {
                if (otherPair.num != null) {
                    return false;
                }
            } else {
                match &= this.num.equals(otherPair.num);
            }
            return match;
        }
        return false;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder(80);
        builder.append("(tag=");
        builder.append(this.tag);
        if (this.num != null) {
            builder.append(",num =");
            builder.append(this.num);
        }
        if (this.type != null) {
            builder.append(",type=");
            builder.append((Object)this.type);
        }
        builder.append(")");
        return builder.toString();
    }

    public final Integer getTag() {
        return this.tag;
    }

    public final Integer getNum() {
        return this.num;
    }

    public final DataType getType() {
        return this.type;
    }

    public final String getFormat() {
        return this.format;
    }

    public final String getDescription() {
        return this.description;
    }
}

