/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.BlockHeaderV4;
import org.jlab.coda.jevio.BlockNode;
import org.jlab.coda.jevio.BufferNode;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.EvioXMLDictionary;

public class EvioCompactReader {
    private static final int MAGIC_OFFSET = 28;
    private static final int VERSION_OFFSET = 20;
    private static final int BLOCK_SIZE_OFFSET = 0;
    private static final int BLOCK_NUMBER = 4;
    private static final int BLOCK_HEADER_SIZE_OFFSET = 8;
    private static final int BLOCK_EVENT_COUNT = 12;
    private static final int BLOCK_RESERVED_1 = 16;
    private static final int VERSION_MASK = 255;
    public final ArrayList<EvioNode> eventNodes = new ArrayList(1000);
    private final HashMap<Integer, BlockNode> blockNodes = new HashMap(20);
    private int eventCount = -1;
    private int evioVersion;
    private ByteOrder byteOrder;
    private ByteOrder fileByteOrder;
    private int blockCount = -1;
    private int firstBlockHeaderWords;
    private BlockHeaderV4 blockHeader = new BlockHeaderV4();
    private boolean isFile;
    private boolean hasDictionary;
    private String dictionaryXML;
    private EvioXMLDictionary dictionary;
    private ByteBuffer byteBuffer;
    BufferNode bufferNode;
    private int initialPosition;
    private int validDataWords;
    private boolean closed;
    private boolean fast = true;
    private MappedByteBuffer mappedByteBuffer;
    private String path;
    private long fileSize;

    private static void printBuffer(ByteBuffer buf, int lenInInts) {
        IntBuffer ibuf = buf.asIntBuffer();
        lenInInts = lenInInts > ibuf.capacity() ? ibuf.capacity() : lenInInts;
        for (int i = 0; i < lenInInts; ++i) {
            System.out.println("  Buf(" + i + ") = 0x" + Integer.toHexString(ibuf.get(i)));
        }
    }

    public EvioCompactReader(String path) throws EvioException, IOException {
        this(new File(path));
    }

    public EvioCompactReader(File file) throws EvioException, IOException {
        if (file == null) {
            throw new EvioException("File arg is null");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        this.path = file.getAbsolutePath();
        FileChannel fileChannel = fileInputStream.getChannel();
        this.fileSize = fileChannel.size();
        if (this.fileSize > Integer.MAX_VALUE) {
            throw new EvioException("file too large (must be < 2.1475GB)");
        }
        this.mapFile(fileChannel);
        fileChannel.close();
        this.initialPosition = 0;
        if (this.readFirstHeader() != ReadStatus.SUCCESS) {
            throw new IOException("Failed reading first block header/dictionary");
        }
        this.generateEventPositionTable();
        this.isFile = true;
    }

    public EvioCompactReader(ByteBuffer byteBuffer) throws EvioException {
        if (byteBuffer == null) {
            throw new EvioException("Buffer arg is null");
        }
        this.initialPosition = byteBuffer.position();
        this.byteBuffer = byteBuffer;
        if (this.readFirstHeader() != ReadStatus.SUCCESS) {
            throw new EvioException("Failed reading first block header/dictionary");
        }
        this.generateEventPositionTable();
    }

    public void setBuffer(ByteBuffer buf) throws EvioException {
        this.setBuffer(buf, true);
    }

    synchronized void setBuffer(ByteBuffer buf, boolean fast) throws EvioException {
        if (buf == null) {
            throw new EvioException("arg is null");
        }
        this.close();
        this.fast = fast;
        if (!fast) {
            this.blockNodes.clear();
        }
        this.eventNodes.clear();
        this.blockCount = -1;
        this.eventCount = -1;
        this.dictionaryXML = null;
        this.initialPosition = buf.position();
        this.byteBuffer = buf;
        if (this.readFirstHeader() != ReadStatus.SUCCESS) {
            throw new EvioException("Failed reading first block header/dictionary");
        }
        this.generateEventPositionTable();
        this.closed = false;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public int getEvioVersion() {
        return this.evioVersion;
    }

    public String getPath() {
        return this.path;
    }

    public ByteOrder getFileByteOrder() {
        return this.fileByteOrder;
    }

    public synchronized String getDictionaryXML() throws EvioException {
        if (this.dictionaryXML != null) {
            return this.dictionaryXML;
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        if (this.hasDictionary) {
            try {
                this.readDictionary();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.dictionaryXML;
    }

    public synchronized EvioXMLDictionary getDictionary() throws EvioException {
        if (this.dictionary != null) {
            return this.dictionary;
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        if (this.hasDictionary) {
            try {
                if (this.dictionaryXML == null) {
                    this.readDictionary();
                }
                this.dictionary = new EvioXMLDictionary(this.dictionaryXML);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.dictionary;
    }

    public boolean hasDictionary() {
        return this.hasDictionary;
    }

    private void mapFile(FileChannel inputChannel) throws IOException {
        long sz = inputChannel.size();
        this.mappedByteBuffer = inputChannel.map(FileChannel.MapMode.READ_ONLY, 0L, sz);
        this.byteBuffer = this.mappedByteBuffer;
    }

    public MappedByteBuffer getMappedByteBuffer() {
        return this.mappedByteBuffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public long fileSize() {
        return this.fileSize;
    }

    public EvioNode getEvent(int eventNumber) {
        try {
            return this.eventNodes.get(eventNumber - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public EvioNode getScannedEvent(int eventNumber) {
        try {
            return this.scanStructure(eventNumber);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    private void generateEventPositionTable() throws EvioException {
        boolean firstBlock = true;
        boolean hasDictionary = false;
        this.bufferNode = new BufferNode(this.byteBuffer);
        int position = this.initialPosition;
        int bytesLeft = this.byteBuffer.limit() - position;
        this.blockCount = 0;
        this.eventCount = 0;
        this.validDataWords = 0;
        BlockNode blockNode = null;
        BlockNode previousBlockNode = null;
        try {
            while (bytesLeft > 0) {
                int byteLen;
                if (bytesLeft < 32) {
                    throw new EvioException("Bad evio format: extra " + bytesLeft + " bytes at file end");
                }
                int blockSize = this.byteBuffer.getInt(position);
                int byteInfo = this.byteBuffer.getInt(position + 20);
                int blockHdrSize = this.byteBuffer.getInt(position + 8);
                int blockEventCount = this.byteBuffer.getInt(position + 12);
                int magicNum = this.byteBuffer.getInt(position + 28);
                if (magicNum != -1059454720) {
                    throw new EvioException("Bad evio format: block header magic # incorrect");
                }
                if (blockSize < 8 || blockHdrSize < 8) {
                    throw new EvioException("Bad evio format (block: len = " + blockSize + ", blk header len = " + blockHdrSize + ")");
                }
                if (4 * blockSize > bytesLeft) {
                    throw new EvioException("Bad evio format: not enough data to read block");
                }
                if (!this.fast) {
                    blockNode = new BlockNode();
                    blockNode.pos = position;
                    blockNode.len = blockSize;
                    blockNode.count = blockEventCount;
                    this.blockNodes.put(this.blockCount, blockNode);
                    this.bufferNode.blockNodes.add(blockNode);
                    ++this.blockCount;
                    blockNode.place = blockNode.place;
                    if (previousBlockNode != null) {
                        previousBlockNode.nextBlock = blockNode;
                    } else {
                        previousBlockNode = blockNode;
                    }
                }
                this.validDataWords += blockSize;
                if (firstBlock) {
                    hasDictionary = BlockHeaderV4.hasDictionary(byteInfo);
                }
                position += 4 * blockHdrSize;
                bytesLeft -= 4 * blockHdrSize;
                if (firstBlock && hasDictionary) {
                    firstBlock = false;
                    byteLen = 4 * (this.byteBuffer.getInt(position) + 1);
                    position += byteLen;
                    bytesLeft -= byteLen;
                }
                for (int i = 0; i < blockEventCount; ++i) {
                    if (bytesLeft < 8) {
                        throw new EvioException("Bad evio format: not enough data to read event (bad bank len?)");
                    }
                    EvioNode node = EvioCompactReader.extractEventNode(this.bufferNode, blockNode, position, this.eventCount + i);
                    this.eventNodes.add(node);
                    if (!this.fast) {
                        blockNode.allEventNodes.add(node);
                    }
                    byteLen = 8 + 4 * node.dataLen;
                    position += byteLen;
                    if (byteLen >= 8 && (bytesLeft -= byteLen) >= 0) continue;
                    throw new EvioException("Bad evio format: bad bank length");
                }
                this.eventCount += blockEventCount;
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.bufferNode = null;
            throw new EvioException("Bad evio format", e);
        }
    }

    private ReadStatus readFirstHeader() {
        int pos = this.initialPosition;
        if (this.byteBuffer.limit() - pos < 32) {
            this.byteBuffer.clear();
            return ReadStatus.END_OF_FILE;
        }
        try {
            this.byteOrder = this.byteBuffer.order();
            int magicNumber = this.byteBuffer.getInt(pos + 28);
            if (magicNumber != -1059454720) {
                this.byteOrder = this.byteOrder == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                this.byteBuffer.order(this.byteOrder);
                magicNumber = this.byteBuffer.getInt(pos + 28);
                if (magicNumber != -1059454720) {
                    System.out.println("ERROR reread magic # (" + magicNumber + ") & still not right");
                    return ReadStatus.EVIO_EXCEPTION;
                }
            }
            this.fileByteOrder = this.byteOrder;
            int bitInfo = this.byteBuffer.getInt(pos + 20);
            this.evioVersion = bitInfo & 0xFF;
            if (this.evioVersion < 4) {
                System.out.println("EvioCompactReader: unsupported evio version (" + this.evioVersion + ")");
                return ReadStatus.EVIO_EXCEPTION;
            }
            this.hasDictionary = BlockHeaderV4.bitInfoHasDictionary(bitInfo);
            this.firstBlockHeaderWords = this.byteBuffer.getInt(pos + 8);
            this.blockHeader.setSize(this.byteBuffer.getInt(pos + 0));
            this.blockHeader.setNumber(this.byteBuffer.getInt(pos + 4));
            this.blockHeader.setHeaderLength(this.firstBlockHeaderWords);
            this.blockHeader.setEventCount(this.byteBuffer.getInt(pos + 12));
            this.blockHeader.setReserved1(this.byteBuffer.getInt(pos + 16));
            this.blockHeader.parseToBitInfo(bitInfo);
            this.blockHeader.setVersion(this.evioVersion);
            this.blockHeader.setReserved2(0);
            this.blockHeader.setMagicNumber(magicNumber);
            this.blockHeader.setByteOrder(this.byteOrder);
        }
        catch (EvioException a) {
            this.byteBuffer.clear();
            return ReadStatus.EVIO_EXCEPTION;
        }
        catch (BufferUnderflowException a) {
            System.err.println("ERROR endOfBuffer " + a);
            this.byteBuffer.clear();
            return ReadStatus.UNKNOWN_ERROR;
        }
        return ReadStatus.SUCCESS;
    }

    public BlockHeaderV4 getFirstBlockHeader() {
        return this.blockHeader;
    }

    private void readDictionary() throws EvioException {
        int originalPos = this.byteBuffer.position();
        int pos = this.initialPosition + 4 * this.firstBlockHeaderWords;
        int length = this.byteBuffer.getInt(pos);
        if (length < 1) {
            throw new EvioException("Bad value for dictionary length");
        }
        this.byteBuffer.getInt(pos += 4);
        pos += 4;
        int eventDataSizeBytes = 4 * (length - 1);
        byte[] bytes = new byte[eventDataSizeBytes];
        try {
            this.byteBuffer.position(pos);
            this.byteBuffer.get(bytes, 0, eventDataSizeBytes);
        }
        catch (Exception e) {
            throw new EvioException("Problems reading buffer");
        }
        String[] strs = BaseStructure.unpackRawBytesToStrings(bytes, 0);
        if (strs == null) {
            throw new EvioException("Data in bad format");
        }
        this.dictionaryXML = strs[0];
        this.byteBuffer.position(originalPos);
    }

    private static EvioNode extractEventNode(BufferNode bufferNode, BlockNode blockNode, int position, int place) throws EvioException {
        ByteBuffer buffer = bufferNode.buffer;
        if (buffer.remaining() < 8) {
            throw new EvioException("buffer underflow");
        }
        EvioNode node = new EvioNode(position, place, bufferNode, blockNode);
        node.len = buffer.getInt(position);
        node.dataPos = position + 8;
        node.dataLen = node.len - 1;
        if (buffer.remaining() < 4 * (node.len + 1)) {
            throw new EvioException("buffer underflow");
        }
        position += 4;
        if (buffer.order() == ByteOrder.BIG_ENDIAN) {
            node.tag = buffer.getShort(position) & 0xFFFF;
            position += 2;
            int dt = buffer.get(position++) & 0xFF;
            node.dataType = dt & 0x3F;
            node.pad = dt >>> 6;
            if (dt == 64) {
                node.dataType = DataType.TAGSEGMENT.getValue();
                node.pad = 0;
            }
            node.num = buffer.get(position) & 0xFF;
        } else {
            node.num = buffer.get(position++) & 0xFF;
            int dt = buffer.get(position++) & 0xFF;
            node.dataType = dt & 0x3F;
            node.pad = dt >>> 6;
            if (dt == 64) {
                node.dataType = DataType.TAGSEGMENT.getValue();
                node.pad = 0;
            }
            node.tag = buffer.getShort(position) & 0xFFFF;
        }
        return node;
    }

    private static void scanStructure(EvioNode node) {
        int position;
        DataType type = node.getDataTypeObj();
        if (!type.isStructure()) {
            return;
        }
        int endingPos = position + 4 * node.dataLen;
        ByteBuffer buffer = node.bufferNode.buffer;
        switch (type) {
            case BANK: 
            case ALSOBANK: {
                int dataLen;
                for (position = node.dataPos; position <= endingPos - 8; position += 4 * dataLen) {
                    int num;
                    int pad;
                    int dataType;
                    int dt;
                    int tag;
                    int len = buffer.getInt(position);
                    dataLen = len - 1;
                    position += 4;
                    if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                        tag = buffer.getShort(position) & 0xFFFF;
                        position += 2;
                        dt = buffer.get(position++) & 0xFF;
                        dataType = dt & 0x3F;
                        pad = dt >>> 6;
                        if (dt == 64) {
                            dataType = DataType.TAGSEGMENT.getValue();
                            pad = 0;
                        }
                        num = buffer.get(position++) & 0xFF;
                    } else {
                        num = buffer.get(position++) & 0xFF;
                        dt = buffer.get(position++) & 0xFF;
                        dataType = dt & 0x3F;
                        pad = dt >>> 6;
                        if (dt == 64) {
                            dataType = DataType.TAGSEGMENT.getValue();
                            pad = 0;
                        }
                        tag = buffer.getShort(position) & 0xFFFF;
                        position += 2;
                    }
                    EvioNode kidNode = (EvioNode)node.clone();
                    kidNode.len = len;
                    kidNode.pos = position - 8;
                    kidNode.type = DataType.BANK.getValue();
                    kidNode.dataLen = dataLen;
                    kidNode.dataPos = position;
                    kidNode.dataType = dataType;
                    kidNode.pad = pad;
                    kidNode.tag = tag;
                    kidNode.num = num;
                    kidNode.isEvent = false;
                    kidNode.parentNode = node;
                    node.addChild(kidNode);
                    if (!DataType.isStructure(dataType)) continue;
                    EvioCompactReader.scanStructure(kidNode);
                }
                break;
            }
            case SEGMENT: 
            case ALSOSEGMENT: {
                while (position <= endingPos - 4) {
                    int len;
                    int pad;
                    int dataType;
                    int dt;
                    int tag;
                    if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                        tag = buffer.get(position++) & 0xFF;
                        dt = buffer.get(position++) & 0xFF;
                        dataType = dt & 0x3F;
                        pad = dt >>> 6;
                        if (dt == 64) {
                            dataType = DataType.TAGSEGMENT.getValue();
                            pad = 0;
                        }
                        len = buffer.getShort(position) & 0xFFFF;
                        position += 2;
                    } else {
                        len = buffer.getShort(position) & 0xFFFF;
                        position += 2;
                        dt = buffer.get(position++) & 0xFF;
                        dataType = dt & 0x3F;
                        pad = dt >>> 6;
                        if (dt == 64) {
                            dataType = DataType.TAGSEGMENT.getValue();
                            pad = 0;
                        }
                        tag = buffer.get(position++) & 0xFF;
                    }
                    EvioNode kidNode = (EvioNode)node.clone();
                    kidNode.len = len;
                    kidNode.pos = position - 4;
                    kidNode.type = DataType.SEGMENT.getValue();
                    kidNode.dataLen = len;
                    kidNode.dataPos = position;
                    kidNode.dataType = dataType;
                    kidNode.pad = pad;
                    kidNode.tag = tag;
                    kidNode.num = 0;
                    kidNode.isEvent = false;
                    kidNode.parentNode = node;
                    node.addChild(kidNode);
                    if (DataType.isStructure(dataType)) {
                        EvioCompactReader.scanStructure(kidNode);
                    }
                    position += 4 * len;
                }
                break;
            }
            case TAGSEGMENT: {
                while (position <= endingPos - 4) {
                    int len;
                    int dataType;
                    int tag;
                    int temp;
                    if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                        temp = buffer.getShort(position) & 0xFFFF;
                        tag = temp >>> 4;
                        dataType = temp & 0xF;
                        len = buffer.getShort(position += 2) & 0xFFFF;
                        position += 2;
                    } else {
                        len = buffer.getShort(position) & 0xFFFF;
                        temp = buffer.getShort(position += 2) & 0xFFFF;
                        position += 2;
                        tag = temp >>> 4;
                        dataType = temp & 0xF;
                    }
                    EvioNode kidNode = (EvioNode)node.clone();
                    kidNode.len = len;
                    kidNode.pos = position - 4;
                    kidNode.type = DataType.TAGSEGMENT.getValue();
                    kidNode.dataLen = len;
                    kidNode.dataPos = position;
                    kidNode.dataType = dataType;
                    kidNode.pad = 0;
                    kidNode.tag = tag;
                    kidNode.num = 0;
                    kidNode.isEvent = false;
                    kidNode.parentNode = node;
                    node.addChild(kidNode);
                    if (DataType.isStructure(dataType)) {
                        EvioCompactReader.scanStructure(kidNode);
                    }
                    position += 4 * len;
                }
                break;
            }
        }
    }

    private EvioNode scanStructure(int eventNumber) {
        EvioNode node = this.eventNodes.get(eventNumber - 1);
        if (node.scanned) {
            node.clearLists();
        }
        node.scanned = true;
        EvioCompactReader.scanStructure(node);
        return node;
    }

    public synchronized List<EvioNode> searchEvent(int eventNumber, int tag, int num) throws EvioException {
        if (tag < 0 || num < 0 || eventNumber < 1 || eventNumber > this.eventCount) {
            throw new EvioException("bad arg value(s)");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        ArrayList<EvioNode> returnList = new ArrayList<EvioNode>(100);
        ArrayList<EvioNode> list = this.scanStructure((int)eventNumber).allNodes;
        for (EvioNode enode : list) {
            if (enode.tag != tag || enode.num != num) continue;
            returnList.add(enode);
        }
        return returnList;
    }

    public synchronized List<EvioNode> searchEvent(int eventNumber, String dictName, EvioXMLDictionary dictionary) throws EvioException {
        int num;
        int tag;
        if (dictName == null) {
            throw new EvioException("null dictionary entry name");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        if (dictionary == null && this.hasDictionary) {
            dictionary = this.getDictionary();
        }
        if (dictionary != null) {
            tag = dictionary.getTag(dictName);
            num = dictionary.getNum(dictName);
            if (tag == -1 || num == -1) {
                throw new EvioException("no dictionary entry for " + dictName);
            }
        } else {
            throw new EvioException("no dictionary available");
        }
        return this.searchEvent(eventNumber, tag, num);
    }

    public synchronized ByteBuffer addStructure(int eventNumber, ByteBuffer addBuffer) throws EvioException {
        EvioNode eventNode;
        if (addBuffer == null || addBuffer.remaining() < 8) {
            throw new EvioException("null, empty, or non-evio format buffer arg");
        }
        if (addBuffer.order() != this.byteOrder) {
            throw new EvioException("trying to add wrong endian buffer");
        }
        if (eventNumber < 1) {
            throw new EvioException("event number must be > 0");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        try {
            eventNode = this.eventNodes.get(eventNumber - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EvioException("event " + eventNumber + " does not exist", e);
        }
        int endPos = eventNode.dataPos + 4 * eventNode.dataLen;
        int origAddBufPos = addBuffer.position();
        int appendDataLen = addBuffer.remaining();
        if (appendDataLen % 4 != 0) {
            throw new EvioException("data added is not in evio format");
        }
        int appendDataWordLen = appendDataLen / 4;
        DataType eventDataType = DataType.getDataType(eventNode.dataType);
        ByteBuffer newBuffer = ByteBuffer.allocate(4 * this.validDataWords + appendDataLen);
        newBuffer.order(this.byteOrder);
        this.byteBuffer.limit(endPos).position(this.initialPosition);
        newBuffer.put(this.byteBuffer);
        newBuffer.put(addBuffer);
        this.byteBuffer.limit(4 * this.validDataWords + this.initialPosition).position(endPos);
        newBuffer.put(this.byteBuffer);
        newBuffer.flip();
        this.byteBuffer.position(this.initialPosition);
        addBuffer.position(origAddBufPos);
        for (int i = 0; i < this.eventCount; ++i) {
            EvioNode eNode = this.eventNodes.get(i);
            eNode.pos -= this.initialPosition;
            eNode.dataPos -= this.initialPosition;
            if (i <= eventNode.place) continue;
            eNode.pos += appendDataLen;
            eNode.dataPos += appendDataLen;
        }
        for (int i = 0; i < this.blockCount; ++i) {
            BlockNode bNode = this.blockNodes.get(i);
            bNode.pos -= this.initialPosition;
            if (i <= eventNode.blockNode.place) continue;
            bNode.pos += appendDataLen;
        }
        this.byteBuffer = newBuffer;
        this.initialPosition = newBuffer.position();
        if (this.isFile) {
            this.isFile = false;
            this.mappedByteBuffer = null;
        }
        int blockLenPos = eventNode.blockNode.pos;
        int eventLenPos = eventNode.pos;
        eventNode.blockNode.len += appendDataWordLen;
        newBuffer.putInt(blockLenPos, eventNode.blockNode.len);
        eventNode.len += appendDataWordLen;
        eventNode.dataLen += appendDataWordLen;
        switch (eventDataType) {
            case BANK: 
            case ALSOBANK: {
                newBuffer.putInt(eventLenPos, eventNode.len);
                break;
            }
            case SEGMENT: 
            case ALSOSEGMENT: 
            case TAGSEGMENT: {
                if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
                    newBuffer.putShort(eventLenPos + 2, (short)eventNode.len);
                    break;
                }
                newBuffer.putShort(eventLenPos, (short)eventNode.len);
                break;
            }
            default: {
                throw new EvioException("internal programming error");
            }
        }
        return newBuffer;
    }

    public ByteBuffer getData(EvioNode node) throws EvioException {
        return this.getData(node, false);
    }

    public synchronized ByteBuffer getData(EvioNode node, boolean copy) throws EvioException {
        return node.getByteData(copy);
    }

    public ByteBuffer getEventBuffer(int eventNumber) throws EvioException {
        return this.getEventBuffer(eventNumber, false);
    }

    public synchronized ByteBuffer getEventBuffer(int eventNumber, boolean copy) throws EvioException {
        EvioNode node;
        if (eventNumber < 1) {
            throw new EvioException("event number must be > 0");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        try {
            node = this.eventNodes.get(eventNumber - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new EvioException("event " + eventNumber + " does not exist");
        }
        return node.getStructureBuffer(copy);
    }

    public ByteBuffer getStructureBuffer(EvioNode node) throws EvioException {
        return this.getStructureBuffer(node, false);
    }

    public synchronized ByteBuffer getStructureBuffer(EvioNode node, boolean copy) throws EvioException {
        if (node == null) {
            throw new EvioException("node arg is null");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        return node.getStructureBuffer(copy);
    }

    public synchronized void close() {
        this.byteBuffer.position(this.initialPosition);
        this.closed = true;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public void toFile(String fileName) throws EvioException, IOException {
        if (fileName == null) {
            throw new EvioException("null fileName arg");
        }
        File f = new File(fileName);
        this.toFile(f);
    }

    public synchronized void toFile(File file) throws EvioException, IOException {
        if (file == null) {
            throw new EvioException("null file arg");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        int pos = this.byteBuffer.position();
        FileOutputStream fos = new FileOutputStream(file);
        FileChannel channel = fos.getChannel();
        channel.write(this.byteBuffer);
        channel.close();
        this.byteBuffer.position(pos);
    }

    public static enum ReadStatus {
        SUCCESS,
        END_OF_FILE,
        EVIO_EXCEPTION,
        UNKNOWN_ERROR;

    }
}

