/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.jlab.coda.jevio.BlockNode;
import org.jlab.coda.jevio.BufferNode;
import org.jlab.coda.jevio.DataType;

public final class EvioNode
implements Cloneable {
    int len;
    int tag;
    int num;
    int pad;
    int pos;
    int type;
    int dataLen;
    int dataPos;
    int dataType;
    boolean isEvent;
    BlockNode blockNode;
    BufferNode bufferNode;
    ArrayList<EvioNode> childNodes;
    int place;
    boolean scanned;
    ArrayList<EvioNode> allNodes;
    EvioNode eventNode;
    EvioNode parentNode;

    EvioNode() {
        this.allNodes = new ArrayList(100);
        this.allNodes.add(this);
    }

    EvioNode(int pos, int place, BufferNode bufferNode, BlockNode blockNode) {
        this.pos = pos;
        this.place = place;
        this.blockNode = blockNode;
        this.bufferNode = bufferNode;
        this.isEvent = true;
        this.type = DataType.BANK.getValue();
        this.allNodes = new ArrayList(100);
        this.allNodes.add(this);
    }

    EvioNode(int tag, int num, int pos, int dataPos, DataType type, DataType dataType, BufferNode bufferNode) {
        this.tag = tag;
        this.num = num;
        this.pos = pos;
        this.dataPos = dataPos;
        this.type = type.getValue();
        this.dataType = dataType.getValue();
        this.bufferNode = bufferNode;
    }

    public Object clone() {
        try {
            EvioNode result = (EvioNode)super.clone();
            result.childNodes = null;
            return result;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(100);
        builder.append("tag = ");
        builder.append(this.tag);
        builder.append(", num = ");
        builder.append(this.num);
        builder.append(", type = ");
        builder.append(this.type);
        builder.append(", dataType = ");
        builder.append(this.dataType);
        builder.append(", pos = ");
        builder.append(this.pos);
        builder.append(", dataPos = ");
        builder.append(this.dataPos);
        builder.append(", len = ");
        builder.append(this.len);
        builder.append(", dataLen = ");
        builder.append(this.dataLen);
        return builder.toString();
    }

    public void clearLists() {
        if (this.childNodes != null) {
            this.childNodes.clear();
        }
        if (this.allNodes != null) {
            this.allNodes.clear();
            if (this.eventNode == null) {
                this.allNodes.add(this);
            } else {
                this.allNodes.add(this.eventNode);
            }
        }
    }

    public synchronized void addChild(EvioNode childNode) {
        if (this.childNodes == null) {
            this.childNodes = new ArrayList(100);
        }
        this.childNodes.add(childNode);
        if (this.allNodes != null) {
            this.allNodes.add(childNode);
        }
    }

    public ArrayList<EvioNode> getAllNodes() {
        return this.allNodes;
    }

    public ArrayList<EvioNode> getChildNodes() {
        return this.childNodes;
    }

    public EvioNode getChildAt(int index) {
        if (this.childNodes == null || this.childNodes.size() < index + 1) {
            return null;
        }
        return this.childNodes.get(index);
    }

    public int getChildCount() {
        if (this.childNodes == null) {
            return 0;
        }
        return this.childNodes.size();
    }

    public BufferNode getBufferNode() {
        return this.bufferNode;
    }

    public int getLength() {
        return this.len;
    }

    public int getTotalBytes() {
        return 4 * this.dataLen + this.dataPos - this.pos;
    }

    public int getTag() {
        return this.tag;
    }

    public int getNum() {
        return this.num;
    }

    public int getPad() {
        return this.pad;
    }

    public int getPosition() {
        return this.pos;
    }

    public int getType() {
        return this.type;
    }

    public DataType getTypeObj() {
        return DataType.getDataType(this.type);
    }

    public int getDataLength() {
        return this.dataLen;
    }

    public int getDataPosition() {
        return this.dataPos;
    }

    public int getDataType() {
        return this.dataType;
    }

    public DataType getDataTypeObj() {
        return DataType.getDataType(this.dataType);
    }

    public int getEventNumber() {
        return this.place + 1;
    }

    public boolean isEvent() {
        return this.isEvent;
    }

    public void updateTag(int newTag) {
        ByteBuffer buffer = this.bufferNode.buffer;
        switch (DataType.getDataType(this.type)) {
            case BANK: 
            case ALSOBANK: {
                if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                    buffer.putShort(this.pos + 4, (short)newTag);
                } else {
                    buffer.putShort(this.pos + 6, (short)newTag);
                }
                return;
            }
            case SEGMENT: 
            case ALSOSEGMENT: {
                if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                    buffer.put(this.pos, (byte)newTag);
                } else {
                    buffer.put(this.pos + 3, (byte)newTag);
                }
                return;
            }
            case TAGSEGMENT: {
                short compositeWord = (short)(this.tag << 4 | this.dataType & 0xF);
                if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                    buffer.putShort(this.pos, compositeWord);
                } else {
                    buffer.putShort(this.pos + 2, compositeWord);
                }
                return;
            }
        }
    }

    public void updateNum(int newNum) {
        ByteBuffer buffer = this.bufferNode.buffer;
        switch (DataType.getDataType(this.type)) {
            case BANK: 
            case ALSOBANK: {
                if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                    buffer.put(this.pos + 7, (byte)newNum);
                } else {
                    buffer.put(this.pos + 4, (byte)newNum);
                }
                return;
            }
        }
    }

    public ByteBuffer getByteData(boolean copy) {
        ByteOrder order = this.bufferNode.buffer.order();
        ByteBuffer buffer = this.bufferNode.buffer.duplicate().order(order);
        buffer.limit(this.dataPos + 4 * this.dataLen - this.pad).position(this.dataPos);
        if (copy) {
            ByteBuffer newBuf = ByteBuffer.allocate(4 * this.dataLen - this.pad).order(order);
            newBuf.put(buffer);
            newBuf.flip();
            return newBuf;
        }
        return buffer.slice().order(order);
    }

    public ByteBuffer getStructureBuffer(boolean copy) {
        ByteOrder order = this.bufferNode.buffer.order();
        ByteBuffer buffer = this.bufferNode.buffer.duplicate().order(order);
        buffer.limit(this.dataPos + 4 * this.dataLen).position(this.pos);
        if (copy) {
            ByteBuffer newBuf = ByteBuffer.allocate(this.getTotalBytes()).order(order);
            newBuf.put(buffer);
            newBuf.flip();
            return newBuf;
        }
        return buffer.slice().order(order);
    }
}

