/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.List;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.CompositeData;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;

public class ByteDataTransformer {
    public static int[] getAsIntArray(byte[] bytes, ByteOrder byteOrder) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes).order(byteOrder);
        int intsize = bytes.length / 4;
        int[] array = new int[intsize];
        for (int i = 0; i < intsize; ++i) {
            array[i] = byteBuffer.getInt();
        }
        return array;
    }

    public static short[] getAsShortArray(byte[] bytes, ByteOrder byteOrder) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes).order(byteOrder);
        int shortsize = bytes.length / 2;
        short[] array = new short[shortsize];
        for (int i = 0; i < shortsize; ++i) {
            array[i] = byteBuffer.getShort();
        }
        return array;
    }

    public static short[] getAsShortArray(byte[] bytes, int padding, ByteOrder byteOrder) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes).order(byteOrder);
        int shortsize = bytes.length / 2;
        if (padding % 2 == 0) {
            shortsize -= padding / 2;
        }
        short[] array = new short[shortsize];
        for (int i = 0; i < shortsize; ++i) {
            array[i] = byteBuffer.getShort();
        }
        return array;
    }

    public static long[] getAsLongArray(byte[] bytes, ByteOrder byteOrder) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes).order(byteOrder);
        int longsize = bytes.length / 8;
        long[] array = new long[longsize];
        for (int i = 0; i < longsize; ++i) {
            array[i] = byteBuffer.getLong();
        }
        return array;
    }

    public static double[] getAsDoubleArray(byte[] bytes, ByteOrder byteOrder) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes).order(byteOrder);
        int doublesize = bytes.length / 8;
        double[] array = new double[doublesize];
        for (int i = 0; i < doublesize; ++i) {
            array[i] = byteBuffer.getDouble();
        }
        return array;
    }

    public static float[] getAsFloatArray(byte[] bytes, ByteOrder byteOrder) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes).order(byteOrder);
        int floatsize = bytes.length / 4;
        float[] array = new float[floatsize];
        for (int i = 0; i < floatsize; ++i) {
            array[i] = byteBuffer.getFloat();
        }
        return array;
    }

    public static final int shortBitsToInt(short shortVal) {
        return shortVal & 0xFFFF;
    }

    public static final int byteBitsToInt(byte byteVal) {
        return byteVal & 0xFF;
    }

    public static byte[] toByteArray(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        int size = byteBuffer.remaining();
        byte[] array = new byte[size];
        if (byteBuffer.hasArray() && byteBuffer.array().length == byteBuffer.capacity()) {
            System.arraycopy(byteBuffer.array(), byteBuffer.position(), array, 0, byteBuffer.remaining());
        } else {
            int pos = byteBuffer.position();
            byteBuffer.get(array, 0, size);
            byteBuffer.position(pos);
        }
        return array;
    }

    public static int[] toIntArray(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        IntBuffer ibuf = byteBuffer.asIntBuffer();
        int size = ibuf.limit();
        int[] array = new int[size];
        ibuf.get(array, 0, size);
        return array;
    }

    public static short[] toShortArray(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        ShortBuffer sbuf = byteBuffer.asShortBuffer();
        int size = sbuf.limit();
        short[] array = new short[size];
        sbuf.get(array, 0, size);
        return array;
    }

    public static long[] toLongArray(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        LongBuffer lbuf = byteBuffer.asLongBuffer();
        int size = lbuf.limit();
        long[] array = new long[size];
        lbuf.get(array, 0, size);
        return array;
    }

    public static float[] toFloatArray(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        FloatBuffer fbuf = byteBuffer.asFloatBuffer();
        int size = fbuf.limit();
        float[] array = new float[size];
        fbuf.get(array, 0, size);
        return array;
    }

    public static double[] toDoubleArray(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        DoubleBuffer dbuf = byteBuffer.asDoubleBuffer();
        int size = dbuf.limit();
        double[] array = new double[size];
        dbuf.get(array, 0, size);
        return array;
    }

    public static String[] toStringArray(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return null;
        }
        return BaseStructure.unpackRawBytesToStrings(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
    }

    public static final void intToBytes(int intVal, byte[] b, int off) {
        b[off] = (byte)(intVal >> 24);
        b[off + 1] = (byte)(intVal >> 16);
        b[off + 2] = (byte)(intVal >> 8);
        b[off + 3] = (byte)intVal;
    }

    public static final void shortToBytes(short val, byte[] b, int off) {
        b[off] = (byte)(val >> 8);
        b[off + 1] = (byte)val;
    }

    public static byte[] toBytes(short data, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return new byte[]{(byte)(data >>> 8), (byte)data};
        }
        return new byte[]{(byte)data, (byte)(data >>> 8)};
    }

    public static void toBytes(short data, ByteOrder byteOrder, byte[] dest, int off) throws EvioException {
        if (dest == null || dest.length < 2 + off || off < 0) {
            throw new EvioException("bad arg(s)");
        }
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            dest[off] = (byte)(data >>> 8);
            dest[off + 1] = (byte)data;
        } else {
            dest[off] = (byte)data;
            dest[off + 1] = (byte)(data >>> 8);
        }
    }

    public static byte[] toBytes(short[] data, ByteOrder byteOrder) throws EvioException {
        if (data == null) {
            return null;
        }
        if (data.length > 0x3FFFFFFF) {
            throw new EvioException("short array has too many elements to convert to byte array");
        }
        if (byteOrder == null) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        byte[] b = new byte[data.length * 2];
        ByteBuffer buf = ByteBuffer.wrap(b).order(byteOrder);
        ShortBuffer ib = buf.asShortBuffer();
        ib.put(data, 0, data.length);
        return b;
    }

    public static void toBytes(short[] data, ByteOrder byteOrder, byte[] dest, int off) throws EvioException {
        if (data == null || dest == null || dest.length < 2 * data.length + off || off < 0) {
            throw new EvioException("bad arg(s)");
        }
        if (data.length > 0x3FFFFFFF) {
            throw new EvioException("short array has too many elements to convert to byte array");
        }
        if (byteOrder == null) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        ByteBuffer buf = ByteBuffer.wrap(dest).order(byteOrder);
        buf.position(off);
        ShortBuffer ib = buf.asShortBuffer();
        ib.put(data, 0, data.length);
    }

    public static byte[] toBytes(int data, ByteOrder byteOrder) {
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            return new byte[]{(byte)(data >> 24), (byte)(data >> 16), (byte)(data >> 8), (byte)data};
        }
        return new byte[]{(byte)data, (byte)(data >> 8), (byte)(data >> 16), (byte)(data >> 24)};
    }

    public static void toBytes(int data, ByteOrder byteOrder, byte[] dest, int off) throws EvioException {
        if (dest == null || dest.length < 4 + off || off < 0) {
            throw new EvioException("bad arg(s)");
        }
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            dest[off] = (byte)(data >> 24);
            dest[off + 1] = (byte)(data >> 16);
            dest[off + 2] = (byte)(data >> 8);
            dest[off + 3] = (byte)data;
        } else {
            dest[off] = (byte)data;
            dest[off + 1] = (byte)(data >> 8);
            dest[off + 2] = (byte)(data >> 16);
            dest[off + 3] = (byte)(data >> 24);
        }
    }

    public static byte[] toBytes(int[] data, ByteOrder byteOrder) throws EvioException {
        if (data == null) {
            return null;
        }
        if (data.length > 0x1FFFFFFF) {
            throw new EvioException("int array has too many elements to convert to byte array");
        }
        if (byteOrder == null) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        byte[] b = new byte[data.length * 4];
        ByteBuffer buf = ByteBuffer.wrap(b).order(byteOrder);
        IntBuffer ib = buf.asIntBuffer();
        ib.put(data, 0, data.length);
        return b;
    }

    public static byte[] toBytes(int[] data, int offset, int length, ByteOrder byteOrder) throws EvioException {
        if (data == null) {
            return null;
        }
        if (offset < 0 || length < 1) {
            return null;
        }
        if (data.length > 0x1FFFFFFF) {
            throw new EvioException("int array has too many elements to convert to byte array");
        }
        if (byteOrder == null) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        byte[] b = new byte[length * 4];
        ByteBuffer buf = ByteBuffer.wrap(b).order(byteOrder);
        IntBuffer ib = buf.asIntBuffer();
        ib.put(data, offset, length);
        return b;
    }

    public static void toBytes(int[] data, ByteOrder byteOrder, byte[] dest, int off) throws EvioException {
        if (data == null || dest == null || dest.length < 4 * data.length + off || off < 0) {
            throw new EvioException("bad arg(s)");
        }
        if (data.length > 0x1FFFFFFF) {
            throw new EvioException("int array has too many elements to convert to byte array");
        }
        if (byteOrder == null) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        ByteBuffer buf = ByteBuffer.wrap(dest).order(byteOrder);
        buf.position(off);
        IntBuffer ib = buf.asIntBuffer();
        ib.put(data, 0, data.length);
    }

    public static byte[] toBytesStream(int[] data, ByteOrder byteOrder) throws EvioException {
        if (data == null) {
            return null;
        }
        if (data.length > 0x1FFFFFFF) {
            throw new EvioException("int array has too many elements to convert to byte array");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4 * data.length);
        DataOutputStream out = new DataOutputStream(baos);
        try {
            for (int i : data) {
                if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
                    out.writeInt(i);
                    continue;
                }
                out.writeInt(Integer.reverseBytes(i));
            }
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    public static byte[] toBytes(long data, ByteOrder byteOrder) {
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            return new byte[]{(byte)(data >> 56), (byte)(data >> 48), (byte)(data >> 40), (byte)(data >> 32), (byte)(data >> 24), (byte)(data >> 16), (byte)(data >> 8), (byte)data};
        }
        return new byte[]{(byte)data, (byte)(data >> 8), (byte)(data >> 16), (byte)(data >> 24), (byte)(data >> 32), (byte)(data >> 40), (byte)(data >> 48), (byte)(data >> 56)};
    }

    public static void toBytes(long data, ByteOrder byteOrder, byte[] dest, int off) throws EvioException {
        if (dest == null || dest.length < 8 + off || off < 0) {
            throw new EvioException("bad arg(s)");
        }
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            dest[off] = (byte)(data >> 56);
            dest[off + 1] = (byte)(data >> 48);
            dest[off + 2] = (byte)(data >> 40);
            dest[off + 3] = (byte)(data >> 32);
            dest[off + 4] = (byte)(data >> 24);
            dest[off + 5] = (byte)(data >> 16);
            dest[off + 6] = (byte)(data >> 8);
            dest[off + 7] = (byte)data;
        } else {
            dest[off] = (byte)data;
            dest[off + 1] = (byte)(data >> 8);
            dest[off + 2] = (byte)(data >> 16);
            dest[off + 3] = (byte)(data >> 24);
            dest[off + 4] = (byte)(data >> 32);
            dest[off + 5] = (byte)(data >> 40);
            dest[off + 6] = (byte)(data >> 48);
            dest[off + 7] = (byte)(data >> 56);
        }
    }

    public static byte[] toBytes(long[] data, ByteOrder byteOrder) throws EvioException {
        if (data == null) {
            return null;
        }
        if (data.length > 0xFFFFFFF) {
            throw new EvioException("long array has too many elements to convert to byte array");
        }
        if (byteOrder == null) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        byte[] b = new byte[data.length * 8];
        ByteBuffer buf = ByteBuffer.wrap(b).order(byteOrder);
        LongBuffer ib = buf.asLongBuffer();
        ib.put(data, 0, data.length);
        return b;
    }

    public static void toBytes(long[] data, ByteOrder byteOrder, byte[] dest, int off) throws EvioException {
        if (data == null || dest == null || dest.length < 8 * data.length + off || off < 0) {
            throw new EvioException("bad arg(s)");
        }
        if (data.length > 0xFFFFFFF) {
            throw new EvioException("long array has too many elements to convert to byte array");
        }
        if (byteOrder == null) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        ByteBuffer buf = ByteBuffer.wrap(dest).order(byteOrder);
        buf.position(off);
        LongBuffer ib = buf.asLongBuffer();
        ib.put(data, 0, data.length);
    }

    public static byte[] toBytes(float data, ByteOrder byteOrder) {
        return ByteDataTransformer.toBytes(Float.floatToRawIntBits(data), byteOrder);
    }

    public static void toBytes(float data, ByteOrder byteOrder, byte[] dest, int off) throws EvioException {
        ByteDataTransformer.toBytes(Float.floatToRawIntBits(data), byteOrder, dest, off);
    }

    public static byte[] toBytes(float[] data, ByteOrder byteOrder) throws EvioException {
        if (data == null) {
            return null;
        }
        if (data.length > 0x1FFFFFFF) {
            throw new EvioException("float array has too many elements to convert to byte array");
        }
        if (byteOrder == null) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        byte[] b = new byte[data.length * 4];
        ByteBuffer buf = ByteBuffer.wrap(b).order(byteOrder);
        FloatBuffer ib = buf.asFloatBuffer();
        ib.put(data, 0, data.length);
        return b;
    }

    public static void toBytes(float[] data, ByteOrder byteOrder, byte[] dest, int off) throws EvioException {
        if (data == null || dest == null || dest.length < 4 * data.length + off || off < 0) {
            throw new EvioException("bad arg(s)");
        }
        if (data.length > 0x1FFFFFFF) {
            throw new EvioException("float array has too many elements to convert to byte array");
        }
        if (byteOrder == null) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        ByteBuffer buf = ByteBuffer.wrap(dest).order(byteOrder);
        buf.position(off);
        FloatBuffer ib = buf.asFloatBuffer();
        ib.put(data, 0, data.length);
    }

    public static byte[] toBytes(double data, ByteOrder byteOrder) {
        return ByteDataTransformer.toBytes(Double.doubleToRawLongBits(data), byteOrder);
    }

    public static void toBytes(double data, ByteOrder byteOrder, byte[] dest, int off) throws EvioException {
        ByteDataTransformer.toBytes(Double.doubleToRawLongBits(data), byteOrder, dest, off);
    }

    public static byte[] toBytes(double[] data, ByteOrder byteOrder) throws EvioException {
        if (data == null) {
            return null;
        }
        if (data.length > 0xFFFFFFF) {
            throw new EvioException("double array has too many elements to convert to byte array");
        }
        if (byteOrder == null) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        byte[] b = new byte[data.length * 8];
        ByteBuffer buf = ByteBuffer.wrap(b).order(byteOrder);
        DoubleBuffer ib = buf.asDoubleBuffer();
        ib.put(data, 0, data.length);
        return b;
    }

    public static void toBytes(double[] data, ByteOrder byteOrder, byte[] dest, int off) throws EvioException {
        if (data == null || dest == null || dest.length < 8 * data.length + off || off < 0) {
            throw new EvioException("bad arg(s)");
        }
        if (data.length > 0xFFFFFFF) {
            throw new EvioException("double array has too many elements to convert to byte array");
        }
        if (byteOrder == null) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        ByteBuffer buf = ByteBuffer.wrap(dest).order(byteOrder);
        buf.position(off);
        DoubleBuffer ib = buf.asDoubleBuffer();
        ib.put(data, 0, data.length);
    }

    public static short toShort(byte[] data, ByteOrder byteOrder, int off) throws EvioException {
        if (data == null || data.length < 2 + off || off < 0) {
            throw new EvioException("bad data arg");
        }
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            return (short)((0xFF & data[off]) << 8 | 0xFF & data[1 + off]);
        }
        return (short)(0xFF & data[off] | (0xFF & data[1 + off]) << 8);
    }

    public static short toShort(byte b1, byte b2, ByteOrder byteOrder) {
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            return (short)((0xFF & b1) << 8 | 0xFF & b2);
        }
        return (short)(0xFF & b1 | (0xFF & b2) << 8);
    }

    public static short[] toShortArray(byte[] data, ByteOrder byteOrder) throws EvioException {
        if (data == null || data.length % 2 != 0) {
            throw new EvioException("bad data arg");
        }
        short[] sa = new short[data.length / 2];
        for (int i = 0; i < sa.length; ++i) {
            sa[i] = ByteDataTransformer.toShort(data[i * 2], data[i * 2 + 1], byteOrder);
        }
        return sa;
    }

    public static short[] toShortArray(byte[] data, int padding, ByteOrder byteOrder) throws EvioException {
        if (data == null || data.length % 2 != 0 || padding != 0 && padding != 2) {
            throw new EvioException("bad data arg");
        }
        short[] sa = new short[(data.length - padding) / 2];
        for (int i = 0; i < sa.length; ++i) {
            sa[i] = ByteDataTransformer.toShort(data[i * 2], data[i * 2 + 1], byteOrder);
        }
        return sa;
    }

    public static void toShortArray(byte[] data, int padding, ByteOrder byteOrder, short[] dest, int off) throws EvioException {
        if (data == null || data.length % 2 != 0 || padding != 0 && padding != 2 || dest == null || 2 * dest.length < data.length - padding + off || off < 0) {
            throw new EvioException("bad data arg");
        }
        System.out.println("toShortArray: padding = " + padding + ", data len = " + data.length);
        for (int i = 0; i < data.length - padding - 1; i += 2) {
            dest[i / 2 + off] = ByteDataTransformer.toShort(data[i], data[i + 1], byteOrder);
        }
    }

    public static void toShortArray(byte[] data, ByteOrder byteOrder, short[] dest, int off) throws EvioException {
        if (data == null || data.length % 2 != 0 || dest == null || 2 * dest.length < data.length + off || off < 0) {
            throw new EvioException("bad data arg");
        }
        for (int i = 0; i < data.length - 1; i += 2) {
            dest[i / 2 + off] = ByteDataTransformer.toShort(data[i], data[i + 1], byteOrder);
        }
    }

    public static int toInt(byte[] data, ByteOrder byteOrder, int off) throws EvioException {
        if (data == null || data.length < 4 + off || off < 0) {
            throw new EvioException("bad data arg");
        }
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            return (0xFF & data[off]) << 24 | (0xFF & data[1 + off]) << 16 | (0xFF & data[2 + off]) << 8 | 0xFF & data[3 + off];
        }
        return 0xFF & data[off] | (0xFF & data[1 + off]) << 8 | (0xFF & data[2 + off]) << 16 | (0xFF & data[3 + off]) << 24;
    }

    public static int toInt(byte b1, byte b2, byte b3, byte b4, ByteOrder byteOrder) {
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            return (0xFF & b1) << 24 | (0xFF & b2) << 16 | (0xFF & b3) << 8 | 0xFF & b4;
        }
        return 0xFF & b1 | (0xFF & b2) << 8 | (0xFF & b3) << 16 | (0xFF & b4) << 24;
    }

    public static int[] toIntArray(byte[] data, ByteOrder byteOrder) throws EvioException {
        if (data == null || data.length % 4 != 0) {
            throw new EvioException("bad data arg");
        }
        int[] ints = new int[data.length / 4];
        for (int i = 0; i < ints.length; ++i) {
            int indx = i * 4;
            ints[i] = ByteDataTransformer.toInt(data[indx], data[indx + 1], data[indx + 2], data[indx + 3], byteOrder);
        }
        return ints;
    }

    public static void toIntArray(byte[] data, ByteOrder byteOrder, int[] dest, int off) throws EvioException {
        if (data == null || data.length % 4 != 0 || dest == null || 4 * dest.length < data.length + off || off < 0) {
            throw new EvioException("bad data arg");
        }
        for (int i = 0; i < data.length - 3; i += 4) {
            dest[i / 4 + off] = ByteDataTransformer.toInt(data[i], data[i + 1], data[i + 2], data[i + 3], byteOrder);
        }
    }

    public static long toLong(byte[] data, ByteOrder byteOrder, int off) throws EvioException {
        if (data == null || data.length < 8 + off || off < 0) {
            throw new EvioException("bad data arg");
        }
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            return (long)(0xFF & data[off]) << 56 | (long)(0xFF & data[1 + off]) << 48 | (long)(0xFF & data[2 + off]) << 40 | (long)(0xFF & data[3 + off]) << 32 | (long)(0xFF & data[4 + off]) << 24 | (long)(0xFF & data[5 + off]) << 16 | (long)(0xFF & data[6 + off]) << 8 | (long)(0xFF & data[7 + off]);
        }
        return (long)(0xFF & data[off]) | (long)(0xFF & data[1 + off]) << 8 | (long)(0xFF & data[2 + off]) << 16 | (long)(0xFF & data[3 + off]) << 24 | (long)(0xFF & data[4 + off]) << 32 | (long)(0xFF & data[5 + off]) << 40 | (long)(0xFF & data[6 + off]) << 48 | (long)(0xFF & data[7 + off]) << 56;
    }

    public static long toLong(byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7, byte b8, ByteOrder byteOrder) {
        if (byteOrder == null || byteOrder == ByteOrder.BIG_ENDIAN) {
            return (long)(0xFF & b1) << 56 | (long)(0xFF & b2) << 48 | (long)(0xFF & b3) << 40 | (long)(0xFF & b4) << 32 | (long)(0xFF & b5) << 24 | (long)(0xFF & b6) << 16 | (long)(0xFF & b7) << 8 | (long)(0xFF & b8);
        }
        return (long)(0xFF & b1) | (long)(0xFF & b2) << 8 | (long)(0xFF & b3) << 16 | (long)(0xFF & b4) << 24 | (long)(0xFF & b5) << 32 | (long)(0xFF & b6) << 40 | (long)(0xFF & b7) << 48 | (long)(0xFF & b8) << 56;
    }

    public static long[] toLongArray(byte[] data, ByteOrder byteOrder) throws EvioException {
        if (data == null || data.length % 8 != 0) {
            throw new EvioException("bad data arg");
        }
        long[] lngs = new long[data.length / 8];
        for (int i = 0; i < lngs.length; ++i) {
            int indx = i * 8;
            lngs[i] = ByteDataTransformer.toLong(data[indx], data[indx + 1], data[indx + 2], data[indx + 3], data[indx + 4], data[indx + 5], data[indx + 6], data[indx + 7], byteOrder);
        }
        return lngs;
    }

    public static void toLongArray(byte[] data, ByteOrder byteOrder, long[] dest, int off) throws EvioException {
        if (data == null || data.length % 8 != 0 || dest == null || 8 * dest.length < data.length + off || off < 0) {
            throw new EvioException("bad data arg");
        }
        for (int i = 0; i < data.length - 7; i += 8) {
            dest[i / 8 + off] = ByteDataTransformer.toLong(data[i], data[i + 1], data[i + 2], data[i + 3], data[i + 4], data[i + 5], data[i + 6], data[i + 7], byteOrder);
        }
    }

    public static float toFloat(byte[] data, ByteOrder byteOrder, int off) throws EvioException {
        return Float.intBitsToFloat(ByteDataTransformer.toInt(data, byteOrder, off));
    }

    public static float toFloat(byte b1, byte b2, byte b3, byte b4, ByteOrder byteOrder) {
        return Float.intBitsToFloat(ByteDataTransformer.toInt(b1, b2, b3, b4, byteOrder));
    }

    public static float[] toFloatArray(byte[] data, ByteOrder byteOrder) throws EvioException {
        if (data == null || data.length % 4 != 0) {
            throw new EvioException("bad data arg");
        }
        float[] flts = new float[data.length / 4];
        for (int i = 0; i < flts.length; ++i) {
            int indx = i * 4;
            flts[i] = ByteDataTransformer.toFloat(data[indx], data[indx + 1], data[indx + 2], data[indx + 3], byteOrder);
        }
        return flts;
    }

    public static void toFloatArray(byte[] data, ByteOrder byteOrder, float[] dest, int off) throws EvioException {
        if (data == null || data.length % 4 != 0 || dest == null || 4 * dest.length < data.length + off || off < 0) {
            throw new EvioException("bad data arg");
        }
        for (int i = 0; i < data.length - 3; i += 4) {
            dest[i / 4 + off] = ByteDataTransformer.toFloat(data[i], data[i + 1], data[i + 2], data[i + 3], byteOrder);
        }
    }

    public static double toDouble(byte[] data, ByteOrder byteOrder, int off) throws EvioException {
        return Double.longBitsToDouble(ByteDataTransformer.toLong(data, byteOrder, off));
    }

    public static double toDouble(byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7, byte b8, ByteOrder byteOrder) {
        return Double.longBitsToDouble(ByteDataTransformer.toLong(b1, b2, b3, b4, b5, b6, b7, b8, byteOrder));
    }

    public static double[] toDoubleArray(byte[] data, ByteOrder byteOrder) throws EvioException {
        if (data == null || data.length % 8 != 0) {
            throw new EvioException("bad data arg");
        }
        double[] dbls = new double[data.length / 8];
        for (int i = 0; i < dbls.length; ++i) {
            int indx = i * 8;
            dbls[i] = ByteDataTransformer.toDouble(data[indx], data[indx + 1], data[indx + 2], data[indx + 3], data[indx + 4], data[indx + 5], data[indx + 6], data[indx + 7], byteOrder);
        }
        return dbls;
    }

    public static void toDoubleArray(byte[] data, ByteOrder byteOrder, double[] dest, int off) throws EvioException {
        if (data == null || data.length % 8 != 0 || dest == null || 8 * dest.length < data.length + off || off < 0) {
            throw new EvioException("bad data arg");
        }
        for (int i = 0; i < data.length - 7; i += 8) {
            dest[i / 8 + off] = ByteDataTransformer.toDouble(data[i], data[i + 1], data[i + 2], data[i + 3], data[i + 4], data[i + 5], data[i + 6], data[i + 7], byteOrder);
        }
    }

    public static void swapEvent(ByteBuffer srcBuffer, ByteBuffer destBuffer, int srcPos, int destPos) throws EvioException {
        ByteDataTransformer.swapEvent(srcBuffer, destBuffer, srcPos, destPos, null);
    }

    public static void swapEvent(ByteBuffer srcBuffer, ByteBuffer destBuffer, int srcPos, int destPos, List<EvioNode> nodeList) throws EvioException {
        ByteDataTransformer.swapEvent(srcBuffer, destBuffer, srcPos, destPos, true, nodeList);
    }

    public static void swapEvent(ByteBuffer srcBuffer, ByteBuffer destBuffer, int srcPos, int destPos, boolean swapData, List<EvioNode> nodeList) throws EvioException {
        ByteOrder destOrder;
        if (srcBuffer == null) {
            throw new EvioException("Null event in parseEvent.");
        }
        boolean inPlace = false;
        ByteOrder srcOrder = srcBuffer.order();
        ByteOrder byteOrder = destOrder = srcOrder == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        if (destBuffer == null || srcBuffer == destBuffer) {
            destBuffer = srcBuffer.duplicate();
            destPos = srcPos;
            inPlace = true;
        }
        destBuffer.order(destOrder);
        if (srcPos < 0 || srcPos > srcBuffer.capacity() - 8) {
            throw new EvioException("bad value for srcPos arg");
        }
        if (destPos < 0 || destPos > destBuffer.capacity() - 8) {
            throw new EvioException("bad value for destPos arg");
        }
        EvioNode node = new EvioNode();
        ByteDataTransformer.swapBankHeader(node, srcBuffer, destBuffer, srcPos, destPos);
        if (nodeList != null) {
            node.eventNode = node;
            node.scanned = true;
            node.isEvent = true;
            node.type = DataType.BANK.getValue();
            nodeList.add(node);
        }
        ByteDataTransformer.swapStructure(node.getDataTypeObj(), srcBuffer, destBuffer, srcPos + 8, destPos + 8, node.dataLen, inPlace, swapData, nodeList);
        if (inPlace) {
            srcBuffer.order(destOrder);
        }
    }

    static void swapBankHeader(EvioNode node, ByteBuffer srcBuffer, ByteBuffer destBuffer, int srcPos, int destPos) throws EvioException {
        try {
            int num;
            int pad;
            int type;
            int dt;
            int tag;
            ByteOrder srcOrder = srcBuffer.order();
            if (node != null) {
                node.pos = destPos;
            }
            int length = srcBuffer.getInt(srcPos);
            destBuffer.putInt(destPos, length);
            srcPos += 4;
            destPos += 4;
            if (srcOrder == ByteOrder.BIG_ENDIAN) {
                tag = srcBuffer.getShort(srcPos) & 0xFFFF;
                srcPos += 2;
                dt = srcBuffer.get(srcPos++) & 0xFF;
                type = dt & 0x3F;
                pad = dt >>> 6;
                if (dt == 64) {
                    type = DataType.TAGSEGMENT.getValue();
                    pad = 0;
                }
                num = srcBuffer.get(srcPos++) & 0xFF;
            } else {
                num = srcBuffer.get(srcPos++) & 0xFF;
                dt = srcBuffer.get(srcPos++) & 0xFF;
                type = dt & 0x3F;
                pad = dt >>> 6;
                if (dt == 64) {
                    type = DataType.TAGSEGMENT.getValue();
                    pad = 0;
                }
                tag = srcBuffer.getShort(srcPos) & 0xFFFF;
                srcPos += 2;
            }
            if (srcOrder == ByteOrder.BIG_ENDIAN) {
                destBuffer.put(destPos++, (byte)num);
                destBuffer.put(destPos++, (byte)dt);
                destBuffer.putShort(destPos, (short)tag);
                destPos += 2;
            } else {
                destBuffer.putShort(destPos, (short)tag);
                destPos += 2;
                destBuffer.put(destPos++, (byte)dt);
                destBuffer.put(destPos++, (byte)num);
            }
            if (node != null) {
                node.len = length;
                node.num = num;
                node.tag = tag;
                node.pad = pad;
                node.dataPos = destPos;
                node.dataLen = length - 1;
                node.dataType = type;
            }
        }
        catch (BufferOverflowException e) {
            throw new EvioException("destBuffer too small to hold swapped data");
        }
        catch (BufferUnderflowException e) {
            throw new EvioException("srcBuffer not evio format");
        }
    }

    static void swapSegmentHeader(EvioNode node, ByteBuffer srcBuffer, ByteBuffer destBuffer, int srcPos, int destPos) throws EvioException {
        try {
            int len;
            int pad;
            int type;
            int dt;
            int tag;
            ByteOrder srcOrder = srcBuffer.order();
            if (node != null) {
                node.pos = destPos;
            }
            if (srcOrder == ByteOrder.BIG_ENDIAN) {
                tag = srcBuffer.get(srcPos++) & 0xFF;
                dt = srcBuffer.get(srcPos++) & 0xFF;
                type = dt & 0x3F;
                pad = dt >>> 6;
                if (dt == 64) {
                    type = DataType.TAGSEGMENT.getValue();
                    pad = 0;
                }
                len = srcBuffer.getShort(srcPos) & 0xFFFF;
                srcPos += 2;
            } else {
                len = srcBuffer.getShort(srcPos) & 0xFFFF;
                srcPos += 2;
                dt = srcBuffer.get(srcPos++) & 0xFF;
                type = dt & 0x3F;
                pad = dt >>> 6;
                if (dt == 64) {
                    type = DataType.TAGSEGMENT.getValue();
                    pad = 0;
                }
                tag = srcBuffer.get(srcPos++) & 0xFF;
            }
            if (srcOrder == ByteOrder.BIG_ENDIAN) {
                destBuffer.putShort(destPos, (short)len);
                destPos += 2;
                destBuffer.put(destPos++, (byte)dt);
                destBuffer.put(destPos++, (byte)tag);
            } else {
                destBuffer.put(destPos++, (byte)tag);
                destBuffer.put(destPos++, (byte)(type & 0x3F | pad << 6));
                destBuffer.putShort(destPos, (short)len);
                destPos += 2;
            }
            if (node != null) {
                node.len = len;
                node.num = 0;
                node.tag = tag;
                node.pad = pad;
                node.dataPos = destPos;
                node.dataLen = len;
                node.dataType = type;
            }
        }
        catch (BufferOverflowException e) {
            throw new EvioException("destBuffer too small to hold swapped data");
        }
        catch (BufferUnderflowException e) {
            throw new EvioException("srcBuffer not evio format");
        }
    }

    static void swapTagSegmentHeader(EvioNode node, ByteBuffer srcBuffer, ByteBuffer destBuffer, int srcPos, int destPos) throws EvioException {
        try {
            int len;
            int type;
            int tag;
            int temp;
            ByteOrder srcOrder = srcBuffer.order();
            if (node != null) {
                node.pos = destPos;
            }
            if (srcOrder == ByteOrder.BIG_ENDIAN) {
                temp = srcBuffer.getShort(srcPos) & 0xFFFF;
                tag = temp >>> 4;
                type = temp & 0xF;
                len = srcBuffer.getShort(srcPos += 2) & 0xFFFF;
                srcPos += 2;
            } else {
                len = srcBuffer.getShort(srcPos) & 0xFFFF;
                temp = srcBuffer.getShort(srcPos += 2) & 0xFFFF;
                srcPos += 2;
                tag = temp >>> 4;
                type = temp & 0xF;
            }
            if (srcOrder == ByteOrder.BIG_ENDIAN) {
                destBuffer.putShort(destPos, (short)len);
                destBuffer.putShort(destPos += 2, (short)temp);
                destPos += 2;
            } else {
                destBuffer.putShort(destPos, (short)temp);
                destBuffer.putShort(destPos += 2, (short)len);
                destPos += 2;
            }
            if (node != null) {
                node.len = len;
                node.num = 0;
                node.tag = tag;
                node.pad = 0;
                node.dataPos = destPos;
                node.dataLen = len;
                node.dataType = type;
            }
        }
        catch (BufferOverflowException e) {
            throw new EvioException("destBuffer too small to hold swapped data");
        }
        catch (BufferUnderflowException e) {
            throw new EvioException("srcBuffer not evio format");
        }
    }

    static void swapData(DataType type, ByteBuffer srcBuffer, ByteBuffer destBuffer, int srcPos, int destPos, int len, boolean inPlace) throws EvioException {
        int endPos = srcPos + 4 * len;
        switch (type) {
            case LONG64: 
            case ULONG64: 
            case DOUBLE64: {
                while (srcPos < endPos) {
                    destBuffer.putLong(destPos, srcBuffer.getLong(srcPos));
                    srcPos += 8;
                    destPos += 8;
                }
                break;
            }
            case INT32: 
            case UINT32: 
            case FLOAT32: {
                while (srcPos < endPos) {
                    destBuffer.putInt(destPos, srcBuffer.getInt(srcPos));
                    srcPos += 4;
                    destPos += 4;
                }
                break;
            }
            case SHORT16: 
            case USHORT16: {
                while (srcPos < endPos) {
                    destBuffer.putShort(destPos, srcBuffer.getShort(srcPos));
                    srcPos += 2;
                    destPos += 2;
                }
                break;
            }
            case CHAR8: 
            case UCHAR8: 
            case CHARSTAR8: {
                if (inPlace) break;
                while (srcPos < endPos) {
                    destBuffer.put(destPos, srcBuffer.get(srcPos));
                    ++srcPos;
                    ++destPos;
                }
                break;
            }
            case COMPOSITE: {
                CompositeData.swapAll(srcBuffer, destBuffer, srcPos, destPos, len, inPlace);
                break;
            }
        }
    }

    static void swapStructure(DataType dataType, ByteBuffer srcBuffer, ByteBuffer destBuffer, int srcPos, int destPos, int length, boolean inPlace, boolean swapData, List<EvioNode> nodeList) throws EvioException {
        if (!dataType.isStructure()) {
            if (swapData) {
                ByteDataTransformer.swapData(dataType, srcBuffer, destBuffer, srcPos, destPos, length, inPlace);
            }
            return;
        }
        int offset = 0;
        int sPos = srcPos;
        int dPos = destPos;
        EvioNode node = new EvioNode();
        EvioNode firstNode = null;
        if (nodeList != null) {
            firstNode = nodeList.get(0);
            node.scanned = true;
            node.eventNode = firstNode;
        }
        length *= 4;
        switch (dataType) {
            case BANK: 
            case ALSOBANK: {
                while (offset < length) {
                    ByteDataTransformer.swapBankHeader(node, srcBuffer, destBuffer, sPos, dPos);
                    ByteDataTransformer.swapStructure(node.getDataTypeObj(), srcBuffer, destBuffer, sPos + 8, dPos + 8, node.dataLen, inPlace, swapData, nodeList);
                    sPos = srcPos + (offset += 4 * (node.len + 1));
                    dPos = destPos + offset;
                    if (nodeList == null) continue;
                    node.type = DataType.BANK.getValue();
                    nodeList.add(node);
                    if (offset >= length) continue;
                    node = new EvioNode();
                    node.scanned = true;
                    node.eventNode = firstNode;
                }
                break;
            }
            case SEGMENT: 
            case ALSOSEGMENT: {
                while (offset < length) {
                    ByteDataTransformer.swapSegmentHeader(node, srcBuffer, destBuffer, sPos, dPos);
                    ByteDataTransformer.swapStructure(node.getDataTypeObj(), srcBuffer, destBuffer, sPos + 4, dPos + 4, node.dataLen, inPlace, swapData, nodeList);
                    sPos = srcPos + (offset += 4 * (node.len + 1));
                    dPos = destPos + offset;
                    if (nodeList == null) continue;
                    node.type = DataType.SEGMENT.getValue();
                    nodeList.add(node);
                    if (offset >= length) continue;
                    node = new EvioNode();
                    node.scanned = true;
                    node.eventNode = firstNode;
                }
                break;
            }
            case TAGSEGMENT: {
                while (offset < length) {
                    ByteDataTransformer.swapTagSegmentHeader(node, srcBuffer, destBuffer, sPos, dPos);
                    ByteDataTransformer.swapStructure(node.getDataTypeObj(), srcBuffer, destBuffer, sPos + 4, dPos + 4, node.dataLen, inPlace, swapData, nodeList);
                    sPos = srcPos + (offset += 4 * (node.len + 1));
                    dPos = destPos + offset;
                    if (nodeList == null) continue;
                    node.type = DataType.TAGSEGMENT.getValue();
                    nodeList.add(node);
                    if (offset >= length) continue;
                    node = new EvioNode();
                    node.scanned = true;
                    node.eventNode = firstNode;
                }
                break;
            }
        }
    }
}

