/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jlab.coda.jevio.BlockNode;
import org.jlab.coda.jevio.BufferNode;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.EvioXMLDictionary;

public class EvioCompactStructureHandler {
    private EvioNode node;
    private ByteBuffer byteBuffer;
    private ByteOrder byteOrder;
    private int initialPosition;
    private boolean closed;

    public EvioCompactStructureHandler(EvioNode node) throws EvioException {
        if (node == null) {
            throw new EvioException("node arg is null");
        }
        ByteBuffer byteBuffer = node.getBufferNode().getBuffer();
        if (byteBuffer.remaining() < 1) {
            throw new EvioException("Buffer has too little data");
        }
        if ((node.getTypeObj() == DataType.BANK || node.getTypeObj() == DataType.ALSOBANK) && byteBuffer.remaining() < 2) {
            throw new EvioException("Buffer has too little data");
        }
        this.node = node;
        this.byteBuffer = byteBuffer;
        this.initialPosition = byteBuffer.position();
        this.byteOrder = byteBuffer.order();
        if (node.len + 1 > byteBuffer.remaining() / 4) {
            throw new EvioException("Buffer has too little data");
        }
    }

    public EvioCompactStructureHandler(ByteBuffer byteBuffer, DataType type) throws EvioException {
        if (byteBuffer == null) {
            throw new EvioException("Buffer arg is null");
        }
        if (type == null || !type.isStructure()) {
            throw new EvioException("type arg is null or is not an evio structure");
        }
        if (byteBuffer.remaining() < 1) {
            throw new EvioException("Buffer has too little data");
        }
        if ((type == DataType.BANK || type == DataType.ALSOBANK) && byteBuffer.remaining() < 2) {
            throw new EvioException("Buffer has too little data");
        }
        this.initialPosition = byteBuffer.position();
        this.byteBuffer = byteBuffer;
        this.byteOrder = byteBuffer.order();
        this.node = this.extractNode(byteBuffer, null, null, type, this.initialPosition, 0, false);
        if (this.node.len + 1 > byteBuffer.remaining() / 4) {
            throw new EvioException("Buffer has too little data");
        }
    }

    public synchronized void setBuffer(ByteBuffer buf, DataType type) throws EvioException {
        if (buf == null) {
            throw new EvioException("Buffer arg is null");
        }
        if (type == null || !type.isStructure()) {
            throw new EvioException("type arg is null or is not an evio structure");
        }
        if (this.byteBuffer.remaining() < 1) {
            throw new EvioException("Buffer has too little data");
        }
        if ((type == DataType.BANK || type == DataType.ALSOBANK) && this.byteBuffer.remaining() < 2) {
            throw new EvioException("Buffer has too little data");
        }
        this.close();
        this.initialPosition = buf.position();
        this.byteBuffer = buf;
        this.byteOrder = this.byteBuffer.order();
        this.node = this.extractNode(this.byteBuffer, null, null, type, this.initialPosition, 0, false);
        if (this.node.len + 1 > this.byteBuffer.remaining() / 4) {
            throw new EvioException("Buffer has too little data");
        }
        this.closed = false;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public EvioNode getStructure() {
        return this.node;
    }

    public EvioNode getScannedStructure() {
        EvioCompactStructureHandler.scanStructure(this.node);
        return this.node;
    }

    private EvioNode extractNode(ByteBuffer buffer, BlockNode blockNode, EvioNode eventNode, DataType type, int position, int place, boolean isEvent) throws EvioException {
        EvioNode node = new EvioNode();
        node.pos = position;
        node.place = place;
        node.blockNode = blockNode;
        node.eventNode = eventNode;
        node.isEvent = isEvent;
        node.type = type.getValue();
        node.bufferNode = new BufferNode(buffer);
        try {
            switch (type) {
                case BANK: 
                case ALSOBANK: {
                    node.len = buffer.getInt(position);
                    node.dataPos = position + 8;
                    node.dataLen = node.len - 1;
                    position += 4;
                    if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                        node.tag = buffer.getShort(position) & 0xFFFF;
                        position += 2;
                        int dt = buffer.get(position++) & 0xFF;
                        node.dataType = dt & 0x3F;
                        node.pad = dt >>> 6;
                        if (dt == 64) {
                            node.dataType = DataType.TAGSEGMENT.getValue();
                            node.pad = 0;
                        }
                        node.num = buffer.get(position) & 0xFF;
                        break;
                    }
                    node.num = buffer.get(position++) & 0xFF;
                    int dt = buffer.get(position++) & 0xFF;
                    node.dataType = dt & 0x3F;
                    node.pad = dt >>> 6;
                    if (dt == 64) {
                        node.dataType = DataType.TAGSEGMENT.getValue();
                        node.pad = 0;
                    }
                    node.tag = buffer.getShort(position) & 0xFFFF;
                    break;
                }
                case SEGMENT: 
                case ALSOSEGMENT: {
                    node.dataPos = position + 4;
                    if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                        node.tag = buffer.get(position++) & 0xFF;
                        int dt = buffer.get(position++) & 0xFF;
                        node.dataType = dt & 0x3F;
                        node.pad = dt >>> 6;
                        if (dt == 64) {
                            node.dataType = DataType.TAGSEGMENT.getValue();
                            node.pad = 0;
                        }
                        node.len = buffer.getShort(position) & 0xFFFF;
                    } else {
                        node.len = buffer.getShort(position) & 0xFFFF;
                        position += 2;
                        int dt = buffer.get(position++) & 0xFF;
                        node.dataType = dt & 0x3F;
                        node.pad = dt >>> 6;
                        if (dt == 64) {
                            node.dataType = DataType.TAGSEGMENT.getValue();
                            node.pad = 0;
                        }
                        node.tag = buffer.get(position) & 0xFF;
                    }
                    node.dataLen = node.len;
                    break;
                }
                case TAGSEGMENT: {
                    node.dataPos = position + 4;
                    if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                        int temp = buffer.getShort(position) & 0xFFFF;
                        node.tag = temp >>> 4;
                        node.dataType = temp & 0xF;
                        node.len = buffer.getShort(position += 2) & 0xFFFF;
                    } else {
                        node.len = buffer.getShort(position) & 0xFFFF;
                        int temp = buffer.getShort(position += 2) & 0xFFFF;
                        node.tag = temp >>> 4;
                        node.dataType = temp & 0xF;
                    }
                    node.dataLen = node.len;
                    break;
                }
                default: {
                    throw new EvioException("File/buffer bad format");
                }
            }
        }
        catch (BufferUnderflowException a) {
            throw new EvioException("File/buffer bad format");
        }
        return node;
    }

    private static void scanStructure(EvioNode node) {
        int position;
        DataType type = node.getDataTypeObj();
        if (!type.isStructure()) {
            return;
        }
        int dataBytes = 4 * node.dataLen;
        int endingPos = position + dataBytes;
        ByteBuffer buffer = node.bufferNode.buffer;
        switch (type) {
            case BANK: 
            case ALSOBANK: {
                int dataLen;
                for (position = node.dataPos; position < endingPos; position += 4 * dataLen) {
                    int num;
                    int pad;
                    int dataType;
                    int dt;
                    int tag;
                    int len = buffer.getInt(position);
                    dataLen = len - 1;
                    position += 4;
                    if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                        tag = buffer.getShort(position) & 0xFFFF;
                        position += 2;
                        dt = buffer.get(position++) & 0xFF;
                        dataType = dt & 0x3F;
                        pad = dt >>> 6;
                        if (dt == 64) {
                            dataType = DataType.TAGSEGMENT.getValue();
                            pad = 0;
                        }
                        num = buffer.get(position++) & 0xFF;
                    } else {
                        num = buffer.get(position++) & 0xFF;
                        dt = buffer.get(position++) & 0xFF;
                        dataType = dt & 0x3F;
                        pad = dt >>> 6;
                        if (dt == 64) {
                            dataType = DataType.TAGSEGMENT.getValue();
                            pad = 0;
                        }
                        tag = buffer.getShort(position) & 0xFFFF;
                        position += 2;
                    }
                    EvioNode kidNode = (EvioNode)node.clone();
                    kidNode.len = len;
                    kidNode.pos = position - 8;
                    kidNode.type = DataType.BANK.getValue();
                    kidNode.dataLen = dataLen;
                    kidNode.dataPos = position;
                    kidNode.dataType = dataType;
                    kidNode.pad = pad;
                    kidNode.tag = tag;
                    kidNode.num = num;
                    kidNode.isEvent = false;
                    kidNode.parentNode = node;
                    node.addChild(kidNode);
                    if (!DataType.isStructure(dataType)) continue;
                    EvioCompactStructureHandler.scanStructure(kidNode);
                }
                break;
            }
            case SEGMENT: 
            case ALSOSEGMENT: {
                while (position < endingPos) {
                    int len;
                    int pad;
                    int dataType;
                    int dt;
                    int tag;
                    if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                        tag = buffer.get(position++) & 0xFF;
                        dt = buffer.get(position++) & 0xFF;
                        dataType = dt & 0x3F;
                        pad = dt >>> 6;
                        if (dt == 64) {
                            dataType = DataType.TAGSEGMENT.getValue();
                            pad = 0;
                        }
                        len = buffer.getShort(position) & 0xFFFF;
                        position += 2;
                    } else {
                        len = buffer.getShort(position) & 0xFFFF;
                        position += 2;
                        dt = buffer.get(position++) & 0xFF;
                        dataType = dt & 0x3F;
                        pad = dt >>> 6;
                        if (dt == 64) {
                            dataType = DataType.TAGSEGMENT.getValue();
                            pad = 0;
                        }
                        tag = buffer.get(position++) & 0xFF;
                    }
                    EvioNode kidNode = (EvioNode)node.clone();
                    kidNode.len = len;
                    kidNode.pos = position - 4;
                    kidNode.type = DataType.SEGMENT.getValue();
                    kidNode.dataLen = len;
                    kidNode.dataPos = position;
                    kidNode.dataType = dataType;
                    kidNode.pad = pad;
                    kidNode.tag = tag;
                    kidNode.num = 0;
                    kidNode.isEvent = false;
                    kidNode.parentNode = node;
                    node.addChild(kidNode);
                    if (DataType.isStructure(dataType)) {
                        EvioCompactStructureHandler.scanStructure(kidNode);
                    }
                    position += 4 * len;
                }
                break;
            }
            case TAGSEGMENT: {
                while (position < endingPos) {
                    int len;
                    int dataType;
                    int tag;
                    int temp;
                    if (buffer.order() == ByteOrder.BIG_ENDIAN) {
                        temp = buffer.getShort(position) & 0xFFFF;
                        tag = temp >>> 4;
                        dataType = temp & 0xF;
                        len = buffer.getShort(position += 2) & 0xFFFF;
                        position += 2;
                    } else {
                        len = buffer.getShort(position) & 0xFFFF;
                        temp = buffer.getShort(position += 2) & 0xFFFF;
                        position += 2;
                        tag = temp >>> 4;
                        dataType = temp & 0xF;
                    }
                    EvioNode kidNode = (EvioNode)node.clone();
                    kidNode.len = len;
                    kidNode.pos = position - 4;
                    kidNode.type = DataType.TAGSEGMENT.getValue();
                    kidNode.dataLen = len;
                    kidNode.dataPos = position;
                    kidNode.dataType = dataType;
                    kidNode.pad = 0;
                    kidNode.tag = tag;
                    kidNode.num = 0;
                    kidNode.isEvent = false;
                    kidNode.parentNode = node;
                    node.addChild(kidNode);
                    if (DataType.isStructure(dataType)) {
                        EvioCompactStructureHandler.scanStructure(kidNode);
                    }
                    position += 4 * len;
                }
                break;
            }
        }
    }

    private static void printBuffer(ByteBuffer buf, int lenInInts) {
        IntBuffer ibuf = buf.asIntBuffer();
        lenInInts = lenInInts > ibuf.capacity() ? ibuf.capacity() : lenInInts;
        for (int i = 0; i < lenInInts; ++i) {
            System.out.println("  Buf(" + i + ") = 0x" + Integer.toHexString(ibuf.get(i)));
        }
    }

    private ArrayList<EvioNode> scanStructure() {
        if (!this.node.scanned) {
            this.node.scanned = true;
            EvioCompactStructureHandler.scanStructure(this.node);
        }
        return this.node.allNodes;
    }

    public synchronized List<EvioNode> searchStructure(int tag, int num) throws EvioException {
        if (tag < 0 || num < 0) {
            throw new EvioException("bad arg value(s)");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        ArrayList<EvioNode> returnList = new ArrayList<EvioNode>(100);
        ArrayList<EvioNode> list = this.scanStructure();
        for (EvioNode enode : list) {
            if (enode.tag != tag || enode.num != num) continue;
            returnList.add(enode);
        }
        return returnList;
    }

    public List<EvioNode> searchStructure(String dictName, EvioXMLDictionary dictionary) throws EvioException {
        if (dictName == null || dictionary == null) {
            throw new EvioException("null dictionary and/or entry name");
        }
        int tag = dictionary.getTag(dictName);
        int num = dictionary.getNum(dictName);
        if (tag == -1 || num == -1) {
            throw new EvioException("no dictionary entry for " + dictName);
        }
        return this.searchStructure(tag, num);
    }

    public synchronized ByteBuffer addStructure(ByteBuffer addBuffer) throws EvioException {
        if (addBuffer == null || addBuffer.remaining() < 4) {
            throw new EvioException("null, empty, or non-evio format buffer arg");
        }
        if (addBuffer.order() != this.byteOrder) {
            throw new EvioException("trying to add wrong endian buffer");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        int endPos = this.node.dataPos + 4 * this.node.dataLen;
        int origAddBufPos = addBuffer.position();
        int appendDataLen = addBuffer.remaining();
        if (appendDataLen % 4 != 0) {
            throw new EvioException("data added is not in evio format");
        }
        int appendDataWordLen = appendDataLen / 4;
        DataType eventDataType = this.node.getDataTypeObj();
        ByteBuffer newBuffer = ByteBuffer.allocate(endPos - this.initialPosition + appendDataLen);
        newBuffer.order(this.byteOrder);
        this.byteBuffer.limit(endPos).position(this.initialPosition);
        newBuffer.put(this.byteBuffer);
        int newDataPos = newBuffer.position();
        newBuffer.put(addBuffer);
        newBuffer.flip();
        this.byteBuffer.position(this.initialPosition);
        addBuffer.position(origAddBufPos);
        boolean didEventNode = false;
        if (this.initialPosition != 0) {
            if (this.node.allNodes != null) {
                for (EvioNode evNode : this.node.allNodes) {
                    evNode.pos -= this.initialPosition;
                    evNode.dataPos -= this.initialPosition;
                    if (evNode != this.node) continue;
                    didEventNode = true;
                }
            }
            if (!didEventNode) {
                this.node.pos -= this.initialPosition;
                this.node.dataPos -= this.initialPosition;
            }
        }
        this.byteBuffer = newBuffer;
        this.initialPosition = newBuffer.position();
        int eventLenPos = this.node.pos;
        this.node.len += appendDataWordLen;
        this.node.dataLen += appendDataWordLen;
        switch (eventDataType) {
            case BANK: 
            case ALSOBANK: {
                newBuffer.putInt(eventLenPos, this.node.len);
                break;
            }
            case SEGMENT: 
            case ALSOSEGMENT: 
            case TAGSEGMENT: {
                if (this.byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
                    newBuffer.putShort(eventLenPos + 2, (short)this.node.len);
                    break;
                }
                newBuffer.putShort(eventLenPos, (short)this.node.len);
                break;
            }
            default: {
                throw new EvioException("internal programming error");
            }
        }
        if (this.node.scanned) {
            EvioNode newNode = this.extractNode(newBuffer, this.node.blockNode, this.node, eventDataType, newDataPos, 0, false);
            this.node.allNodes.add(newNode);
            EvioCompactStructureHandler.scanStructure(newNode);
            this.node.childNodes.addAll(newNode.childNodes);
        }
        return newBuffer;
    }

    public ByteBuffer getData(EvioNode node) throws EvioException {
        return this.getData(node, false);
    }

    public synchronized ByteBuffer getData(EvioNode node, boolean copy) throws EvioException {
        if (this.closed) {
            throw new EvioException("object closed");
        }
        int pos = this.byteBuffer.position();
        int lim = this.byteBuffer.limit();
        this.byteBuffer.limit(node.dataPos + 4 * node.dataLen - node.pad).position(node.dataPos);
        if (copy) {
            ByteBuffer newBuf = ByteBuffer.allocate(4 * node.dataLen - node.pad).order(this.byteOrder);
            newBuf.put(this.byteBuffer);
            newBuf.flip();
            this.byteBuffer.limit(lim).position(pos);
            return newBuf;
        }
        ByteBuffer buf = this.byteBuffer.slice().order(this.byteOrder);
        this.byteBuffer.limit(lim).position(pos);
        return buf;
    }

    public ByteBuffer getStructureBuffer(EvioNode node) throws EvioException {
        return this.getStructureBuffer(node, false);
    }

    public synchronized ByteBuffer getStructureBuffer(EvioNode node, boolean copy) throws EvioException {
        if (node == null) {
            throw new EvioException("node arg is null");
        }
        if (this.closed) {
            throw new EvioException("object closed");
        }
        int pos = this.byteBuffer.position();
        int lim = this.byteBuffer.limit();
        this.byteBuffer.limit(node.dataPos + 4 * node.dataLen).position(node.pos);
        if (copy) {
            ByteBuffer newBuf = ByteBuffer.allocate(node.dataPos + 4 * node.dataLen - node.pos).order(this.byteOrder);
            newBuf.put(this.byteBuffer);
            newBuf.flip();
            this.byteBuffer.limit(lim).position(pos);
            return newBuf;
        }
        ByteBuffer buf = this.byteBuffer.slice().order(this.byteOrder);
        this.byteBuffer.limit(lim).position(pos);
        return buf;
    }

    public synchronized List<EvioNode> getNodes() throws EvioException {
        if (this.closed) {
            throw new EvioException("object closed");
        }
        return Collections.unmodifiableList(this.scanStructure());
    }

    public synchronized List<EvioNode> getChildNodes() throws EvioException {
        if (this.closed) {
            throw new EvioException("object closed");
        }
        this.scanStructure();
        return Collections.unmodifiableList(this.node.childNodes);
    }

    public synchronized void close() {
        this.byteBuffer.position(this.initialPosition);
        this.closed = true;
    }
}

