/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.nio.ByteOrder;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultTreeModel;
import org.jlab.coda.jevio.BankHeader;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioSegment;
import org.jlab.coda.jevio.EvioTagSegment;
import org.jlab.coda.jevio.IEvioFilter;
import org.jlab.coda.jevio.IEvioListener;
import org.jlab.coda.jevio.IEvioStructure;
import org.jlab.coda.jevio.SegmentHeader;
import org.jlab.coda.jevio.TagSegmentHeader;

public class EventParser {
    private EventListenerList evioListenerList;
    protected boolean notificationActive = true;
    private IEvioFilter evioFilter;

    public synchronized void parseEvent(EvioEvent evioEvent) throws EvioException {
        if (evioEvent == null) {
            throw new EvioException("Null event in parseEvent.");
        }
        if (evioEvent.parsed) {
            System.out.println("Event already parsed");
            return;
        }
        this.notifyStart(evioEvent);
        this.parseStructure(evioEvent, evioEvent);
        evioEvent.parsed = true;
        this.notifyStop(evioEvent);
    }

    private void parseStructure(EvioEvent evioEvent, BaseStructure structure) throws EvioException {
        BaseStructure child = structure;
        BaseStructure parent = child.getParent();
        if (parent == null) {
            evioEvent.treeModel = new DefaultTreeModel(evioEvent);
        } else {
            evioEvent.insert(child, parent);
        }
        DataType dataType = structure.getHeader().getDataType();
        if (!dataType.isStructure()) {
            this.notifyEvioListeners(evioEvent, structure);
            return;
        }
        byte[] bytes = structure.getRawBytes();
        ByteOrder byteOrder = structure.getByteOrder();
        if (bytes == null && evioEvent == null) {
            throw new EvioException("Null data in parseStructure (Bank).");
        }
        int length = bytes.length;
        switch (dataType) {
            case BANK: 
            case ALSOBANK: {
                int offset;
                BankHeader header;
                for (offset = 0; offset < length; offset += 4 * (header.getLength() + 1)) {
                    header = EventParser.createBankHeader(bytes, offset, byteOrder);
                    int newByteLen = 4 * (header.getLength() - 1);
                    byte[] newBytes = new byte[newByteLen];
                    System.arraycopy(bytes, offset + 8, newBytes, 0, newByteLen);
                    EvioBank childBank = new EvioBank(header);
                    childBank.setParent(structure);
                    childBank.setRawBytes(newBytes);
                    childBank.setByteOrder(byteOrder);
                    this.parseStructure(evioEvent, childBank);
                }
                break;
            }
            case SEGMENT: 
            case ALSOSEGMENT: {
                int offset;
                while (offset < length) {
                    SegmentHeader header = EventParser.createSegmentHeader(bytes, offset, byteOrder);
                    int newByteLen = 4 * header.getLength();
                    byte[] newBytes = new byte[newByteLen];
                    System.arraycopy(bytes, offset + 4, newBytes, 0, newByteLen);
                    EvioSegment childSegment = new EvioSegment(header);
                    childSegment.setParent(structure);
                    childSegment.setRawBytes(newBytes);
                    childSegment.setByteOrder(byteOrder);
                    this.parseStructure(evioEvent, childSegment);
                    offset += 4 * (header.getLength() + 1);
                }
                break;
            }
            case TAGSEGMENT: {
                int offset;
                while (offset < length) {
                    TagSegmentHeader header = EventParser.createTagSegmentHeader(bytes, offset, byteOrder);
                    int newByteLen = 4 * header.getLength();
                    byte[] newBytes = new byte[newByteLen];
                    System.arraycopy(bytes, offset + 4, newBytes, 0, newByteLen);
                    EvioTagSegment childTagSegment = new EvioTagSegment(header);
                    childTagSegment.setParent(structure);
                    childTagSegment.setRawBytes(newBytes);
                    childTagSegment.setByteOrder(byteOrder);
                    this.parseStructure(evioEvent, childTagSegment);
                    offset += 4 * (header.getLength() + 1);
                }
                break;
            }
        }
        this.notifyEvioListeners(evioEvent, structure);
    }

    static BankHeader createBankHeader(byte[] bytes, int offset, ByteOrder byteOrder) throws EvioException {
        BankHeader header = new BankHeader();
        if (offset + 8 > bytes.length) {
            throw new EvioException("bad evio format");
        }
        int len = ByteDataTransformer.toInt(bytes, byteOrder, offset);
        if (len < 1 || 4 * len + 4 + offset > bytes.length) {
            throw new EvioException("bad length in bank header (0x" + Integer.toHexString(len) + ")");
        }
        header.setLength(len);
        offset += 4;
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            header.setTag(ByteDataTransformer.shortBitsToInt(ByteDataTransformer.toShort(bytes, byteOrder, offset)));
            int dt = ByteDataTransformer.byteBitsToInt(bytes[offset += 2]);
            ++offset;
            int type = dt & 0x3F;
            int padding = dt >>> 6;
            if (dt == 64) {
                type = DataType.TAGSEGMENT.getValue();
                padding = 0;
            }
            header.setDataType(type);
            header.setPadding(padding);
            header.setNumber(ByteDataTransformer.byteBitsToInt(bytes[offset]));
        } else {
            header.setNumber(ByteDataTransformer.byteBitsToInt(bytes[offset]));
            int dt = ByteDataTransformer.byteBitsToInt(bytes[++offset]);
            ++offset;
            int type = dt & 0x3F;
            int padding = dt >>> 6;
            if (dt == 64) {
                type = DataType.TAGSEGMENT.getValue();
                padding = 0;
            }
            header.setDataType(type);
            header.setPadding(padding);
            header.setTag(ByteDataTransformer.shortBitsToInt(ByteDataTransformer.toShort(bytes, byteOrder, offset)));
        }
        return header;
    }

    static SegmentHeader createSegmentHeader(byte[] bytes, int offset, ByteOrder byteOrder) throws EvioException {
        SegmentHeader header = new SegmentHeader();
        if (offset + 4 > bytes.length) {
            throw new EvioException("bad evio format");
        }
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            header.setTag(ByteDataTransformer.byteBitsToInt(bytes[offset]));
            int dt = ByteDataTransformer.byteBitsToInt(bytes[++offset]);
            ++offset;
            int type = dt & 0x3F;
            int padding = dt >>> 6;
            if (dt == 64) {
                type = DataType.TAGSEGMENT.getValue();
                padding = 0;
            }
            header.setDataType(type);
            header.setPadding(padding);
            int len = ByteDataTransformer.shortBitsToInt(ByteDataTransformer.toShort(bytes, byteOrder, offset));
            if (len < 1 || 4 * len + 2 + offset > bytes.length) {
                System.out.println("Type = " + (Object)((Object)DataType.getDataType(type)) + ", offset = " + offset + ", len = " + len);
                throw new EvioException("bad length in seg header (0x" + Integer.toHexString(len) + ")," + "4(len + 1) + off = " + (4 * len + 4 + offset) + " > limit = " + bytes.length);
            }
            header.setLength(len);
        } else {
            int len = ByteDataTransformer.shortBitsToInt(ByteDataTransformer.toShort(bytes, byteOrder, offset));
            if (len < 1 || 4 * len + 4 + offset > bytes.length) {
                throw new EvioException("bad length in seg header (0x" + Integer.toHexString(len) + ")");
            }
            header.setLength(len);
            int dt = ByteDataTransformer.byteBitsToInt(bytes[offset += 2]);
            ++offset;
            int type = dt & 0x3F;
            int padding = dt >>> 6;
            if (dt == 64) {
                type = DataType.TAGSEGMENT.getValue();
                padding = 0;
            }
            header.setDataType(type);
            header.setPadding(padding);
            header.setTag(ByteDataTransformer.byteBitsToInt(bytes[offset]));
        }
        return header;
    }

    static TagSegmentHeader createTagSegmentHeader(byte[] bytes, int offset, ByteOrder byteOrder) throws EvioException {
        TagSegmentHeader header = new TagSegmentHeader();
        if (offset + 4 > bytes.length) {
            throw new EvioException("bad evio format");
        }
        try {
            if (byteOrder == ByteOrder.BIG_ENDIAN) {
                int temp = ByteDataTransformer.shortBitsToInt(ByteDataTransformer.toShort(bytes, byteOrder, offset));
                header.setTag(temp >>> 4);
                header.setDataType(temp & 0xF);
                int len = ByteDataTransformer.shortBitsToInt(ByteDataTransformer.toShort(bytes, byteOrder, offset += 2));
                if (len < 1 || 4 * len + 2 + offset > bytes.length) {
                    throw new EvioException("bad length in tagseg header (0x" + Integer.toHexString(len) + ")");
                }
                header.setLength(len);
            } else {
                int len = ByteDataTransformer.shortBitsToInt(ByteDataTransformer.toShort(bytes, byteOrder, offset));
                if (len < 1 || 4 * len + 4 + offset > bytes.length) {
                    throw new EvioException("bad length in tagseg header (0x" + Integer.toHexString(len) + ")");
                }
                header.setLength(len);
                int temp = ByteDataTransformer.shortBitsToInt(ByteDataTransformer.toShort(bytes, byteOrder, offset += 2));
                header.setTag(temp >>> 4);
                header.setDataType(temp & 0xF);
            }
        }
        catch (EvioException e) {
            // empty catch block
        }
        return header;
    }

    protected void notifyEvioListeners(EvioEvent evioEvent, IEvioStructure structure) {
        if (!this.notificationActive) {
            return;
        }
        if (this.evioListenerList == null) {
            return;
        }
        if (this.evioFilter != null && !this.evioFilter.accept(structure.getStructureType(), structure)) {
            return;
        }
        Object[] listeners = this.evioListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IEvioListener.class) continue;
            ((IEvioListener)listeners[i + 1]).gotStructure(evioEvent, structure);
        }
    }

    protected void notifyStart(EvioEvent evioEvent) {
        if (!this.notificationActive) {
            return;
        }
        if (this.evioListenerList == null) {
            return;
        }
        Object[] listeners = this.evioListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IEvioListener.class) continue;
            ((IEvioListener)listeners[i + 1]).startEventParse(evioEvent);
        }
    }

    protected void notifyStop(EvioEvent evioEvent) {
        if (!this.notificationActive) {
            return;
        }
        if (this.evioListenerList == null) {
            return;
        }
        Object[] listeners = this.evioListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IEvioListener.class) continue;
            ((IEvioListener)listeners[i + 1]).endEventParse(evioEvent);
        }
    }

    public void removeEvioListener(IEvioListener listener) {
        if (listener == null || this.evioListenerList == null) {
            return;
        }
        this.evioListenerList.remove(IEvioListener.class, listener);
    }

    public void addEvioListener(IEvioListener listener) {
        if (listener == null) {
            return;
        }
        if (this.evioListenerList == null) {
            this.evioListenerList = new EventListenerList();
        }
        this.evioListenerList.add(IEvioListener.class, listener);
    }

    public boolean isNotificationActive() {
        return this.notificationActive;
    }

    public void setNotificationActive(boolean notificationActive) {
        this.notificationActive = notificationActive;
    }

    public void setEvioFilter(IEvioFilter evioFilter) {
        this.evioFilter = evioFilter;
    }
}

