/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.BitSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.BlockHeaderV4;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.Utilities;

public class EventWriter {
    static final int BLOCK_LENGTH_OFFSET = 0;
    static final int BLOCK_NUMBER_OFFSET = 4;
    static final int HEADER_LENGTH_OFFSET = 8;
    static final int EVENT_COUNT_OFFSET = 12;
    static final int RESERVED1_COUNT_OFFSET = 16;
    static final int BIT_INFO_OFFSET = 20;
    static final int MAGIC_OFFSET = 28;
    static final int VERSION_MASK = 255;
    static int DEFAULT_BLOCK_SIZE = 64000;
    static int DEFAULT_BLOCK_COUNT = 10000;
    static int MAX_BLOCK_SIZE = 25600000;
    static int MAX_BLOCK_COUNT = 100000;
    static int MIN_BLOCK_SIZE = 256;
    static int MIN_BLOCK_COUNT = 1;
    static boolean debug;
    static final int headerBytes = 32;
    private int blockSizeMax;
    private int blockCountMax;
    private int blockNumber;
    private String xmlDictionary;
    private boolean wroteDictionary;
    private int dictionaryBankBytes;
    byte[] dictionaryBytes;
    private BitSet bitInfo;
    private boolean closed;
    private boolean toFile;
    private boolean append;
    private int targetBlockSize;
    private int reserved1;
    private int reserved2;
    private long bytesWrittenToBuffer;
    private int eventsWrittenToBuffer;
    private int eventsWrittenTotal;
    private int currentHeaderPosition;
    private int currentBlockSize;
    private int currentBlockEventCount;
    private int bufferSize;
    private ByteBuffer buffer;
    private ByteOrder byteOrder;
    private File currentFile;
    private RandomAccessFile raf;
    private FileChannel fileChannel;
    private int splitCount;
    public String baseFileName;
    public int specifierCount;
    public int runNumber;
    private long split;
    private boolean overWriteOK;
    private long bytesWrittenToFile;
    private int eventsWrittenToFile;
    private FileCloser fileCloser;

    public EventWriter(File file) throws EvioException {
        this(file, false);
    }

    public EventWriter(File file, boolean append) throws EvioException {
        this(file, DEFAULT_BLOCK_SIZE, DEFAULT_BLOCK_COUNT, ByteOrder.nativeOrder(), null, null, true, append);
    }

    public EventWriter(File file, String dictionary, boolean append) throws EvioException {
        this(file, DEFAULT_BLOCK_SIZE, DEFAULT_BLOCK_COUNT, ByteOrder.nativeOrder(), dictionary, null, true, append);
    }

    public EventWriter(String filename) throws EvioException {
        this(filename, false);
    }

    public EventWriter(String filename, boolean append) throws EvioException {
        this(new File(filename), DEFAULT_BLOCK_SIZE, DEFAULT_BLOCK_COUNT, ByteOrder.nativeOrder(), null, null, true, append);
    }

    public EventWriter(String filename, boolean append, ByteOrder byteOrder) throws EvioException {
        this(new File(filename), DEFAULT_BLOCK_SIZE, DEFAULT_BLOCK_COUNT, byteOrder, null, null, true, append);
    }

    public EventWriter(File file, int blockSizeMax, int blockCountMax, ByteOrder byteOrder, String xmlDictionary, BitSet bitInfo) throws EvioException {
        this(file, blockSizeMax, blockCountMax, byteOrder, xmlDictionary, bitInfo, true, false);
    }

    public EventWriter(File file, int blockSizeMax, int blockCountMax, ByteOrder byteOrder, String xmlDictionary, BitSet bitInfo, boolean overWriteOK) throws EvioException {
        this(file, blockSizeMax, blockCountMax, byteOrder, xmlDictionary, bitInfo, overWriteOK, false);
    }

    public EventWriter(File file, int blockSizeMax, int blockCountMax, ByteOrder byteOrder, String xmlDictionary, BitSet bitInfo, boolean overWriteOK, boolean append) throws EvioException {
        this(file.getPath(), null, null, 0, 0L, blockSizeMax, blockCountMax, 0, byteOrder, xmlDictionary, bitInfo, overWriteOK, append);
    }

    public EventWriter(String baseName, String directory, String runType, int runNumber, long split, ByteOrder byteOrder, String xmlDictionary) throws EvioException {
        this(baseName, directory, runType, runNumber, split, DEFAULT_BLOCK_SIZE, DEFAULT_BLOCK_COUNT, 0, byteOrder, xmlDictionary, null, false, false);
    }

    public EventWriter(String baseName, String directory, String runType, int runNumber, long split, ByteOrder byteOrder, String xmlDictionary, boolean overWriteOK) throws EvioException {
        this(baseName, directory, runType, runNumber, split, DEFAULT_BLOCK_SIZE, DEFAULT_BLOCK_COUNT, 0, byteOrder, xmlDictionary, null, overWriteOK, false);
    }

    public EventWriter(String baseName, String directory, String runType, int runNumber, long split, int blockSizeMax, int blockCountMax, int bufferSize, ByteOrder byteOrder, String xmlDictionary, BitSet bitInfo, boolean overWriteOK, boolean append) throws EvioException {
        if (baseName == null) {
            throw new EvioException("baseName arg is null");
        }
        if (blockSizeMax < MIN_BLOCK_SIZE) {
            throw new EvioException("blockSizeMax arg must be bigger");
        }
        if (blockSizeMax > MAX_BLOCK_SIZE) {
            throw new EvioException("blockSizeMax arg must be smaller");
        }
        if (blockCountMax < MIN_BLOCK_COUNT) {
            throw new EvioException("blockCountMax arg must be bigger");
        }
        if (blockCountMax > MAX_BLOCK_COUNT) {
            throw new EvioException("blockCountMax arg must be smaller");
        }
        if (xmlDictionary != null && append) {
            throw new EvioException("Cannot specify dictionary when appending");
        }
        if (split > 0L && append) {
            throw new EvioException("Cannot specify split when appending");
        }
        if (bufferSize < 4 * blockSizeMax + 32) {
            bufferSize = 4 * blockSizeMax + 32;
        }
        if (byteOrder == null) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        this.split = split;
        this.append = append;
        this.runNumber = runNumber;
        this.byteOrder = byteOrder;
        this.bufferSize = bufferSize;
        this.overWriteOK = overWriteOK;
        this.blockSizeMax = blockSizeMax;
        this.blockCountMax = blockCountMax;
        this.xmlDictionary = xmlDictionary;
        this.toFile = true;
        this.blockNumber = 1;
        if (bitInfo != null) {
            this.bitInfo = (BitSet)bitInfo.clone();
        }
        this.splitCount = 0;
        if (directory != null) {
            baseName = directory + "/" + baseName;
        }
        StringBuilder builder = new StringBuilder(100);
        this.specifierCount = Utilities.generateBaseFileName(baseName, runType, builder);
        this.baseFileName = builder.toString();
        String fileName = Utilities.generateFileName(this.baseFileName, this.specifierCount, runNumber, split, this.splitCount++);
        this.currentFile = new File(fileName);
        if (!overWriteOK && !append && this.currentFile.exists() && this.currentFile.isFile()) {
            throw new EvioException("File exists but user requested no over-writing or appending, " + this.currentFile.getPath());
        }
        this.buffer = ByteBuffer.allocateDirect(bufferSize);
        this.buffer.order(byteOrder);
        this.targetBlockSize = 4 * blockSizeMax;
        this.currentBlockSize = 8;
        if (split > 0L) {
            this.fileCloser = new FileCloser();
        }
        try {
            if (append) {
                this.raf = new RandomAccessFile(this.currentFile, "rw");
                this.fileChannel = this.raf.getChannel();
                if (this.fileChannel.size() > 0L) {
                    this.examineFirstBlockHeader();
                    if (this.byteOrder != byteOrder) {
                        this.buffer.order(this.byteOrder);
                    }
                    this.toAppendPosition();
                    this.buffer.clear();
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new EvioException("File could not be opened for writing, " + this.currentFile.getPath(), e);
        }
        catch (IOException e) {
            throw new EvioException("File could not be positioned for appending, " + this.currentFile.getPath(), e);
        }
        if (xmlDictionary == null) {
            this.writeNewHeader(8, 0, this.blockNumber++, bitInfo, false, false, true, false);
        } else {
            this.writeNewHeader(8, 0, this.blockNumber++, bitInfo, true, false, true, false);
            this.writeDictionary();
        }
        this.writeEmptyLastBlockHeader(this.blockNumber);
    }

    public EventWriter(ByteBuffer buf) throws EvioException {
        this(buf, DEFAULT_BLOCK_SIZE, DEFAULT_BLOCK_COUNT, null, null, 0, false);
    }

    public EventWriter(ByteBuffer buf, boolean append) throws EvioException {
        this(buf, DEFAULT_BLOCK_SIZE, DEFAULT_BLOCK_COUNT, null, null, 0, append);
    }

    public EventWriter(ByteBuffer buf, String xmlDictionary, boolean append) throws EvioException {
        this(buf, DEFAULT_BLOCK_SIZE, DEFAULT_BLOCK_COUNT, xmlDictionary, null, 0, append);
    }

    public EventWriter(ByteBuffer buf, int blockSizeMax, int blockCountMax, String xmlDictionary, BitSet bitInfo) throws EvioException {
        this(buf, blockSizeMax, blockCountMax, xmlDictionary, bitInfo, 0, false);
    }

    public EventWriter(ByteBuffer buf, int blockSizeMax, int blockCountMax, String xmlDictionary, BitSet bitInfo, boolean append) throws EvioException {
        this(buf, blockSizeMax, blockCountMax, xmlDictionary, bitInfo, 0, append);
    }

    public EventWriter(ByteBuffer buf, int blockSizeMax, int blockCountMax, String xmlDictionary, BitSet bitInfo, int reserved1, int blockNumber) throws EvioException {
        this.initializeBuffer(buf, blockSizeMax, blockCountMax, xmlDictionary, bitInfo, reserved1, blockNumber, false);
    }

    public EventWriter(ByteBuffer buf, int blockSizeMax, int blockCountMax, String xmlDictionary, BitSet bitInfo, int reserved1, boolean append) throws EvioException {
        this.initializeBuffer(buf, blockSizeMax, blockCountMax, xmlDictionary, bitInfo, reserved1, 0, append);
    }

    private void initializeBuffer(ByteBuffer buf, int blockSizeMax, int blockCountMax, String xmlDictionary, BitSet bitInfo, int reserved1, int blockNumber, boolean append) throws EvioException {
        if (blockSizeMax < MIN_BLOCK_SIZE) {
            throw new EvioException("Max block size arg (" + blockSizeMax + ") must be >= " + MIN_BLOCK_SIZE);
        }
        if (blockSizeMax > MAX_BLOCK_SIZE) {
            throw new EvioException("Max block size arg (" + blockSizeMax + ") must be <= " + MAX_BLOCK_SIZE);
        }
        if (blockCountMax < MIN_BLOCK_COUNT) {
            throw new EvioException("Max block count arg (" + blockCountMax + ") must be >= " + MIN_BLOCK_COUNT);
        }
        if (blockCountMax > MAX_BLOCK_COUNT) {
            throw new EvioException("Max block count arg (" + blockCountMax + ") must be <= " + MAX_BLOCK_COUNT);
        }
        if (buf == null) {
            throw new EvioException("Buffer arg cannot be null");
        }
        if (xmlDictionary != null && append) {
            throw new EvioException("Cannot specify dictionary when appending");
        }
        this.append = append;
        this.buffer = buf;
        this.byteOrder = buf.order();
        this.reserved1 = reserved1;
        this.blockNumber = blockNumber;
        this.blockSizeMax = blockSizeMax;
        this.blockCountMax = blockCountMax;
        this.xmlDictionary = xmlDictionary;
        this.split = 0L;
        this.toFile = false;
        this.closed = false;
        this.eventsWrittenTotal = 0;
        this.eventsWrittenToBuffer = 0;
        this.bytesWrittenToBuffer = 0L;
        this.currentBlockSize = 8;
        this.currentBlockEventCount = 0;
        this.buffer.position(0);
        this.bufferSize = buf.capacity();
        this.targetBlockSize = 4 * blockSizeMax;
        if (bitInfo != null) {
            this.bitInfo = (BitSet)bitInfo.clone();
        }
        try {
            if (append) {
                this.examineFirstBlockHeader();
                this.toAppendPosition();
            }
        }
        catch (IOException e) {
            throw new EvioException("Buffer could not be positioned for appending", e);
        }
        if (xmlDictionary == null) {
            this.writeNewHeader(8, 0, this.blockNumber++, bitInfo, false, false, true, false);
        } else {
            this.writeNewHeader(8, 0, this.blockNumber++, bitInfo, true, false, true, false);
            this.writeDictionary();
        }
        this.writeEmptyLastBlockHeader(this.blockNumber);
    }

    public long getBytesWrittenToBuffer() {
        return this.bytesWrittenToBuffer;
    }

    public void setBuffer(ByteBuffer buf, BitSet bitInfo, int blockNumber) throws EvioException {
        if (this.toFile) {
            return;
        }
        if (!this.closed) {
            throw new EvioException("close EventWriter before changing buffers");
        }
        this.bitInfo = bitInfo;
        this.initializeBuffer(buf, this.blockSizeMax, this.blockCountMax, this.xmlDictionary, bitInfo, this.reserved1, blockNumber, this.append);
    }

    public void setBuffer(ByteBuffer buf) throws EvioException {
        if (this.toFile) {
            return;
        }
        if (!this.closed) {
            throw new EvioException("close EventWriter before changing buffers");
        }
        this.initializeBuffer(buf, this.blockSizeMax, this.blockCountMax, this.xmlDictionary, this.bitInfo, this.reserved1, 1, this.append);
    }

    private ByteBuffer getBuffer() {
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getByteBuffer() {
        ByteBuffer buf;
        if (this.toFile()) {
            return null;
        }
        EventWriter eventWriter = this;
        synchronized (eventWriter) {
            buf = this.buffer.duplicate().order(this.buffer.order());
            if (!this.closed && buf.position() < buf.capacity() - 32) {
                buf.position(buf.position() + 32);
            }
        }
        buf.flip();
        return buf;
    }

    public boolean toFile() {
        return this.toFile;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public String getCurrentFilename() {
        if (this.currentFile != null) {
            return this.currentFile.getName();
        }
        return null;
    }

    public String getCurrentFilePath() {
        if (this.currentFile != null) {
            return this.currentFile.getPath();
        }
        return null;
    }

    public int getSplitCount() {
        return this.splitCount;
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public int getEventsWritten() {
        return this.eventsWrittenTotal;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setStartingBlockNumber(int startingBlockNumber) {
        if (this.eventsWrittenTotal > 0) {
            return;
        }
        this.blockNumber = startingBlockNumber;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        if (debug) {
            System.out.println("close: called");
        }
        try {
            if (this.toFile) {
                if (debug) {
                    System.out.println("close: flush what we have to file");
                }
                this.flushToFile(true);
            } else {
                this.buffer.position(this.buffer.position() + 32);
            }
        }
        catch (EvioException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.toFile && this.raf != null) {
                this.raf.close();
                if (this.fileCloser != null) {
                    this.fileCloser.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closed = true;
    }

    protected synchronized IOStatus examineFirstBlockHeader() throws IOException, EvioException {
        int currentPosition;
        if (!this.append) {
            throw new EvioException("need to be in append mode");
        }
        if (this.toFile) {
            this.buffer.clear();
            this.buffer.limit(32);
            int nBytes = this.fileChannel.read(this.buffer);
            if (nBytes != 32) {
                throw new EvioException("bad file format");
            }
            currentPosition = 0;
            this.fileChannel.position(0L);
        } else {
            if (this.buffer.remaining() < 32) {
                return IOStatus.END_OF_FILE;
            }
            currentPosition = this.buffer.position();
        }
        try {
            int bitInfo;
            int evioVersion;
            this.byteOrder = this.buffer.order();
            int magicNumber = this.buffer.getInt(currentPosition + 28);
            if (magicNumber != -1059454720) {
                this.byteOrder = this.byteOrder == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                this.buffer.order(this.byteOrder);
                magicNumber = this.buffer.getInt(currentPosition + 28);
                if (magicNumber != -1059454720) {
                    System.out.println("ERROR: reread magic # (" + magicNumber + ") & still not right");
                    return IOStatus.EVIO_EXCEPTION;
                }
            }
            if ((evioVersion = (bitInfo = this.buffer.getInt(currentPosition + 20)) & 0xFF) < 4) {
                System.out.println("ERROR: evio version# = " + evioVersion);
                return IOStatus.EVIO_EXCEPTION;
            }
        }
        catch (BufferUnderflowException a) {
            System.err.println("ERROR endOfBuffer " + a);
            return IOStatus.UNKNOWN_ERROR;
        }
        return IOStatus.SUCCESS;
    }

    private void toAppendPosition() throws EvioException, IOException {
        int headerLength;
        int blockLength;
        int bitInfo;
        int nBytes;
        if (!this.append) {
            throw new EvioException("need to be in append mode");
        }
        this.blockNumber = 1;
        while (true) {
            int currentPosition;
            if (this.toFile) {
                this.buffer.clear();
                this.buffer.limit(32);
                nBytes = this.fileChannel.read(this.buffer);
                if (nBytes != 32) {
                    throw new EvioException("bad file format");
                }
                currentPosition = 0;
            } else {
                if (this.buffer.remaining() < 32) {
                    throw new EvioException("bad buffer format");
                }
                currentPosition = this.buffer.position();
            }
            bitInfo = this.buffer.getInt(currentPosition + 20);
            blockLength = this.buffer.getInt(currentPosition + 0);
            int blockNum = this.buffer.getInt(currentPosition + 4);
            headerLength = this.buffer.getInt(currentPosition + 8);
            int blockEventCount = this.buffer.getInt(currentPosition + 12);
            boolean lastBlock = BlockHeaderV4.isLastBlock(bitInfo);
            this.eventsWrittenTotal += blockEventCount;
            if (!this.toFile) {
                this.eventsWrittenToBuffer += blockEventCount;
            }
            ++this.blockNumber;
            if (lastBlock) break;
            if (this.toFile) {
                this.fileChannel.position(this.fileChannel.position() + (long)(4 * blockLength) - 32L);
                continue;
            }
            if (this.buffer.remaining() < 4 * blockLength) {
                throw new EvioException("bad buffer format");
            }
            this.buffer.position(this.buffer.position() + 4 * blockLength);
        }
        if (this.toFile) {
            this.eventsWrittenToFile = this.eventsWrittenTotal;
        }
        if (blockLength > headerLength) {
            bitInfo = BlockHeaderV4.clearLastBlockBit(bitInfo);
            if (this.toFile) {
                this.fileChannel.position(this.fileChannel.position() - 12L);
                this.buffer.clear();
                this.buffer.putInt(bitInfo);
                this.buffer.flip();
                nBytes = this.fileChannel.write(this.buffer);
                if (nBytes != 4) {
                    throw new EvioException("file writing error");
                }
                this.fileChannel.position(this.fileChannel.position() + (long)(4 * blockLength) - 21L);
            } else {
                this.buffer.putInt(this.buffer.position() + 20, bitInfo);
                this.buffer.position(this.buffer.position() + 4 * blockLength);
            }
        } else {
            --this.blockNumber;
            if (this.toFile) {
                this.fileChannel.position(this.fileChannel.position() - 32L);
            }
        }
        if (this.toFile) {
            this.writeEmptyLastBlockHeaderToFile(this.blockNumber);
            this.bytesWrittenToFile = this.fileChannel.position();
        } else {
            if (this.buffer.remaining() < 32) {
                throw new EvioException("bad buffer format");
            }
            this.writeEmptyLastBlockHeader(this.blockNumber);
            this.bytesWrittenToBuffer = this.buffer.position() + 32;
        }
    }

    private void writeEmptyLastBlockHeaderToFile(int blockNumber) throws IOException {
        this.buffer.clear().position(0);
        this.buffer.putInt(8);
        this.buffer.putInt(blockNumber);
        this.buffer.putInt(8);
        this.buffer.putInt(0);
        this.buffer.putInt(this.reserved1);
        this.buffer.putInt(BlockHeaderV4.generateSixthWord(4, false, true, 0));
        this.buffer.putInt(this.reserved2);
        this.buffer.putInt(-1059454720);
        this.buffer.flip();
        this.fileChannel.write(this.buffer);
    }

    private void writeEmptyLastBlockHeader(int blockNumber) throws EvioException {
        this.writeNewHeader(8, 0, blockNumber, null, false, true, false, true);
    }

    private void writeNewHeader(int words, int eventCount, int blockNumber, BitSet bitInfo, boolean hasDictionary, boolean isLast, boolean currentHeader, boolean absoluteMode) throws EvioException {
        if (this.buffer.remaining() < 32) {
            throw new EvioException("Buffer size exceeded");
        }
        if (currentHeader) {
            this.currentHeaderPosition = this.buffer.position();
        }
        int sixthWord = BlockHeaderV4.generateSixthWord(bitInfo, 4, hasDictionary, isLast, 0);
        if (absoluteMode) {
            int pos = this.buffer.position();
            this.buffer.putInt(pos, words);
            this.buffer.putInt(pos + 4, blockNumber);
            this.buffer.putInt(pos + 8, 8);
            this.buffer.putInt(pos + 12, eventCount);
            this.buffer.putInt(pos + 16, this.reserved1);
            this.buffer.putInt(pos + 20, sixthWord);
            this.buffer.putInt(pos + 24, this.reserved2);
            this.buffer.putInt(pos + 28, -1059454720);
        } else {
            this.buffer.putInt(words);
            this.buffer.putInt(blockNumber);
            this.buffer.putInt(8);
            this.buffer.putInt(eventCount);
            this.buffer.putInt(this.reserved1);
            this.buffer.putInt(sixthWord);
            this.buffer.putInt(this.reserved2);
            this.buffer.putInt(-1059454720);
        }
        this.bytesWrittenToBuffer += 32L;
        if (debug) {
            System.out.println("writeNewHeader: set bytesWrittenToBuffer to " + this.bytesWrittenToBuffer);
        }
    }

    private void writeDictionary() throws EvioException {
        if (this.xmlDictionary == null || this.xmlDictionary.length() < 1) {
            throw new EvioException("no dictionary to write");
        }
        if (this.dictionaryBytes == null) {
            this.dictionaryBytes = BaseStructure.stringsToRawBytes(new String[]{this.xmlDictionary});
            this.dictionaryBankBytes = this.dictionaryBytes.length + 8;
        }
        if (this.dictionaryBankBytes > this.buffer.remaining()) {
            if (!this.toFile) {
                throw new EvioException("Not enough room in buffer for dictionary");
            }
            this.expandBuffer(this.dictionaryBankBytes + 64);
            this.resetBuffer(true);
        }
        if (debug) {
            System.out.println("writeDictionary: write dictionary with bank bytes = " + this.dictionaryBankBytes + ", remaining = " + this.buffer.remaining());
        }
        this.buffer.putInt(this.dictionaryBytes.length / 4 + 1);
        if (this.buffer.order() == ByteOrder.BIG_ENDIAN) {
            this.buffer.putShort((short)0);
            this.buffer.put((byte)DataType.CHARSTAR8.getValue());
            this.buffer.put((byte)0);
        } else {
            this.buffer.put((byte)0);
            this.buffer.put((byte)DataType.CHARSTAR8.getValue());
            this.buffer.putShort((short)0);
        }
        this.buffer.put(this.dictionaryBytes);
        this.currentBlockSize += this.dictionaryBankBytes / 4;
        this.bytesWrittenToBuffer += (long)this.dictionaryBankBytes;
        ++this.eventsWrittenToBuffer;
        ++this.currentBlockEventCount;
        this.wroteDictionary = true;
        this.buffer.putInt(this.currentHeaderPosition, this.currentBlockSize);
    }

    private void resetBuffer(boolean beforeDictionary) {
        this.buffer.position(0);
        this.buffer.limit(this.buffer.capacity());
        this.bytesWrittenToBuffer = 0L;
        this.eventsWrittenToBuffer = 0;
        try {
            if (beforeDictionary) {
                if (debug) {
                    System.out.println("      resetBuffer: as in constructor");
                }
                this.blockNumber = 1;
                this.writeNewHeader(8, 0, this.blockNumber++, null, true, false, true, false);
            } else {
                if (debug) {
                    System.out.println("      resetBuffer: NOTTTT as in constructor");
                }
                this.writeNewHeader(8, 0, this.blockNumber++, null, false, true, true, false);
            }
        }
        catch (EvioException evioException) {
            // empty catch block
        }
        if (debug) {
            System.out.println("      resetBuffer:  wrote header w/ blknum = " + (this.blockNumber - 1) + ", next blknum = " + this.blockNumber + ", remaining = " + this.buffer.remaining());
        }
        this.currentBlockSize = 8;
        this.currentBlockEventCount = 0;
    }

    private void expandBuffer(int newSize) {
        if (newSize <= this.bufferSize) {
            if (debug) {
                System.out.println("    expandBuffer: buffer is big enough");
            }
            return;
        }
        this.buffer = ByteBuffer.allocateDirect(newSize);
        this.buffer.order(this.byteOrder);
        this.bufferSize = newSize;
        if (debug) {
            System.out.println("    expandBuffer: increased buf size to " + newSize + " bytes");
        }
    }

    private void writeEventToBuffer(EvioBank bank, ByteBuffer bankBuffer, int currentEventBytes) throws EvioException {
        int headerInfoWord;
        if (debug) {
            System.out.println("  writeEventToBuffer: before write, bytesToBuf = " + this.bytesWrittenToBuffer);
        }
        if (bank != null) {
            bank.write(this.buffer);
        } else if (bankBuffer != null) {
            this.buffer.put(bankBuffer);
        } else {
            return;
        }
        this.currentBlockSize += currentEventBytes / 4;
        this.bytesWrittenToBuffer += (long)currentEventBytes;
        ++this.eventsWrittenTotal;
        ++this.eventsWrittenToBuffer;
        ++this.currentBlockEventCount;
        this.buffer.putInt(this.currentHeaderPosition, this.currentBlockSize);
        this.buffer.putInt(this.currentHeaderPosition + 12, this.currentBlockEventCount);
        if (this.wroteDictionary && this.blockNumber == 2 && this.currentBlockEventCount > 1) {
            if (debug) {
                System.out.println("  writeEventToBuffer: subtract ev cnt since in dictionary's blk, cnt = " + (this.currentBlockEventCount - 1));
            }
            this.buffer.putInt(this.currentHeaderPosition + 12, this.currentBlockEventCount - 1);
        }
        if (debug) {
            System.out.println("  writeEventToBuffer: after write,  bytesToBuf = " + this.bytesWrittenToBuffer + ", blksiz = " + this.currentBlockSize + ", blkEvCount (w/ dict) = " + this.currentBlockEventCount + ", blk # = " + this.blockNumber + ", wrote Dict = " + this.wroteDictionary);
        }
        if (BlockHeaderV4.isLastBlock(headerInfoWord = this.buffer.getInt(this.currentHeaderPosition + 20))) {
            this.buffer.putInt(this.currentHeaderPosition + 20, BlockHeaderV4.clearLastBlockBit(headerInfoWord));
        }
        this.writeEmptyLastBlockHeader(this.blockNumber);
        if (debug) {
            System.out.println("evWrite: after last header written, Events written to:");
            System.out.println("         cnt total (no dict) = " + this.eventsWrittenTotal);
            System.out.println("         file cnt total = " + this.eventsWrittenToFile);
            System.out.println("         internal buffer cnt = " + this.eventsWrittenToBuffer);
            System.out.println("         block cnt (w/ dict) = " + this.currentBlockEventCount);
            System.out.println("         bytes-to-buf  = " + this.bytesWrittenToBuffer);
            System.out.println("         bytes-to-file = " + this.bytesWrittenToFile);
            System.out.println("         block # = " + this.blockNumber);
        }
    }

    public boolean hasRoom(int bytes) {
        return this.toFile() || (long)this.bufferSize - this.bytesWrittenToBuffer >= (long)(bytes + 32);
    }

    public void writeEvent(EvioNode node, boolean force) throws EvioException, IOException {
        ByteBuffer bb = node.getBufferNode().getBuffer();
        ByteBuffer eventBuffer = bb.duplicate().order(bb.order());
        int pos = node.getPosition();
        eventBuffer.limit(pos + node.getTotalBytes()).position(pos);
        this.writeEvent(null, eventBuffer, force);
    }

    public void writeEvent(ByteBuffer eventBuffer) throws EvioException, IOException {
        this.writeEvent(null, eventBuffer, false);
    }

    public void writeEvent(EvioBank bank) throws EvioException, IOException {
        this.writeEvent(bank, null, false);
    }

    public void writeEvent(ByteBuffer bankBuffer, boolean force) throws EvioException, IOException {
        this.writeEvent(null, bankBuffer, force);
    }

    public void writeEvent(EvioBank bank, boolean force) throws EvioException, IOException {
        this.writeEvent(bank, null, force);
    }

    private synchronized void writeEvent(EvioBank bank, ByteBuffer bankBuffer, boolean force) throws EvioException, IOException {
        int currentEventBytes;
        if (this.closed) {
            throw new EvioException("close() has already been called");
        }
        boolean doFlush = false;
        boolean roomInBuffer = true;
        boolean splittingFile = false;
        boolean needBiggerBuffer = false;
        boolean writeNewBlockHeader = true;
        int newBufSize = 0;
        if (bank != null) {
            currentEventBytes = bank.getTotalBytes();
        } else if (bankBuffer != null) {
            if (bankBuffer.order() != this.byteOrder) {
                throw new EvioException("event buf is " + bankBuffer.order() + ", and writer is " + this.byteOrder);
            }
            currentEventBytes = bankBuffer.remaining();
            if (currentEventBytes % 4 != 0) {
                throw new EvioException("bad bankBuffer format");
            }
        } else {
            return;
        }
        if (currentEventBytes + 4 * this.currentBlockSize <= this.targetBlockSize && this.currentBlockEventCount < this.blockCountMax || this.currentBlockEventCount < 1) {
            writeNewBlockHeader = false;
        }
        if (!(this.split <= 0L || this.wroteDictionary && this.blockNumber - 1 == 1 && this.eventsWrittenToBuffer < 2)) {
            int headerInfoWord;
            long totalSize = (long)currentEventBytes + this.bytesWrittenToFile + this.bytesWrittenToBuffer;
            if (writeNewBlockHeader && this.bytesWrittenToFile < 1L) {
                totalSize += 32L;
            }
            if (BlockHeaderV4.isLastBlock(headerInfoWord = this.buffer.getInt(this.currentHeaderPosition + 20))) {
                totalSize += 32L;
            }
            if (totalSize > this.split) {
                splittingFile = true;
                if (this.eventsWrittenToBuffer > 0) {
                    doFlush = true;
                }
            }
        }
        if (this.bufferSize < currentEventBytes + 64) {
            if (!this.toFile) {
                System.out.println("evWrite: bufSize = " + this.bufferSize + " <? current event bytes = " + currentEventBytes + " + 2 headers (64), total = " + (currentEventBytes + 64) + ", room = " + ((long)this.bufferSize - this.bytesWrittenToBuffer - 32L));
                throw new EvioException("Buffer too small to write event");
            }
            roomInBuffer = false;
            needBiggerBuffer = true;
        } else if (!writeNewBlockHeader && (long)this.bufferSize - this.bytesWrittenToBuffer < (long)currentEventBytes || writeNewBlockHeader && (long)this.bufferSize - this.bytesWrittenToBuffer < (long)(currentEventBytes + 32)) {
            if (!this.toFile) {
                throw new EvioException("Buffer too small to write event");
            }
            roomInBuffer = false;
        }
        if (!roomInBuffer) {
            if (needBiggerBuffer) {
                newBufSize = currentEventBytes + 64;
            }
            doFlush = true;
        }
        if (doFlush) {
            this.flushToFile(false);
        }
        if (splittingFile) {
            this.splitFile();
        }
        if (needBiggerBuffer) {
            this.expandBuffer(newBufSize);
        }
        if (doFlush || splittingFile) {
            this.resetBuffer(false);
            writeNewBlockHeader = false;
        }
        if (this.xmlDictionary != null && splittingFile) {
            int neededBytes = this.dictionaryBankBytes + 96 + currentEventBytes;
            writeNewBlockHeader = true;
            this.expandBuffer(neededBytes);
            this.resetBuffer(true);
            this.writeDictionary();
        }
        if (writeNewBlockHeader) {
            this.currentBlockSize = 8;
            this.currentBlockEventCount = 0;
            this.writeNewHeader(this.currentBlockSize, 1, this.blockNumber++, null, false, false, true, false);
            this.bytesWrittenToBuffer -= 32L;
        } else {
            int headerInfoWord = this.buffer.getInt(this.currentHeaderPosition + 20);
            if (!BlockHeaderV4.isLastBlock(headerInfoWord)) {
                this.bytesWrittenToBuffer -= 32L;
            }
        }
        this.writeEventToBuffer(bank, bankBuffer, currentEventBytes);
        if (force && this.toFile) {
            this.flushToFile(true);
            this.resetBuffer(false);
        }
    }

    private void flushToFile(boolean force) throws EvioException, IOException {
        if (this.closed) {
            throw new EvioException("close() has already been called");
        }
        if (!this.toFile) {
            return;
        }
        if (this.eventsWrittenToBuffer < 1) {
            return;
        }
        this.buffer.position(this.buffer.position() + 32);
        this.buffer.flip();
        if (this.bytesWrittenToFile < 1L) {
            try {
                this.raf = new RandomAccessFile(this.currentFile, "rw");
                this.fileChannel = this.raf.getChannel();
            }
            catch (FileNotFoundException e) {
                throw new EvioException("File could not be opened for writing, " + this.currentFile.getPath(), e);
            }
        } else {
            this.bytesWrittenToFile -= 32L;
            this.fileChannel.position(this.fileChannel.position() - 32L);
        }
        int bytesWritten = this.buffer.remaining();
        while (this.buffer.hasRemaining()) {
            this.fileChannel.write(this.buffer);
        }
        if (force) {
            this.fileChannel.force(false);
        }
        this.buffer.position(0);
        this.buffer.limit(this.buffer.capacity());
        this.bytesWrittenToFile += (long)bytesWritten;
        ++this.eventsWrittenToFile;
    }

    private void splitFile() throws EvioException, IOException {
        this.blockNumber = 1;
        this.bytesWrittenToFile = 0L;
        this.eventsWrittenToFile = 0;
        if (this.raf != null) {
            this.fileCloser.closeFile(this.raf);
        }
        this.raf = null;
        String fileName = Utilities.generateFileName(this.baseFileName, this.specifierCount, this.runNumber, this.split, this.splitCount++);
        this.currentFile = new File(fileName);
        if (!this.overWriteOK && this.currentFile.exists() && this.currentFile.isFile()) {
            throw new EvioException("File exists but user requested no over-writing, " + this.currentFile.getPath());
        }
        if (debug) {
            System.out.println("splitFile: generated file name = " + fileName);
        }
    }

    private final class FileCloser {
        private final ExecutorService threadPool = Executors.newSingleThreadExecutor();

        FileCloser() {
        }

        void closeFile(RandomAccessFile raf) {
            this.threadPool.submit(new CloseThd(raf));
        }

        void close() {
            this.threadPool.shutdown();
        }

        private class CloseThd
        implements Runnable {
            private RandomAccessFile raf;

            CloseThd(RandomAccessFile raf) {
                this.raf = raf;
            }

            @Override
            public void run() {
                try {
                    this.raf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static enum IOStatus {
        SUCCESS,
        END_OF_FILE,
        EVIO_EXCEPTION,
        CANNOT_OPEN_FILE,
        UNKNOWN_ERROR;

    }
}

