/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.util.IllegalFormatException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.jevio.EvioException;

public class Utilities {
    public static int generateBaseFileName(String baseName, String runType, StringBuilder newNameBuilder) throws EvioException {
        String baseFileName;
        StringBuffer result;
        Matcher matcher;
        Pattern pattern;
        if (baseName == null || newNameBuilder == null) {
            throw new EvioException("null arg(s)");
        }
        String string = baseName = runType == null ? baseName.replace("%s", "") : baseName.replace("%s", runType);
        if (baseName.contains("$(")) {
            pattern = Pattern.compile("\\$\\((.*?)\\)");
            matcher = pattern.matcher(baseName);
            result = new StringBuffer(100);
            while (matcher.find()) {
                String envVar = matcher.group(1);
                String envVal = System.getenv(envVar);
                if (envVal == null) {
                    envVal = "";
                }
                matcher.appendReplacement(result, envVal);
            }
            matcher.appendTail(result);
            baseFileName = result.toString();
        } else {
            baseFileName = baseName;
        }
        pattern = Pattern.compile("%(\\d*)([xd])");
        matcher = pattern.matcher(baseFileName);
        result = new StringBuffer(100);
        int specifierCount = 0;
        while (matcher.find()) {
            String width = matcher.group(1);
            if (width.length() > 0 && !width.startsWith("0")) {
                String newWidth = "0" + width;
                matcher.appendReplacement(result, "%" + newWidth + matcher.group(2));
            }
            ++specifierCount;
        }
        matcher.appendTail(result);
        baseFileName = result.toString();
        if (specifierCount > 2) {
            throw new EvioException("baseName arg is improperly formatted");
        }
        newNameBuilder.delete(0, newNameBuilder.length()).append(baseFileName);
        return specifierCount;
    }

    public static String generateFileName(String baseFileName, int specifierCount, int runNumber, long split, int splitNumber) throws IllegalFormatException {
        String fileName = baseFileName;
        if (split > 0L) {
            if (specifierCount < 1) {
                fileName = baseFileName + "." + splitNumber;
            } else if (specifierCount == 1) {
                fileName = String.format(baseFileName, runNumber);
                fileName = fileName + "." + splitNumber;
            } else {
                fileName = String.format(baseFileName, runNumber, splitNumber);
            }
        } else if (specifierCount == 1) {
            fileName = String.format(baseFileName, runNumber);
        } else if (specifierCount == 2) {
            Pattern pattern = Pattern.compile("(%\\d*[xd])");
            Matcher matcher = pattern.matcher(fileName);
            StringBuffer result = new StringBuffer(100);
            if (matcher.find() && matcher.find()) {
                matcher.appendReplacement(result, "");
                matcher.appendTail(result);
                fileName = result.toString();
            }
            fileName = String.format(fileName, runNumber);
        }
        return fileName;
    }

    public static void bufferToFile(String fileName, ByteBuffer buf, boolean overWriteOK, boolean addBlockHeader) throws IOException, EvioException {
        if (fileName == null || buf == null) {
            throw new EvioException("null arg(s)");
        }
        File file = new File(fileName);
        if (!overWriteOK && file.exists() && file.isFile()) {
            throw new EvioException("File exists but over-writing not permitted, " + file.getPath());
        }
        int limit = buf.limit();
        int position = buf.position();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        FileChannel fileChannel = fileOutputStream.getChannel();
        if (addBlockHeader) {
            ByteBuffer blockHead = ByteBuffer.allocate(32);
            blockHead.order(buf.order());
            blockHead.putInt(8 + (limit - position) / 4);
            blockHead.putInt(1);
            blockHead.putInt(8);
            blockHead.putInt(1);
            blockHead.putInt(0);
            blockHead.putInt(516);
            blockHead.putInt(0);
            blockHead.putInt(-1059454720);
            blockHead.flip();
            fileChannel.write(blockHead);
        }
        fileChannel.write(buf);
        fileChannel.close();
        buf.limit(limit).position(position);
    }

    public static synchronized void printBuffer(ByteBuffer buf, int position, int words, String label) {
        IntBuffer ibuf;
        if (buf == null) {
            System.out.println("printBuffer: buf arg is null");
            return;
        }
        int origPos = buf.position();
        buf.position(position);
        if (label != null) {
            System.out.println(label + ":");
        }
        words = words > (ibuf = buf.asIntBuffer()).capacity() / 4 ? ibuf.capacity() / 4 : words;
        for (int i = 0; i < words; ++i) {
            System.out.println("  Buf(" + i + ") = 0x" + Integer.toHexString(ibuf.get(i)));
        }
        System.out.println();
        buf.position(origPos);
    }
}

