/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioReader;

public class EvioFileTest {
    public static int totalBlockCount(EvioReader reader) {
        EvioReader.ReadStatus status = EvioReader.ReadStatus.SUCCESS;
        int count = 0;
        try {
            reader.rewind();
            while (status == EvioReader.ReadStatus.SUCCESS) {
                status = reader.nextBlockHeader();
                if (status != EvioReader.ReadStatus.SUCCESS) continue;
                reader.position((int)reader.getCurrentBlockHeader().nextBufferStartingPosition());
                ++count;
            }
            reader.rewind();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("total block count: " + count);
        return count;
    }

    public static TestResult readAllBlockHeadersTest(EvioReader reader) {
        TestResult result;
        int blockCount = 0;
        EvioReader.ReadStatus status = EvioReader.ReadStatus.SUCCESS;
        try {
            reader.rewind();
            while (status == EvioReader.ReadStatus.SUCCESS) {
                status = reader.nextBlockHeader();
                if (status != EvioReader.ReadStatus.SUCCESS) continue;
                reader.position((int)reader.getCurrentBlockHeader().nextBufferStartingPosition());
                ++blockCount;
            }
            if (status == EvioReader.ReadStatus.END_OF_FILE) {
                System.out.println("Total blocks read: " + blockCount);
                result = TestResult.PASS;
            } else {
                result = TestResult.FAIL;
            }
            reader.rewind();
        }
        catch (Exception e) {
            e.printStackTrace();
            result = TestResult.FAIL;
        }
        System.out.println("readAllBlockHeadersTest: " + (Object)((Object)result));
        return result;
    }

    public static TestResult readAllEventsTest(EvioReader reader) {
        TestResult result;
        int count = 0;
        try {
            EvioEvent event;
            long oldPosition = reader.position();
            reader.rewind();
            while ((event = reader.nextEvent()) != null) {
                BaseStructureHeader header = event.getHeader();
                System.out.println(++count + ")  size: " + header.getLength() + " type: " + header.getDataTypeName() + " \"" + event.getDescription() + "\"");
            }
            reader.position(oldPosition);
            result = TestResult.PASS;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = TestResult.FAIL;
        }
        System.out.println("readAllBlockHeadersTest: " + (Object)((Object)result));
        return result;
    }

    public static TestResult parseEventsTest(EvioReader reader, int num) {
        int count;
        if (num < 0) {
            num = Integer.MAX_VALUE;
        }
        TestResult result = TestResult.PASS;
        try {
            long oldPosition = reader.position();
            reader.rewind();
            try {
                EvioEvent event;
                for (count = 0; count < num && (event = reader.nextEvent()) != null; ++count) {
                    reader.parseEvent(event);
                }
            }
            catch (EvioException e) {
                e.printStackTrace();
                result = TestResult.FAIL;
            }
            reader.position(oldPosition);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("parseEventsTest parsed: " + count + " events");
        System.out.println("parseEventsTest result: " + (Object)((Object)result));
        return result;
    }

    public static enum TestResult {
        PASS,
        FAIL;

    }
}

