/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

public enum DataType {
    UNKNOWN32(0),
    UINT32(1),
    FLOAT32(2),
    CHARSTAR8(3),
    SHORT16(4),
    USHORT16(5),
    CHAR8(6),
    UCHAR8(7),
    DOUBLE64(8),
    LONG64(9),
    ULONG64(10),
    INT32(11),
    TAGSEGMENT(12),
    ALSOSEGMENT(13),
    ALSOBANK(14),
    COMPOSITE(15),
    BANK(16),
    SEGMENT(32),
    HOLLERIT(33),
    NVALUE(34);

    private int value;
    private static DataType[] intToType;

    public static DataType getDataType(int val) {
        if (val > 66 || val < 0) {
            return null;
        }
        return intToType[val];
    }

    public static String getName(int val) {
        if (val > 66 || val < 0) {
            return "UNKNOWN";
        }
        DataType type = DataType.getDataType(val);
        if (type == null) {
            return "UNKNOWN";
        }
        return type.name();
    }

    public String toString() {
        if (this == ALSOBANK) {
            return "BANK";
        }
        if (this == ALSOSEGMENT) {
            return "SEGMENT";
        }
        return super.toString();
    }

    private DataType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isStructure() {
        switch (this) {
            case BANK: 
            case SEGMENT: 
            case TAGSEGMENT: 
            case ALSOBANK: 
            case ALSOSEGMENT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStructure(int dataType) {
        switch (DataType.getDataType(dataType)) {
            case BANK: 
            case SEGMENT: 
            case TAGSEGMENT: 
            case ALSOBANK: 
            case ALSOSEGMENT: {
                return true;
            }
        }
        return false;
    }

    static {
        intToType = new DataType[67];
        DataType[] arr$ = DataType.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            DataType type;
            DataType.intToType[type.value] = type = arr$[i$];
        }
    }
}

