/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.BitSet;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.IBlockHeader;
import org.jlab.coda.jevio.IEvioWriter;

public class BlockHeaderV4
implements Cloneable,
IEvioWriter,
IBlockHeader {
    public static final int HEADER_SIZE = 8;
    public static final int EV_DICTIONARY_MASK = 256;
    public static final int EV_LASTBLOCK_MASK = 512;
    public static final int EV_BLOCKSIZE = 0;
    public static final int EV_BLOCKNUM = 1;
    public static final int EV_HEADERSIZE = 2;
    public static final int EV_COUNT = 3;
    public static final int EV_RESERVED1 = 4;
    public static final int EV_VERSION = 5;
    public static final int EV_RESERVED2 = 6;
    public static final int EV_MAGIC = 7;
    private int size;
    private int number;
    private int headerLength;
    private int eventCount;
    private int version;
    private int reserved1;
    private int reserved2;
    private BitSet bitInfo = new BitSet(24);
    private int magicNumber;
    private ByteOrder byteOrder;
    private long bufferStartingPosition = -1L;

    @Override
    public int getSize() {
        return this.size;
    }

    public BlockHeaderV4() {
        this.size = 0;
        this.number = 1;
        this.headerLength = 0;
        this.version = 0;
        this.eventCount = 0;
        this.reserved1 = 0;
        this.reserved2 = 0;
        this.magicNumber = 0;
    }

    public BlockHeaderV4(int size, int number) {
        this.size = size;
        this.number = number;
        this.headerLength = 8;
        this.version = 4;
        this.eventCount = 0;
        this.reserved1 = 0;
        this.reserved2 = 0;
        this.magicNumber = -1059454720;
    }

    public BlockHeaderV4(BlockHeaderV4 blkHeader) {
        if (blkHeader == null) {
            return;
        }
        this.size = blkHeader.size;
        this.number = blkHeader.number;
        this.headerLength = blkHeader.headerLength;
        this.version = blkHeader.version;
        this.eventCount = blkHeader.eventCount;
        this.reserved1 = blkHeader.reserved1;
        this.reserved2 = blkHeader.reserved2;
        this.magicNumber = blkHeader.magicNumber;
        this.bitInfo = (BitSet)blkHeader.bitInfo.clone();
        this.bufferStartingPosition = blkHeader.bufferStartingPosition;
    }

    public Object clone() {
        return new BlockHeaderV4(this);
    }

    public void setSize(int size) throws EvioException {
        if (size < 8) {
            throw new EvioException(String.format("Bad value for size in block (physical record) header: %d", size));
        }
        this.size = size;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public void setEventCount(int count) throws EvioException {
        if (count < 0) {
            throw new EvioException(String.format("Bad value for event count in block (physical record) header: %d", count));
        }
        this.eventCount = count;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    @Override
    public int getHeaderLength() {
        return this.headerLength;
    }

    public void setHeaderLength(int headerLength) {
        if (headerLength != 8) {
            System.out.println("Warning: Block Header Length = " + headerLength);
        }
        this.headerLength = headerLength;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public static boolean hasDictionary(int i) {
        return (i & 0x100) > 0;
    }

    @Override
    public boolean hasDictionary() {
        return this.bitInfo.get(0);
    }

    @Override
    public boolean isLastBlock() {
        return this.bitInfo.get(1);
    }

    public static boolean isLastBlock(int i) {
        return (i & 0x200) > 0;
    }

    public static int setLastBlockBit(int i) {
        return i |= 0x200;
    }

    public static int clearLastBlockBit(int i) {
        return i &= 0xFFFFFDFF;
    }

    public int getEventType() {
        int type = 0;
        for (int i = 0; i < 4; ++i) {
            boolean bitSet = this.bitInfo.get(i + 2);
            if (!bitSet) continue;
            type |= 1 << i;
        }
        return type;
    }

    public BitSet getBitInfo() {
        return (BitSet)this.bitInfo.clone();
    }

    public boolean getBitInfo(int bitIndex) {
        if (bitIndex < 0 || bitIndex > 23) {
            return false;
        }
        return this.bitInfo.get(bitIndex);
    }

    public void setBit(int bitIndex, boolean value) {
        if (bitIndex < 0 || bitIndex > 23) {
            return;
        }
        this.bitInfo.set(bitIndex, value);
    }

    public static void setEventType(BitSet bSet, int type) {
        if (type < 0) {
            type = 0;
        } else if (type > 15) {
            type = 15;
        }
        if (bSet.size() < 6) {
            return;
        }
        for (int i = 2; i < 6; ++i) {
            bSet.set(i, (type >>> i - 2 & 1) > 0);
        }
    }

    public int getSixthWord() {
        int v = this.version & 0xFF;
        for (int i = 0; i < this.bitInfo.length(); ++i) {
            if (!this.bitInfo.get(i)) continue;
            v |= 1 << 8 + i;
        }
        return v;
    }

    public static int generateSixthWord(BitSet set) {
        int v = 4;
        for (int i = 0; i < set.length() && i <= 23; ++i) {
            if (!set.get(i)) continue;
            v |= 1 << 8 + i;
        }
        return v;
    }

    public static int generateSixthWord(BitSet bSet, boolean hasDictionary, boolean isEnd) {
        int v = 4;
        for (int i = 0; i < bSet.length() && i <= 23; ++i) {
            if (!bSet.get(i)) continue;
            v |= 1 << 8 + i;
        }
        v = hasDictionary ? v | 0x100 : v;
        v = isEnd ? v | 0x200 : v;
        return v;
    }

    public static int generateSixthWord(int version, boolean hasDictionary, boolean isEnd, int eventType) {
        return BlockHeaderV4.generateSixthWord(null, version, hasDictionary, isEnd, eventType);
    }

    public static int generateSixthWord(BitSet bSet, int version, boolean hasDictionary, boolean isEnd, int eventType) {
        int v = version;
        if (bSet != null) {
            for (int i = 0; i < bSet.length() && i <= 23; ++i) {
                if (!bSet.get(i)) continue;
                v |= 1 << 8 + i;
            }
        }
        v = hasDictionary ? v | 0x100 : v;
        v = isEnd ? v | 0x200 : v;
        return v |= (eventType & 0xF) << 10;
    }

    public void parseToBitInfo(int word) throws EvioException {
        for (int i = 0; i < 24; ++i) {
            this.bitInfo.set(i, (word >>> 8 + i & 1) > 0);
        }
    }

    public static boolean bitInfoHasDictionary(int word) {
        BitSet bitInfo = new BitSet(24);
        for (int i = 0; i < 24; ++i) {
            bitInfo.set(i, (word >>> 8 + i & 1) > 0);
        }
        return bitInfo.get(0);
    }

    public int getReserved1() {
        return this.reserved1;
    }

    public void setReserved1(int reserved1) {
        this.reserved1 = reserved1;
    }

    public int getReserved2() {
        return this.reserved2;
    }

    public void setReserved2(int reserved2) {
        this.reserved2 = reserved2;
    }

    @Override
    public int getMagicNumber() {
        return this.magicNumber;
    }

    public void setMagicNumber(int magicNumber) throws EvioException {
        if (magicNumber != -1059454720) {
            throw new EvioException(String.format("Value for magicNumber %8x does not match MAGIC_NUMBER 0xc0da0100.", magicNumber));
        }
        this.magicNumber = magicNumber;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(512);
        sb.append(String.format("block size:     %d\n", this.size));
        sb.append(String.format("number:         %d\n", this.number));
        sb.append(String.format("headerLen:      %d\n", this.headerLength));
        sb.append(String.format("event count:    %d\n", this.eventCount));
        sb.append(String.format("reserved 1:     %d\n", this.reserved1));
        sb.append(String.format("bit info:       %s\n", this.bitInfo));
        sb.append(String.format("has dictionary: %b\n", this.hasDictionary()));
        sb.append(String.format("version:        %d\n", this.version));
        sb.append(String.format("magicNumber:    %8x\n", this.magicNumber));
        sb.append(String.format(" *buffer start: %d\n", this.getBufferStartingPosition()));
        sb.append(String.format(" *next   start: %d\n", this.nextBufferStartingPosition()));
        return sb.toString();
    }

    @Override
    public long getBufferEndingPosition() {
        return this.bufferStartingPosition + (long)(4 * this.size);
    }

    @Override
    public long getBufferStartingPosition() {
        return this.bufferStartingPosition;
    }

    @Override
    public void setBufferStartingPosition(long bufferStartingPosition) {
        this.bufferStartingPosition = bufferStartingPosition;
    }

    @Override
    public long nextBufferStartingPosition() {
        return this.getBufferEndingPosition();
    }

    @Override
    public long firstEventStartingPosition() {
        return this.bufferStartingPosition + (long)(4 * this.headerLength);
    }

    @Override
    public int bytesRemaining(long position) throws EvioException {
        if (position < this.bufferStartingPosition) {
            throw new EvioException("Provided position is less than buffer starting position.");
        }
        long nextBufferStart = this.nextBufferStartingPosition();
        if (position > nextBufferStart) {
            throw new EvioException("Provided position beyond buffer end position.");
        }
        return (int)(nextBufferStart - position);
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        byteBuffer.putInt(this.size);
        byteBuffer.putInt(this.number);
        byteBuffer.putInt(this.headerLength);
        byteBuffer.putInt(this.eventCount);
        byteBuffer.putInt(0);
        byteBuffer.putInt(this.getSixthWord());
        byteBuffer.putInt(0);
        byteBuffer.putInt(this.magicNumber);
        return 32;
    }
}

